/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import groovy.lang.Closure;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.Buildable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.DirectoryTree;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.file.CompositeFileTree;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.internal.file.collections.DirectoryFileTreeFactory;
import org.gradle.api.internal.file.collections.FileCollectionAdapter;
import org.gradle.api.internal.file.collections.FileCollectionResolveContext;
import org.gradle.api.internal.file.collections.MinimalFileSet;
import org.gradle.api.internal.provider.DefaultProviderFactory;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.provider.PropertyState;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSourceDirectorySet
extends CompositeFileTree
implements SourceDirectorySet {
    private final List<Object> source = new ArrayList<Object>();
    private final String name;
    private final String displayName;
    private final FileResolver fileResolver;
    private final DirectoryFileTreeFactory directoryFileTreeFactory;
    private final PatternSet patterns;
    private final PatternSet filter;
    private final FileCollection dirs;
    private final PropertyState<File> outputDir;

    public DefaultSourceDirectorySet(String name, String displayName, FileResolver fileResolver, DirectoryFileTreeFactory directoryFileTreeFactory) {
        this.name = name;
        this.displayName = displayName;
        this.fileResolver = fileResolver;
        this.directoryFileTreeFactory = directoryFileTreeFactory;
        this.patterns = (PatternSet)fileResolver.getPatternSetFactory().create();
        this.filter = (PatternSet)fileResolver.getPatternSetFactory().create();
        this.dirs = new FileCollectionAdapter(new SourceDirectories());
        DefaultProviderFactory providerFactory = new DefaultProviderFactory();
        this.outputDir = providerFactory.property(File.class);
    }

    public DefaultSourceDirectorySet(String name, FileResolver fileResolver, DirectoryFileTreeFactory directoryFileTreeFactory) {
        this(name, name, fileResolver, directoryFileTreeFactory);
    }

    public String getName() {
        return this.name;
    }

    public FileCollection getSourceDirectories() {
        return this.dirs;
    }

    public Set<File> getSrcDirs() {
        LinkedHashSet<File> dirs = new LinkedHashSet<File>();
        for (DirectoryTree tree : this.getSrcDirTrees()) {
            dirs.add(tree.getDir());
        }
        return dirs;
    }

    public Set<String> getIncludes() {
        return this.patterns.getIncludes();
    }

    public Set<String> getExcludes() {
        return this.patterns.getExcludes();
    }

    public PatternFilterable setIncludes(Iterable<String> includes) {
        this.patterns.setIncludes(includes);
        return this;
    }

    public PatternFilterable setExcludes(Iterable<String> excludes) {
        this.patterns.setExcludes(excludes);
        return this;
    }

    public PatternFilterable include(String ... includes) {
        this.patterns.include(includes);
        return this;
    }

    public PatternFilterable include(Iterable<String> includes) {
        this.patterns.include(includes);
        return this;
    }

    public PatternFilterable include(Spec<FileTreeElement> includeSpec) {
        this.patterns.include(includeSpec);
        return this;
    }

    public PatternFilterable include(Closure includeSpec) {
        this.patterns.include(includeSpec);
        return this;
    }

    public PatternFilterable exclude(Iterable<String> excludes) {
        this.patterns.exclude(excludes);
        return this;
    }

    public PatternFilterable exclude(String ... excludes) {
        this.patterns.exclude(excludes);
        return this;
    }

    public PatternFilterable exclude(Spec<FileTreeElement> excludeSpec) {
        this.patterns.exclude(excludeSpec);
        return this;
    }

    public PatternFilterable exclude(Closure excludeSpec) {
        this.patterns.exclude(excludeSpec);
        return this;
    }

    public PatternFilterable getFilter() {
        return this.filter;
    }

    public File getOutputDir() {
        return (File)this.outputDir.get();
    }

    public void setOutputDir(Provider<File> provider) {
        this.outputDir.set(provider);
    }

    public void setOutputDir(File outputDir) {
        this.outputDir.set((Object)outputDir);
    }

    public Set<DirectoryTree> getSrcDirTrees() {
        LinkedHashMap<File, DirectoryTree> trees = new LinkedHashMap<File, DirectoryTree>();
        for (DirectoryTree tree : this.doGetSrcDirTrees()) {
            if (trees.containsKey(tree.getDir())) continue;
            trees.put(tree.getDir(), tree);
        }
        return new LinkedHashSet<DirectoryTree>(trees.values());
    }

    private Set<DirectoryTree> doGetSrcDirTrees() {
        LinkedHashSet<DirectoryTree> result = new LinkedHashSet<DirectoryTree>();
        for (Object path : this.source) {
            if (path instanceof SourceDirectorySet) {
                SourceDirectorySet nested = (SourceDirectorySet)path;
                result.addAll(nested.getSrcDirTrees());
                continue;
            }
            Iterator i$ = this.fileResolver.resolveFiles(path).iterator();
            while (i$.hasNext()) {
                File srcDir = (File)i$.next();
                if (srcDir.exists() && !srcDir.isDirectory()) {
                    throw new InvalidUserDataException(String.format("Source directory '%s' is not a directory.", srcDir));
                }
                result.add(this.directoryFileTreeFactory.create(srcDir, this.patterns));
            }
        }
        return result;
    }

    @Override
    public void visitDependencies(TaskDependencyResolveContext context) {
        for (Object path : this.source) {
            if (path instanceof SourceDirectorySet) {
                context.add(((SourceDirectorySet)path).getBuildDependencies());
                continue;
            }
            context.add(this.fileResolver.resolveFiles(path));
        }
    }

    @Override
    public void visitContents(FileCollectionResolveContext context) {
        for (DirectoryTree directoryTree : this.doGetSrcDirTrees()) {
            context.add(((DirectoryFileTree)directoryTree).filter((PatternFilterable)this.filter));
        }
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public SourceDirectorySet srcDir(Object srcDir) {
        this.source.add(srcDir);
        return this;
    }

    public SourceDirectorySet srcDirs(Object ... srcDirs) {
        for (Object srcDir : srcDirs) {
            this.source.add(srcDir);
        }
        return this;
    }

    public SourceDirectorySet setSrcDirs(Iterable<?> srcPaths) {
        this.source.clear();
        GUtil.addToCollection(this.source, (Iterable[])new Iterable[]{srcPaths});
        return this;
    }

    public SourceDirectorySet source(SourceDirectorySet source) {
        this.source.add(source);
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SourceDirectories
    implements MinimalFileSet,
    Buildable {
        private SourceDirectories() {
        }

        public TaskDependency getBuildDependencies() {
            return DefaultSourceDirectorySet.this.getBuildDependencies();
        }

        @Override
        public Set<File> getFiles() {
            return DefaultSourceDirectorySet.this.getSrcDirs();
        }

        @Override
        public String getDisplayName() {
            return DefaultSourceDirectorySet.this.displayName;
        }
    }
}

