/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.test.xctest.plugins;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryVar;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.language.swift.plugins.SwiftBasePlugin;
import org.gradle.language.swift.plugins.SwiftExecutablePlugin;
import org.gradle.language.swift.plugins.SwiftLibraryPlugin;
import org.gradle.language.swift.tasks.SwiftCompile;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.tasks.AbstractLinkTask;
import org.gradle.nativeplatform.tasks.LinkExecutable;
import org.gradle.nativeplatform.test.xctest.SwiftXCTestSuite;
import org.gradle.nativeplatform.test.xctest.internal.DefaultSwiftXCTestSuite;
import org.gradle.nativeplatform.test.xctest.internal.MacOSSdkPlatformPathLocator;
import org.gradle.nativeplatform.test.xctest.tasks.CreateXcTestBundle;
import org.gradle.nativeplatform.test.xctest.tasks.XcTest;
import org.gradle.nativeplatform.toolchain.NativeToolChain;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;

@Incubating
public class XCTestConventionPlugin
implements Plugin<ProjectInternal> {
    private final FileOperations fileOperations;
    private final MacOSSdkPlatformPathLocator sdkPlatformPathLocator;

    @Inject
    public XCTestConventionPlugin(FileOperations fileOperations, MacOSSdkPlatformPathLocator sdkPlatformPathLocator) {
        this.fileOperations = fileOperations;
        this.sdkPlatformPathLocator = sdkPlatformPathLocator;
    }

    public void apply(ProjectInternal project) {
        if (!OperatingSystem.current().isMacOsX()) {
            throw new UnsupportedOperationException("'xctest' plugin is only supported on macOS at this stage.");
        }
        project.getPluginManager().apply(SwiftBasePlugin.class);
        DirectoryVar buildDirectory = project.getLayout().getBuildDirectory();
        ConfigurationContainer configurations = project.getConfigurations();
        TaskContainerInternal tasks = project.getTasks();
        ProviderFactory providers = project.getProviders();
        SwiftXCTestSuite component = (SwiftXCTestSuite)project.getExtensions().create(SwiftXCTestSuite.class, "xctest", DefaultSwiftXCTestSuite.class, new Object[]{"test", project.getObjects(), this.fileOperations, providers, configurations});
        project.getComponents().add((Object)component);
        project.getComponents().add((Object)component.getExecutable());
        SwiftCompile compile = (SwiftCompile)tasks.getByName("compileTestSwift");
        File frameworkDir = new File(this.sdkPlatformPathLocator.find(), "Developer/Library/Frameworks");
        compile.setCompilerArgs((List)Lists.newArrayList((Object[])new String[]{"-g", "-F" + frameworkDir.getAbsolutePath()}));
        compile.setModuleName(project.getName() + "Test");
        NativeToolChain toolChain = compile.getToolChain();
        NativePlatform targetPlatform = compile.getTargetPlatform();
        LinkExecutable link = (LinkExecutable)tasks.create("linkTest", LinkExecutable.class);
        link.source((Object)compile.getObjectFileDirectory().getAsFileTree().matching((PatternFilterable)new PatternSet().include(new String[]{"**/*.obj", "**/*.o"})));
        link.lib((Object)component.getExecutable().getLinkLibraries());
        link.setLinkerArgs((List)Lists.newArrayList((Object[])new String[]{"-Xlinker", "-bundle", "-F" + frameworkDir.getAbsolutePath(), "-framework", "XCTest", "-Xlinker", "-rpath", "-Xlinker", "@executable_path/../Frameworks", "-Xlinker", "-rpath", "-Xlinker", "@loader_path/../Frameworks"}));
        PlatformToolProvider toolProvider = ((NativeToolChainInternal)toolChain).select((NativePlatformInternal)targetPlatform);
        Provider exeLocation = buildDirectory.file(toolProvider.getExecutableName("exe/" + project.getName() + "Test"));
        link.setOutputFile(exeLocation);
        link.setTargetPlatform(targetPlatform);
        link.setToolChain(toolChain);
        this.configureTestedComponent((Project)project);
        Provider testBundleDir = buildDirectory.dir("bundle/" + project.getName() + "Test.xctest");
        final CreateXcTestBundle testBundle = (CreateXcTestBundle)tasks.create("createXcTestBundle", CreateXcTestBundle.class);
        testBundle.setExecutableFile((Provider<? extends RegularFile>)link.getBinaryFile());
        testBundle.setInformationFile(project.file((Object)"src/test/resources/Info.plist"));
        testBundle.setOutputDir((Provider<? extends Directory>)testBundleDir);
        testBundle.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task element) {
                return testBundle.getExecutableFile().exists();
            }
        });
        final XcTest xcTest = (XcTest)tasks.create("xcTest", XcTest.class);
        xcTest.dependsOn(new Object[]{testBundle});
        xcTest.setBinResultsDir(project.file((Object)"build/results/test/bin"));
        xcTest.setTestBundleDir((Provider<? extends Directory>)testBundleDir);
        xcTest.setWorkingDir((Provider<? extends Directory>)buildDirectory.dir("bundle"));
        xcTest.getReports().getHtml().setDestination(((Directory)buildDirectory.dir("reports/test").get()).getAsFile());
        xcTest.getReports().getJunitXml().setDestination(((Directory)buildDirectory.dir("reports/test/xml").get()).getAsFile());
        xcTest.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task element) {
                return xcTest.getTestBundleDir().exists();
            }
        });
        Task test = tasks.create("test");
        test.dependsOn(new Object[]{xcTest});
    }

    private void configureTestedComponent(final Project project) {
        project.getPlugins().withType(SwiftExecutablePlugin.class, (Action)new Action<SwiftExecutablePlugin>(){

            public void execute(SwiftExecutablePlugin plugin) {
                XCTestConventionPlugin.this.configureTestedSwiftComponent(project);
            }
        });
        project.getPlugins().withType(SwiftLibraryPlugin.class, (Action)new Action<SwiftLibraryPlugin>(){

            public void execute(SwiftLibraryPlugin plugin) {
                XCTestConventionPlugin.this.configureTestedSwiftComponent(project);
            }
        });
    }

    private void configureTestedSwiftComponent(Project project) {
        TaskContainer tasks = project.getTasks();
        SwiftCompile compileMain = (SwiftCompile)tasks.withType(SwiftCompile.class).getByName("compileDebugSwift");
        SwiftCompile compileTest = (SwiftCompile)tasks.withType(SwiftCompile.class).getByName("compileTestSwift");
        compileTest.includes((Object)compileMain.getObjectFileDirectory());
        AbstractLinkTask linkTest = (AbstractLinkTask)tasks.withType(AbstractLinkTask.class).getByName("linkTest");
        linkTest.source((Object)compileMain.getObjectFileDirectory().getAsFileTree().matching((PatternFilterable)new PatternSet().include(new String[]{"**/*.obj", "**/*.o"})));
    }
}

