/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.xmss;

import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.Xof;
import org.bouncycastle.pqc.crypto.xmss.XMSSUtil;

public final class KeyedHashFunctions {
    private final Digest digest;
    private final int digestSize;

    protected KeyedHashFunctions(Digest digest, int n) {
        if (digest == null) {
            throw new NullPointerException("digest == null");
        }
        this.digest = digest;
        this.digestSize = n;
    }

    private byte[] coreDigest(int n, byte[] byArray, byte[] byArray2) {
        int n2;
        byte[] byArray3 = new byte[this.digestSize + byArray.length + byArray2.length];
        byte[] byArray4 = XMSSUtil.toBytesBigEndian(n, this.digestSize);
        for (n2 = 0; n2 < byArray4.length; ++n2) {
            byArray3[n2] = byArray4[n2];
        }
        for (n2 = 0; n2 < byArray.length; ++n2) {
            byArray3[byArray4.length + n2] = byArray[n2];
        }
        for (n2 = 0; n2 < byArray2.length; ++n2) {
            byArray3[byArray4.length + byArray.length + n2] = byArray2[n2];
        }
        this.digest.update(byArray3, 0, byArray3.length);
        byte[] byArray5 = new byte[this.digestSize];
        if (this.digest instanceof Xof) {
            ((Xof)this.digest).doFinal(byArray5, 0, this.digestSize);
        } else {
            this.digest.doFinal(byArray5, 0);
        }
        return byArray5;
    }

    protected byte[] F(byte[] byArray, byte[] byArray2) {
        if (byArray.length != this.digestSize) {
            throw new IllegalArgumentException("wrong key length");
        }
        if (byArray2.length != this.digestSize) {
            throw new IllegalArgumentException("wrong in length");
        }
        return this.coreDigest(0, byArray, byArray2);
    }

    protected byte[] H(byte[] byArray, byte[] byArray2) {
        if (byArray.length != this.digestSize) {
            throw new IllegalArgumentException("wrong key length");
        }
        if (byArray2.length != 2 * this.digestSize) {
            throw new IllegalArgumentException("wrong in length");
        }
        return this.coreDigest(1, byArray, byArray2);
    }

    protected byte[] HMsg(byte[] byArray, byte[] byArray2) {
        if (byArray.length != 3 * this.digestSize) {
            throw new IllegalArgumentException("wrong key length");
        }
        return this.coreDigest(2, byArray, byArray2);
    }

    protected byte[] PRF(byte[] byArray, byte[] byArray2) {
        if (byArray.length != this.digestSize) {
            throw new IllegalArgumentException("wrong key length");
        }
        if (byArray2.length != 32) {
            throw new IllegalArgumentException("wrong address length");
        }
        return this.coreDigest(3, byArray, byArray2);
    }
}

