/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.JavaCallableMemberDescriptor;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/InterfaceDefaultMethodCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "jvmTarget", "Lorg/jetbrains/kotlin/config/JvmTarget;", "(Lorg/jetbrains/kotlin/config/JvmTarget;)V", "getJvmTarget", "()Lorg/jetbrains/kotlin/config/JvmTarget;", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "kotlin-compiler"})
public final class InterfaceDefaultMethodCallChecker
implements CallChecker {
    @NotNull
    private final JvmTarget jvmTarget;

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkParameterIsNotNull(resolvedCall2, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(reportOn, "reportOn");
        Intrinsics.checkParameterIsNotNull(context, "context");
        boolean supportDefaults = Intrinsics.areEqual(this.jvmTarget, JvmTarget.JVM_1_8);
        Object obj = resolvedCall2.getResultingDescriptor();
        if (!(obj instanceof FunctionDescriptor)) {
            obj = null;
        }
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)obj;
        if (functionDescriptor == null) {
            return;
        }
        FunctionDescriptor descriptor2 = functionDescriptor;
        if (!supportDefaults && DescriptorUtils.isStaticDeclaration(descriptor2) && DescriptorUtils.isInterface(descriptor2.getContainingDeclaration()) && descriptor2 instanceof JavaCallableMemberDescriptor) {
            context.getTrace().report(ErrorsJvm.INTERFACE_STATIC_METHOD_CALL_FROM_JAVA6_TARGET.on(reportOn));
        }
        Call call2 = resolvedCall2.getCall();
        Intrinsics.checkExpressionValueIsNotNull(call2, "resolvedCall.call");
        if (CallResolverUtilKt.getSuperCallExpression(call2) == null) {
            return;
        }
        if (!DescriptorUtils.isInterface(descriptor2.getOriginal().getContainingDeclaration())) {
            return;
        }
        FunctionDescriptor realDescriptor = (FunctionDescriptor)DescriptorUtils.unwrapFakeOverride((CallableMemberDescriptor)descriptor2);
        DeclarationDescriptor declarationDescriptor = realDescriptor.getContainingDeclaration();
        if (!(declarationDescriptor instanceof ClassDescriptor)) {
            declarationDescriptor = null;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor;
        if (classDescriptor == null) {
            return;
        }
        ClassDescriptor realDescriptorOwner = classDescriptor;
        if (DescriptorUtils.isInterface(realDescriptorOwner) && realDescriptor instanceof JavaCallableMemberDescriptor) {
            ClassifierDescriptor classifier2 = DescriptorUtils.getParentOfType(context.getScope().getOwnerDescriptor(), ClassifierDescriptor.class);
            if (classifier2 != null && DescriptorUtils.isInterface(classifier2)) {
                context.getTrace().report(ErrorsJvm.INTERFACE_CANT_CALL_DEFAULT_METHOD_VIA_SUPER.on(reportOn));
            } else if (!supportDefaults) {
                context.getTrace().report(ErrorsJvm.DEFAULT_METHOD_CALL_FROM_JAVA6_TARGET.on(reportOn));
            }
        }
    }

    @NotNull
    public final JvmTarget getJvmTarget() {
        return this.jvmTarget;
    }

    public InterfaceDefaultMethodCallChecker(@NotNull JvmTarget jvmTarget) {
        Intrinsics.checkParameterIsNotNull(jvmTarget, "jvmTarget");
        this.jvmTarget = jvmTarget;
    }
}

