/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.moduleconverter;

import java.util.Collection;
import java.util.Set;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.configurations.Configurations;
import org.gradle.api.internal.artifacts.configurations.OutgoingVariant;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.ConfigurationComponentMetaDataBuilder;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.DependenciesToModuleDescriptorConverter;
import org.gradle.internal.component.local.model.BuildableLocalComponentMetadata;

public class DefaultConfigurationComponentMetaDataBuilder
implements ConfigurationComponentMetaDataBuilder {
    private final DependenciesToModuleDescriptorConverter dependenciesConverter;

    public DefaultConfigurationComponentMetaDataBuilder(DependenciesToModuleDescriptorConverter dependenciesConverter) {
        this.dependenciesConverter = dependenciesConverter;
    }

    @Override
    public void addConfigurations(BuildableLocalComponentMetadata metaData, Collection<? extends ConfigurationInternal> configurations) {
        for (ConfigurationInternal configurationInternal : configurations) {
            this.addConfiguration(metaData, configurationInternal);
            this.dependenciesConverter.addDependencyDescriptors(metaData, configurationInternal);
            OutgoingVariant outgoingVariant = configurationInternal.convertToOutgoingVariant();
            metaData.addArtifacts(configurationInternal.getName(), outgoingVariant.getArtifacts());
            for (OutgoingVariant outgoingVariant2 : outgoingVariant.getChildren()) {
                metaData.addVariant(configurationInternal.getName(), outgoingVariant2);
            }
        }
    }

    private void addConfiguration(BuildableLocalComponentMetadata metaData, ConfigurationInternal configuration) {
        configuration.preventFromFurtherMutation();
        Set<String> hierarchy = Configurations.getNames(configuration.getHierarchy());
        Set<String> extendsFrom = Configurations.getNames(configuration.getExtendsFrom());
        metaData.addConfiguration(configuration.getName(), configuration.getDescription(), extendsFrom, hierarchy, configuration.isVisible(), configuration.isTransitive(), configuration.getAttributes(), configuration.isCanBeConsumed(), configuration.isCanBeResolved());
    }
}

