/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.console;

import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Hashtable;
import java.util.Map;
import javajs.api.GenericImageDialog;
import javajs.util.PT;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import org.jmol.api.JmolAppConsoleInterface;
import org.jmol.awt.Platform;
import org.jmol.viewer.Viewer;

public class ImageDialog
extends JDialog
implements GenericImageDialog,
WindowListener,
ActionListener {
    private JMenuBar menubar;
    protected Image image;
    protected Viewer vwr;
    protected Canvas canvas;
    private String title;
    private Map<String, GenericImageDialog> imageMap;
    private JmolAppConsoleInterface console;

    public ImageDialog(Viewer vwr, String title, Map<String, GenericImageDialog> imageMap) {
        super(Platform.getWindow((Container)vwr.display) instanceof JFrame ? (JFrame)Platform.getWindow((Container)vwr.display) : null, title, false);
        this.vwr = vwr;
        this.setResizable(false);
        this.console = vwr.getConsole();
        this.addWindowListener(this);
        this.title = title;
        this.imageMap = imageMap;
        imageMap.put(title, this);
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.setBackground(new Color(255, 0, 0));
        this.canvas = new ImageCanvas();
        wrapper.add((Component)this.canvas, "Center");
        JPanel container = new JPanel();
        container.setLayout(new BorderLayout());
        this.menubar = new JMenuBar();
        this.menubar.add(this.createMenu());
        this.setJMenuBar(this.menubar);
        container.add((Component)wrapper, "Center");
        this.getContentPane().add(container);
        this.pack();
        this.setLocation(100, 100);
        this.setVisible(true);
    }

    private JMenu createMenu() {
        String[] itemKeys = PT.getTokens("saveas close");
        this.vwr.getConsole();
        JMenu menu = (JMenu)this.console.newJMenu("file");
        for (int i = 0; i < itemKeys.length; ++i) {
            String item = itemKeys[i];
            JMenuItem mi = this.createMenuItem(item);
            menu.add(mi);
        }
        menu.setVisible(true);
        return menu;
    }

    private JMenuItem createMenuItem(String cmd) {
        JMenuItem mi = (JMenuItem)this.console.newJMenuItem(cmd);
        mi.setActionCommand(cmd);
        mi.addActionListener(this);
        mi.setVisible(true);
        return mi;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("close")) {
            this.closeMe();
        } else if (cmd.equals("saveas")) {
            this.saveAs();
        }
    }

    private void saveAs() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Hashtable<String, Object> params = new Hashtable<String, Object>();
                String fname = ImageDialog.this.vwr.dialogAsk("Save Image", "jmol.png", params);
                if (fname == null) {
                    return;
                }
                String type = "PNG";
                int pt = fname.lastIndexOf(".");
                if (pt > 0) {
                    type = fname.substring(pt + 1).toUpperCase();
                }
                params.put("fileName", fname);
                params.put("type", type);
                params.put("image", ImageDialog.this.image);
                ImageDialog.this.vwr.showString(ImageDialog.this.vwr.processWriteOrCapture(params), false);
            }
        }){}.start();
    }

    @Override
    public void closeMe() {
        this.imageMap.remove(this.title);
        this.dispose();
    }

    @Override
    public void setImage(Object oimage) {
        if (oimage == null) {
            this.closeMe();
            return;
        }
        this.image = (Image)oimage;
        int w = this.image.getWidth(null);
        int h = this.image.getHeight(null);
        this.setTitle(this.title + " [" + w + " x " + h + "]");
        Dimension d = new Dimension(w, h);
        this.canvas.setSize(d);
        this.pack();
        this.repaint();
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.closeMe();
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    class ImageCanvas
    extends Canvas {
        ImageCanvas() {
        }

        @Override
        public void paint(Graphics g) {
            g.drawImage(ImageDialog.this.image, 0, 0, null);
        }
    }
}

