/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.threads;

import java.awt.Color;
import org.netbeans.lib.profiler.global.CommonConstants;

public class ThreadData {
    static final byte NO_STATE = 127;
    private final Object dataLock = new Object();
    private final String name;
    private final String className;
    private long[] times = new long[6];
    private byte[] threadStates;
    private long[] timeStamps;
    private int capacity;
    private int curSize;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadData(String string, String string2) {
        Object object = this.dataLock;
        synchronized (object) {
            this.capacity = 50;
            this.timeStamps = new long[this.capacity];
            this.threadStates = new byte[this.capacity];
            this.curSize = 0;
        }
        this.name = string;
        this.className = string2;
    }

    public String getClassName() {
        return this.className;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getFirstState() {
        Object object = this.dataLock;
        synchronized (object) {
            if (this.curSize == 0) {
                return 127;
            }
            return this.threadStates[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFirstTimeStamp() {
        Object object = this.dataLock;
        synchronized (object) {
            if (this.curSize == 0) {
                return 0L;
            }
            return this.timeStamps[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getLastState() {
        Object object = this.dataLock;
        synchronized (object) {
            if (this.curSize == 0) {
                return 127;
            }
            return this.threadStates[this.curSize - 1];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastTimeStamp() {
        Object object = this.dataLock;
        synchronized (object) {
            if (this.curSize == 0) {
                return 0L;
            }
            return this.timeStamps[this.curSize - 1];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() {
        Object object = this.dataLock;
        synchronized (object) {
            return this.name;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getRunningTime(long l) {
        Object object = this.dataLock;
        synchronized (object) {
            long l2 = this.times[1];
            if (this.getLastState() == 1) {
                l2 += l - this.getLastTimeStamp();
            }
            return l2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSleepingTime(long l) {
        Object object = this.dataLock;
        synchronized (object) {
            long l2 = this.times[2];
            if (this.getLastState() == 2) {
                l2 += l - this.getLastTimeStamp();
            }
            return l2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getWaitTime(long l) {
        Object object = this.dataLock;
        synchronized (object) {
            long l2 = this.times[4];
            if (this.getLastState() == 4) {
                l2 += l - this.getLastTimeStamp();
            }
            return l2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getParkTime(long l) {
        Object object = this.dataLock;
        synchronized (object) {
            long l2 = this.times[5];
            if (this.getLastState() == 5) {
                l2 += l - this.getLastTimeStamp();
            }
            return l2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMonitorTime(long l) {
        Object object = this.dataLock;
        synchronized (object) {
            long l2 = this.times[3];
            if (this.getLastState() == 3) {
                l2 += l - this.getLastTimeStamp();
            }
            return l2;
        }
    }

    public long getTotalTime(long l) {
        return ThreadData.isAliveState(this.getLastState()) ? l - this.getFirstTimeStamp() : this.getLastTimeStamp() - this.getFirstTimeStamp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getStateAt(int n) {
        Object object = this.dataLock;
        synchronized (object) {
            return this.threadStates[n];
        }
    }

    public static Color getThreadStateColor(int n) {
        switch (n) {
            case -1: {
                return CommonConstants.THREAD_STATUS_UNKNOWN_COLOR;
            }
            case 0: {
                return CommonConstants.THREAD_STATUS_ZOMBIE_COLOR;
            }
            case 1: {
                return CommonConstants.THREAD_STATUS_RUNNING_COLOR;
            }
            case 2: {
                return CommonConstants.THREAD_STATUS_SLEEPING_COLOR;
            }
            case 3: {
                return CommonConstants.THREAD_STATUS_MONITOR_COLOR;
            }
            case 4: {
                return CommonConstants.THREAD_STATUS_WAIT_COLOR;
            }
            case 5: {
                return CommonConstants.THREAD_STATUS_PARK_COLOR;
            }
        }
        return CommonConstants.THREAD_STATUS_UNKNOWN_COLOR;
    }

    public static boolean isAliveState(int n) {
        if (n == 1) {
            return true;
        }
        if (n == 2) {
            return true;
        }
        if (n == 3) {
            return true;
        }
        if (n == 4) {
            return true;
        }
        return n == 5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Color getThreadStateColorAt(int n) {
        Object object = this.dataLock;
        synchronized (object) {
            return ThreadData.getThreadStateColor(this.threadStates[n]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTimeStampAt(int n) {
        Object object = this.dataLock;
        synchronized (object) {
            return this.timeStamps[n];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(long l, byte by) {
        Object object = this.dataLock;
        synchronized (object) {
            if (this.curSize == this.capacity) {
                long[] lArray = this.timeStamps;
                byte[] byArray = this.threadStates;
                int n = this.capacity;
                this.capacity *= 2;
                this.timeStamps = new long[this.capacity];
                this.threadStates = new byte[this.capacity];
                System.arraycopy(lArray, 0, this.timeStamps, 0, n);
                System.arraycopy(byArray, 0, this.threadStates, 0, n);
            }
            this.timeStamps[this.curSize] = l;
            this.threadStates[this.curSize] = by;
            if (this.curSize > 0) {
                long l2 = l - this.timeStamps[this.curSize - 1];
                byte by2 = this.threadStates[this.curSize - 1];
                this.times[by2] = this.times[by2] + l2;
                this.times[0] = this.times[0] + l2;
            }
            ++this.curSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearStates() {
        Object object = this.dataLock;
        synchronized (object) {
            this.capacity = 50;
            this.timeStamps = new long[this.capacity];
            this.threadStates = new byte[this.capacity];
            this.curSize = 0;
            this.times = new long[6];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.dataLock;
        synchronized (object) {
            return this.curSize;
        }
    }

    public String toString() {
        return this.getName();
    }
}

