/*
 * Decompiled with CFR 0.152.
 */
package dguitar.players.sound;

import dguitar.adaptors.song.Song;
import dguitar.adaptors.song.SongMeasure;
import dguitar.adaptors.song.SongMeasureTrack;
import dguitar.adaptors.song.SongTrack;
import dguitar.adaptors.song.SongVirtualTrack;
import dguitar.adaptors.song.Tempo;
import dguitar.adaptors.song.TimeSignature;
import dguitar.players.sound.Arrangement;
import dguitar.players.sound.DefaultArrangement;
import dguitar.players.sound.EventSettings;
import dguitar.players.sound.EventSoundPlayer;
import dguitar.players.sound.EventStream;
import dguitar.players.sound.Performance;
import dguitar.players.sound.PerformanceEventListener;
import dguitar.players.sound.PerformanceTimerListener;
import dguitar.players.sound.RealtimeSoundPlayer;
import dguitar.players.sound.SoundPlayer;
import dguitar.players.sound.TimerSettings;
import java.util.List;

public class MasterPlayer
implements RealtimeSoundPlayer,
EventSoundPlayer {
    int timerFrequency = 4;
    boolean noteEventsEnabled = false;
    SoundPlayer soundPlayer;

    public void setTimerFrequency(int ppq) {
        this.timerFrequency = ppq;
    }

    public void enableNoteEvents(boolean enable) {
        this.noteEventsEnabled = enable;
    }

    public void setSoundPlayer(SoundPlayer soundPlayer) {
        this.soundPlayer = soundPlayer;
    }

    public void addEventListener(PerformanceEventListener listener) {
        ((EventSoundPlayer)this.soundPlayer).addEventListener(listener);
    }

    public void addTimerListener(PerformanceTimerListener listener) {
        ((RealtimeSoundPlayer)this.soundPlayer).addTimerListener(listener);
    }

    public Performance arrange(Song song, Arrangement passedArrangement) {
        Arrangement arrangement = null;
        arrangement = passedArrangement == null ? new DefaultArrangement(song) : passedArrangement;
        int tracks = song.getTrackCount();
        List arrangedMeasures = arrangement.getMeasureList();
        int measures = arrangedMeasures.size();
        if (this.soundPlayer instanceof TimerSettings) {
            ((TimerSettings)((Object)this.soundPlayer)).setTimerFrequency(this.timerFrequency);
        }
        if (this.soundPlayer instanceof EventSettings) {
            ((EventSettings)((Object)this.soundPlayer)).enableNoteEvents(this.noteEventsEnabled);
        }
        Performance performance = this.soundPlayer.createPerformance(tracks, song.getTempo(), song.getResolution());
        performance.setTimerFrequency(this.timerFrequency);
        TimeSignature lastTimeSignature = null;
        int location = 0;
        int m = 0;
        while (m < measures) {
            Integer measureIndex = (Integer)arrangedMeasures.get(m);
            SongMeasure measure = song.getPerformanceMeasure(measureIndex);
            TimeSignature currentTimeSignature = measure.getTimeSignature();
            if (lastTimeSignature == null || !currentTimeSignature.equals(lastTimeSignature)) {
                performance.setTimeSignature(location, currentTimeSignature);
                lastTimeSignature = currentTimeSignature;
            }
            performance.addTimerEvents(measure, location);
            location += measure.getLength();
            ++m;
        }
        int t = 1;
        while (t <= tracks) {
            SongTrack songTrack = song.getTrack(t);
            performance.initializeTrack(songTrack);
            int virtualTracks = songTrack.getVirtualTrackCount();
            int v = 0;
            while (v < virtualTracks) {
                EventStream es = new EventStream(songTrack, v);
                location = 0;
                int m2 = 0;
                while (m2 < measures) {
                    Integer measureIndex = (Integer)arrangedMeasures.get(m2);
                    SongMeasure measure = song.getPerformanceMeasure(measureIndex);
                    SongMeasureTrack smt = measure.getTrack(songTrack);
                    SongVirtualTrack svt = smt.getVirtualTrack(v);
                    List events = svt.getEvents();
                    es.addEvents(events, location);
                    location += measure.getLength();
                    ++m2;
                }
                es.close();
                performance.addMusicalEvents(es);
                ++v;
            }
            ++t;
        }
        this.soundPlayer.setPerformance(performance);
        return performance;
    }

    public void start() {
        this.soundPlayer.start();
    }

    public void stop() {
        ((RealtimeSoundPlayer)this.soundPlayer).stop();
    }

    public void waitForCompletion() {
        ((RealtimeSoundPlayer)this.soundPlayer).waitForCompletion();
    }

    public void close() {
        this.soundPlayer.close();
    }

    public Performance createPerformance(int tracks, Tempo tempo, int resolution) {
        return null;
    }

    public void setPerformance(Performance performance) {
        this.soundPlayer.setPerformance(performance);
    }
}

