/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.util;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.StringTokenizer;
import org.fibs.geotag.Settings;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class Proxies {
    private static final I18n i18n = I18nFactory.getI18n(Proxies.class);
    public static final String[] PROXY_TYPES = new String[]{i18n.tr("No proxy"), i18n.tr("HTTP proxy"), i18n.tr("Socks proxy")};

    private Proxies() {
    }

    public static Proxy getProxy() {
        Proxy proxy = Proxy.NO_PROXY;
        int type = Settings.get(Settings.SETTING.PROXY_TYPE, 0);
        if (type != 0) {
            String address = Settings.get(Settings.SETTING.PROXY_ADDRESS, "");
            StringTokenizer tokenizer = new StringTokenizer(address, ":");
            try {
                String hostname = tokenizer.nextToken();
                int port = Integer.parseInt(tokenizer.nextToken());
                InetSocketAddress socketAddress = new InetSocketAddress(hostname, port);
                if (type == 1) {
                    proxy = new Proxy(Proxy.Type.HTTP, socketAddress);
                } else if (type == 2) {
                    proxy = new Proxy(Proxy.Type.SOCKS, socketAddress);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return proxy;
    }
}

