/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshotter;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshotterRegistry;
import org.gradle.internal.Cast;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFileCollectionSnapshotterRegistry
implements FileCollectionSnapshotterRegistry {
    private final Map<Class<?>, FileCollectionSnapshotter> snapshotters;

    public DefaultFileCollectionSnapshotterRegistry(Collection<FileCollectionSnapshotter> snapshotters) {
        this.snapshotters = ImmutableMap.copyOf((Map)Maps.uniqueIndex(snapshotters, (Function)new Function<FileCollectionSnapshotter, Class<?>>(){

            public Class<?> apply(FileCollectionSnapshotter snapshotter) {
                Class<?> type;
                Class<? extends FileCollectionSnapshotter> registeredType = snapshotter.getRegisteredType();
                if (!registeredType.isAssignableFrom(type = snapshotter.getClass())) {
                    throw new IllegalArgumentException(String.format("Snapshotter registered type '%s' must be a super-type of the actual snapshotter type '%s'", registeredType.getName(), type.getName()));
                }
                return registeredType;
            }
        }));
    }

    @Override
    public Collection<FileCollectionSnapshotter> getAllSnapshotters() {
        return this.snapshotters.values();
    }

    @Override
    public <T> T getSnapshotter(Class<? extends T> type) {
        FileCollectionSnapshotter snapshotter = this.snapshotters.get(type);
        if (snapshotter == null) {
            throw new IllegalStateException(String.format("No snapshotter registered with type '%s'", type.getName()));
        }
        return (T)Cast.uncheckedCast((Object)snapshotter);
    }
}

