/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.lib.profiler.common.CommonUtils;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.event.ProfilingStateAdapter;
import org.netbeans.lib.profiler.common.event.ProfilingStateEvent;
import org.netbeans.lib.profiler.common.event.ProfilingStateListener;
import org.netbeans.lib.profiler.results.ExportDataDumper;
import org.netbeans.lib.profiler.ui.ResultsView;
import org.netbeans.lib.profiler.ui.locks.LockContentionPanel;
import org.netbeans.modules.profiler.Bundle;
import org.netbeans.modules.profiler.ExportAction;
import org.netbeans.modules.profiler.ProfilerTopComponent;
import org.netbeans.modules.profiler.SaveViewAction;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.openide.util.HelpCtx;

public final class LockContentionWindow
extends ProfilerTopComponent {
    private static final String HELP_CTX_KEY = "LockContentionWindow.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("LockContentionWindow.HelpCtx");
    private static LockContentionWindow defaultInstance;
    private static final Image windowIcon;
    private final ResultsView lockView;
    private final LockContentionPanel locksPanel;

    LockContentionWindow() {
        assert (SwingUtilities.isEventDispatchThread());
        this.setName(Bundle.LockContentionWindow_WindowName());
        this.setIcon(windowIcon);
        this.getAccessibleContext().setAccessibleDescription(Bundle.LockContentionWindow_WindowAccessDescr());
        this.setLayout(new BorderLayout());
        this.lockView = new ResultsView();
        this.add((Component)this.lockView, "Center");
        this.locksPanel = new LockContentionPanel();
        this.locksPanel.addSaveViewAction((AbstractAction)new SaveViewAction(new SaveView()));
        this.locksPanel.addExportAction((AbstractAction)new ExportAction(new Exporter(), null));
        this.lockView.addView("Locks", null, "Locks", (Component)this.locksPanel, this.locksPanel.getToolbar());
        this.profilingStateChanged(Profiler.getDefault().getProfilingState());
        this.updateLocksView();
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
        this.lockView.addChangeListener((ChangeListener)new Listener());
        this.locksPanel.addLockContentionListener((ActionListener)new LockContentionListener());
        Profiler.getDefault().addProfilingStateListener((ProfilingStateListener)new ProfilingStateAdapter(){

            public void profilingStateChanged(ProfilingStateEvent profilingStateEvent) {
                LockContentionWindow.this.profilingStateChanged(profilingStateEvent.getNewState());
            }

            public void lockContentionMonitoringChanged() {
                LockContentionWindow.this.updateLocksView();
            }
        });
    }

    public static LockContentionWindow getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new LockContentionWindow();
        }
        return defaultInstance;
    }

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    public static void closeIfOpened() {
        if (defaultInstance != null) {
            CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (defaultInstance.isOpened()) {
                        defaultInstance.close();
                    }
                }
            });
        }
    }

    public int getPersistenceType() {
        return 2;
    }

    protected String preferredID() {
        return ((Object)((Object)this)).getClass().getName();
    }

    @Override
    protected Component defaultFocusOwner() {
        return null;
    }

    public void showView() {
        this.open();
        this.requestActive();
    }

    private void updateLocksView() {
        if (Profiler.getDefault().getLockContentionMonitoringEnabled()) {
            this.locksPanel.lockContentionEnabled();
        } else {
            this.locksPanel.lockContentionDisabled();
        }
    }

    private void profilingStateChanged(boolean bl) {
        if (bl) {
            this.locksPanel.profilingSessionStarted();
        } else {
            this.locksPanel.profilingSessionFinished();
        }
    }

    private void profilingStateChanged(int n) {
        if (n == 4) {
            this.profilingStateChanged(true);
        } else {
            this.profilingStateChanged(false);
        }
    }

    static {
        windowIcon = Icons.getImage((String)"ProfilerIcons.WindowLocks");
    }

    private class SaveView
    implements SaveViewAction.ViewProvider {
        private SaveView() {
        }

        @Override
        public BufferedImage getViewImage(boolean bl) {
            return LockContentionWindow.this.locksPanel.getCurrentViewScreenshot(bl);
        }

        @Override
        public String getViewName() {
            return Bundle.LockContentionWindow_WindowName();
        }

        @Override
        public boolean fitsVisibleArea() {
            return LockContentionWindow.this.locksPanel.fitsVisibleArea();
        }

        @Override
        public boolean hasView() {
            return LockContentionWindow.this.locksPanel.hasView();
        }
    }

    private class Listener
    implements ChangeListener {
        private Listener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
        }
    }

    private class LockContentionListener
    implements ActionListener {
        private LockContentionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Profiler.getDefault().setLockContentionMonitoringEnabled(true);
            LockContentionWindow.this.locksPanel.lockContentionEnabled();
        }
    }

    private class Exporter
    implements ExportAction.ExportProvider {
        private Exporter() {
        }

        @Override
        public void exportData(int n, ExportDataDumper exportDataDumper) {
            LockContentionWindow.this.locksPanel.exportData(n, exportDataDumper, this.getViewName());
        }

        @Override
        public String getViewName() {
            return Bundle.LockContentionWindow_WindowName();
        }

        @Override
        public boolean hasExportableView() {
            return LockContentionWindow.this.locksPanel.hasView();
        }

        @Override
        public boolean hasLoadedSnapshot() {
            return false;
        }
    }
}

