/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.Action;
import org.netbeans.lib.profiler.common.CommonUtils;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.event.ProfilingStateAdapter;
import org.netbeans.lib.profiler.common.event.ProfilingStateEvent;
import org.netbeans.lib.profiler.common.event.ProfilingStateListener;
import org.netbeans.lib.profiler.ui.ResultsView;
import org.netbeans.lib.profiler.ui.threads.ThreadsPanel;
import org.netbeans.modules.profiler.Bundle;
import org.netbeans.modules.profiler.ProfilerTopComponent;
import org.netbeans.modules.profiler.SaveViewAction;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.openide.util.HelpCtx;

public final class ThreadsWindow
extends ProfilerTopComponent
implements ActionListener,
SaveViewAction.ViewProvider {
    private static final String HELP_CTX_KEY = "ThreadsWindow.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("ThreadsWindow.HelpCtx");
    private static ThreadsWindow defaultInstance;
    private static final Image windowIcon;
    private final ResultsView threadsView;
    private final ThreadsPanel threadsPanel;

    public ThreadsWindow() {
        this.setName(Bundle.ThreadsWindow_ThreadsWindowName());
        this.setIcon(windowIcon);
        this.getAccessibleContext().setAccessibleDescription(Bundle.ThreadsWindow_ThreadsAccessDescr());
        this.setLayout(new BorderLayout());
        this.threadsView = new ResultsView();
        this.add((Component)this.threadsView, "Center");
        this.threadsPanel = new ThreadsPanel(Profiler.getDefault().getThreadsManager(), (Action)new SaveViewAction(this));
        this.threadsPanel.addThreadsMonitoringActionListener((ActionListener)this);
        this.threadsView.addView(Bundle.ThreadsWindow_ThreadsTimelineTabName(), null, Bundle.ThreadsWindow_ThreadsTimelineTabDescr(), (Component)this.threadsPanel, this.threadsPanel.getToolbar());
        this.profilingStateChanged(Profiler.getDefault().getProfilingState());
        this.updateThreadsView();
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
        Profiler.getDefault().addProfilingStateListener((ProfilingStateListener)new ProfilingStateAdapter(){

            public void profilingStateChanged(ProfilingStateEvent profilingStateEvent) {
                ThreadsWindow.this.profilingStateChanged(profilingStateEvent.getNewState());
            }

            public void threadsMonitoringChanged() {
                ThreadsWindow.this.updateThreadsView();
            }
        });
    }

    public static ThreadsWindow getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new ThreadsWindow();
        }
        return defaultInstance;
    }

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Profiler.getDefault().setThreadsMonitoringEnabled(true);
    }

    public static void closeIfOpened() {
        if (defaultInstance != null) {
            CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (defaultInstance.isOpened()) {
                        defaultInstance.close();
                    }
                }
            });
        }
    }

    public int getPersistenceType() {
        return 2;
    }

    @Override
    public BufferedImage getViewImage(boolean bl) {
        return this.threadsPanel.getCurrentViewScreenshot(bl);
    }

    @Override
    public String getViewName() {
        return "threads";
    }

    @Override
    protected Component defaultFocusOwner() {
        return this.threadsPanel;
    }

    @Override
    public boolean fitsVisibleArea() {
        return this.threadsPanel.fitsVisibleArea();
    }

    @Override
    public boolean hasView() {
        return this.threadsPanel.hasView();
    }

    public void showThreads() {
        this.open();
        this.requestActive();
    }

    private void updateThreadsView() {
        if (Profiler.getDefault().getThreadsMonitoringEnabled()) {
            this.threadsPanel.threadsMonitoringEnabled();
        } else {
            this.threadsPanel.threadsMonitoringDisabled();
        }
    }

    protected String preferredID() {
        return this.getClass().getName();
    }

    private void profilingStateChanged(boolean bl) {
        if (bl) {
            this.threadsPanel.profilingSessionStarted();
        } else {
            this.threadsPanel.profilingSessionFinished();
        }
    }

    private void profilingStateChanged(int n) {
        if (n == 4) {
            this.profilingStateChanged(true);
        } else {
            this.profilingStateChanged(false);
        }
    }

    static {
        windowIcon = Icons.getImage((String)"ProfilerIcons.WindowThreads");
    }
}

