/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.kotlin.dsl.accessors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.kotlin.dsl.accessors.InaccessibilityReason;
import org.gradle.kotlin.dsl.accessors.ProjectSchema;
import org.gradle.kotlin.dsl.accessors.TypeAccessibility;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.lexer.KotlinLexer;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H\u0002\u001a\u0018\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H\u0002\u001a!\u0010\u0007\u001a\u0004\u0018\u00010\u00032\u0006\u0010\b\u001a\u00020\u00032\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\nH\u0082\b\u001a\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0002\u001a\u001a\u0010\f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u0018\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0010H\u0002\u001a\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u0018\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0010H\u0002\u001a\u0018\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0010H\u0002\u001a\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0004\u001a\u00020\u0003H\u0000\u001a&\u0010\u0018\u001a\u00020\u0019*\b\u0012\u0004\u0012\u00020\u000e0\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00190\u001cH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"invalidNameChars", "", "accessibleConventionAccessorFor", "", "name", "type", "accessibleExtensionAccessorFor", "codeForExtension", "extensionName", "code", "Lkotlin/Function0;", "configurationAccessorFor", "conventionAccessorFor", "typeAccess", "Lorg/gradle/kotlin/dsl/accessors/TypeAccessibility;", "documentInaccessibilityReasons", "Lorg/gradle/kotlin/dsl/accessors/TypeAccessibility$Inaccessible;", "extensionAccessorFor", "inaccessibleConventionAccessorFor", "inaccessibleExtensionAccessorFor", "isKotlinIdentifier", "", "candidate", "isLegalExtensionName", "forEachAccessor", "", "Lorg/gradle/kotlin/dsl/accessors/ProjectSchema;", "action", "Lkotlin/Function1;", "provider_main"})
public final class CodeGeneratorKt {
    private static final char[] invalidNameChars = new char[]{'.', '/', '\\'};

    public static final void forEachAccessor(@NotNull ProjectSchema<? extends TypeAccessibility> $receiver, @NotNull Function1<? super String, Unit> action) {
        Object object;
        TypeAccessibility type;
        String name;
        Object object2;
        Map.Entry<String, ? extends TypeAccessibility> $name_type;
        Map.Entry<String, ? extends TypeAccessibility> element$iv;
        Object $receiver$iv;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        Object object3 = $receiver$iv = $receiver.getExtensions();
        Iterator<Map.Entry<String, ? extends TypeAccessibility>> iterator = object3.entrySet().iterator();
        while (iterator.hasNext()) {
            $name_type = element$iv = iterator.next();
            object2 = $name_type;
            name = object2.getKey();
            object2 = $name_type;
            type = object2.getValue();
            String string = CodeGeneratorKt.extensionAccessorFor(name, type);
            if (string == null) continue;
            object2 = string;
            object = action;
            Unit cfr_ignored_0 = (Unit)object.invoke(object2);
        }
        object3 = $receiver$iv = $receiver.getConventions();
        iterator = object3.entrySet().iterator();
        while (iterator.hasNext()) {
            $name_type = element$iv = iterator.next();
            object2 = $name_type;
            name = object2.getKey();
            object2 = $name_type;
            type = object2.getValue();
            object2 = $receiver.getExtensions();
            Object object4 = object = object2;
            if (object4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
            }
            if (!(object4.containsKey(name) ^ true)) continue;
            String string = CodeGeneratorKt.conventionAccessorFor(name, type);
            if (string == null) continue;
            object2 = string;
            object = action;
            Unit cfr_ignored_1 = (Unit)object.invoke(object2);
        }
        $receiver$iv = $receiver.getConfigurations();
        object3 = $receiver$iv.iterator();
        while (object3.hasNext()) {
            String string;
            Object element$iv2 = object3.next();
            String name2 = (String)element$iv2;
            if (CodeGeneratorKt.configurationAccessorFor(name2) == null) continue;
            object2 = action;
            Unit cfr_ignored_2 = (Unit)object2.invoke((Object)string);
        }
    }

    private static final String extensionAccessorFor(String name, TypeAccessibility typeAccess) {
        String string;
        if (CodeGeneratorKt.isLegalExtensionName(name)) {
            String string2;
            TypeAccessibility typeAccessibility = typeAccess;
            if (typeAccessibility instanceof TypeAccessibility.Accessible) {
                string2 = CodeGeneratorKt.accessibleExtensionAccessorFor(name, ((TypeAccessibility.Accessible)typeAccess).getType());
            } else if (typeAccessibility instanceof TypeAccessibility.Inaccessible) {
                string2 = CodeGeneratorKt.inaccessibleExtensionAccessorFor(name, (TypeAccessibility.Inaccessible)typeAccess);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            string = StringsKt.replaceIndent$default((String)string2, null, (int)1, null);
        } else {
            string = null;
        }
        return string;
    }

    private static final String accessibleExtensionAccessorFor(String name, String type) {
        return "\n        /**\n         * Retrieves the [" + name + "][" + type + "] project extension.\n         */\n        val Project.`" + name + "`: " + type + " get() =\n            extensions.getByName(\"" + name + "\") as " + type + "\n\n        /**\n         * Configures the [" + name + "][" + type + "] project extension.\n         */\n        fun Project.`" + name + "`(configure: " + type + ".() -> Unit): Unit =\n            extensions.configure(\"" + name + "\", configure)\n\n    ";
    }

    private static final String inaccessibleExtensionAccessorFor(String name, TypeAccessibility.Inaccessible typeAccess) {
        return "\n        /**\n         * Retrieves the [" + name + "][" + typeAccess.getType() + "] project extension.\n         *\n         * " + CodeGeneratorKt.documentInaccessibilityReasons(name, typeAccess) + "\n         */\n        val Project.`" + name + "`: Any get() =\n            extensions.getByName(\"" + name + "\")\n\n        /**\n         * Configures the [" + name + "][" + typeAccess.getType() + "] project extension.\n         *\n         * " + CodeGeneratorKt.documentInaccessibilityReasons(name, typeAccess) + "\n         */\n        fun Project.`" + name + "`(configure: Any.() -> Unit): Unit =\n            extensions.configure(\"" + name + "\", configure)\n\n    ";
    }

    private static final String conventionAccessorFor(String name, TypeAccessibility typeAccess) {
        String string;
        if (CodeGeneratorKt.isLegalExtensionName(name)) {
            String string2;
            TypeAccessibility typeAccessibility = typeAccess;
            if (typeAccessibility instanceof TypeAccessibility.Accessible) {
                string2 = CodeGeneratorKt.accessibleConventionAccessorFor(name, ((TypeAccessibility.Accessible)typeAccess).getType());
            } else if (typeAccessibility instanceof TypeAccessibility.Inaccessible) {
                string2 = CodeGeneratorKt.inaccessibleConventionAccessorFor(name, (TypeAccessibility.Inaccessible)typeAccess);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            string = StringsKt.replaceIndent$default((String)string2, null, (int)1, null);
        } else {
            string = null;
        }
        return string;
    }

    private static final String accessibleConventionAccessorFor(String name, String type) {
        return "\n        /**\n         * Retrieves the [" + name + "][" + type + "] project convention.\n         */\n        val Project.`" + name + "`: " + type + " get() =\n            convention.getPluginByName<" + type + ">(\"" + name + "\")\n\n        /**\n         * Configures the [" + name + "][" + type + "] project convention.\n         */\n        fun Project.`" + name + "`(configure: " + type + ".() -> Unit): Unit =\n            configure(`" + name + "`)\n\n    ";
    }

    private static final String inaccessibleConventionAccessorFor(String name, TypeAccessibility.Inaccessible typeAccess) {
        return "\n        /**\n         * Retrieves the [" + name + "][" + typeAccess.getType() + "] project convention.\n         *\n         * " + CodeGeneratorKt.documentInaccessibilityReasons(name, typeAccess) + "\n         */\n        val Project.`" + name + "`: Any get() =\n            convention.getPluginByName<Any>(\"" + name + "\")\n\n        /**\n         * Configures the [" + name + "][" + typeAccess.getType() + "] project convention.\n         *\n         * " + CodeGeneratorKt.documentInaccessibilityReasons(name, typeAccess) + "\n         */\n        fun Project.`" + name + "`(configure: Any.() -> Unit): Unit =\n            configure(`" + name + "`)\n\n    ";
    }

    private static final String configurationAccessorFor(String name) {
        return CodeGeneratorKt.isLegalExtensionName(name) ? StringsKt.replaceIndent$default((String)("\n            /**\n             * The '" + name + "' configuration.\n             */\n            val ConfigurationContainer.`" + name + "`: Configuration\n                get() = getByName(\"" + name + "\")\n\n            /**\n             * Adds a dependency to the '" + name + "' configuration.\n             *\n             * @param dependencyNotation notation for the dependency to be added.\n             * @return The dependency.\n             *\n             * @see DependencyHandler.add\n             */\n            fun DependencyHandler.`" + name + "`(dependencyNotation: Any): Dependency =\n                add(\"" + name + "\", dependencyNotation)\n\n            /**\n             * Adds a dependency to the '" + name + "' configuration.\n             *\n             * @param dependencyNotation notation for the dependency to be added.\n             * @param dependencyConfiguration expression to use to configure the dependency.\n             * @return The dependency.\n             *\n             * @see DependencyHandler.add\n             */\n            inline\n            fun DependencyHandler.`" + name + "`(\n                dependencyNotation: String,\n                dependencyConfiguration: ExternalModuleDependency.() -> Unit): ExternalModuleDependency =\n                add(\"" + name + "\", dependencyNotation, dependencyConfiguration)\n\n            /**\n             * Adds a dependency to the '" + name + "' configuration.\n             *\n             * @param group the group of the module to be added as a dependency.\n             * @param name the name of the module to be added as a dependency.\n             * @param version the optional version of the module to be added as a dependency.\n             * @param configuration the optional configuration of the module to be added as a dependency.\n             * @param classifier the optional classifier of the module artifact to be added as a dependency.\n             * @param ext the optional extension of the module artifact to be added as a dependency.\n             * @return The dependency.\n             *\n             * @see DependencyHandler.add\n             */\n            fun DependencyHandler.`" + name + "`(\n                group: String,\n                name: String,\n                version: String? = null,\n                configuration: String? = null,\n                classifier: String? = null,\n                ext: String? = null): ExternalModuleDependency =\n                create(group, name, version, configuration, classifier, ext).apply { add(\"" + name + "\", this) }\n\n            /**\n             * Adds a dependency to the '" + name + "' configuration.\n             *\n             * @param group the group of the module to be added as a dependency.\n             * @param name the name of the module to be added as a dependency.\n             * @param version the optional version of the module to be added as a dependency.\n             * @param configuration the optional configuration of the module to be added as a dependency.\n             * @param classifier the optional classifier of the module artifact to be added as a dependency.\n             * @param ext the optional extension of the module artifact to be added as a dependency.\n             * @param dependencyConfiguration expression to use to configure the dependency.\n             * @return The dependency.\n             *\n             * @see DependencyHandler.create\n             * @see DependencyHandler.add\n             */\n            inline\n            fun DependencyHandler.`" + name + "`(\n                group: String,\n                name: String,\n                version: String? = null,\n                configuration: String? = null,\n                classifier: String? = null,\n                ext: String? = null,\n                dependencyConfiguration: ExternalModuleDependency.() -> Unit): ExternalModuleDependency =\n                add(\"" + name + "\", create(group, name, version, configuration, classifier, ext), dependencyConfiguration)\n\n            /**\n             * Adds a dependency to the '" + name + "' configuration.\n             *\n             * @param dependency dependency to be added.\n             * @param dependencyConfiguration expression to use to configure the dependency.\n             * @return The dependency.\n             *\n             * @see DependencyHandler.add\n             */\n            inline\n            fun <T : ModuleDependency> DependencyHandler.`" + name + "`(dependency: T, dependencyConfiguration: T.() -> Unit): T =\n                add(\"" + name + "\", dependency, dependencyConfiguration)\n\n        "), null, (int)1, null) : null;
    }

    /*
     * WARNING - void declaration
     */
    private static final String documentInaccessibilityReasons(String name, TypeAccessibility.Inaccessible typeAccess) {
        Collection<String> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Iterable iterable = typeAccess.getReasons();
        StringBuilder stringBuilder = new StringBuilder().append('`').append(name).append("` is not accessible in a type safe way because:\n");
        void var3_4 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void reason;
            InaccessibilityReason inaccessibilityReason = (InaccessibilityReason)item$iv$iv;
            collection = destination$iv$iv;
            String string = "         * - " + reason.getExplanation();
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        return stringBuilder.append(CollectionsKt.joinToString$default((Iterable)collection, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null)).toString();
    }

    private static final String codeForExtension(String extensionName, Function0<String> code) {
        return CodeGeneratorKt.isLegalExtensionName(extensionName) ? StringsKt.replaceIndent$default((String)((String)code.invoke()), null, (int)1, null) : null;
    }

    public static final boolean isLegalExtensionName(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return CodeGeneratorKt.isKotlinIdentifier('`' + name + '`') && StringsKt.indexOfAny$default((CharSequence)name, (char[])invalidNameChars, (int)0, (boolean)false, (int)6, null) < 0;
    }

    private static final boolean isKotlinIdentifier(String candidate) {
        KotlinLexer kotlinLexer;
        KotlinLexer $receiver = kotlinLexer = new KotlinLexer();
        $receiver.start((CharSequence)candidate);
        return $receiver.getTokenStart() == 0 && $receiver.getTokenEnd() == candidate.length() && Intrinsics.areEqual((Object)$receiver.getTokenType(), (Object)KtTokens.IDENTIFIER);
    }
}

