/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.declaration;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.DataClassMethodGenerator;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsConditional;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsFunctionScope;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNew;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsThisRef;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.UtilsKt;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;

class JsDataClassGenerator
extends DataClassMethodGenerator {
    private final TranslationContext context;

    JsDataClassGenerator(KtClassOrObject klass2, TranslationContext context) {
        super(klass2, context.bindingContext());
        this.context = context;
    }

    @Override
    public void generateComponentFunction(@NotNull FunctionDescriptor function2, @NotNull ValueParameterDescriptor parameter) {
        if (function2 == null) {
            JsDataClassGenerator.$$$reportNull$$$0(0);
        }
        if (parameter == null) {
            JsDataClassGenerator.$$$reportNull$$$0(1);
        }
        PropertyDescriptor propertyDescriptor = this.context.bindingContext().get(BindingContext.VALUE_PARAMETER_AS_PROPERTY, parameter);
        assert (propertyDescriptor != null) : "Property descriptor is expected to be non-null";
        JsFunction functionObject = this.generateJsMethod(function2);
        JsNameRef returnExpression = JsAstUtils.pureFqn(this.context.getNameForDescriptor(propertyDescriptor), (JsExpression)new JsThisRef());
        JsReturn returnStatement = new JsReturn(returnExpression);
        returnStatement.setSource(KotlinSourceElementKt.getPsi(parameter.getSource()));
        functionObject.getBody().getStatements().add(returnStatement);
    }

    @Override
    public void generateCopyFunction(@NotNull FunctionDescriptor function2, @NotNull List<? extends KtParameter> constructorParameters) {
        if (function2 == null) {
            JsDataClassGenerator.$$$reportNull$$$0(2);
        }
        if (constructorParameters == null) {
            JsDataClassGenerator.$$$reportNull$$$0(3);
        }
        JsFunction functionObj = this.generateJsMethod(function2);
        assert (function2.getValueParameters().size() == constructorParameters.size());
        ArrayList<JsExpression> constructorArguments = new ArrayList<JsExpression>(constructorParameters.size());
        for (int i = 0; i < constructorParameters.size(); ++i) {
            JsExpression argumentValue;
            KtParameter constructorParam = constructorParameters.get(i);
            ValueParameterDescriptor parameterDescriptor = (ValueParameterDescriptor)BindingContextUtils.getNotNull(this.context.bindingContext(), BindingContext.VALUE_PARAMETER, constructorParam);
            PropertyDescriptor propertyDescriptor = BindingContextUtils.getNotNull(this.context.bindingContext(), BindingContext.VALUE_PARAMETER_AS_PROPERTY, parameterDescriptor);
            JsName fieldName = this.context.getNameForDescriptor(propertyDescriptor);
            JsName paramName = JsScope.declareTemporaryName(this.context.getNameForDescriptor(parameterDescriptor).getIdent());
            functionObj.getParameters().add(new JsParameter(paramName));
            JsNameRef parameterValue = new JsNameRef(paramName);
            if (!constructorParam.hasValOrVar()) {
                assert (!DescriptorUtilsKt.hasDefaultValue(function2.getValueParameters().get(i)));
                argumentValue = parameterValue;
            } else {
                JsBinaryOperation defaultCondition = JsAstUtils.equality(new JsNameRef(paramName), Namer.getUndefinedExpression());
                argumentValue = new JsConditional(defaultCondition, new JsNameRef(fieldName, (JsExpression)new JsThisRef()), parameterValue);
            }
            constructorArguments.add(argumentValue.source(constructorParam));
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)function2.getContainingDeclaration();
        ClassConstructorDescriptor constructor = classDescriptor.getUnsubstitutedPrimaryConstructor();
        assert (constructor != null) : "Data class should have primary constructor: " + classDescriptor;
        JsExpression constructorRef = this.context.getInnerReference(constructor);
        JsNew returnExpression = new JsNew(constructorRef, constructorArguments);
        if (this.context.shouldBeDeferred(constructor)) {
            this.context.deferConstructorCall(constructor, returnExpression.getArguments());
        }
        returnExpression.setSource(this.getDeclaration());
        JsReturn returnStatement = new JsReturn(returnExpression);
        returnStatement.setSource(this.getDeclaration());
        functionObj.getBody().getStatements().add(returnStatement);
    }

    @Override
    public void generateToStringMethod(@NotNull FunctionDescriptor function2, @NotNull List<? extends PropertyDescriptor> classProperties) {
        if (function2 == null) {
            JsDataClassGenerator.$$$reportNull$$$0(4);
        }
        if (classProperties == null) {
            JsDataClassGenerator.$$$reportNull$$$0(5);
        }
        assert (!classProperties.isEmpty());
        JsFunction functionObj = this.generateJsMethod(function2);
        JsExpression result2 = null;
        for (int i = 0; i < classProperties.size(); ++i) {
            String printName = classProperties.get(i).getName().asString();
            JsName name = this.context.getNameForDescriptor(classProperties.get(i));
            JsStringLiteral literal = new JsStringLiteral((i == 0 ? this.getClassDescriptor().getName() + "(" : ", ") + printName + "=");
            JsInvocation expr = new JsInvocation((JsExpression)this.context.namer().kotlin("toString"), new JsNameRef(name, (JsExpression)new JsThisRef()));
            PsiElement source = KotlinSourceElementKt.getPsi(classProperties.get(i).getSource());
            JsExpression component = JsAstUtils.sum(literal, expr).source(source);
            result2 = result2 == null ? component : JsAstUtils.sum(result2, component);
        }
        assert (result2 != null);
        result2 = JsAstUtils.sum(result2, new JsStringLiteral(")"));
        JsReturn returnStatement = new JsReturn(result2);
        returnStatement.setSource(this.getDeclaration());
        functionObj.getBody().getStatements().add(returnStatement);
    }

    @Override
    public void generateHashCodeMethod(@NotNull FunctionDescriptor function2, @NotNull List<? extends PropertyDescriptor> classProperties) {
        if (function2 == null) {
            JsDataClassGenerator.$$$reportNull$$$0(6);
        }
        if (classProperties == null) {
            JsDataClassGenerator.$$$reportNull$$$0(7);
        }
        JsFunction functionObj = this.generateJsMethod(function2);
        List<JsStatement> statements = functionObj.getBody().getStatements();
        JsName varName = functionObj.getScope().declareName("result");
        JsVars resultVar = new JsVars(new JsVars.JsVar(varName, new JsIntLiteral(0)));
        resultVar.setSource(this.getDeclaration());
        statements.add(resultVar);
        for (PropertyDescriptor propertyDescriptor : classProperties) {
            JsName name = this.context.getNameForDescriptor(propertyDescriptor);
            JsInvocation component = new JsInvocation((JsExpression)this.context.namer().kotlin("hashCode"), new JsNameRef(name, (JsExpression)new JsThisRef()));
            JsBinaryOperation newHashValue = JsAstUtils.sum(JsAstUtils.mul(new JsNameRef(varName), new JsIntLiteral(31)), component);
            JsBinaryOperation assignment = JsAstUtils.assignment(new JsNameRef(varName), new JsBinaryOperation(JsBinaryOperator.BIT_OR, newHashValue, new JsIntLiteral(0)));
            statements.add(assignment.source(KotlinSourceElementKt.getPsi(propertyDescriptor.getSource())).makeStmt());
        }
        JsReturn returnStatement = new JsReturn(new JsNameRef(varName));
        returnStatement.setSource(this.getDeclaration());
        statements.add(returnStatement);
    }

    @Override
    public void generateEqualsMethod(@NotNull FunctionDescriptor function2, @NotNull List<? extends PropertyDescriptor> classProperties) {
        if (function2 == null) {
            JsDataClassGenerator.$$$reportNull$$$0(8);
        }
        if (classProperties == null) {
            JsDataClassGenerator.$$$reportNull$$$0(9);
        }
        assert (!classProperties.isEmpty());
        JsFunction functionObj = this.generateJsMethod(function2);
        JsFunctionScope funScope = functionObj.getScope();
        JsName paramName = funScope.declareName("other");
        functionObj.getParameters().add(new JsParameter(paramName));
        JsBinaryOperation referenceEqual = JsAstUtils.equality(new JsThisRef(), new JsNameRef(paramName));
        JsBinaryOperation isNotNull = JsAstUtils.inequality(new JsNameRef(paramName), new JsNullLiteral());
        JsBinaryOperation otherIsObject = JsAstUtils.typeOfIs(paramName.makeRef(), new JsStringLiteral("object"));
        JsBinaryOperation prototypeEqual = JsAstUtils.equality(new JsInvocation((JsExpression)new JsNameRef("getPrototypeOf", (JsExpression)new JsNameRef("Object")), new JsThisRef()), new JsInvocation((JsExpression)new JsNameRef("getPrototypeOf", (JsExpression)new JsNameRef("Object")), new JsNameRef(paramName)));
        JsNode fieldChain = null;
        for (PropertyDescriptor propertyDescriptor : classProperties) {
            JsName name = this.context.getNameForDescriptor(propertyDescriptor);
            PsiElement source = KotlinSourceElementKt.getPsi(propertyDescriptor.getSource());
            JsNode next = new JsInvocation((JsExpression)this.context.namer().kotlin("equals"), new JsNameRef(name, (JsExpression)new JsThisRef()), new JsNameRef(name, (JsExpression)new JsNameRef(paramName))).source(source);
            if (fieldChain == null) {
                fieldChain = next;
                continue;
            }
            fieldChain = JsAstUtils.and((JsExpression)fieldChain, (JsExpression)next);
        }
        assert (fieldChain != null);
        JsBinaryOperation returnExpression = JsAstUtils.or(referenceEqual, JsAstUtils.and(isNotNull, JsAstUtils.and(otherIsObject, JsAstUtils.and(prototypeEqual, fieldChain))));
        JsReturn jsReturn = new JsReturn(returnExpression);
        jsReturn.setSource(this.getDeclaration());
        functionObj.getBody().getStatements().add(jsReturn);
    }

    private JsFunction generateJsMethod(@NotNull FunctionDescriptor functionDescriptor) {
        if (functionDescriptor == null) {
            JsDataClassGenerator.$$$reportNull$$$0(10);
        }
        JsFunction functionObject = this.context.createRootScopedFunction(functionDescriptor);
        functionObject.setSource(this.getDeclaration());
        ClassDescriptor containingClass = (ClassDescriptor)functionDescriptor.getContainingDeclaration();
        this.context.addDeclarationStatement(UtilsKt.addFunctionToPrototype(this.context, containingClass, functionDescriptor, functionObject));
        return functionObject;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructorParameters";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classProperties";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionDescriptor";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/js/translate/declaration/JsDataClassGenerator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "generateComponentFunction";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "generateCopyFunction";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "generateToStringMethod";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "generateHashCodeMethod";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "generateEqualsMethod";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "generateJsMethod";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

