/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.intrinsic.operation;

import java.util.Arrays;
import java.util.EnumSet;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableSet;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.TopLevelFIF;
import org.jetbrains.kotlin.js.translate.intrinsic.operation.AbstractBinaryOperationIntrinsic;
import org.jetbrains.kotlin.js.translate.intrinsic.operation.BinaryOperationIntrinsic;
import org.jetbrains.kotlin.js.translate.intrinsic.operation.BinaryOperationIntrinsicFactory;
import org.jetbrains.kotlin.js.translate.intrinsic.operation.EqualsBOIF;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0012\u0013B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0016J\u0016\u0010\n\u001a\u0010\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f0\u000bH\u0016J$\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0002J\f\u0010\u0010\u001a\u00020\u000f*\u00020\u0011H\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/EqualsBOIF;", "Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/BinaryOperationIntrinsicFactory;", "()V", "getIntrinsic", "Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/BinaryOperationIntrinsic;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "leftType", "Lorg/jetbrains/kotlin/types/KotlinType;", "rightType", "getSupportTokens", "Lorg/jetbrains/kotlin/com/google/common/collect/ImmutableSet;", "Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;", "kotlin.jvm.PlatformType", "isEnumIntrinsicApplicable", "", "isNegated", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "EnumEqualsIntrinsic", "EqualsIntrinsic", "kotlin-compiler"})
public final class EqualsBOIF
implements BinaryOperationIntrinsicFactory {
    public static final EqualsBOIF INSTANCE;

    @NotNull
    public ImmutableSet<KtSingleValueToken> getSupportTokens() {
        ImmutableSet<KtSingleValueToken> immutableSet = OperatorConventions.EQUALS_OPERATIONS;
        if (immutableSet == null) {
            Intrinsics.throwNpe();
        }
        return immutableSet;
    }

    @Override
    @Nullable
    public BinaryOperationIntrinsic getIntrinsic(@NotNull FunctionDescriptor descriptor2, @Nullable KotlinType leftType, @Nullable KotlinType rightType) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        AbstractBinaryOperationIntrinsic result2 = this.isEnumIntrinsicApplicable(descriptor2, leftType, rightType) ? (AbstractBinaryOperationIntrinsic)EnumEqualsIntrinsic.INSTANCE : (KotlinBuiltIns.isBuiltIn(descriptor2) || TopLevelFIF.EQUALS_IN_ANY.test(descriptor2) ? (AbstractBinaryOperationIntrinsic)EqualsIntrinsic.INSTANCE : null);
        return result2;
    }

    private final boolean isEnumIntrinsicApplicable(FunctionDescriptor descriptor2, KotlinType leftType, KotlinType rightType) {
        return DescriptorUtils.isEnumClass(descriptor2.getContainingDeclaration()) && leftType != null && rightType != null && !TypeUtils.isNullableType(leftType) && !TypeUtils.isNullableType(rightType);
    }

    private final boolean isNegated(@NotNull KtBinaryExpression $receiver) {
        return Intrinsics.areEqual(PsiUtils.getOperationToken($receiver), KtTokens.EXCLEQ);
    }

    private EqualsBOIF() {
        INSTANCE = this;
    }

    static {
        new EqualsBOIF();
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\t\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000eH\u0002R2\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/EqualsBOIF$EqualsIntrinsic;", "Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/AbstractBinaryOperationIntrinsic;", "()V", "SIMPLE_PRIMITIVES", "Ljava/util/EnumSet;", "Lorg/jetbrains/kotlin/builtins/PrimitiveType;", "kotlin.jvm.PlatformType", "apply", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "left", "right", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "getRefinedType", "Lorg/jetbrains/kotlin/types/KotlinType;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "kotlin-compiler"})
    private static final class EqualsIntrinsic
    extends AbstractBinaryOperationIntrinsic {
        private static final EnumSet<PrimitiveType> SIMPLE_PRIMITIVES;
        public static final EqualsIntrinsic INSTANCE;

        @Override
        @NotNull
        public JsExpression apply(@NotNull KtBinaryExpression expression2, @NotNull JsExpression left, @NotNull JsExpression right, @NotNull TranslationContext context) {
            JsExpression jsExpression;
            boolean appliedToDynamic;
            ReceiverValue $i$a$1$let;
            ReceiverValue $receiver;
            PrimitiveType rightType;
            PrimitiveType primitiveType;
            PrimitiveType primitiveType2;
            KotlinType it;
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            Intrinsics.checkParameterIsNotNull(left, "left");
            Intrinsics.checkParameterIsNotNull(right, "right");
            Intrinsics.checkParameterIsNotNull(context, "context");
            boolean isNegated = INSTANCE.isNegated(expression2);
            if (right instanceof JsNullLiteral || left instanceof JsNullLiteral) {
                JsBinaryOperation jsBinaryOperation = TranslationUtils.nullCheck(right instanceof JsNullLiteral ? left : right, isNegated);
                Intrinsics.checkExpressionValueIsNotNull(jsBinaryOperation, "TranslationUtils.nullChe\u2026ft else right, isNegated)");
                return jsBinaryOperation;
            }
            KtExpression ktExpression = expression2.getLeft();
            if (ktExpression == null) {
                String string = "No left-hand side: " + expression2.getText();
                throw (Throwable)new IllegalStateException(string.toString());
            }
            KtExpression ktLeft = ktExpression;
            KtExpression $i$a$1$checkNotNull = expression2.getRight();
            if ($i$a$1$checkNotNull == null) {
                String string = "No right-hand side: " + expression2.getText();
                throw (Throwable)new IllegalStateException(string.toString());
            }
            KtExpression ktRight = $i$a$1$checkNotNull;
            KotlinType kotlinType = this.getRefinedType(ktLeft, context);
            if (kotlinType != null) {
                KotlinType $i$a$1$checkNotNull2;
                it = $i$a$1$checkNotNull2 = kotlinType;
                primitiveType2 = KotlinBuiltIns.getPrimitiveType(it);
            } else {
                primitiveType2 = null;
            }
            PrimitiveType leftType = primitiveType2;
            KotlinType kotlinType2 = this.getRefinedType(ktRight, context);
            if (kotlinType2 != null) {
                KotlinType it2 = it = kotlinType2;
                primitiveType = KotlinBuiltIns.getPrimitiveType(it2);
            } else {
                primitiveType = rightType = null;
            }
            if (leftType != null && (SIMPLE_PRIMITIVES.contains((Object)leftType) || Intrinsics.areEqual((Object)leftType, (Object)rightType) && Intrinsics.areEqual((Object)leftType, (Object)PrimitiveType.LONG) ^ true)) {
                return new JsBinaryOperation(isNegated ? JsBinaryOperator.REF_NEQ : JsBinaryOperator.REF_EQ, Translation.unboxIfNeeded(left, Intrinsics.areEqual((Object)leftType, (Object)PrimitiveType.CHAR)), Translation.unboxIfNeeded(right, Intrinsics.areEqual((Object)rightType, (Object)PrimitiveType.CHAR)));
            }
            KtElement ktElement = expression2;
            BindingContext bindingContext = context.bindingContext();
            Intrinsics.checkExpressionValueIsNotNull(bindingContext, "context.bindingContext()");
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, bindingContext);
            boolean bl = resolvedCall2 != null && (($receiver = ($i$a$1$let = resolvedCall2.getDispatchReceiver())) != null ? DynamicTypesKt.isDynamic($receiver.getType()) : false) ? true : (appliedToDynamic = false);
            if (appliedToDynamic) {
                return new JsBinaryOperation(isNegated ? JsBinaryOperator.NEQ : JsBinaryOperator.EQ, left, right);
            }
            JsExpression maybeBoxedLeft = Intrinsics.areEqual((Object)leftType, (Object)PrimitiveType.CHAR) ? JsAstUtils.charToBoxedChar(left) : left;
            JsExpression maybeBoxedRight = Intrinsics.areEqual((Object)rightType, (Object)PrimitiveType.CHAR) ? JsAstUtils.charToBoxedChar(right) : right;
            JsExpression result2 = TopLevelFIF.KOTLIN_EQUALS.apply(maybeBoxedLeft, Arrays.asList(maybeBoxedRight), context);
            if (isNegated) {
                JsPrefixOperation jsPrefixOperation = JsAstUtils.not(result2);
                Intrinsics.checkExpressionValueIsNotNull(jsPrefixOperation, "JsAstUtils.not(result)");
                jsExpression = jsPrefixOperation;
            } else {
                JsExpression jsExpression2 = result2;
                jsExpression = jsExpression2;
                Intrinsics.checkExpressionValueIsNotNull(jsExpression2, "result");
            }
            return jsExpression;
        }

        private final KotlinType getRefinedType(KtExpression expression2, TranslationContext context) {
            KotlinType kotlinType;
            KotlinType kotlinType2;
            Object v5;
            Iterable iterable;
            Iterable iterable2;
            getRefinedType.isPrimitiveFn.1 isPrimitiveFn2;
            KotlinType ktType;
            block6: {
                BindingContext bindingContext = context.bindingContext();
                DeclarationDescriptor declarationDescriptor = context.getDeclarationDescriptor();
                if (declarationDescriptor == null) {
                    ModuleDescriptor moduleDescriptor = context.getCurrentModule();
                    Intrinsics.checkExpressionValueIsNotNull(moduleDescriptor, "context.currentModule");
                    declarationDescriptor = moduleDescriptor;
                }
                DeclarationDescriptor descriptor2 = declarationDescriptor;
                KotlinType kotlinType3 = bindingContext.getType(expression2);
                if (kotlinType3 == null) {
                    return null;
                }
                KotlinType kotlinType4 = ktType = kotlinType3;
                Intrinsics.checkExpressionValueIsNotNull(kotlinType4, "ktType");
                BindingContext bindingContext2 = bindingContext;
                Intrinsics.checkExpressionValueIsNotNull(bindingContext2, "bindingContext");
                DataFlowValue dataFlow = DataFlowValueFactory.createDataFlowValue(expression2, kotlinType4, bindingContext2, descriptor2);
                isPrimitiveFn2 = getRefinedType.isPrimitiveFn.1.INSTANCE;
                iterable = iterable2 = (Iterable)BindingContextUtilsKt.getDataFlowInfoBefore(bindingContext, expression2).getStableTypes(dataFlow);
                for (Object t : iterable) {
                    if (!((Boolean)((Function1)isPrimitiveFn2).invoke(t)).booleanValue()) continue;
                    v5 = t;
                    break block6;
                }
                v5 = null;
            }
            if ((kotlinType2 = (KotlinType)v5) == null) {
                Object v7;
                block7: {
                    iterable = iterable2 = (Iterable)TypeUtils.getAllSupertypes(ktType);
                    for (Object t : iterable) {
                        if (!((Boolean)((Function1)isPrimitiveFn2).invoke(t)).booleanValue()) continue;
                        v7 = t;
                        break block7;
                    }
                    v7 = null;
                }
                kotlinType2 = kotlinType = (KotlinType)v7;
            }
            if (kotlinType2 == null) {
                kotlinType = ktType;
            }
            return kotlinType;
        }

        private EqualsIntrinsic() {
            INSTANCE = this;
            SIMPLE_PRIMITIVES = EnumSet.of((Enum)PrimitiveType.BYTE, (Enum)PrimitiveType.SHORT, (Enum)PrimitiveType.INT);
        }

        static {
            new EqualsIntrinsic();
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/EqualsBOIF$EnumEqualsIntrinsic;", "Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/AbstractBinaryOperationIntrinsic;", "()V", "apply", "Lorg/jetbrains/kotlin/js/backend/ast/JsBinaryOperation;", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "left", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "right", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "kotlin-compiler"})
    public static final class EnumEqualsIntrinsic
    extends AbstractBinaryOperationIntrinsic {
        public static final EnumEqualsIntrinsic INSTANCE;

        @Override
        @NotNull
        public JsBinaryOperation apply(@NotNull KtBinaryExpression expression2, @NotNull JsExpression left, @NotNull JsExpression right, @NotNull TranslationContext context) {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            Intrinsics.checkParameterIsNotNull(left, "left");
            Intrinsics.checkParameterIsNotNull(right, "right");
            Intrinsics.checkParameterIsNotNull(context, "context");
            JsBinaryOperator operator = INSTANCE.isNegated(expression2) ? JsBinaryOperator.REF_NEQ : JsBinaryOperator.REF_EQ;
            return new JsBinaryOperation(operator, left, right);
        }

        private EnumEqualsIntrinsic() {
            INSTANCE = this;
        }

        static {
            new EnumEqualsIntrinsic();
        }
    }
}

