/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.glsof.common.utils;

import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sourceforge.glsof.common.i18n.Messages;

public class WidgetUtils {
    public static JButton createTipButton(String iconPath, String toolTip) {
        final JButton b = new JButton(new ImageIcon(WidgetUtils.class.getResource(iconPath)));
        final Border raisedBevelBorder = BorderFactory.createRaisedBevelBorder();
        Insets insets = raisedBevelBorder.getBorderInsets(b);
        final EmptyBorder emptyBorder = new EmptyBorder(insets);
        b.setBorder(emptyBorder);
        b.setFocusPainted(false);
        b.setOpaque(false);
        b.setContentAreaFilled(false);
        b.setToolTipText(Messages.NLS(toolTip));
        b.getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ButtonModel model = (ButtonModel)e.getSource();
                if (model.isRollover()) {
                    b.setBorder(raisedBevelBorder);
                } else {
                    b.setBorder(emptyBorder);
                }
            }
        });
        return b;
    }

    public static JLabel createLabel(String text, String tip) {
        JLabel label = new JLabel(text);
        label.setToolTipText(tip);
        return label;
    }

    public static JButton createButton(String text, String tip) {
        JButton button = new JButton(text);
        button.setToolTipText(tip);
        return button;
    }

    public static JCheckBox createCheckBox(String text, String tip) {
        JCheckBox checkBox = new JCheckBox(text);
        checkBox.setToolTipText(tip);
        return checkBox;
    }
}

