/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import sun.awt.SunToolkit;
import sun.font.GlyphList;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.loops.FontInfo;
import sun.java2d.loops.GraphicsPrimitive;
import sun.java2d.pipe.GlyphListPipe;
import sun.java2d.pipe.Region;
import sun.java2d.x11.X11SurfaceData;

public class X11TextRenderer
extends GlyphListPipe {
    @Override
    public void drawGlyphVector(SunGraphics2D sunGraphics2D, GlyphVector glyphVector, float f, float f2) {
        FontRenderContext fontRenderContext = glyphVector.getFontRenderContext();
        FontInfo fontInfo = sunGraphics2D.getGVFontInfo(glyphVector.getFont(), fontRenderContext);
        switch (fontInfo.aaHint) {
            case 1: {
                super.drawGlyphVector(sunGraphics2D, glyphVector, f, f2);
                return;
            }
            case 2: {
                SurfaceData cfr_ignored_0 = sunGraphics2D.surfaceData;
                SurfaceData.aaTextRenderer.drawGlyphVector(sunGraphics2D, glyphVector, f, f2);
                return;
            }
            case 4: 
            case 6: {
                SurfaceData cfr_ignored_1 = sunGraphics2D.surfaceData;
                SurfaceData.lcdTextRenderer.drawGlyphVector(sunGraphics2D, glyphVector, f, f2);
                return;
            }
        }
    }

    native void doDrawGlyphList(long var1, long var3, Region var5, GlyphList var6);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void drawGlyphList(SunGraphics2D sunGraphics2D, GlyphList glyphList) {
        SunToolkit.awtLock();
        try {
            X11SurfaceData x11SurfaceData = (X11SurfaceData)sunGraphics2D.surfaceData;
            Region region = sunGraphics2D.getCompClip();
            long l = x11SurfaceData.getRenderGC(region, 0, null, sunGraphics2D.pixel);
            this.doDrawGlyphList(x11SurfaceData.getNativeOps(), l, region, glyphList);
        }
        finally {
            SunToolkit.awtUnlock();
        }
    }

    public X11TextRenderer traceWrap() {
        return new Tracer();
    }

    public static class Tracer
    extends X11TextRenderer {
        @Override
        void doDrawGlyphList(long l, long l2, Region region, GlyphList glyphList) {
            GraphicsPrimitive.tracePrimitive("X11DrawGlyphs");
            super.doDrawGlyphList(l, l2, region, glyphList);
        }
    }
}

