/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.ui;

import com.sun.star.awt.FontDescriptor;
import com.sun.star.awt.Rectangle;
import com.sun.star.awt.Size;
import com.sun.star.awt.XActionListener;
import com.sun.star.awt.XAdjustmentListener;
import com.sun.star.awt.XButton;
import com.sun.star.awt.XControl;
import com.sun.star.awt.XControlContainer;
import com.sun.star.awt.XControlModel;
import com.sun.star.awt.XDialog;
import com.sun.star.awt.XFixedText;
import com.sun.star.awt.XItemListener;
import com.sun.star.awt.XLayoutConstrains;
import com.sun.star.awt.XListBox;
import com.sun.star.awt.XRadioButton;
import com.sun.star.awt.XReschedule;
import com.sun.star.awt.XScrollBar;
import com.sun.star.awt.XTextComponent;
import com.sun.star.awt.XTextListener;
import com.sun.star.awt.XToolkit;
import com.sun.star.awt.XVclWindowPeer;
import com.sun.star.awt.XView;
import com.sun.star.awt.XWindow;
import com.sun.star.awt.XWindowPeer;
import com.sun.star.beans.XMultiPropertySet;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.frame.XFrame;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.uno.Any;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.wizards.common.Desktop;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.common.Resource;
import com.sun.star.wizards.ui.PeerConfig;
import com.sun.star.wizards.ui.UIConsts;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnoDialog {
    public XMultiServiceFactory xMSF;
    XMultiServiceFactory MSFDialogModel;
    private XNameContainer xDlgNames;
    XControlContainer xDlgContainer;
    private XNameAccess m_xDlgNameAccess;
    public XControl xControl;
    public XDialog xDialog;
    public XReschedule xReschedule;
    public XWindow xWindow;
    public XComponent xComponent;
    public XInterface xDialogModel;
    private XInterface xUnoDialog;
    private XVclWindowPeer xVclWindowPeer;
    public HashMap<String, Integer> ControlList;
    public Resource m_oResource;
    public XWindowPeer xWindowPeer = null;
    private PeerConfig m_oPeerConfig;
    private Boolean BisHighContrastModeActivated = null;

    public UnoDialog(XMultiServiceFactory xMSF) {
        try {
            this.xMSF = xMSF;
            this.ControlList = new HashMap();
            this.xDialogModel = (XInterface)xMSF.createInstance("com.sun.star.awt.UnoControlDialogModel");
            XMultiPropertySet xMultiPSetDlg = (XMultiPropertySet)UnoRuntime.queryInterface(XMultiPropertySet.class, (Object)this.xDialogModel);
            xMultiPSetDlg.setPropertyValues(new String[0], new Object[0]);
            this.MSFDialogModel = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)this.xDialogModel);
            this.xUnoDialog = (XInterface)xMSF.createInstance("com.sun.star.awt.UnoControlDialog");
            this.xControl = (XControl)UnoRuntime.queryInterface(XControl.class, (Object)this.xUnoDialog);
            XControlModel xControlModel = (XControlModel)UnoRuntime.queryInterface(XControlModel.class, (Object)this.xDialogModel);
            this.xControl.setModel(xControlModel);
            UnoRuntime.queryInterface(XPropertySet.class, (Object)this.xDialogModel);
            this.xDlgContainer = (XControlContainer)UnoRuntime.queryInterface(XControlContainer.class, (Object)this.xUnoDialog);
            this.xDlgNames = (XNameContainer)UnoRuntime.queryInterface(XNameContainer.class, (Object)this.xDialogModel);
            this.xComponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)this.xUnoDialog);
            this.xWindow = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)this.xUnoDialog);
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public int getControlKey(Object EventObject2, HashMap<String, Integer> ControlList) {
        int iKey;
        XControl xContrl = (XControl)UnoRuntime.queryInterface(XControl.class, (Object)EventObject2);
        XControlModel xControlModel = xContrl.getModel();
        XPropertySet xPSet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xControlModel);
        try {
            String sName = (String)xPSet.getPropertyValue(PropertyNames.PROPERTY_NAME);
            Integer KeyObject = ControlList.get(sName);
            iKey = KeyObject;
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(System.err);
            iKey = 2000;
        }
        return iKey;
    }

    private void createPeerConfiguration() {
        this.m_oPeerConfig = new PeerConfig(this);
    }

    public PeerConfig getPeerConfiguration() {
        if (this.m_oPeerConfig == null) {
            this.createPeerConfiguration();
        }
        return this.m_oPeerConfig;
    }

    XNameAccess getDlgNameAccess() {
        if (this.m_xDlgNameAccess == null) {
            this.m_xDlgNameAccess = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)this.xDialogModel);
        }
        return this.m_xDlgNameAccess;
    }

    public void setControlProperty(String ControlName, String PropertyName, Object PropertyValue2) {
        try {
            if (PropertyValue2 != null) {
                if (!this.getDlgNameAccess().hasByName(ControlName)) {
                    return;
                }
                Object xControlModel = this.getDlgNameAccess().getByName(ControlName);
                XPropertySet xPSet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xControlModel);
                if (AnyConverter.isArray((Object)PropertyValue2)) {
                    Type seqType = new Type(PropertyValue2.getClass());
                    PropertyValue2 = new Any(seqType, PropertyValue2);
                }
                xPSet.setPropertyValue(PropertyName, PropertyValue2);
            }
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public Resource getResource() {
        return this.m_oResource;
    }

    public void setControlProperties(String ControlName, String[] PropertyNames2, Object[] PropertyValues) {
        try {
            if (PropertyValues != null) {
                if (!this.getDlgNameAccess().hasByName(ControlName)) {
                    return;
                }
                Object xControlModel = this.getDlgNameAccess().getByName(ControlName);
                XMultiPropertySet xMultiPSet = (XMultiPropertySet)UnoRuntime.queryInterface(XMultiPropertySet.class, (Object)xControlModel);
                xMultiPSet.setPropertyValues(PropertyNames2, PropertyValues);
            }
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public Object getControlProperty(String ControlName, String PropertyName) {
        try {
            Object xControlModel = this.getDlgNameAccess().getByName(ControlName);
            XPropertySet xPSet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xControlModel);
            return xPSet.getPropertyValue(PropertyName);
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(System.err);
            return null;
        }
    }

    public double getMAPConversionFactor(String ControlName) {
        XControl xControl2 = this.xDlgContainer.getControl(ControlName);
        XView xView = (XView)UnoRuntime.queryInterface(XView.class, (Object)xControl2);
        Size aSize = xView.getSize();
        double dblMAPWidth = ((Integer)Helper.getUnoPropertyValue(xControl2.getModel(), PropertyNames.PROPERTY_WIDTH)).intValue();
        return (double)aSize.Width / dblMAPWidth;
    }

    public Size getpreferredLabelSize(String LabelName, String sLabel) {
        XControl xControl2 = this.xDlgContainer.getControl(LabelName);
        XFixedText xFixedText = (XFixedText)UnoRuntime.queryInterface(XFixedText.class, (Object)xControl2);
        String OldText = xFixedText.getText();
        xFixedText.setText(sLabel);
        XLayoutConstrains xLayoutConstrains = (XLayoutConstrains)UnoRuntime.queryInterface(XLayoutConstrains.class, (Object)xControl2);
        Size aSize = xLayoutConstrains.getPreferredSize();
        xFixedText.setText(OldText);
        return aSize;
    }

    public void removeSelectedItems(XListBox xListBox) {
        short[] SelList = xListBox.getSelectedItemsPos();
        int Sellen = SelList.length;
        for (int i = Sellen - 1; i >= 0; --i) {
            xListBox.removeItems(SelList[i], (short)1);
        }
    }

    public static int getListBoxItemCount(XListBox _xListBox) {
        String[] fieldnames = (String[])Helper.getUnoPropertyValue(UnoDialog.getModel(_xListBox), PropertyNames.STRING_ITEM_LIST);
        return fieldnames.length;
    }

    public static short getSelectedItemPos(XListBox _xListBox) {
        short[] ipos = (short[])Helper.getUnoPropertyValue(UnoDialog.getModel(_xListBox), PropertyNames.SELECTED_ITEMS);
        return ipos[0];
    }

    public static boolean isListBoxSelected(XListBox _xListBox) {
        short[] ipos = (short[])Helper.getUnoPropertyValue(UnoDialog.getModel(_xListBox), PropertyNames.SELECTED_ITEMS);
        return ipos.length > 0;
    }

    public XFixedText insertLabel(String sName, String[] sPropNames, Object[] oPropValues) {
        try {
            XInterface oFixedText = this.insertControlModel("com.sun.star.awt.UnoControlFixedTextModel", sName, sPropNames, oPropValues);
            XPropertySet xPSet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)oFixedText);
            xPSet.setPropertyValue(PropertyNames.PROPERTY_NAME, (Object)sName);
            XControl oLabel = this.xDlgContainer.getControl(sName);
            return (XFixedText)UnoRuntime.queryInterface(XFixedText.class, (Object)oLabel);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public XButton insertButton(String sName, int iControlKey, XActionListener xActionListener, String[] sProperties, Object[] sValues) throws com.sun.star.uno.Exception {
        XInterface oButtonModel = this.insertControlModel("com.sun.star.awt.UnoControlButtonModel", sName, sProperties, sValues);
        XPropertySet xPSet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)oButtonModel);
        xPSet.setPropertyValue(PropertyNames.PROPERTY_NAME, (Object)sName);
        XControl objectButton = this.xDlgContainer.getControl(sName);
        XButton xButton = (XButton)UnoRuntime.queryInterface(XButton.class, (Object)objectButton);
        if (xActionListener != null) {
            xButton.addActionListener(xActionListener);
        }
        Integer ControlKey = iControlKey;
        if (this.ControlList != null) {
            this.ControlList.put(sName, ControlKey);
        }
        return xButton;
    }

    public XScrollBar insertScrollBar(String sName, int iControlKey, XAdjustmentListener xAdjustmentListener, String[] sProperties, Object[] sValues) {
        try {
            XInterface oScrollModel = this.insertControlModel("com.sun.star.awt.UnoControlScrollBarModel", sName, sProperties, sValues);
            XPropertySet xPSet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)oScrollModel);
            xPSet.setPropertyValue(PropertyNames.PROPERTY_NAME, (Object)sName);
            XControl oScrollBar = this.xDlgContainer.getControl(sName);
            XScrollBar xScrollBar = (XScrollBar)UnoRuntime.queryInterface(XScrollBar.class, (Object)oScrollBar);
            if (xAdjustmentListener != null) {
                xScrollBar.addAdjustmentListener(xAdjustmentListener);
            }
            Integer ControlKey = iControlKey;
            if (this.ControlList != null) {
                this.ControlList.put(sName, ControlKey);
            }
            return xScrollBar;
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(System.err);
            return null;
        }
    }

    public XTextComponent insertTextField(String sName, int iControlKey, XTextListener xTextListener, String[] sProperties, Object[] sValues) {
        return this.insertEditField("com.sun.star.awt.UnoControlEditModel", sName, iControlKey, xTextListener, sProperties, sValues);
    }

    public XTextComponent insertFormattedField(String sName, int iControlKey, XTextListener xTextListener, String[] sProperties, Object[] sValues) {
        return this.insertEditField("com.sun.star.awt.UnoControlFormattedFieldModel", sName, iControlKey, xTextListener, sProperties, sValues);
    }

    private XTextComponent insertEditField(String ServiceName, String sName, int iControlKey, XTextListener xTextListener, String[] sProperties, Object[] sValues) {
        try {
            XInterface xTextModel = this.insertControlModel(ServiceName, sName, sProperties, sValues);
            XPropertySet xPSet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xTextModel);
            xPSet.setPropertyValue(PropertyNames.PROPERTY_NAME, (Object)sName);
            XControl xTextField = this.xDlgContainer.getControl(sName);
            XTextComponent xTextBox = (XTextComponent)UnoRuntime.queryInterface(XTextComponent.class, (Object)xTextField);
            if (xTextListener != null) {
                xTextBox.addTextListener(xTextListener);
            }
            Integer ControlKey = iControlKey;
            this.ControlList.put(sName, ControlKey);
            return xTextBox;
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(System.err);
            return null;
        }
    }

    public XListBox insertListBox(String sName, int iControlKey, XActionListener xActionListener, XItemListener xItemListener, String[] sProperties, Object[] sValues) throws com.sun.star.uno.Exception {
        XInterface xListBoxModel = this.insertControlModel("com.sun.star.awt.UnoControlListBoxModel", sName, sProperties, sValues);
        XPropertySet xPSet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xListBoxModel);
        xPSet.setPropertyValue(PropertyNames.PROPERTY_NAME, (Object)sName);
        XControl xControlListBox = this.xDlgContainer.getControl(sName);
        XListBox xListBox = (XListBox)UnoRuntime.queryInterface(XListBox.class, (Object)xControlListBox);
        if (xItemListener != null) {
            xListBox.addItemListener(xItemListener);
        }
        if (xActionListener != null) {
            xListBox.addActionListener(xActionListener);
        }
        Integer ControlKey = iControlKey;
        this.ControlList.put(sName, ControlKey);
        return xListBox;
    }

    public XRadioButton insertRadioButton(String sName, int iControlKey, XItemListener xItemListener, String[] sProperties, Object[] sValues) {
        XRadioButton xRadioButton = this.insertRadioButton(sName, iControlKey, sProperties, sValues);
        if (xItemListener != null) {
            xRadioButton.addItemListener(xItemListener);
        }
        return xRadioButton;
    }

    public XButton insertRadioButton(String sName, int iControlKey, XActionListener xActionListener, String[] sProperties, Object[] sValues) {
        XRadioButton xRadioButton = this.insertRadioButton(sName, iControlKey, sProperties, sValues);
        XButton xButton = (XButton)UnoRuntime.queryInterface(XButton.class, (Object)xRadioButton);
        if (xActionListener != null) {
            xButton.addActionListener(xActionListener);
        }
        return xButton;
    }

    public XRadioButton insertRadioButton(String sName, int iControlKey, String[] sProperties, Object[] sValues) {
        XRadioButton xRadioButton = this.insertRadioButton(sName, sProperties, sValues);
        Integer ControlKey = iControlKey;
        this.ControlList.put(sName, ControlKey);
        return xRadioButton;
    }

    public XRadioButton insertRadioButton(String sName, String[] sProperties, Object[] sValues) {
        try {
            XInterface oRadioButtonModel = this.insertControlModel("com.sun.star.awt.UnoControlRadioButtonModel", sName, sProperties, sValues);
            XPropertySet xPSet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)oRadioButtonModel);
            xPSet.setPropertyValue(PropertyNames.PROPERTY_NAME, (Object)sName);
            XControl xControlRadioButton = this.xDlgContainer.getControl(sName);
            return (XRadioButton)UnoRuntime.queryInterface(XRadioButton.class, (Object)xControlRadioButton);
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(System.err);
            return null;
        }
    }

    public void setControlVisible(String controlname, boolean bIsVisible) {
        try {
            int iCurDialogStep = AnyConverter.toInt((Object)Helper.getUnoPropertyValue(this.xDialogModel, PropertyNames.PROPERTY_STEP));
            if (bIsVisible) {
                this.setControlProperty(controlname, PropertyNames.PROPERTY_STEP, iCurDialogStep);
            } else {
                this.setControlProperty(controlname, PropertyNames.PROPERTY_STEP, UIConsts.INVISIBLESTEP);
            }
        }
        catch (IllegalArgumentException exception) {
            exception.printStackTrace(System.err);
        }
    }

    public void repaintDialogStep() {
        try {
            int ncurstep = AnyConverter.toInt((Object)Helper.getUnoPropertyValue(this.xDialogModel, PropertyNames.PROPERTY_STEP));
            Helper.setUnoPropertyValue(this.xDialogModel, PropertyNames.PROPERTY_STEP, 99);
            Helper.setUnoPropertyValue(this.xDialogModel, PropertyNames.PROPERTY_STEP, ncurstep);
        }
        catch (IllegalArgumentException exception) {
            exception.printStackTrace(System.err);
        }
    }

    public XInterface insertControlModel(String ServiceName, String sName, String[] sProperties, Object[] sValues) {
        try {
            XInterface xControlModel = (XInterface)this.MSFDialogModel.createInstance(ServiceName);
            Helper.setUnoPropertyValues(xControlModel, sProperties, sValues);
            this.xDlgNames.insertByName(sName, (Object)xControlModel);
            return xControlModel;
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(System.err);
            return null;
        }
    }

    public void setFocus(String ControlName) {
        XControl oFocusControl = this.xDlgContainer.getControl(ControlName);
        XWindow xWindow = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)oFocusControl);
        xWindow.setFocus();
    }

    public void selectListBoxItem(XListBox xListBox, short iFieldsSelIndex) {
        short FieldCount;
        if (iFieldsSelIndex > -1 && (FieldCount = xListBox.getItemCount()) > 0) {
            if (iFieldsSelIndex < FieldCount) {
                xListBox.selectItemPos(iFieldsSelIndex, true);
            } else {
                xListBox.selectItemPos((short)(iFieldsSelIndex - 1), true);
            }
        }
    }

    public static void deselectListBox(XInterface _xBasisListBox) {
        Object oListBoxModel = UnoDialog.getModel(_xBasisListBox);
        Object sList = Helper.getUnoPropertyValue(oListBoxModel, PropertyNames.STRING_ITEM_LIST);
        Helper.setUnoPropertyValue(oListBoxModel, PropertyNames.STRING_ITEM_LIST, new String[0]);
        Helper.setUnoPropertyValue(oListBoxModel, PropertyNames.STRING_ITEM_LIST, sList);
    }

    public void calculateDialogPosition(Rectangle FramePosSize) {
        Rectangle CurPosSize = this.xWindow.getPosSize();
        int WindowHeight = FramePosSize.Height;
        int WindowWidth = FramePosSize.Width;
        int DialogWidth = CurPosSize.Width;
        int DialogHeight = CurPosSize.Height;
        int iXPos = WindowWidth / 2 - DialogWidth / 2;
        int iYPos = WindowHeight / 2 - DialogHeight / 2;
        this.xWindow.setPosSize(iXPos, iYPos, DialogWidth, DialogHeight, (short)3);
    }

    public short executeDialog(Rectangle FramePosSize) throws com.sun.star.uno.Exception {
        if (this.xControl.getPeer() == null) {
            throw new java.lang.IllegalArgumentException("Please create a peer, using your own frame");
        }
        this.calculateDialogPosition(FramePosSize);
        if (this.xWindowPeer == null) {
            this.createWindowPeer();
        }
        this.xVclWindowPeer = (XVclWindowPeer)UnoRuntime.queryInterface(XVclWindowPeer.class, (Object)this.xWindowPeer);
        this.BisHighContrastModeActivated = this.isHighContrastModeActivated();
        this.xDialog = (XDialog)UnoRuntime.queryInterface(XDialog.class, (Object)this.xUnoDialog);
        return this.xDialog.execute();
    }

    public short executeDialog(XInterface xComponent) throws com.sun.star.uno.Exception {
        XWindow w;
        XFrame frame = (XFrame)UnoRuntime.queryInterface(XFrame.class, (Object)xComponent);
        if (frame != null && (w = frame.getComponentWindow()) != null) {
            return this.executeDialog(w.getPosSize());
        }
        return this.executeDialog(new Rectangle(0, 0, 640, 400));
    }

    public short executeDialog() throws com.sun.star.uno.Exception {
        return this.executeDialog((XInterface)Desktop.getActiveFrame(this.xMSF));
    }

    public void modifyFontWeight(String ControlName, float FontWeight) {
        FontDescriptor oFontDesc = new FontDescriptor();
        oFontDesc.Weight = FontWeight;
        this.setControlProperty(ControlName, PropertyNames.FONT_DESCRIPTOR, oFontDesc);
    }

    public XWindowPeer createWindowPeer(XWindowPeer parentPeer) throws com.sun.star.uno.Exception {
        this.xWindow.setVisible(false);
        Object tk = this.xMSF.createInstance("com.sun.star.awt.Toolkit");
        if (parentPeer == null) {
            parentPeer = ((XToolkit)UnoRuntime.queryInterface(XToolkit.class, (Object)tk)).getDesktopWindow();
        }
        XToolkit xToolkit = (XToolkit)UnoRuntime.queryInterface(XToolkit.class, (Object)tk);
        this.xReschedule = (XReschedule)UnoRuntime.queryInterface(XReschedule.class, (Object)xToolkit);
        this.xControl.createPeer(xToolkit, parentPeer);
        this.xWindowPeer = this.xControl.getPeer();
        return this.xControl.getPeer();
    }

    public XWindowPeer createWindowPeer() throws com.sun.star.uno.Exception {
        return this.createWindowPeer(null);
    }

    public static Object getModel(Object control) {
        XControl xControl = (XControl)UnoRuntime.queryInterface(XControl.class, (Object)control);
        return xControl.getModel();
    }

    public static void setEnabled(Object control, boolean enabled) {
        UnoDialog.setEnabled(control, enabled ? Boolean.TRUE : Boolean.FALSE);
    }

    private static void setEnabled(Object control, Boolean enabled) {
        Helper.setUnoPropertyValue(UnoDialog.getModel(control), PropertyNames.PROPERTY_ENABLED, enabled);
    }

    private static int getControlModelType(Object oControlModel) {
        XServiceInfo xServiceInfo = (XServiceInfo)UnoRuntime.queryInterface(XServiceInfo.class, (Object)oControlModel);
        if (xServiceInfo.supportsService("com.sun.star.awt.UnoControlFixedTextModel")) {
            return 11;
        }
        if (xServiceInfo.supportsService("com.sun.star.awt.UnoControlButtonModel")) {
            return 1;
        }
        if (xServiceInfo.supportsService("com.sun.star.awt.UnoControlCurrencyFieldModel")) {
            return 21;
        }
        if (xServiceInfo.supportsService("com.sun.star.awt.UnoControlDateFieldModel")) {
            return 7;
        }
        if (xServiceInfo.supportsService("com.sun.star.awt.UnoControlFixedLineModel")) {
            return 10;
        }
        if (xServiceInfo.supportsService("com.sun.star.awt.UnoControlFormattedFieldModel")) {
            return 12;
        }
        if (xServiceInfo.supportsService("com.sun.star.awt.UnoControlRoadmapModel")) {
            return 18;
        }
        if (xServiceInfo.supportsService("com.sun.star.awt.UnoControlNumericFieldModel")) {
            return 15;
        }
        if (xServiceInfo.supportsService("com.sun.star.awt.UnoControlPatternFieldModel")) {
            return 16;
        }
        if (xServiceInfo.supportsService("com.sun.star.awt.UnoControlHyperTextModel")) {
            return 14;
        }
        if (xServiceInfo.supportsService("com.sun.star.awt.UnoControlProgressBarModel")) {
            return 17;
        }
        if (xServiceInfo.supportsService("com.sun.star.awt.UnoControlTimeFieldModel")) {
            return 20;
        }
        if (xServiceInfo.supportsService("com.sun.star.awt.UnoControlImageControlModel")) {
            return 2;
        }
        if (xServiceInfo.supportsService("com.sun.star.awt.UnoControlRadioButtonModel")) {
            return 6;
        }
        if (xServiceInfo.supportsService("com.sun.star.awt.UnoControlCheckBoxModel")) {
            return 5;
        }
        if (xServiceInfo.supportsService("com.sun.star.awt.UnoControlEditModel")) {
            return 8;
        }
        if (xServiceInfo.supportsService("com.sun.star.awt.UnoControlComboBoxModel")) {
            return 4;
        }
        if (xServiceInfo.supportsService("com.sun.star.awt.UnoControlListBoxModel")) {
            return 3;
        }
        return -1;
    }

    public static String getDisplayProperty(Object oControlModel) {
        int itype = UnoDialog.getControlModelType(oControlModel);
        return UnoDialog.getDisplayProperty(itype);
    }

    private static String getDisplayProperty(int itype) {
        switch (itype) {
            case 11: {
                return PropertyNames.PROPERTY_LABEL;
            }
            case 1: {
                return PropertyNames.PROPERTY_LABEL;
            }
            case 10: {
                return PropertyNames.PROPERTY_LABEL;
            }
            case 15: {
                return "Value";
            }
            case 21: {
                return "Value";
            }
            case 12: {
                return "EffectiveValue";
            }
            case 7: {
                return "Date";
            }
            case 20: {
                return "Time";
            }
            case 19: {
                return "ScrollValue";
            }
            case 17: {
                return "ProgressValue";
            }
            case 2: {
                return PropertyNames.PROPERTY_IMAGEURL;
            }
            case 6: {
                return PropertyNames.PROPERTY_STATE;
            }
            case 5: {
                return PropertyNames.PROPERTY_STATE;
            }
            case 8: {
                return "Text";
            }
            case 4: {
                return "Text";
            }
            case 16: {
                return "Text";
            }
            case 3: {
                return PropertyNames.SELECTED_ITEMS;
            }
        }
        return PropertyNames.EMPTY_STRING;
    }

    public void addResourceHandler(String _Module) {
        this.m_oResource = new Resource(this.xMSF, _Module);
    }

    public static short setInitialTabindex(int _istep) {
        return (short)(_istep * 100);
    }

    private boolean isHighContrastModeActivated() {
        if (this.xVclWindowPeer != null) {
            if (this.BisHighContrastModeActivated == null) {
                int nUIColor;
                try {
                    nUIColor = AnyConverter.toInt((Object)this.xVclWindowPeer.getProperty("DisplayBackgroundColor"));
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace(System.err);
                    return false;
                }
                int nRed = UnoDialog.getRedColorShare(nUIColor);
                int nGreen = UnoDialog.getGreenColorShare(nUIColor);
                int nBlue = UnoDialog.getBlueColorShare(nUIColor);
                int nLuminance = (nBlue * 28 + nGreen * 151 + nRed * 77) / 256;
                boolean bisactivated = nLuminance <= 25;
                this.BisHighContrastModeActivated = bisactivated;
                return bisactivated;
            }
            return this.BisHighContrastModeActivated;
        }
        return false;
    }

    private static int getRedColorShare(int _nColor) {
        int nRed = _nColor / 65536;
        return nRed;
    }

    private static int getGreenColorShare(int _nColor) {
        int nRedModulo = _nColor % 65536;
        int nGreen = nRedModulo / 256;
        return nGreen;
    }

    private static int getBlueColorShare(int _nColor) {
        int nGreenModulo;
        int nRedModulo = _nColor % 65536;
        int nBlue = nGreenModulo = nRedModulo % 256;
        return nBlue;
    }

    public static short getListBoxLineCount() {
        return 20;
    }
}

