/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.data.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.jfree.report.DataSet;
import org.jfree.report.JFreeReportBoot;
import org.jfree.report.ReportData;
import org.jfree.report.ReportDataFactory;
import org.jfree.report.ReportDataFactoryException;
import org.jfree.report.TableReportData;
import org.jfree.report.modules.data.sql.ConnectionProvider;
import org.jfree.report.modules.data.sql.SQLParameterLookupParser;
import org.jfree.report.modules.data.sql.SQLReportData;
import org.jfree.report.modules.data.sql.StaticConnectionProvider;
import org.jfree.report.util.DataSetUtility;
import org.jfree.report.util.PropertyLookupParser;
import org.pentaho.reporting.libraries.base.config.Configuration;

public class SimpleSQLReportDataFactory
implements ReportDataFactory,
Cloneable {
    private static final Object NULL_TOKEN = new Object();
    private HashMap preparedStatements;
    private Connection connection;
    private ConnectionProvider connectionProvider;
    private boolean labelMapping;
    private static final String COLUMN_NAME_MAPPING_KEY = "org.jfree.report.modules.data.sql.ColumnNameMapping";

    public SimpleSQLReportDataFactory(Connection connection) {
        this(new StaticConnectionProvider(connection));
    }

    public SimpleSQLReportDataFactory(ConnectionProvider connectionProvider) {
        if (connectionProvider == null) {
            throw new NullPointerException();
        }
        this.connectionProvider = connectionProvider;
        this.preparedStatements = new HashMap();
        Configuration configuration = JFreeReportBoot.getInstance().getGlobalConfig();
        this.labelMapping = configuration.getConfigProperty(COLUMN_NAME_MAPPING_KEY, "Label").equals("Label");
    }

    public boolean isLabelMapping() {
        return this.labelMapping;
    }

    public void setLabelMapping(boolean bl) {
        this.labelMapping = bl;
    }

    private synchronized Connection getConnection() throws SQLException {
        if (this.connection == null) {
            this.connection = this.connectionProvider.getConnection();
        }
        return this.connection;
    }

    private int getBestResultSetType() throws SQLException {
        Connection connection = this.getConnection();
        boolean bl = connection.getMetaData().supportsResultSetType(1004);
        boolean bl2 = connection.getMetaData().supportsResultSetType(1005);
        if (bl) {
            return 1004;
        }
        if (bl2) {
            return 1005;
        }
        return 1003;
    }

    public synchronized ReportData queryData(String string, DataSet dataSet) throws ReportDataFactoryException {
        try {
            Object object;
            String[] stringArray;
            Object object2;
            PreparedStatementCarrier preparedStatementCarrier = (PreparedStatementCarrier)this.preparedStatements.get(string);
            if (preparedStatementCarrier == null) {
                object2 = new SQLParameterLookupParser();
                stringArray = ((PropertyLookupParser)object2).translateAndLookup(string);
                PreparedStatement preparedStatement = this.getConnection().prepareStatement((String)stringArray, this.getBestResultSetType(), 1007);
                preparedStatementCarrier = new PreparedStatementCarrier(preparedStatement, ((SQLParameterLookupParser)object2).getFields());
                this.preparedStatements.put(string, preparedStatementCarrier);
            }
            object2 = preparedStatementCarrier.getPreparedStatement();
            object2.clearParameters();
            stringArray = preparedStatementCarrier.getParameters();
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                object = DataSetUtility.getByName(dataSet, string2, NULL_TOKEN);
                if (object == NULL_TOKEN) {
                    throw new ReportDataFactoryException("Setting parameter '" + string2 + "' failed: No such column.");
                }
                if (object == null) {
                    object2.setObject(i + 1, null);
                    continue;
                }
                object2.setObject(i + 1, object);
            }
            ResultSet resultSet = object2.executeQuery();
            int n = resultSet.getType();
            if (n == 1003) {
                object = this.generateDefaultTableModel(resultSet, this.labelMapping);
                resultSet.close();
                return new TableReportData((TableModel)object);
            }
            return new SQLReportData(resultSet, this.labelMapping);
        }
        catch (ReportDataFactoryException reportDataFactoryException) {
            throw reportDataFactoryException;
        }
        catch (Exception exception) {
            throw new ReportDataFactoryException("Failed at query: " + string, exception);
        }
    }

    public void open() {
    }

    public synchronized void close() {
        if (this.connection == null) {
            return;
        }
        try {
            this.connection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.connection = null;
    }

    private TableModel generateDefaultTableModel(ResultSet resultSet, boolean bl) throws SQLException {
        Object[] objectArray;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>(n);
        for (int i = 0; i < n; ++i) {
            if (bl) {
                objectArray = resultSetMetaData.getColumnLabel(i + 1);
                arrayList.add(objectArray);
                continue;
            }
            objectArray = resultSetMetaData.getColumnName(i + 1);
            arrayList.add(objectArray);
        }
        ArrayList<Object[]> arrayList2 = new ArrayList<Object[]>();
        while (resultSet.next()) {
            objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                objectArray[i] = resultSet.getObject(i + 1);
                if (!resultSet.wasNull()) continue;
                objectArray[i] = null;
            }
            arrayList2.add(objectArray);
        }
        objectArray = arrayList2.toArray();
        Object[][] objectArray2 = new Object[objectArray.length][];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray2[i] = (Object[])objectArray[i];
        }
        return new DefaultTableModel(objectArray2, arrayList.toArray());
    }

    public ReportDataFactory derive() {
        try {
            return (ReportDataFactory)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("Clone failed?");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        SimpleSQLReportDataFactory simpleSQLReportDataFactory = (SimpleSQLReportDataFactory)super.clone();
        simpleSQLReportDataFactory.connection = null;
        simpleSQLReportDataFactory.preparedStatements = new HashMap();
        return simpleSQLReportDataFactory;
    }

    private static class PreparedStatementCarrier {
        private PreparedStatement preparedStatement;
        private String[] parameters;

        public PreparedStatementCarrier(PreparedStatement preparedStatement, String[] stringArray) {
            this.preparedStatement = preparedStatement;
            this.parameters = stringArray;
        }

        public PreparedStatement getPreparedStatement() {
            return this.preparedStatement;
        }

        public String[] getParameters() {
            return this.parameters;
        }
    }
}

