/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.deletebydate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import tim.prune.function.deletebydate.DateInfo;

public class DateInfoList {
    private List<DateInfo> _infoList = new ArrayList<DateInfo>();
    private DateInfo _previousInfo = null;
    private boolean _hasBeenSorted = false;

    public void addPoint(Date date) {
        if (this._previousInfo != null && this._previousInfo.isSameDate(date)) {
            this._previousInfo.incrementCount();
        } else {
            boolean bl = false;
            for (DateInfo dateInfo : this._infoList) {
                if (!dateInfo.isSameDate(date)) continue;
                dateInfo.incrementCount();
                this._previousInfo = dateInfo;
                bl = true;
                break;
            }
            if (!bl) {
                this._previousInfo = new DateInfo(date);
                this._previousInfo.incrementCount();
                this._infoList.add(this._previousInfo);
                this._hasBeenSorted = false;
            }
        }
    }

    public void clearAll() {
        this._infoList.clear();
        this._previousInfo = null;
        this._hasBeenSorted = true;
    }

    public boolean hasDatelessPoints() {
        if (this._infoList.isEmpty()) {
            return false;
        }
        this.sort();
        DateInfo dateInfo = this._infoList.get(0);
        return dateInfo != null && dateInfo.isDateless() && dateInfo.getPointCount() > 0;
    }

    public int getNumEntries() {
        return this._infoList.size();
    }

    public int getTotalNumPoints() {
        int n = 0;
        for (DateInfo dateInfo : this._infoList) {
            n += dateInfo.getPointCount();
        }
        return n;
    }

    private void sort() {
        if (!this._hasBeenSorted) {
            Collections.sort(this._infoList);
            this._hasBeenSorted = true;
        }
    }

    public DateInfo getDateInfo(int n) {
        this.sort();
        return this._infoList.get(n);
    }
}

