/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import org.jruby.ParseResult;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IREvalScript;
import org.jruby.ir.IRFlags;
import org.jruby.ir.IRFor;
import org.jruby.ir.IRManager;
import org.jruby.ir.IRMethod;
import org.jruby.ir.IRModuleBody;
import org.jruby.ir.IRScopeType;
import org.jruby.ir.IRScriptBody;
import org.jruby.ir.dataflow.analyses.LiveVariablesProblem;
import org.jruby.ir.dataflow.analyses.StoreLocalVarPlacementProblem;
import org.jruby.ir.dataflow.analyses.UnboxableOpsAnalysisProblem;
import org.jruby.ir.instructions.CallBase;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.interpreter.FullInterpreterContext;
import org.jruby.ir.interpreter.InterpreterContext;
import org.jruby.ir.operands.Fixnum;
import org.jruby.ir.operands.Float;
import org.jruby.ir.operands.Label;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.operands.Self;
import org.jruby.ir.operands.TemporaryBooleanVariable;
import org.jruby.ir.operands.TemporaryCurrentModuleVariable;
import org.jruby.ir.operands.TemporaryCurrentScopeVariable;
import org.jruby.ir.operands.TemporaryFixnumVariable;
import org.jruby.ir.operands.TemporaryFloatVariable;
import org.jruby.ir.operands.TemporaryLocalReplacementVariable;
import org.jruby.ir.operands.TemporaryLocalVariable;
import org.jruby.ir.operands.TemporaryVariable;
import org.jruby.ir.operands.TemporaryVariableType;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.passes.AddCallProtocolInstructions;
import org.jruby.ir.passes.CompilerPass;
import org.jruby.ir.passes.CompilerPassScheduler;
import org.jruby.ir.passes.UnboxingPass;
import org.jruby.ir.representations.BasicBlock;
import org.jruby.ir.representations.CFG;
import org.jruby.ir.transformations.inlining.CFGInliner;
import org.jruby.ir.transformations.inlining.SimpleCloneInfo;
import org.jruby.ir.util.IGVDumper;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Helpers;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public abstract class IRScope
implements ParseResult {
    public static final Logger LOG = LoggerFactory.getLogger(IRScope.class);
    private static final Collection<IRClosure> NO_CLOSURES = Collections.unmodifiableCollection(new ArrayList(0));
    private static AtomicInteger globalScopeCount = new AtomicInteger();
    private int scopeId;
    private String name;
    private final int lineNumber;
    private IRScope lexicalParent;
    private List<IRClosure> nestedClosures;
    private int nextClosureIndex;
    private List<IRScope> lexicalChildren;
    private final StaticScope staticScope;
    private Set<LocalVariable> definedLocalVars;
    private Set<LocalVariable> usedLocalVars;
    protected InterpreterContext interpreterContext;
    protected FullInterpreterContext fullInterpreterContext;
    protected int temporaryVariableIndex;
    protected int floatVariableIndex;
    protected int fixnumVariableIndex;
    protected int booleanVariableIndex;
    private Map<String, Integer> nextVarIndex;
    private TemporaryLocalVariable currentModuleVariable;
    private TemporaryLocalVariable currentScopeVariable;
    Map<String, LocalVariable> localVars;
    EnumSet<IRFlags> flags = EnumSet.noneOf(IRFlags.class);
    private boolean flagsComputed;
    protected int threadPollInstrsCount;
    private IRManager manager;
    private TemporaryVariable yieldClosureVariable;
    private static final EnumSet<IRFlags> NEEDS_DYNAMIC_SCOPE_FLAGS = EnumSet.of(IRFlags.CAN_RECEIVE_BREAKS, IRFlags.HAS_NONLOCAL_RETURNS, IRFlags.CAN_RECEIVE_NONLOCAL_RETURNS, IRFlags.BINDING_HAS_ESCAPED);

    protected IRScope(IRScope s2, IRScope lexicalParent) {
        this.lexicalParent = lexicalParent;
        this.manager = s2.manager;
        this.lineNumber = s2.lineNumber;
        this.staticScope = s2.staticScope;
        this.threadPollInstrsCount = s2.threadPollInstrsCount;
        this.nextClosureIndex = s2.nextClosureIndex;
        this.temporaryVariableIndex = s2.temporaryVariableIndex;
        this.floatVariableIndex = s2.floatVariableIndex;
        this.nextVarIndex = new HashMap<String, Integer>(1);
        this.interpreterContext = null;
        this.flagsComputed = s2.flagsComputed;
        this.flags = s2.flags.clone();
        this.localVars = new HashMap<String, LocalVariable>(s2.localVars);
        this.scopeId = globalScopeCount.getAndIncrement();
        this.setupLexicalContainment();
    }

    public IRScope(IRManager manager, IRScope lexicalParent, String name2, int lineNumber, StaticScope staticScope) {
        this.manager = manager;
        this.lexicalParent = lexicalParent;
        this.name = name2;
        this.lineNumber = lineNumber;
        this.staticScope = staticScope;
        this.threadPollInstrsCount = 0;
        this.nextClosureIndex = 0;
        this.temporaryVariableIndex = -1;
        this.floatVariableIndex = -1;
        this.nextVarIndex = new HashMap<String, Integer>(1);
        this.interpreterContext = null;
        this.flagsComputed = false;
        this.flags.remove((Object)IRFlags.CAN_RECEIVE_BREAKS);
        this.flags.remove((Object)IRFlags.CAN_RECEIVE_NONLOCAL_RETURNS);
        this.flags.remove((Object)IRFlags.HAS_BREAK_INSTRS);
        this.flags.remove((Object)IRFlags.HAS_END_BLOCKS);
        this.flags.remove((Object)IRFlags.HAS_EXPLICIT_CALL_PROTOCOL);
        this.flags.remove((Object)IRFlags.HAS_LOOPS);
        this.flags.remove((Object)IRFlags.HAS_NONLOCAL_RETURNS);
        this.flags.remove((Object)IRFlags.RECEIVES_KEYWORD_ARGS);
        this.flags.add(IRFlags.CAN_CAPTURE_CALLERS_BINDING);
        this.flags.add(IRFlags.BINDING_HAS_ESCAPED);
        this.flags.add(IRFlags.USES_EVAL);
        this.flags.add(IRFlags.USES_BACKREF_OR_LASTLINE);
        this.flags.add(IRFlags.REQUIRES_DYNSCOPE);
        this.flags.add(IRFlags.USES_ZSUPER);
        if (this.parentMaybeUsingRefinements()) {
            this.flags.add(IRFlags.MAYBE_USING_REFINEMENTS);
        }
        this.localVars = new HashMap<String, LocalVariable>(1);
        this.scopeId = globalScopeCount.getAndIncrement();
        this.setupLexicalContainment();
    }

    private void setupLexicalContainment() {
        if (this.manager.isDryRun() || RubyInstanceConfig.IR_WRITING || RubyInstanceConfig.RECORD_LEXICAL_HIERARCHY) {
            this.lexicalChildren = new ArrayList<IRScope>(1);
            if (this.lexicalParent != null) {
                this.lexicalParent.addChildScope(this);
            }
        }
    }

    public int getScopeId() {
        return this.scopeId;
    }

    public int hashCode() {
        return this.scopeId;
    }

    public void setInterpreterContext(InterpreterContext interpreterContext) {
        this.interpreterContext = interpreterContext;
    }

    public boolean equals(Object other) {
        return other != null && this.getClass() == other.getClass() && this.scopeId == ((IRScope)other).scopeId;
    }

    protected void addChildScope(IRScope scope) {
        if (this.lexicalChildren == null) {
            this.lexicalChildren = new ArrayList<IRScope>(1);
        }
        this.lexicalChildren.add(scope);
    }

    public List<IRScope> getLexicalScopes() {
        if (this.lexicalChildren == null) {
            this.lexicalChildren = new ArrayList<IRScope>(1);
        }
        return this.lexicalChildren;
    }

    public void addClosure(IRClosure closure) {
        if (this.nestedClosures == null) {
            this.nestedClosures = new ArrayList<IRClosure>(1);
        }
        this.nestedClosures.add(closure);
    }

    public void removeClosure(IRClosure closure) {
        if (this.nestedClosures != null) {
            this.nestedClosures.remove(closure);
        }
    }

    public LocalVariable getNewFlipStateVariable() {
        return this.getLocalVariable("%flip_" + this.allocateNextPrefixedName("%flip"), 0);
    }

    public Label getNewLabel(String prefix) {
        return new Label(prefix, this.allocateNextPrefixedName(prefix));
    }

    public Label getNewLabel() {
        return this.getNewLabel("LBL");
    }

    public Collection<IRClosure> getClosures() {
        return this.nestedClosures == null ? NO_CLOSURES : this.nestedClosures;
    }

    public IRManager getManager() {
        return this.manager;
    }

    public void setIsMaybeUsingRefinements() {
        this.flags.add(IRFlags.MAYBE_USING_REFINEMENTS);
    }

    public boolean parentMaybeUsingRefinements() {
        for (IRScope s2 = this; s2 != null; s2 = s2.getLexicalParent()) {
            if (s2.getFlags().contains((Object)IRFlags.MAYBE_USING_REFINEMENTS)) {
                return true;
            }
            if (!(s2 instanceof IREvalScript)) continue;
            return false;
        }
        return false;
    }

    public boolean maybeUsingRefinements() {
        return this.getFlags().contains((Object)IRFlags.MAYBE_USING_REFINEMENTS);
    }

    public IRScope getLexicalParent() {
        return this.lexicalParent;
    }

    public StaticScope getStaticScope() {
        return this.staticScope;
    }

    public IRMethod getNearestMethod() {
        IRScope current2;
        for (current2 = this; current2 != null && !(current2 instanceof IRMethod); current2 = current2.getLexicalParent()) {
        }
        return (IRMethod)current2;
    }

    public IRScope getNearestFlipVariableScope() {
        IRScope current2;
        for (current2 = this; current2 != null && !current2.isFlipScope(); current2 = current2.getLexicalParent()) {
        }
        return current2;
    }

    public IRScope getNearestTopLocalVariableScope() {
        IRScope current2;
        for (current2 = this; current2 != null && !current2.isTopLocalVariableScope(); current2 = current2.getLexicalParent()) {
        }
        return current2;
    }

    public int getNearestModuleReferencingScopeDepth() {
        int n = 0;
        IRScope current2 = this;
        while (!(current2 instanceof IRModuleBody)) {
            if (current2 == null || current2 instanceof IREvalScript) {
                return -1;
            }
            if ((current2 = current2.getLexicalParent()) instanceof IRFor) continue;
            ++n;
        }
        return n;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name2) {
        this.name = name2;
    }

    public void setFileName(String filename2) {
        this.getTopLevelScope().setFileName(filename2);
    }

    public String getFileName() {
        return this.getTopLevelScope().getFileName();
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public IRScope getTopLevelScope() {
        IRScope current2;
        for (current2 = this; current2 != null && !current2.isScriptScope(); current2 = current2.getLexicalParent()) {
        }
        return current2;
    }

    public boolean isNestedInClosure(IRClosure closure) {
        for (IRScope s2 = this; s2 != null && !s2.isTopLocalVariableScope(); s2 = s2.getLexicalParent()) {
            if (s2 != closure) continue;
            return true;
        }
        return false;
    }

    public void setHasLoopsFlag() {
        this.flags.add(IRFlags.HAS_LOOPS);
    }

    public boolean hasLoops() {
        return this.flags.contains((Object)IRFlags.HAS_LOOPS);
    }

    public boolean hasExplicitCallProtocol() {
        return this.flags.contains((Object)IRFlags.HAS_EXPLICIT_CALL_PROTOCOL);
    }

    public void setExplicitCallProtocolFlag() {
        this.flags.add(IRFlags.HAS_EXPLICIT_CALL_PROTOCOL);
    }

    public boolean receivesKeywordArgs() {
        return this.flags.contains((Object)IRFlags.RECEIVES_KEYWORD_ARGS);
    }

    public boolean bindingHasEscaped() {
        return this.flags.contains((Object)IRFlags.BINDING_HAS_ESCAPED);
    }

    public boolean usesBackrefOrLastline() {
        return this.flags.contains((Object)IRFlags.USES_BACKREF_OR_LASTLINE);
    }

    public boolean usesEval() {
        return this.flags.contains((Object)IRFlags.USES_EVAL);
    }

    public boolean usesZSuper() {
        return this.flags.contains((Object)IRFlags.USES_ZSUPER);
    }

    public boolean canReceiveNonlocalReturns() {
        this.computeScopeFlags();
        return this.flags.contains((Object)IRFlags.CAN_RECEIVE_NONLOCAL_RETURNS);
    }

    public void putLiveVariablesProblem(LiveVariablesProblem problem) {
        if (this.fullInterpreterContext == null) {
            if (problem != null) {
                throw new IllegalStateException("LVP being stored when no FIC");
            }
            return;
        }
        this.fullInterpreterContext.getDataFlowProblems().put("Live Variables Analysis", problem);
    }

    public LiveVariablesProblem getLiveVariablesProblem() {
        if (this.fullInterpreterContext == null) {
            return null;
        }
        return (LiveVariablesProblem)this.fullInterpreterContext.getDataFlowProblems().get("Live Variables Analysis");
    }

    public void putStoreLocalVarPlacementProblem(StoreLocalVarPlacementProblem problem) {
        if (this.fullInterpreterContext == null) {
            if (problem != null) {
                throw new IllegalStateException("StoreLocalVarPlacementProblem being stored when no FIC");
            }
            return;
        }
        this.fullInterpreterContext.getDataFlowProblems().put("Placement of local-var stores", problem);
    }

    public StoreLocalVarPlacementProblem getStoreLocalVarPlacementProblem() {
        if (this.fullInterpreterContext == null) {
            return null;
        }
        return (StoreLocalVarPlacementProblem)this.fullInterpreterContext.getDataFlowProblems().get("Placement of local-var stores");
    }

    public void putUnboxableOpsAnalysisProblem(UnboxableOpsAnalysisProblem problem) {
        if (this.fullInterpreterContext == null) {
            if (problem != null) {
                throw new IllegalStateException("UboxableOpsAnalysisProblem being stored when no FIC");
            }
            return;
        }
        this.fullInterpreterContext.getDataFlowProblems().put("UnboxableOpsAnalysis", problem);
    }

    public UnboxableOpsAnalysisProblem getUnboxableOpsAnalysisProblem() {
        if (this.fullInterpreterContext == null) {
            return null;
        }
        return (UnboxableOpsAnalysisProblem)this.fullInterpreterContext.getDataFlowProblems().get("UnboxableOpsAnalysis");
    }

    public CFG getCFG() {
        if (this.getFullInterpreterContext() == null) {
            this.prepareFullBuildCommon();
        }
        return this.fullInterpreterContext.getCFG();
    }

    protected boolean isUnsafeScope() {
        if (this.isBeginEndBlock()) {
            return true;
        }
        List<IRClosure> beginBlocks = this.getBeginBlocks();
        if (beginBlocks != null && !beginBlocks.isEmpty()) {
            return true;
        }
        beginBlocks = this.getNearestTopLocalVariableScope().getBeginBlocks();
        return beginBlocks != null && !beginBlocks.isEmpty();
    }

    public List<CompilerPass> getExecutedPasses() {
        return this.fullInterpreterContext == null ? new ArrayList(1) : this.fullInterpreterContext.getExecutedPasses();
    }

    private void runCompilerPasses(List<CompilerPass> passes, IGVDumper dumper) {
        if (this.isUnsafeScope()) {
            passes = this.getManager().getSafePasses(this);
        }
        if (dumper != null) {
            dumper.dump(this.getCFG(), "Start");
        }
        CompilerPassScheduler scheduler = IRManager.schedulePasses(passes);
        for (CompilerPass pass2 : scheduler) {
            pass2.run(this);
            if (dumper == null) continue;
            dumper.dump(this.getCFG(), pass2.getShortLabel());
        }
        if (RubyInstanceConfig.IR_UNBOXING) {
            UnboxingPass pass3 = new UnboxingPass();
            pass3.run(this);
            if (dumper != null) {
                dumper.dump(this.getCFG(), pass3.getShortLabel());
            }
        }
        if (dumper != null) {
            dumper.close();
        }
    }

    public InterpreterContext allocateInterpreterContext(List<Instr> instructions) {
        this.interpreterContext = new InterpreterContext(this, instructions);
        if (RubyInstanceConfig.IR_COMPILER_DEBUG) {
            LOG.info(this.interpreterContext.toString(), new Object[0]);
        }
        return this.interpreterContext;
    }

    public InterpreterContext allocateInterpreterContext(Callable<List<Instr>> instructions) {
        try {
            this.interpreterContext = new InterpreterContext(this, instructions);
        }
        catch (Exception e) {
            Helpers.throwException(e);
        }
        if (RubyInstanceConfig.IR_COMPILER_DEBUG) {
            LOG.info(this.interpreterContext.toString(), new Object[0]);
        }
        return this.interpreterContext;
    }

    private Instr[] cloneInstrs() {
        SimpleCloneInfo cloneInfo = new SimpleCloneInfo(this, false);
        Instr[] instructions = this.interpreterContext.getInstructions();
        int length2 = instructions.length;
        Instr[] newInstructions = new Instr[length2];
        for (int i2 = 0; i2 < length2; ++i2) {
            newInstructions[i2] = instructions[i2].clone(cloneInfo);
        }
        return newInstructions;
    }

    private void prepareFullBuildCommon() {
        if (this.fullInterpreterContext != null) {
            return;
        }
        this.fullInterpreterContext = new FullInterpreterContext(this, this.cloneInstrs());
    }

    public synchronized FullInterpreterContext prepareFullBuild() {
        if (this.fullInterpreterContext != null && this.fullInterpreterContext.buildComplete()) {
            return this.fullInterpreterContext;
        }
        for (IRScope iRScope : this.getClosures()) {
            iRScope.prepareFullBuild();
        }
        this.prepareFullBuildCommon();
        this.runCompilerPasses(this.getManager().getCompilerPasses(this), this.dumpToIGV());
        this.getManager().optimizeIfSimpleScope(this);
        if (!this.isUnsafeScope()) {
            new AddCallProtocolInstructions().run(this);
        }
        this.fullInterpreterContext.generateInstructionsForInterpretation();
        return this.fullInterpreterContext;
    }

    public String getFullyQualifiedName() {
        if (this.getLexicalParent() == null) {
            return this.getName();
        }
        return this.getLexicalParent().getFullyQualifiedName() + "::" + this.getName();
    }

    public IGVDumper dumpToIGV() {
        String spec;
        if (RubyInstanceConfig.IR_DEBUG_IGV != null && ((spec = RubyInstanceConfig.IR_DEBUG_IGV).contains(":") && spec.equals(this.getFileName() + ":" + this.getLineNumber()) || spec.equals(this.getFileName()))) {
            return new IGVDumper(this.getFullyQualifiedName() + "; line " + this.getLineNumber());
        }
        return null;
    }

    public synchronized BasicBlock[] prepareForCompilation() {
        if (this.fullInterpreterContext != null && this.fullInterpreterContext.buildComplete()) {
            return this.fullInterpreterContext.getLinearizedBBList();
        }
        for (IRScope iRScope : this.getClosures()) {
            iRScope.prepareForCompilation();
        }
        this.prepareFullBuildCommon();
        this.runCompilerPasses(this.getManager().getJITPasses(this), this.dumpToIGV());
        BasicBlock[] bbs = this.fullInterpreterContext.linearizeBasicBlocks();
        return bbs;
    }

    public Map<BasicBlock, Label> buildJVMExceptionTable() {
        HashMap<BasicBlock, Label> map2 = new HashMap<BasicBlock, Label>(1);
        for (BasicBlock bb : this.fullInterpreterContext.getLinearizedBBList()) {
            BasicBlock rescueBB = this.getCFG().getRescuerBBFor(bb);
            if (rescueBB == null) continue;
            map2.put(bb, rescueBB.getLabel());
        }
        return map2;
    }

    public EnumSet<IRFlags> getFlags() {
        return this.flags;
    }

    private void initScopeFlags() {
        this.flags.remove((Object)IRFlags.CAN_CAPTURE_CALLERS_BINDING);
        this.flags.remove((Object)IRFlags.CAN_RECEIVE_BREAKS);
        this.flags.remove((Object)IRFlags.CAN_RECEIVE_NONLOCAL_RETURNS);
        this.flags.remove((Object)IRFlags.HAS_BREAK_INSTRS);
        this.flags.remove((Object)IRFlags.HAS_NONLOCAL_RETURNS);
        this.flags.remove((Object)IRFlags.USES_ZSUPER);
        this.flags.remove((Object)IRFlags.USES_EVAL);
        this.flags.remove((Object)IRFlags.USES_BACKREF_OR_LASTLINE);
        this.flags.remove((Object)IRFlags.REQUIRES_DYNSCOPE);
    }

    private void bindingEscapedScopeFlagsCheck() {
        if (this instanceof IREvalScript || this instanceof IRScriptBody) {
            this.flags.add(IRFlags.BINDING_HAS_ESCAPED);
        } else {
            this.flags.remove((Object)IRFlags.BINDING_HAS_ESCAPED);
        }
    }

    private void calculateClosureScopeFlags() {
        for (IRClosure cl : this.getClosures()) {
            cl.computeScopeFlags();
            if (cl.usesEval()) {
                this.flags.add(IRFlags.CAN_RECEIVE_BREAKS);
                this.flags.add(IRFlags.CAN_RECEIVE_NONLOCAL_RETURNS);
                this.flags.add(IRFlags.USES_ZSUPER);
                continue;
            }
            if (cl.flags.contains((Object)IRFlags.HAS_BREAK_INSTRS) || cl.flags.contains((Object)IRFlags.CAN_RECEIVE_BREAKS)) {
                this.flags.add(IRFlags.CAN_RECEIVE_BREAKS);
            }
            if (cl.flags.contains((Object)IRFlags.HAS_NONLOCAL_RETURNS) || cl.flags.contains((Object)IRFlags.CAN_RECEIVE_NONLOCAL_RETURNS)) {
                this.flags.add(IRFlags.CAN_RECEIVE_NONLOCAL_RETURNS);
            }
            if (!cl.usesZSuper()) continue;
            this.flags.add(IRFlags.USES_ZSUPER);
        }
    }

    private void computeNeedsDynamicScopeFlag() {
        for (IRFlags f : NEEDS_DYNAMIC_SCOPE_FLAGS) {
            if (!this.flags.contains((Object)f)) continue;
            this.flags.add(IRFlags.REQUIRES_DYNSCOPE);
            return;
        }
    }

    public void computeScopeFlagsEarly(List<Instr> instructions) {
        this.initScopeFlags();
        this.bindingEscapedScopeFlagsCheck();
        for (Instr i2 : instructions) {
            i2.computeScopeFlags(this);
        }
        this.calculateClosureScopeFlags();
        this.computeNeedsDynamicScopeFlag();
        this.flagsComputed = true;
    }

    public void computeScopeFlags() {
        if (this.flagsComputed) {
            return;
        }
        this.initScopeFlags();
        this.bindingEscapedScopeFlagsCheck();
        if (this.fullInterpreterContext != null) {
            this.fullInterpreterContext.computeScopeFlagsFromInstructions();
        } else {
            this.interpreterContext.computeScopeFlagsFromInstructions();
        }
        this.calculateClosureScopeFlags();
        this.computeNeedsDynamicScopeFlag();
        this.flagsComputed = true;
    }

    public abstract IRScopeType getScopeType();

    public String toString() {
        return String.valueOf((Object)this.getScopeType()) + ' ' + this.getName() + '[' + this.getFileName() + ':' + this.getLineNumber() + ']';
    }

    public String debugOutput() {
        return this.toStringInstrs();
    }

    public String toStringInstrs() {
        if (this.fullInterpreterContext != null) {
            return "Instructions:\n" + this.fullInterpreterContext.toStringInstrs();
        }
        return this.interpreterContext.toStringInstrs();
    }

    public Variable getSelf() {
        return Self.SELF;
    }

    public Variable getCurrentModuleVariable() {
        if (this.currentModuleVariable == null) {
            ++this.temporaryVariableIndex;
            this.currentModuleVariable = TemporaryCurrentModuleVariable.ModuleVariableFor(this.temporaryVariableIndex);
        }
        return this.currentModuleVariable;
    }

    public Variable getCurrentScopeVariable() {
        if (this.currentScopeVariable == null) {
            ++this.temporaryVariableIndex;
            this.currentScopeVariable = TemporaryCurrentScopeVariable.ScopeVariableFor(this.temporaryVariableIndex);
        }
        return this.currentScopeVariable;
    }

    public Map<String, LocalVariable> getLocalVariables() {
        return this.localVars;
    }

    public Set<LocalVariable> getUsedLocalVariables() {
        return this.usedLocalVars;
    }

    public void setLocalVariables(Map<String, LocalVariable> variables) {
        this.localVars = variables;
    }

    public void setLabelIndices(Map<String, Integer> indices) {
        this.nextVarIndex = indices;
    }

    public LocalVariable lookupExistingLVar(String name2) {
        return this.localVars.get(name2);
    }

    protected LocalVariable findExistingLocalVariable(String name2, int depth) {
        return this.localVars.get(name2);
    }

    public LocalVariable getLocalVariable(String name2, int scopeDepth) {
        LocalVariable lvar = this.findExistingLocalVariable(name2, scopeDepth);
        if (lvar == null) {
            lvar = this.getNewLocalVariable(name2, scopeDepth);
        } else if (lvar.getScopeDepth() != scopeDepth) {
            lvar = lvar.cloneForDepth(scopeDepth);
        }
        return lvar;
    }

    public LocalVariable getNewLocalVariable(String name2, int scopeDepth) {
        assert (scopeDepth == 0) : "Scope depth is non-zero for new-var request " + name2 + " in " + this;
        LocalVariable lvar = new LocalVariable(name2, scopeDepth, this.getStaticScope().addVariable(name2));
        this.localVars.put(name2, lvar);
        return lvar;
    }

    public TemporaryLocalVariable createTemporaryVariable() {
        return this.getNewTemporaryVariable(TemporaryVariableType.LOCAL);
    }

    public TemporaryLocalVariable getNewTemporaryVariableFor(LocalVariable var) {
        ++this.temporaryVariableIndex;
        return new TemporaryLocalReplacementVariable(var.getName(), this.temporaryVariableIndex);
    }

    public TemporaryLocalVariable getNewTemporaryVariable(TemporaryVariableType type2) {
        switch (type2) {
            case FLOAT: {
                ++this.floatVariableIndex;
                return new TemporaryFloatVariable(this.floatVariableIndex);
            }
            case FIXNUM: {
                ++this.fixnumVariableIndex;
                return new TemporaryFixnumVariable(this.fixnumVariableIndex);
            }
            case BOOLEAN: {
                ++this.booleanVariableIndex;
                return new TemporaryBooleanVariable(this.booleanVariableIndex);
            }
            case LOCAL: {
                ++this.temporaryVariableIndex;
                return this.manager.newTemporaryLocalVariable(this.temporaryVariableIndex);
            }
        }
        throw new RuntimeException("Invalid temporary variable being alloced in this scope: " + (Object)((Object)type2));
    }

    public void setTemporaryVariableCount(int count2) {
        this.temporaryVariableIndex = count2 + 1;
    }

    public TemporaryVariable getYieldClosureVariable() {
        if (this.yieldClosureVariable == null) {
            this.yieldClosureVariable = this.createTemporaryVariable();
            return this.yieldClosureVariable;
        }
        return this.yieldClosureVariable;
    }

    public TemporaryLocalVariable getNewUnboxedVariable(Class type2) {
        TemporaryVariableType varType = type2 == Float.class ? TemporaryVariableType.FLOAT : (type2 == Fixnum.class ? TemporaryVariableType.FIXNUM : (type2 == Boolean.class ? TemporaryVariableType.BOOLEAN : TemporaryVariableType.LOCAL));
        return this.getNewTemporaryVariable(varType);
    }

    public void resetTemporaryVariables() {
        this.temporaryVariableIndex = -1;
        this.floatVariableIndex = -1;
        this.fixnumVariableIndex = -1;
        this.booleanVariableIndex = -1;
    }

    public int getTemporaryVariablesCount() {
        return this.temporaryVariableIndex + 1;
    }

    public int getFloatVariablesCount() {
        return this.floatVariableIndex + 1;
    }

    public int getFixnumVariablesCount() {
        return this.fixnumVariableIndex + 1;
    }

    public int getBooleanVariablesCount() {
        return this.booleanVariableIndex + 1;
    }

    public Variable getNewInlineVariable(String inlinePrefix, Variable v) {
        if (v instanceof LocalVariable) {
            LocalVariable lv = (LocalVariable)v;
            return this.getLocalVariable(inlinePrefix + lv.getName(), lv.getScopeDepth());
        }
        return this.createTemporaryVariable();
    }

    public int getThreadPollInstrsCount() {
        return this.threadPollInstrsCount;
    }

    public int getLocalVariablesCount() {
        return this.localVars.size();
    }

    public int getUsedVariablesCount() {
        return this.getLocalVariablesCount() + this.getPrefixCountSize("%flip");
    }

    public void setUpUseDefLocalVarMaps() {
        this.definedLocalVars = new HashSet<LocalVariable>(1);
        this.usedLocalVars = new HashSet<LocalVariable>(1);
        for (BasicBlock bb : this.getCFG().getBasicBlocks()) {
            for (Instr i2 : bb.getInstrs()) {
                Variable v;
                for (Variable v2 : i2.getUsedVariables()) {
                    if (!(v2 instanceof LocalVariable)) continue;
                    this.usedLocalVars.add((LocalVariable)v2);
                }
                if (!(i2 instanceof ResultInstr) || !((v = ((ResultInstr)((Object)i2)).getResult()) instanceof LocalVariable) || ((LocalVariable)v).getScopeDepth() != 0) continue;
                this.definedLocalVars.add((LocalVariable)v);
            }
        }
        for (IRClosure cl : this.getClosures()) {
            cl.setUpUseDefLocalVarMaps();
        }
    }

    public boolean usesLocalVariable(Variable v) {
        if (this.usedLocalVars == null) {
            this.setUpUseDefLocalVarMaps();
        }
        if (this.usedLocalVars.contains(v)) {
            return true;
        }
        for (IRClosure cl : this.getClosures()) {
            if (!cl.usesLocalVariable(v)) continue;
            return true;
        }
        return false;
    }

    public boolean definesLocalVariable(Variable v) {
        if (this.definedLocalVars == null) {
            this.setUpUseDefLocalVarMaps();
        }
        if (this.definedLocalVars.contains(v)) {
            return true;
        }
        for (IRClosure cl : this.getClosures()) {
            if (!cl.definesLocalVariable(v)) continue;
            return true;
        }
        return false;
    }

    public boolean hasBeenBuilt() {
        return true;
    }

    public FullInterpreterContext getExecutionContext() {
        return this.fullInterpreterContext;
    }

    public InterpreterContext getInterpreterContext() {
        return this.interpreterContext;
    }

    public FullInterpreterContext getFullInterpreterContext() {
        return this.fullInterpreterContext;
    }

    protected void depends(Object obj) {
        assert (obj != null) : "Unsatisfied dependency and this depends() was set up wrong.  Use depends(build()) not depends(build).";
    }

    public void resetState() {
        this.interpreterContext = null;
        this.fullInterpreterContext = null;
        this.flagsComputed = false;
        this.flags.add(IRFlags.CAN_CAPTURE_CALLERS_BINDING);
        this.flags.add(IRFlags.BINDING_HAS_ESCAPED);
        this.flags.add(IRFlags.USES_EVAL);
        this.flags.add(IRFlags.USES_ZSUPER);
        this.flags.remove((Object)IRFlags.HAS_BREAK_INSTRS);
        this.flags.remove((Object)IRFlags.HAS_NONLOCAL_RETURNS);
        this.flags.remove((Object)IRFlags.CAN_RECEIVE_BREAKS);
        this.flags.remove((Object)IRFlags.CAN_RECEIVE_NONLOCAL_RETURNS);
        FullInterpreterContext fic = this.getFullInterpreterContext();
        if (fic != null) {
            int i2 = 0;
            while (i2 < fic.getExecutedPasses().size()) {
                if (fic.getExecutedPasses().get(i2).invalidate(this)) continue;
                ++i2;
            }
        }
    }

    public void inlineMethod(IRScope method, RubyModule implClass, int classToken, BasicBlock basicBlock, CallBase call2, boolean cloneHost) {
        new CFGInliner(this.getCFG()).inlineMethod(method, implClass, classToken, basicBlock, call2, cloneHost);
        this.resetState();
        for (CompilerPass pass2 : this.getManager().getInliningCompilerPasses(this)) {
            pass2.run(this);
        }
    }

    public void recordBeginBlock(IRClosure beginBlockClosure) {
        throw new RuntimeException("BEGIN blocks cannot be added to: " + this.getClass().getName());
    }

    public List<IRClosure> getBeginBlocks() {
        return null;
    }

    public List<IRClosure> getEndBlocks() {
        return null;
    }

    protected int allocateNextPrefixedName(String prefix) {
        int index2 = this.getPrefixCountSize(prefix);
        this.nextVarIndex.put(prefix, index2 + 1);
        return index2;
    }

    protected void resetVariableCounter(String prefix) {
        this.nextVarIndex.remove(prefix);
    }

    public Map<String, Integer> getVarIndices() {
        return this.nextVarIndex;
    }

    protected int getPrefixCountSize(String prefix) {
        Integer index2 = this.nextVarIndex.get(prefix);
        if (index2 == null) {
            return 0;
        }
        return index2;
    }

    public int getNextClosureId() {
        ++this.nextClosureIndex;
        return this.nextClosureIndex;
    }

    public boolean isBeginEndBlock() {
        return false;
    }

    public boolean isModuleBody() {
        return false;
    }

    public boolean isNonSingletonClassBody() {
        return false;
    }

    public boolean isFlipScope() {
        return true;
    }

    public boolean isTopLocalVariableScope() {
        return true;
    }

    public boolean isScriptScope() {
        return false;
    }

    public boolean needsFrame() {
        boolean bindingHasEscaped = this.bindingHasEscaped();
        boolean requireFrame = bindingHasEscaped || this.usesEval();
        for (IRFlags flag : this.getFlags()) {
            switch (flag) {
                case BINDING_HAS_ESCAPED: 
                case CAN_CAPTURE_CALLERS_BINDING: 
                case REQUIRES_FRAME: 
                case REQUIRES_VISIBILITY: 
                case USES_BACKREF_OR_LASTLINE: 
                case USES_EVAL: 
                case USES_ZSUPER: {
                    requireFrame = true;
                }
            }
        }
        return requireFrame;
    }

    public boolean reuseParentScope() {
        return this.getFlags().contains((Object)IRFlags.REUSE_PARENT_DYNSCOPE);
    }

    public boolean needsBinding() {
        return this.reuseParentScope() || !this.getFlags().contains((Object)IRFlags.DYNSCOPE_ELIMINATED);
    }
}

