/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.MethodSignatureBase;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.annotations.NotNull;

public class MethodSignatureBackedByPsiMethod
extends MethodSignatureBase {
    private final PsiMethod myMethod;
    private final boolean myIsRaw;
    private final String myName;

    protected MethodSignatureBackedByPsiMethod(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor2, boolean isRaw, @NotNull PsiType[] parameterTypes, @NotNull PsiTypeParameter[] methodTypeParameters) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/util/MethodSignatureBackedByPsiMethod", "<init>"));
        }
        if (substitutor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/psi/util/MethodSignatureBackedByPsiMethod", "<init>"));
        }
        if (parameterTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterTypes", "com/intellij/psi/util/MethodSignatureBackedByPsiMethod", "<init>"));
        }
        if (methodTypeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodTypeParameters", "com/intellij/psi/util/MethodSignatureBackedByPsiMethod", "<init>"));
        }
        super(substitutor2, parameterTypes, methodTypeParameters);
        this.myIsRaw = isRaw;
        this.myMethod = method;
        this.myName = method.getName();
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/MethodSignatureBackedByPsiMethod", "getName"));
        }
        return string;
    }

    @Override
    public boolean isRaw() {
        return this.myIsRaw;
    }

    @Override
    public boolean isConstructor() {
        return this.myMethod.isConstructor();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof MethodSignatureBackedByPsiMethod && ((MethodSignatureBackedByPsiMethod)o).myMethod == this.myMethod) {
            return true;
        }
        return super.equals(o);
    }

    @NotNull
    public PsiMethod getMethod() {
        PsiMethod psiMethod = this.myMethod;
        if (psiMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/MethodSignatureBackedByPsiMethod", "getMethod"));
        }
        return psiMethod;
    }

    @NotNull
    public static MethodSignatureBackedByPsiMethod create(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor2) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/util/MethodSignatureBackedByPsiMethod", "create"));
        }
        if (substitutor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/psi/util/MethodSignatureBackedByPsiMethod", "create"));
        }
        MethodSignatureBackedByPsiMethod methodSignatureBackedByPsiMethod = MethodSignatureBackedByPsiMethod.create(method, substitutor2, PsiUtil.isRawSubstitutor(method, substitutor2));
        if (methodSignatureBackedByPsiMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/MethodSignatureBackedByPsiMethod", "create"));
        }
        return methodSignatureBackedByPsiMethod;
    }

    @NotNull
    public static MethodSignatureBackedByPsiMethod create(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor2, boolean isRaw) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/util/MethodSignatureBackedByPsiMethod", "create"));
        }
        if (substitutor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/psi/util/MethodSignatureBackedByPsiMethod", "create"));
        }
        PsiTypeParameter[] methodTypeParameters = method.getTypeParameters();
        if (isRaw) {
            substitutor2 = JavaPsiFacade.getInstance(method.getProject()).getElementFactory().createRawSubstitutor(substitutor2, methodTypeParameters);
            methodTypeParameters = PsiTypeParameter.EMPTY_ARRAY;
        }
        assert (substitutor2.isValid());
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        PsiType[] parameterTypes = PsiType.createArray(parameters2.length);
        for (int i = 0; i < parameterTypes.length; ++i) {
            PsiParameter parameter = parameters2[i];
            PsiType type2 = parameter.getType();
            PsiType psiType = parameterTypes[i] = isRaw ? TypeConversionUtil.erasure(substitutor2.substitute(type2)) : type2;
            if (parameterTypes[i] == null || parameterTypes[i].isValid()) continue;
            PsiUtil.ensureValidType(parameterTypes[i], "Method " + method + " of " + method.getClass() + "; param " + parameter + " of " + parameter.getClass());
        }
        MethodSignatureBackedByPsiMethod methodSignatureBackedByPsiMethod = new MethodSignatureBackedByPsiMethod(method, substitutor2, isRaw, parameterTypes, methodTypeParameters);
        if (methodSignatureBackedByPsiMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/MethodSignatureBackedByPsiMethod", "create"));
        }
        return methodSignatureBackedByPsiMethod;
    }
}

