/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class UniqueResultsQuery<T, M>
implements Query<T> {
    @NotNull
    private final Query<T> myOriginal;
    @NotNull
    private final TObjectHashingStrategy<M> myHashingStrategy;
    @NotNull
    private final Function<T, M> myMapper;

    public UniqueResultsQuery(@NotNull Query<T> original) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/util/UniqueResultsQuery", "<init>"));
        }
        this(original, ContainerUtil.canonicalStrategy(), FunctionUtil.id());
    }

    public UniqueResultsQuery(@NotNull Query<T> original, @NotNull TObjectHashingStrategy<M> hashingStrategy) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/util/UniqueResultsQuery", "<init>"));
        }
        if (hashingStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashingStrategy", "com/intellij/util/UniqueResultsQuery", "<init>"));
        }
        this(original, hashingStrategy, FunctionUtil.id());
    }

    public UniqueResultsQuery(@NotNull Query<T> original, @NotNull TObjectHashingStrategy<M> hashingStrategy, @NotNull Function<T, M> mapper) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/util/UniqueResultsQuery", "<init>"));
        }
        if (hashingStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashingStrategy", "com/intellij/util/UniqueResultsQuery", "<init>"));
        }
        if (mapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapper", "com/intellij/util/UniqueResultsQuery", "<init>"));
        }
        this.myOriginal = original;
        this.myHashingStrategy = hashingStrategy;
        this.myMapper = mapper;
    }

    @Override
    public T findFirst() {
        return this.myOriginal.findFirst();
    }

    @Override
    public boolean forEach(@NotNull Processor<T> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/util/UniqueResultsQuery", "forEach"));
        }
        return this.process(Collections.synchronizedSet(new THashSet<M>(this.myHashingStrategy)), consumer);
    }

    private boolean process(@NotNull Set<M> processedElements, @NotNull Processor<T> consumer) {
        if (processedElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processedElements", "com/intellij/util/UniqueResultsQuery", "process"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/util/UniqueResultsQuery", "process"));
        }
        return this.myOriginal.forEach(new MyProcessor(processedElements, consumer));
    }

    @Override
    @NotNull
    public Collection<T> findAll() {
        List result2 = Collections.synchronizedList(new ArrayList());
        Processor processor = Processors.cancelableCollectProcessor(result2);
        this.forEach((Processor<T>)processor);
        List list2 = result2;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/UniqueResultsQuery", "findAll"));
        }
        return list2;
    }

    @Override
    public Iterator<T> iterator() {
        return this.findAll().iterator();
    }

    public String toString() {
        return "UniqueQuery: " + this.myOriginal;
    }

    private class MyProcessor
    implements Processor<T> {
        private final Set<M> myProcessedElements;
        private final Processor<T> myConsumer;

        public MyProcessor(@NotNull Set<M> processedElements, @NotNull Processor<T> consumer) {
            if (processedElements == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processedElements", "com/intellij/util/UniqueResultsQuery$MyProcessor", "<init>"));
            }
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/util/UniqueResultsQuery$MyProcessor", "<init>"));
            }
            this.myProcessedElements = processedElements;
            this.myConsumer = consumer;
        }

        @Override
        public boolean process(T t) {
            return !this.myProcessedElements.add(UniqueResultsQuery.this.myMapper.fun(t)) || this.myConsumer.process(t);
        }
    }
}

