/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.model;

import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.netbeans.modules.profiler.heapwalk.model.BrowserUtils;
import org.netbeans.modules.profiler.heapwalk.model.ChildrenComputer;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNode;

public abstract class AbstractHeapWalkerNode
implements HeapWalkerNode {
    private HeapWalkerNode parent;
    private Icon icon;
    private String name;
    private String type;
    private String value;
    private String size;
    private String retainedSize;
    private HeapWalkerNode[] children;
    private int mode = 1;
    private Map<Object, Integer> indexes;

    public AbstractHeapWalkerNode(HeapWalkerNode heapWalkerNode) {
        this(heapWalkerNode, heapWalkerNode == null ? 1 : heapWalkerNode.getMode());
    }

    public AbstractHeapWalkerNode(HeapWalkerNode heapWalkerNode, int n) {
        this.parent = heapWalkerNode;
        this.mode = n;
    }

    @Override
    public HeapWalkerNode getChild(int n) {
        return this.getChildren()[n];
    }

    @Override
    public HeapWalkerNode[] getChildren() {
        if (this.children == null) {
            this.children = this.computeChildren();
            this.indexes = null;
        }
        return this.children;
    }

    private Map<Object, Integer> getIndexes() {
        if (this.indexes == null) {
            HeapWalkerNode[] heapWalkerNodeArray = this.getChildren();
            this.indexes = new HashMap<Object, Integer>(heapWalkerNodeArray.length * 4 / 3);
            for (int i = 0; i < heapWalkerNodeArray.length; ++i) {
                this.indexes.put(heapWalkerNodeArray[i], i);
            }
        }
        return this.indexes;
    }

    @Override
    public Icon getIcon() {
        if (this.icon == null) {
            this.icon = this.computeIcon();
        }
        return this.icon;
    }

    @Override
    public int getIndexOfChild(Object object) {
        Integer n = this.getIndexes().get(object);
        return n != null ? n : -1;
    }

    @Override
    public boolean isLeaf() {
        return this.getNChildren() == 0;
    }

    @Override
    public int getMode() {
        return this.mode;
    }

    @Override
    public int getNChildren() {
        if (this.getChildren() == null) {
            return 0;
        }
        return this.getChildren().length;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.name = this.computeName();
        }
        return this.name;
    }

    @Override
    public HeapWalkerNode getParent() {
        return this.parent;
    }

    @Override
    public boolean isRoot() {
        return this.getParent() == null;
    }

    @Override
    public String getSimpleType() {
        return BrowserUtils.getSimpleType(this.getType());
    }

    @Override
    public String getType() {
        if (this.type == null) {
            this.type = this.computeType();
        }
        return this.type;
    }

    @Override
    public String getValue() {
        if (this.value == null) {
            this.value = this.computeValue();
        }
        return this.value;
    }

    @Override
    public String getDetails() {
        return null;
    }

    @Override
    public String getSize() {
        if (this.size == null) {
            this.size = this.computeSize();
        }
        return this.size;
    }

    @Override
    public String getRetainedSize() {
        if (this.retainedSize == null) {
            this.retainedSize = this.computeRetainedSize();
        }
        return this.retainedSize;
    }

    @Override
    public boolean currentlyHasChildren() {
        return this.children != null;
    }

    protected ChildrenComputer getChildrenComputer() {
        return null;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public Object getNodeID() {
        return this.getName();
    }

    public boolean equals(Object object) {
        if (!(object instanceof HeapWalkerNode)) {
            return false;
        }
        HeapWalkerNode heapWalkerNode = (HeapWalkerNode)object;
        return this.getNodeID().equals(heapWalkerNode.getNodeID());
    }

    public int hashCode() {
        return this.getNodeID().hashCode();
    }

    protected abstract Icon computeIcon();

    protected abstract String computeName();

    protected abstract String computeType();

    protected abstract String computeValue();

    protected abstract String computeSize();

    protected abstract String computeRetainedSize();

    protected void setChildren(HeapWalkerNode[] heapWalkerNodeArray) {
        this.changeChildren(heapWalkerNodeArray);
    }

    protected HeapWalkerNode[] computeChildren() {
        ChildrenComputer childrenComputer = this.getChildrenComputer();
        if (childrenComputer != null) {
            return BrowserUtils.lazilyCreateChildren(this, childrenComputer);
        }
        return new HeapWalkerNode[0];
    }

    void changeChildren(final HeapWalkerNode[] heapWalkerNodeArray) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                AbstractHeapWalkerNode.access$002(AbstractHeapWalkerNode.this, heapWalkerNodeArray);
                AbstractHeapWalkerNode.this.indexes = null;
            }
        };
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception exception) {}
        } else {
            runnable.run();
        }
    }

    static /* synthetic */ HeapWalkerNode[] access$002(AbstractHeapWalkerNode abstractHeapWalkerNode, HeapWalkerNode[] heapWalkerNodeArray) {
        abstractHeapWalkerNode.children = heapWalkerNodeArray;
        return heapWalkerNodeArray;
    }
}

