/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.util.List;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariant;
import org.gradle.api.internal.artifacts.transform.ConsumerVariantMatchResult;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.internal.Pair;
import org.gradle.internal.component.AmbiguousVariantSelectionException;
import org.gradle.internal.text.TreeFormatter;

public class AmbiguousTransformException
extends RuntimeException {
    public AmbiguousTransformException(String producerDisplayName, AttributeContainerInternal requested, List<Pair<ResolvedVariant, ConsumerVariantMatchResult.ConsumerVariant>> candidates) {
        super(AmbiguousTransformException.format(producerDisplayName, requested, candidates));
    }

    private static String format(String producerDisplayName, AttributeContainerInternal requested, List<Pair<ResolvedVariant, ConsumerVariantMatchResult.ConsumerVariant>> candidates) {
        TreeFormatter formatter = new TreeFormatter();
        formatter.node("Found multiple transforms that can produce a variant of " + producerDisplayName + " for consumer attributes");
        AmbiguousVariantSelectionException.formatAttributes(formatter, (AttributeContainer)requested);
        formatter.node("Found the following transforms");
        formatter.startChildren();
        for (Pair<ResolvedVariant, ConsumerVariantMatchResult.ConsumerVariant> candidate : candidates) {
            formatter.node("Transform from " + ((ResolvedVariant)candidate.getLeft()).asDescribable().getDisplayName());
            AmbiguousVariantSelectionException.formatAttributes(formatter, (AttributeContainer)((ResolvedVariant)candidate.getLeft()).getAttributes());
        }
        formatter.endChildren();
        return formatter.toString();
    }
}

