/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import javax.annotation.Nullable;
import org.gradle.api.internal.provider.AbstractProvider;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.provider.Provider;
import org.gradle.internal.Cast;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Providers {
    private static final Provider<Object> NULL_PROVIDER = new ProviderInternal<Object>(){

        public Object get() {
            throw new IllegalStateException("No value has been specified for this provider.");
        }

        @Override
        @Nullable
        public Class<Object> getType() {
            return null;
        }

        public Object getOrNull() {
            return null;
        }

        public boolean isPresent() {
            return false;
        }
    };
    public static final Provider<Boolean> TRUE = Providers.of(true);
    public static final Provider<Boolean> FALSE = Providers.of(false);
    public static final Provider<Character> CHAR_ZERO = Providers.of(Character.valueOf('\u0000'));
    public static final Provider<Byte> BYTE_ZERO = Providers.of((byte)0);
    public static final Provider<Short> SHORT_ZERO = Providers.of((short)0);
    public static final Provider<Integer> INTEGER_ZERO = Providers.of(0);
    public static final Provider<Long> LONG_ZERO = Providers.of(0L);
    public static final Provider<Float> FLOAT_ZERO = Providers.of(Float.valueOf(0.0f));
    public static final Provider<Double> DOUBLE_ZERO = Providers.of(0.0);

    public static <T> Provider<T> notDefined() {
        return (Provider)Cast.uncheckedCast(NULL_PROVIDER);
    }

    public static <T> Provider<T> of(final T value) {
        return new AbstractProvider<T>(){

            @Override
            @Nullable
            public Class<T> getType() {
                return (Class)Cast.uncheckedCast(value.getClass());
            }

            public T getOrNull() {
                return value;
            }
        };
    }
}

