/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterators;
import java.io.File;
import java.util.Iterator;
import java.util.Map;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.tasks.AbstractTaskOutputPropertySpec;
import org.gradle.api.internal.tasks.CacheableTaskOutputCompositeFilePropertyElementSpec;
import org.gradle.api.internal.tasks.CacheableTaskOutputFilePropertySpec;
import org.gradle.api.internal.tasks.NonCacheableTaskOutputPropertySpec;
import org.gradle.api.internal.tasks.TaskOutputFilePropertySpec;
import org.gradle.util.DeferredUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeTaskOutputPropertySpec
extends AbstractTaskOutputPropertySpec {
    private final CacheableTaskOutputFilePropertySpec.OutputType outputType;
    private final Object paths;
    private final String taskName;
    private final FileResolver resolver;

    public CompositeTaskOutputPropertySpec(String taskName, FileResolver resolver, CacheableTaskOutputFilePropertySpec.OutputType outputType, Object[] paths) {
        this.taskName = taskName;
        this.resolver = resolver;
        this.outputType = outputType;
        this.paths = paths != null && paths.length == 1 ? paths[0] : paths;
    }

    public CacheableTaskOutputFilePropertySpec.OutputType getOutputType() {
        return this.outputType;
    }

    public Iterator<TaskOutputFilePropertySpec> resolveToOutputProperties() {
        Object unpackedPaths = DeferredUtil.unpack(this.paths);
        if (unpackedPaths == null) {
            return Iterators.emptyIterator();
        }
        if (unpackedPaths instanceof Map) {
            final Iterator iterator = ((Map)unpackedPaths).entrySet().iterator();
            return new AbstractIterator<TaskOutputFilePropertySpec>(){

                protected TaskOutputFilePropertySpec computeNext() {
                    if (iterator.hasNext()) {
                        Map.Entry entry = (Map.Entry)iterator.next();
                        Object key = entry.getKey();
                        if (key == null) {
                            throw new IllegalArgumentException(String.format("Mapped output property '%s' has null key", CompositeTaskOutputPropertySpec.this.getPropertyName()));
                        }
                        String id = key.toString();
                        File file = CompositeTaskOutputPropertySpec.this.resolver.resolve(entry.getValue());
                        return new CacheableTaskOutputCompositeFilePropertyElementSpec(CompositeTaskOutputPropertySpec.this, "." + id, file);
                    }
                    return (TaskOutputFilePropertySpec)this.endOfData();
                }
            };
        }
        return Iterators.singletonIterator((Object)new NonCacheableTaskOutputPropertySpec(this.taskName, this, this.resolver, unpackedPaths));
    }
}

