/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.xmlb;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.util.xmlb.BeanBinding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.NotNullDeserializeBinding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.SerializationFilter;
import org.jetbrains.kotlin.com.intellij.util.xmlb.XmlSerializationException;
import org.jetbrains.kotlin.com.intellij.util.xmlb.XmlSerializerImpl;
import org.jetbrains.kotlin.org.jdom.Element;

public class XmlSerializer {
    private static final SerializationFilter TRUE_FILTER = new SerializationFilter(){};

    private XmlSerializer() {
    }

    @NotNull
    public static <T> T deserialize(@NotNull Element element, @NotNull Class<T> aClass2) throws XmlSerializationException {
        Object object;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/util/xmlb/XmlSerializer", "deserialize"));
        }
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/util/xmlb/XmlSerializer", "deserialize"));
        }
        try {
            NotNullDeserializeBinding binding = (NotNullDeserializeBinding)XmlSerializerImpl.serializer.getClassBinding(aClass2);
            object = binding.deserialize(null, element);
        }
        catch (XmlSerializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XmlSerializationException("Cannot deserialize class " + aClass2.getName(), e);
        }
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/xmlb/XmlSerializer", "deserialize"));
        }
        return (T)object;
    }

    public static void deserializeInto(@NotNull Object bean, @NotNull Element element) {
        if (bean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "org/jetbrains/kotlin/com/intellij/util/xmlb/XmlSerializer", "deserializeInto"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/util/xmlb/XmlSerializer", "deserializeInto"));
        }
        try {
            Class<?> clazz = bean.getClass();
            ((BeanBinding)XmlSerializerImpl.serializer.getClassBinding(clazz)).deserializeInto(bean, element);
        }
        catch (XmlSerializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XmlSerializationException(e);
        }
    }
}

