/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.cpp.internal;

import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.FileCollection;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.language.cpp.CppBinary;
import org.gradle.language.nativeplatform.internal.Names;

public class DefaultCppBinary
implements CppBinary {
    private final String name;
    private final Provider<String> baseName;
    private final boolean debuggable;
    private final FileCollection sourceFiles;
    private final FileCollection includePath;
    private final FileCollection linkLibraries;
    private final FileCollection runtimeLibraries;

    public DefaultCppBinary(String name, ObjectFactory objects, Provider<String> baseName, boolean debuggable, FileCollection sourceFiles, FileCollection componentHeaderDirs, ConfigurationContainer configurations, Configuration implementation) {
        this.name = name;
        this.baseName = baseName;
        this.debuggable = debuggable;
        this.sourceFiles = sourceFiles;
        Names names = Names.of(name);
        Configuration includePathConfig = (Configuration)configurations.create(names.withPrefix("cppCompile"));
        includePathConfig.setCanBeConsumed(false);
        includePathConfig.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)objects.named(Usage.class, "cplusplus-api"));
        includePathConfig.getAttributes().attribute(DEBUGGABLE_ATTRIBUTE, (Object)debuggable);
        Configuration nativeLink = (Configuration)configurations.create(names.withPrefix("nativeLink"));
        nativeLink.setCanBeConsumed(false);
        nativeLink.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)objects.named(Usage.class, "native-link"));
        nativeLink.getAttributes().attribute(DEBUGGABLE_ATTRIBUTE, (Object)debuggable);
        Configuration nativeRuntime = (Configuration)configurations.create(names.withPrefix("nativeRuntime"));
        nativeRuntime.setCanBeConsumed(false);
        nativeRuntime.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)objects.named(Usage.class, "native-runtime"));
        nativeRuntime.getAttributes().attribute(DEBUGGABLE_ATTRIBUTE, (Object)debuggable);
        includePathConfig.extendsFrom(new Configuration[]{implementation});
        nativeLink.extendsFrom(new Configuration[]{implementation});
        nativeRuntime.extendsFrom(new Configuration[]{implementation});
        this.includePath = componentHeaderDirs.plus((FileCollection)includePathConfig);
        this.linkLibraries = nativeLink;
        this.runtimeLibraries = nativeRuntime;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Provider<String> getBaseName() {
        return this.baseName;
    }

    @Override
    public boolean isDebuggable() {
        return this.debuggable;
    }

    @Override
    public FileCollection getCppSource() {
        return this.sourceFiles;
    }

    @Override
    public FileCollection getCompileIncludePath() {
        return this.includePath;
    }

    @Override
    public FileCollection getLinkLibraries() {
        return this.linkLibraries;
    }

    @Override
    public FileCollection getRuntimeLibraries() {
        return this.runtimeLibraries;
    }
}

