/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.cpp.internal;

import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.language.cpp.CppLibrary;
import org.gradle.language.cpp.CppSharedLibrary;
import org.gradle.language.cpp.internal.DefaultCppComponent;
import org.gradle.language.cpp.internal.DefaultCppSharedLibrary;

public class DefaultCppLibrary
extends DefaultCppComponent
implements CppLibrary {
    private final ConfigurableFileCollection publicHeaders;
    private final FileCollection publicHeadersWithConvention;
    private final DefaultCppSharedLibrary debug;
    private final DefaultCppSharedLibrary release;
    private final Configuration api;

    @Inject
    public DefaultCppLibrary(String name, ObjectFactory objectFactory, FileOperations fileOperations, ProviderFactory providerFactory, ConfigurationContainer configurations) {
        super(name, fileOperations, providerFactory, configurations);
        this.publicHeaders = fileOperations.files(new Object[0]);
        this.publicHeadersWithConvention = this.createDirView(this.publicHeaders, "src/" + name + "/public");
        this.debug = new DefaultCppSharedLibrary(name + "Debug", objectFactory, (Provider<String>)this.getBaseName(), true, this.getCppSource(), this.getAllHeaderDirs(), configurations, this.getImplementationDependencies());
        this.release = new DefaultCppSharedLibrary(name + "Release", objectFactory, (Provider<String>)this.getBaseName(), false, this.getCppSource(), this.getAllHeaderDirs(), configurations, this.getImplementationDependencies());
        this.api = (Configuration)configurations.create(this.getNames().withSuffix("api"));
        this.api.setCanBeConsumed(false);
        this.api.setCanBeResolved(false);
        this.getImplementationDependencies().extendsFrom(new Configuration[]{this.api});
    }

    @Override
    public Configuration getApiDependencies() {
        return this.api;
    }

    @Override
    public ConfigurableFileCollection getPublicHeaders() {
        return this.publicHeaders;
    }

    @Override
    public void publicHeaders(Action<? super ConfigurableFileCollection> action) {
        action.execute((Object)this.publicHeaders);
    }

    @Override
    public FileCollection getPublicHeaderDirs() {
        return this.publicHeadersWithConvention;
    }

    @Override
    protected FileCollection getAllHeaderDirs() {
        return this.publicHeadersWithConvention.plus(super.getAllHeaderDirs());
    }

    @Override
    public CppSharedLibrary getDevelopmentBinary() {
        return this.debug;
    }

    @Override
    public CppSharedLibrary getDebugSharedLibrary() {
        return this.debug;
    }

    @Override
    public CppSharedLibrary getReleaseSharedLibrary() {
        return this.release;
    }
}

