/*
 * Decompiled with CFR 0.152.
 */
package dguitar.gui;

import dguitar.codecs.guitarPro.GPBeat;
import dguitar.codecs.guitarPro.GPBendType;
import dguitar.codecs.guitarPro.GPDuration;
import dguitar.codecs.guitarPro.GPDynamic;
import dguitar.codecs.guitarPro.GPEffectsOnNote;
import dguitar.codecs.guitarPro.GPNote;
import dguitar.gui.BarMTP;
import dguitar.gui.BarPanel;
import dguitar.gui.DGuitar;
import dguitar.gui.DisplayOptions;
import dguitar.gui.SlideLabel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import java.util.Vector;
import javax.swing.JLabel;

public class BarTablature
extends BarMTP {
    private static final int EONX = 5;
    private List EONlabels;
    private List SLabels;

    public BarTablature(DisplayOptions dco, BarPanel BP) {
        super(dco, BP);
        this.commonConstructor();
    }

    private void addSilence(int currentX, GPDuration d) {
        JLabel SilenceLabel = new JLabel(DGuitar.Silences[d.getIndex()]);
        this.locateSilence(SilenceLabel, currentX);
        SilenceLabel.setVisible(true);
        this.add(SilenceLabel);
        this.SLabels.add(SilenceLabel);
    }

    protected int calculateHeightOfString(int s) {
        int y = this.getDisplayOptions().TopOffset + this.BP.H - s * this.getDisplayOptions().LS;
        y += (7 - this.BP.LINES) * this.getDisplayOptions().LS;
        return y += this.fontAscent / 2;
    }

    private void commonConstructor() {
        this.SLabels = new Vector(0, 1);
        this.EONlabels = new Vector(0, 1);
    }

    private JLabel createLabelForIndex(int pos, int x, int y, GPEffectsOnNote EON, GPBeat beat) {
        int index = -1 * pos;
        SlideLabel resp = null;
        if (index >= 1 && index <= 6) {
            int width = this.calculateWidthOfBeat(beat);
            SlideLabel SL = new SlideLabel(this.getDisplayOptions(), width);
            SL.setTypeOfSlide(EON.slide);
            SL.setAnchor(x, y);
            resp = SL;
        }
        return resp;
    }

    private void eonAdd(int currentX, int currentY, GPEffectsOnNote EON, GPBeat beat) {
        JLabel EONlabel;
        int pos = this.index(EON);
        if (pos >= 0) {
            EONlabel = new JLabel();
            EONlabel.setIcon(DGuitar.EONs[pos]);
            this.eonLocate(EONlabel, currentX, currentY, EON, beat);
        } else {
            EONlabel = this.createLabelForIndex(pos, currentX, currentY, EON, beat);
        }
        if (pos == 0) {
            EONlabel.setName("?");
            EONlabel.setVisible(this.getDisplayOptions().displayUnsupportedEffects);
        } else {
            EONlabel.setName("" + pos);
            EONlabel.setVisible(true);
        }
        EONlabel.setToolTipText(EON.toString());
        this.add(EONlabel);
        this.EONlabels.add(EONlabel);
    }

    private void eonLocate(JLabel EONLabel, int currentX, int currentY, GPEffectsOnNote EON, GPBeat beat) {
        Dimension dim = EONLabel.getPreferredSize();
        Point p = new Point(currentX, currentY);
        SlideLabel SL = new SlideLabel();
        if (SL.getClass().isInstance(EONLabel)) {
            SL = (SlideLabel)EONLabel;
            Point aux = SL.setAnchor(p);
            SL.setWidth(this.calculateWidthOfBeat(beat));
        } else {
            Point aux = this.eonPosition(EON, p, dim);
            Rectangle rect = new Rectangle(aux.x, aux.y, dim.width, dim.height);
            EONLabel.setBounds(rect);
        }
    }

    private Point eonPosition(GPEffectsOnNote EON, Point current, Dimension dim) {
        int whichEON = this.index(EON);
        Point res = current;
        if (whichEON == 1) {
            res.x = current.x + 5;
            res.y = current.y - dim.height / 2;
        } else if (whichEON == 0 || whichEON >= 2 && whichEON <= 6) {
            res.x = current.x + 5;
            res.y = current.y - 3 * dim.height / 2 + 2;
        }
        return res;
    }

    public boolean equals(Object o) {
        boolean resp = false;
        if (o != null && o.getClass().isInstance(this)) {
            BarTablature other = (BarTablature)o;
            resp = this.mtp.equals(other.mtp);
        }
        return resp;
    }

    private int index(GPBendType bendType) {
        int i = -1;
        if (bendType != null) {
            if (bendType.equals(GPBendType.BEND)) {
                i = 0;
            } else if (bendType.equals(GPBendType.BEND_RELEASE)) {
                i = 1;
            } else if (bendType.equals(GPBendType.BEND_RELEASE_BEND)) {
                i = 2;
            } else if (bendType.equals(GPBendType.PREBEND)) {
                i = 3;
            } else if (bendType.equals(GPBendType.PREBEND_RELEASE)) {
                i = 4;
            }
        }
        return i;
    }

    private int index(GPEffectsOnNote EON) {
        int i = -1;
        if (EON != null) {
            i = 0;
            if (EON.letRing) {
                i = 1;
            } else if (EON.bend != null) {
                i = 2 + this.index(EON.bend.getType());
            } else if (EON.slide != null) {
                i = -1 * (1 + EON.slide.getIndex());
            }
        }
        return i;
    }

    private void locateSilence(JLabel SilenceLabel, int currentX) {
        Dimension dim = SilenceLabel.getPreferredSize();
        int y = this.getDisplayOptions().TopOffset + this.BP.H / 2 - dim.height / 2;
        int x = currentX - dim.width / 2;
        Rectangle rect = new Rectangle(x, y, dim.width, dim.height);
        SilenceLabel.setBounds(rect);
    }

    protected void paintEffects(Graphics g, int currentX, int y, GPEffectsOnNote EON, int contEON, GPBeat beat) {
        if (EON != null) {
            Color prevColor = g.getColor();
            if (this.addEONs && EON != null) {
                this.eonAdd(currentX, y, EON, beat);
            } else {
                JLabel eon = (JLabel)this.EONlabels.get(contEON);
                if (eon.getName().equals("?")) {
                    eon.setVisible(this.getDisplayOptions().displayUnsupportedEffects);
                }
                this.eonLocate(eon, currentX, y, EON, beat);
            }
            g.setColor(prevColor);
        }
    }

    protected void paintNote(Graphics g, int currentX, int y, GPNote note) {
        GPDynamic dynamic;
        Color prevColor = g.getColor();
        int fret = note.getFretNumber();
        String aux = "" + fret;
        int x = this.paintSpaceAroundFret(g, aux, currentX, y);
        if (this.getDisplayOptions().coloringForFrets == 1) {
            if (note.duration != null) {
                int pos = note.duration.getIndex();
                Color noteColor = this.getDisplayOptions().fretColors.getColor(pos);
                g.setColor(noteColor);
            }
        } else if (this.getDisplayOptions().coloringForFrets == 2 && (dynamic = note.getDynamic()) != null) {
            int pos = dynamic.getIndex() - 1;
            Color noteColor = this.getDisplayOptions().fretColors.getColor(pos);
            g.setColor(noteColor);
        }
        g.drawString(aux, x + 1, y - 1);
        g.setColor(prevColor);
    }

    protected void paintRhythmHL(Graphics g, int x, int lowest, int n, GPBeat prev) {
        Color prevColor = g.getColor();
        if (prev != null) {
            int i = 0;
            while (i <= n) {
                int aux = lowest - i * 3;
                g.setColor(this.colorPrev);
                int x2 = i <= this.lastNumHLines ? x - this.calculateWidthOfBeat(prev) + this.getDisplayOptions().NS / 2 + 1 : x - this.getDisplayOptions().NS / 2;
                g.drawLine(x, aux - 1, x2, aux - 1);
                g.drawLine(x, aux, x2, aux);
                ++i;
            }
        } else {
            int i = 0;
            while (i <= n) {
                int aux = lowest - i * 3;
                g.setColor(this.colorNext);
                int x2 = x + this.getDisplayOptions().NS / 2;
                g.drawLine(x, aux - 1, x2, aux - 1);
                g.drawLine(x, aux, x2, aux);
                ++i;
            }
        }
        g.setColor(prevColor);
    }

    protected void paintSilence(Graphics g, int currentX, GPBeat beat, int contSilences) {
        Color prevColor = g.getColor();
        if (this.addSilence) {
            this.addSilence(currentX, beat.getDuration());
        } else {
            this.locateSilence((JLabel)this.SLabels.get(contSilences), currentX);
        }
        g.setColor(prevColor);
    }

    private int paintSpaceAroundFret(Graphics g, String aux, int x, int y) {
        Color prevColor = g.getColor();
        g.setColor(this.getBackground());
        int dx = g.getFontMetrics().stringWidth(aux);
        int newx = x - dx / 2;
        g.fillRect(newx, y - this.fontAscent, dx + 2, this.fontAscent + 1);
        g.setColor(prevColor);
        return newx;
    }
}

