/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal.incremental;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.BaseSerializerFactory;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.HashCodeSerializer;
import org.gradle.internal.serialize.ListSerializer;
import org.gradle.internal.serialize.MapSerializer;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.serialize.SetSerializer;
import org.gradle.language.nativeplatform.internal.Include;
import org.gradle.language.nativeplatform.internal.IncludeDirectives;
import org.gradle.language.nativeplatform.internal.IncludeType;
import org.gradle.language.nativeplatform.internal.incremental.CompilationFileState;
import org.gradle.language.nativeplatform.internal.incremental.CompilationState;
import org.gradle.language.nativeplatform.internal.incremental.ResolvedInclude;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.DefaultInclude;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.DefaultIncludeDirectives;

public class CompilationStateSerializer
extends AbstractSerializer<CompilationState> {
    private static final BaseSerializerFactory SERIALIZER_FACTORY = new BaseSerializerFactory();
    private final Serializer<File> fileSerializer = SERIALIZER_FACTORY.getSerializerFor(File.class);
    private final SetSerializer<File> fileSetSerializer = new SetSerializer(this.fileSerializer);
    private final MapSerializer<File, CompilationFileState> stateMapSerializer = new MapSerializer(this.fileSerializer, (Serializer)new CompilationFileStateSerializer(this.fileSerializer));

    public CompilationState read(Decoder decoder) throws Exception {
        ImmutableSet sourceInputs = ImmutableSet.copyOf((Collection)this.fileSetSerializer.read(decoder));
        ImmutableMap fileStates = ImmutableMap.copyOf((Map)this.stateMapSerializer.read(decoder));
        return new CompilationState((ImmutableSet<File>)sourceInputs, (ImmutableMap<File, CompilationFileState>)fileStates);
    }

    public void write(Encoder encoder, CompilationState value) throws Exception {
        this.fileSetSerializer.write(encoder, value.getSourceInputs());
        this.stateMapSerializer.write(encoder, value.getFileStates());
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        CompilationStateSerializer rhs = (CompilationStateSerializer)((Object)obj);
        return Objects.equal(this.fileSerializer, rhs.fileSerializer) && Objects.equal(this.fileSetSerializer, rhs.fileSetSerializer) && Objects.equal(this.stateMapSerializer, rhs.stateMapSerializer);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.fileSerializer, this.fileSetSerializer, this.stateMapSerializer});
    }

    static /* synthetic */ BaseSerializerFactory access$400() {
        return SERIALIZER_FACTORY;
    }

    private static class IncludeSerializer
    extends AbstractSerializer<Include> {
        private final Serializer<String> stringSerializer = CompilationStateSerializer.access$400().getSerializerFor(String.class);
        private final Serializer<Boolean> booleanSerializer = CompilationStateSerializer.access$400().getSerializerFor(Boolean.class);
        private final Serializer<IncludeType> enumSerializer = CompilationStateSerializer.access$400().getSerializerFor(IncludeType.class);

        private IncludeSerializer() {
        }

        public Include read(Decoder decoder) throws Exception {
            String value = (String)this.stringSerializer.read(decoder);
            boolean isImport = (Boolean)this.booleanSerializer.read(decoder);
            IncludeType type = (IncludeType)this.enumSerializer.read(decoder);
            return new DefaultInclude(value, isImport, type);
        }

        public void write(Encoder encoder, Include value) throws Exception {
            this.stringSerializer.write(encoder, (Object)value.getValue());
            this.booleanSerializer.write(encoder, (Object)value.isImport());
            this.enumSerializer.write(encoder, (Object)value.getType());
        }

        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            IncludeSerializer rhs = (IncludeSerializer)((Object)obj);
            return Objects.equal(this.stringSerializer, rhs.stringSerializer) && Objects.equal(this.booleanSerializer, rhs.booleanSerializer) && Objects.equal(this.enumSerializer, rhs.enumSerializer);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.stringSerializer, this.booleanSerializer, this.enumSerializer});
        }
    }

    private static class SourceIncludesSerializer
    extends AbstractSerializer<IncludeDirectives> {
        private final Serializer<Include> includeSerializer = new IncludeSerializer();
        private final ListSerializer<Include> includeListSerializer = new ListSerializer(this.includeSerializer);

        private SourceIncludesSerializer() {
        }

        public IncludeDirectives read(Decoder decoder) throws Exception {
            return new DefaultIncludeDirectives((List)this.includeListSerializer.read(decoder));
        }

        public void write(Encoder encoder, IncludeDirectives value) throws Exception {
            this.includeListSerializer.write(encoder, (Collection)value.getIncludesAndImports());
        }

        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            SourceIncludesSerializer rhs = (SourceIncludesSerializer)((Object)obj);
            return Objects.equal(this.includeSerializer, rhs.includeSerializer) && Objects.equal(this.includeListSerializer, rhs.includeListSerializer);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.includeSerializer, this.includeListSerializer});
        }
    }

    private static class ResolvedIncludeSerializer
    extends AbstractSerializer<ResolvedInclude> {
        private final Serializer<File> fileSerializer;

        private ResolvedIncludeSerializer(Serializer<File> fileSerializer) {
            this.fileSerializer = fileSerializer;
        }

        public ResolvedInclude read(Decoder decoder) throws Exception {
            String include = decoder.readString();
            File included = null;
            if (decoder.readBoolean()) {
                included = (File)this.fileSerializer.read(decoder);
            }
            return new ResolvedInclude(include, included);
        }

        public void write(Encoder encoder, ResolvedInclude value) throws Exception {
            encoder.writeString((CharSequence)value.getInclude());
            if (value.getFile() == null) {
                encoder.writeBoolean(false);
            } else {
                encoder.writeBoolean(true);
                this.fileSerializer.write(encoder, (Object)value.getFile());
            }
        }

        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            ResolvedIncludeSerializer rhs = (ResolvedIncludeSerializer)((Object)obj);
            return Objects.equal(this.fileSerializer, rhs.fileSerializer);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.fileSerializer});
        }
    }

    private static class CompilationFileStateSerializer
    extends AbstractSerializer<CompilationFileState> {
        private final Serializer<HashCode> hashSerializer = new HashCodeSerializer();
        private final Serializer<Set<ResolvedInclude>> resolveIncludesSerializer;
        private final Serializer<IncludeDirectives> sourceIncludesSerializer = new SourceIncludesSerializer();

        private CompilationFileStateSerializer(Serializer<File> fileSerializer) {
            this.resolveIncludesSerializer = new SetSerializer((Serializer)new ResolvedIncludeSerializer(fileSerializer));
        }

        public CompilationFileState read(Decoder decoder) throws Exception {
            HashCode hash = (HashCode)this.hashSerializer.read(decoder);
            ImmutableSet resolvedIncludes = ImmutableSet.copyOf((Collection)((Collection)this.resolveIncludesSerializer.read(decoder)));
            IncludeDirectives includeDirectives = (IncludeDirectives)this.sourceIncludesSerializer.read(decoder);
            return new CompilationFileState(hash, includeDirectives, (ImmutableSet<ResolvedInclude>)resolvedIncludes);
        }

        public void write(Encoder encoder, CompilationFileState value) throws Exception {
            this.hashSerializer.write(encoder, (Object)value.getHash());
            this.resolveIncludesSerializer.write(encoder, value.getResolvedIncludes());
            this.sourceIncludesSerializer.write(encoder, (Object)value.getIncludeDirectives());
        }

        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            CompilationFileStateSerializer rhs = (CompilationFileStateSerializer)((Object)obj);
            return Objects.equal(this.hashSerializer, rhs.hashSerializer) && Objects.equal(this.resolveIncludesSerializer, rhs.resolveIncludesSerializer) && Objects.equal(this.sourceIncludesSerializer, rhs.sourceIncludesSerializer);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.hashSerializer, this.resolveIncludesSerializer, this.sourceIncludesSerializer});
        }
    }
}

