/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotation;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierList;
import org.jetbrains.kotlin.com.intellij.psi.impl.light.LightModifierList;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public class PsiCompositeModifierList
extends LightModifierList {
    private final List<PsiModifierList> mySublists;

    public PsiCompositeModifierList(PsiManager manager, List<PsiModifierList> sublists) {
        super(manager);
        this.mySublists = sublists;
    }

    @Override
    @NotNull
    public PsiAnnotation[] getAnnotations() {
        ArrayList annotations2 = new ArrayList();
        for (PsiModifierList list2 : this.mySublists) {
            ContainerUtil.addAll(annotations2, list2.getAnnotations());
        }
        PsiAnnotation[] psiAnnotationArray = annotations2.toArray(new PsiAnnotation[annotations2.size()]);
        if (psiAnnotationArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiCompositeModifierList", "getAnnotations"));
        }
        return psiAnnotationArray;
    }

    @Override
    public PsiAnnotation findAnnotation(@NotNull String qualifiedName2) {
        if (qualifiedName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiCompositeModifierList", "findAnnotation"));
        }
        for (PsiModifierList sublist : this.mySublists) {
            PsiAnnotation annotation2 = sublist.findAnnotation(qualifiedName2);
            if (annotation2 == null) continue;
            return annotation2;
        }
        return null;
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiCompositeModifierList", "hasModifierProperty"));
        }
        for (PsiModifierList sublist : this.mySublists) {
            if (!sublist.hasModifierProperty(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasExplicitModifier(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiCompositeModifierList", "hasExplicitModifier"));
        }
        for (PsiModifierList sublist : this.mySublists) {
            if (!sublist.hasExplicitModifier(name)) continue;
            return true;
        }
        return false;
    }
}

