/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.ReflectionTypes;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.javax.inject.Inject;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtCollectionLiteralExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.ResolveArgumentsMode;
import org.jetbrains.kotlin.resolve.calls.context.CallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CheckArgumentTypesMode;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilderImplKt;
import org.jetbrains.kotlin.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsUtil;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstructor;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.types.FunctionPlaceholders;
import org.jetbrains.kotlin.types.FunctionPlaceholdersKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.expressions.DoubleColonExpressionResolver;
import org.jetbrains.kotlin.types.expressions.DoubleColonLHS;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;

public class ArgumentTypeResolver {
    @NotNull
    private final TypeResolver typeResolver;
    @NotNull
    private final DoubleColonExpressionResolver doubleColonExpressionResolver;
    @NotNull
    private final KotlinBuiltIns builtIns;
    @NotNull
    private final ReflectionTypes reflectionTypes;
    @NotNull
    private final ConstantExpressionEvaluator constantExpressionEvaluator;
    @NotNull
    private final FunctionPlaceholders functionPlaceholders;
    private ExpressionTypingServices expressionTypingServices;

    public ArgumentTypeResolver(@NotNull TypeResolver typeResolver, @NotNull DoubleColonExpressionResolver doubleColonExpressionResolver, @NotNull KotlinBuiltIns builtIns, @NotNull ReflectionTypes reflectionTypes, @NotNull ConstantExpressionEvaluator constantExpressionEvaluator, @NotNull FunctionPlaceholders functionPlaceholders) {
        if (typeResolver == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(0);
        }
        if (doubleColonExpressionResolver == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(1);
        }
        if (builtIns == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(2);
        }
        if (reflectionTypes == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(3);
        }
        if (constantExpressionEvaluator == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(4);
        }
        if (functionPlaceholders == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(5);
        }
        this.typeResolver = typeResolver;
        this.doubleColonExpressionResolver = doubleColonExpressionResolver;
        this.builtIns = builtIns;
        this.reflectionTypes = reflectionTypes;
        this.constantExpressionEvaluator = constantExpressionEvaluator;
        this.functionPlaceholders = functionPlaceholders;
    }

    @Inject
    public void setExpressionTypingServices(@NotNull ExpressionTypingServices expressionTypingServices) {
        if (expressionTypingServices == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(6);
        }
        this.expressionTypingServices = expressionTypingServices;
    }

    public static boolean isSubtypeOfForArgumentType(@NotNull KotlinType actualType, @NotNull KotlinType expectedType) {
        if (actualType == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(7);
        }
        if (expectedType == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(8);
        }
        if (FunctionPlaceholdersKt.isFunctionPlaceholder(actualType)) {
            KotlinType functionType = ConstraintSystemBuilderImplKt.createTypeForFunctionPlaceholder(actualType, expectedType);
            return KotlinTypeChecker.DEFAULT.isSubtypeOf(functionType, expectedType);
        }
        return KotlinTypeChecker.DEFAULT.isSubtypeOf(actualType, expectedType);
    }

    public void checkTypesWithNoCallee(@NotNull CallResolutionContext<?> context) {
        if (context == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(9);
        }
        this.checkTypesWithNoCallee(context, ResolveArgumentsMode.SHAPE_FUNCTION_ARGUMENTS);
    }

    public void checkTypesWithNoCallee(@NotNull CallResolutionContext<?> context, @NotNull ResolveArgumentsMode resolveFunctionArgumentBodies) {
        if (context == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(10);
        }
        if (resolveFunctionArgumentBodies == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(11);
        }
        if (context.checkArguments != CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS) {
            return;
        }
        for (ValueArgument valueArgument : context.call.getValueArguments()) {
            KtExpression argumentExpression = valueArgument.getArgumentExpression();
            if (argumentExpression == null || argumentExpression instanceof KtLambdaExpression) continue;
            this.checkArgumentTypeWithNoCallee(context, argumentExpression);
        }
        if (resolveFunctionArgumentBodies == ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS) {
            this.checkTypesForFunctionArgumentsWithNoCallee(context);
        }
        for (KtTypeProjection ktTypeProjection : context.call.getTypeArguments()) {
            KtTypeReference typeReference = ktTypeProjection.getTypeReference();
            if (typeReference == null) {
                context.trace.report(Errors.PROJECTION_ON_NON_CLASS_TYPE_ARGUMENT.on(ktTypeProjection));
                continue;
            }
            this.typeResolver.resolveType(context.scope, typeReference, context.trace, true);
        }
    }

    public void checkTypesForFunctionArgumentsWithNoCallee(@NotNull CallResolutionContext<?> context) {
        if (context == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(12);
        }
        if (context.checkArguments != CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS) {
            return;
        }
        for (ValueArgument valueArgument : context.call.getValueArguments()) {
            KtExpression argumentExpression = valueArgument.getArgumentExpression();
            if (argumentExpression == null || !ArgumentTypeResolver.isFunctionLiteralArgument(argumentExpression, context)) continue;
            this.checkArgumentTypeWithNoCallee(context, argumentExpression);
        }
    }

    private void checkArgumentTypeWithNoCallee(CallResolutionContext<?> context, KtExpression argumentExpression) {
        this.expressionTypingServices.getTypeInfo(argumentExpression, (ResolutionContext)context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE));
        this.updateResultArgumentTypeIfNotDenotable(context, argumentExpression);
    }

    public static boolean isFunctionLiteralArgument(@NotNull KtExpression expression2, @NotNull ResolutionContext context) {
        if (expression2 == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(13);
        }
        if (context == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(14);
        }
        return ArgumentTypeResolver.getFunctionLiteralArgumentIfAny(expression2, context) != null;
    }

    @NotNull
    public static KtFunction getFunctionLiteralArgument(@NotNull KtExpression expression2, @NotNull ResolutionContext context) {
        if (expression2 == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(15);
        }
        if (context == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(16);
        }
        assert (ArgumentTypeResolver.isFunctionLiteralArgument(expression2, context));
        KtFunction ktFunction = ArgumentTypeResolver.getFunctionLiteralArgumentIfAny(expression2, context);
        if (ktFunction == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(17);
        }
        return ktFunction;
    }

    @Nullable
    public static KtFunction getFunctionLiteralArgumentIfAny(@NotNull KtExpression expression2, @NotNull ResolutionContext context) {
        KtExpression deparenthesizedExpression;
        if (expression2 == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(18);
        }
        if (context == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(19);
        }
        if ((deparenthesizedExpression = KtPsiUtil.getLastElementDeparenthesized(expression2, context.statementFilter)) instanceof KtLambdaExpression) {
            return ((KtLambdaExpression)deparenthesizedExpression).getFunctionLiteral();
        }
        if (deparenthesizedExpression instanceof KtFunction) {
            return (KtFunction)deparenthesizedExpression;
        }
        return null;
    }

    @Nullable
    public static KtCallableReferenceExpression getCallableReferenceExpressionIfAny(@NotNull KtExpression expression2, @NotNull CallResolutionContext<?> context) {
        KtExpression deparenthesizedExpression;
        if (expression2 == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(20);
        }
        if (context == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(21);
        }
        if ((deparenthesizedExpression = KtPsiUtil.getLastElementDeparenthesized(expression2, context.statementFilter)) instanceof KtCallableReferenceExpression) {
            return (KtCallableReferenceExpression)deparenthesizedExpression;
        }
        return null;
    }

    @NotNull
    public KotlinTypeInfo getArgumentTypeInfo(@Nullable KtExpression expression2, @NotNull CallResolutionContext<?> context, @NotNull ResolveArgumentsMode resolveArgumentsMode) {
        if (context == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(22);
        }
        if (resolveArgumentsMode == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(23);
        }
        if (expression2 == null) {
            KotlinTypeInfo kotlinTypeInfo = TypeInfoFactoryKt.noTypeInfo(context);
            if (kotlinTypeInfo == null) {
                ArgumentTypeResolver.$$$reportNull$$$0(24);
            }
            return kotlinTypeInfo;
        }
        KtFunction functionLiteralArgument = ArgumentTypeResolver.getFunctionLiteralArgumentIfAny(expression2, context);
        if (functionLiteralArgument != null) {
            KotlinTypeInfo kotlinTypeInfo = this.getFunctionLiteralTypeInfo(expression2, functionLiteralArgument, context, resolveArgumentsMode);
            if (kotlinTypeInfo == null) {
                ArgumentTypeResolver.$$$reportNull$$$0(25);
            }
            return kotlinTypeInfo;
        }
        KtCallableReferenceExpression callableReferenceExpression = ArgumentTypeResolver.getCallableReferenceExpressionIfAny(expression2, context);
        if (callableReferenceExpression != null) {
            KotlinTypeInfo kotlinTypeInfo = this.getCallableReferenceTypeInfo(expression2, callableReferenceExpression, context, resolveArgumentsMode);
            if (kotlinTypeInfo == null) {
                ArgumentTypeResolver.$$$reportNull$$$0(26);
            }
            return kotlinTypeInfo;
        }
        if (ArgumentTypeResolver.isCollectionLiteralInsideAnnotation(expression2, context)) {
            Object newContext = context.replaceContextDependency(ContextDependency.INDEPENDENT);
            KotlinTypeInfo kotlinTypeInfo = this.expressionTypingServices.getTypeInfo(expression2, (ResolutionContext)newContext);
            if (kotlinTypeInfo == null) {
                ArgumentTypeResolver.$$$reportNull$$$0(27);
            }
            return kotlinTypeInfo;
        }
        KotlinTypeInfo recordedTypeInfo = BindingContextUtils.getRecordedTypeInfo(expression2, context.trace.getBindingContext());
        if (recordedTypeInfo != null) {
            KotlinTypeInfo kotlinTypeInfo = recordedTypeInfo;
            if (kotlinTypeInfo == null) {
                ArgumentTypeResolver.$$$reportNull$$$0(28);
            }
            return kotlinTypeInfo;
        }
        Object newContext = ((CallResolutionContext)context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.DEPENDENT);
        KotlinTypeInfo kotlinTypeInfo = this.expressionTypingServices.getTypeInfo(expression2, (ResolutionContext)newContext);
        if (kotlinTypeInfo == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(29);
        }
        return kotlinTypeInfo;
    }

    @NotNull
    public KotlinTypeInfo getCallableReferenceTypeInfo(@NotNull KtExpression expression2, @NotNull KtCallableReferenceExpression callableReferenceExpression, @NotNull CallResolutionContext<?> context, @NotNull ResolveArgumentsMode resolveArgumentsMode) {
        if (expression2 == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(30);
        }
        if (callableReferenceExpression == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(31);
        }
        if (context == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(32);
        }
        if (resolveArgumentsMode == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(33);
        }
        if (resolveArgumentsMode == ResolveArgumentsMode.SHAPE_FUNCTION_ARGUMENTS) {
            KotlinType type2 = this.getShapeTypeOfCallableReference(callableReferenceExpression, context, true);
            KotlinTypeInfo kotlinTypeInfo = TypeInfoFactoryKt.createTypeInfo(type2);
            if (kotlinTypeInfo == null) {
                ArgumentTypeResolver.$$$reportNull$$$0(34);
            }
            return kotlinTypeInfo;
        }
        KotlinTypeInfo kotlinTypeInfo = this.expressionTypingServices.getTypeInfo(expression2, (ResolutionContext)context.replaceContextDependency(ContextDependency.INDEPENDENT));
        if (kotlinTypeInfo == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(35);
        }
        return kotlinTypeInfo;
    }

    @Nullable
    public KotlinType getShapeTypeOfCallableReference(@NotNull KtCallableReferenceExpression callableReferenceExpression, @NotNull CallResolutionContext<?> context, boolean expectedTypeIsUnknown) {
        if (callableReferenceExpression == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(36);
        }
        if (context == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(37);
        }
        Pair<DoubleColonLHS, OverloadResolutionResults<?>> pair = this.doubleColonExpressionResolver.resolveCallableReference(callableReferenceExpression, ExpressionTypingContext.newContext(context), ResolveArgumentsMode.SHAPE_FUNCTION_ARGUMENTS);
        DoubleColonLHS lhs = pair.getFirst();
        OverloadResolutionResults<?> overloadResolutionResults = pair.getSecond();
        if (overloadResolutionResults == null) {
            return null;
        }
        if (ArgumentTypeResolver.isSingleAndPossibleTransformToSuccess(overloadResolutionResults)) {
            ResolvedCall<?> resolvedCall2 = OverloadResolutionResultsUtil.getResultingCall(overloadResolutionResults, context.contextDependency);
            if (resolvedCall2 == null) {
                return null;
            }
            return DoubleColonExpressionResolver.Companion.createKCallableTypeForReference((CallableDescriptor)resolvedCall2.getResultingDescriptor(), lhs, this.reflectionTypes, context.scope.getOwnerDescriptor());
        }
        if (expectedTypeIsUnknown) {
            return this.functionPlaceholders.createFunctionPlaceholderType(Collections.emptyList(), false);
        }
        return FunctionTypesKt.createFunctionType(this.builtIns, Annotations.Companion.getEMPTY(), null, Collections.emptyList(), null, TypeUtils.DONT_CARE);
    }

    private static boolean isSingleAndPossibleTransformToSuccess(@NotNull OverloadResolutionResults<?> overloadResolutionResults) {
        if (overloadResolutionResults == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(38);
        }
        if (!overloadResolutionResults.isSingleResult()) {
            return false;
        }
        ResolvedCall<?> call2 = CollectionsKt.singleOrNull(overloadResolutionResults.getResultingCalls());
        return call2 != null && call2.getStatus().possibleTransformToSuccess();
    }

    @NotNull
    public KotlinTypeInfo getFunctionLiteralTypeInfo(@NotNull KtExpression expression2, @NotNull KtFunction functionLiteral, @NotNull CallResolutionContext<?> context, @NotNull ResolveArgumentsMode resolveArgumentsMode) {
        if (expression2 == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(39);
        }
        if (functionLiteral == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(40);
        }
        if (context == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(41);
        }
        if (resolveArgumentsMode == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(42);
        }
        if (resolveArgumentsMode == ResolveArgumentsMode.SHAPE_FUNCTION_ARGUMENTS) {
            KotlinType type2 = this.getShapeTypeOfFunctionLiteral(functionLiteral, context.scope, context.trace, true);
            KotlinTypeInfo kotlinTypeInfo = TypeInfoFactoryKt.createTypeInfo(type2, context);
            if (kotlinTypeInfo == null) {
                ArgumentTypeResolver.$$$reportNull$$$0(43);
            }
            return kotlinTypeInfo;
        }
        KotlinTypeInfo kotlinTypeInfo = this.expressionTypingServices.getTypeInfo(expression2, (ResolutionContext)context.replaceContextDependency(ContextDependency.INDEPENDENT));
        if (kotlinTypeInfo == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(44);
        }
        return kotlinTypeInfo;
    }

    @Nullable
    public KotlinType getShapeTypeOfFunctionLiteral(@NotNull KtFunction function2, @NotNull LexicalScope scope, @NotNull BindingTrace trace, boolean expectedTypeIsUnknown) {
        if (function2 == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(45);
        }
        if (scope == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(46);
        }
        if (trace == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(47);
        }
        boolean isFunctionLiteral = function2 instanceof KtFunctionLiteral;
        if (function2.getValueParameterList() == null && isFunctionLiteral) {
            return expectedTypeIsUnknown ? this.functionPlaceholders.createFunctionPlaceholderType(Collections.emptyList(), false) : FunctionTypesKt.createFunctionType(this.builtIns, Annotations.Companion.getEMPTY(), null, Collections.emptyList(), null, TypeUtils.DONT_CARE);
        }
        List<KtParameter> valueParameters = function2.getValueParameters();
        TemporaryBindingTrace temporaryTrace = TemporaryBindingTrace.create(trace, "trace to resolve function literal parameter types");
        ArrayList<KotlinType> parameterTypes = new ArrayList<KotlinType>(valueParameters.size());
        ArrayList<Name> parameterNames = new ArrayList<Name>(valueParameters.size());
        for (KtParameter parameter : valueParameters) {
            parameterTypes.add(this.resolveTypeRefWithDefault(parameter.getTypeReference(), scope, temporaryTrace, TypeUtils.DONT_CARE));
            Name name = parameter.getNameAsName();
            if (name == null) {
                name = SpecialNames.NO_NAME_PROVIDED;
            }
            parameterNames.add(name);
        }
        KotlinType returnType = this.resolveTypeRefWithDefault(function2.getTypeReference(), scope, temporaryTrace, TypeUtils.DONT_CARE);
        assert (returnType != null);
        KotlinType receiverType = this.resolveTypeRefWithDefault(function2.getReceiverTypeReference(), scope, temporaryTrace, null);
        return expectedTypeIsUnknown && isFunctionLiteral ? this.functionPlaceholders.createFunctionPlaceholderType(parameterTypes, true) : FunctionTypesKt.createFunctionType(this.builtIns, Annotations.Companion.getEMPTY(), receiverType, parameterTypes, parameterNames, returnType);
    }

    @Nullable
    public KotlinType resolveTypeRefWithDefault(@Nullable KtTypeReference returnTypeRef, @NotNull LexicalScope scope, @NotNull BindingTrace trace, @Nullable KotlinType defaultValue) {
        if (scope == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(48);
        }
        if (trace == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(49);
        }
        if (returnTypeRef != null) {
            return this.typeResolver.resolveType(scope, returnTypeRef, trace, true);
        }
        return defaultValue;
    }

    public void analyzeArgumentsAndRecordTypes(@NotNull CallResolutionContext<?> context, @NotNull ResolveArgumentsMode resolveArgumentsMode) {
        if (context == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(50);
        }
        if (resolveArgumentsMode == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(51);
        }
        MutableDataFlowInfoForArguments infoForArguments = context.dataFlowInfoForArguments;
        Call call2 = context.call;
        for (ValueArgument valueArgument : call2.getValueArguments()) {
            KtExpression expression2 = valueArgument.getArgumentExpression();
            if (expression2 == null || ArgumentTypeResolver.isCollectionLiteralInsideAnnotation(expression2, context)) continue;
            CallResolutionContext newContext = (CallResolutionContext)context.replaceDataFlowInfo(infoForArguments.getInfo(valueArgument));
            KotlinTypeInfo typeInfoForCall = this.getArgumentTypeInfo(expression2, newContext, resolveArgumentsMode);
            infoForArguments.updateInfo(valueArgument, typeInfoForCall.getDataFlowInfo());
        }
    }

    @Nullable
    public KotlinType updateResultArgumentTypeIfNotDenotable(@NotNull ResolutionContext context, @NotNull KtExpression expression2) {
        KotlinType type2;
        if (context == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(52);
        }
        if (expression2 == null) {
            ArgumentTypeResolver.$$$reportNull$$$0(53);
        }
        if ((type2 = context.trace.getType(expression2)) != null && !type2.getConstructor().isDenotable() && type2.getConstructor() instanceof IntegerValueTypeConstructor) {
            IntegerValueTypeConstructor constructor = (IntegerValueTypeConstructor)type2.getConstructor();
            KotlinType primitiveType = TypeUtils.getPrimitiveNumberType(constructor, context.expectedType);
            this.constantExpressionEvaluator.updateNumberType(primitiveType, expression2, context.statementFilter, context.trace);
            return primitiveType;
        }
        return null;
    }

    private static boolean isCollectionLiteralInsideAnnotation(KtExpression expression2, CallResolutionContext<?> context) {
        return expression2 instanceof KtCollectionLiteralExpression && context.call.getCallElement() instanceof KtAnnotationEntry;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 17: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 34: 
            case 35: 
            case 43: 
            case 44: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 17: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 34: 
            case 35: 
            case 43: 
            case 44: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeResolver";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doubleColonExpressionResolver";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builtIns";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reflectionTypes";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constantExpressionEvaluator";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionPlaceholders";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionTypingServices";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedType";
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 21: 
            case 22: 
            case 32: 
            case 37: 
            case 41: 
            case 50: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveFunctionArgumentBodies";
                break;
            }
            case 13: 
            case 15: 
            case 18: 
            case 20: 
            case 30: 
            case 39: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 17: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 34: 
            case 35: 
            case 43: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver";
                break;
            }
            case 23: 
            case 33: 
            case 42: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveArgumentsMode";
                break;
            }
            case 31: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callableReferenceExpression";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overloadResolutionResults";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionLiteral";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 46: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 47: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionLiteralArgument";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentTypeInfo";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getCallableReferenceTypeInfo";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionLiteralTypeInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setExpressionTypingServices";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isSubtypeOfForArgumentType";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkTypesWithNoCallee";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "checkTypesForFunctionArgumentsWithNoCallee";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isFunctionLiteralArgument";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionLiteralArgument";
                break;
            }
            case 17: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 34: 
            case 35: 
            case 43: 
            case 44: {
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionLiteralArgumentIfAny";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getCallableReferenceExpressionIfAny";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getArgumentTypeInfo";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getCallableReferenceTypeInfo";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getShapeTypeOfCallableReference";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isSingleAndPossibleTransformToSuccess";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionLiteralTypeInfo";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getShapeTypeOfFunctionLiteral";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "resolveTypeRefWithDefault";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "analyzeArgumentsAndRecordTypes";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "updateResultArgumentTypeIfNotDenotable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 17: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 34: 
            case 35: 
            case 43: 
            case 44: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

