/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.tool;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.processing.Processor;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.CompilationProgress;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.batch.ClasspathJsr199;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.batch.Main;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilationUnit;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblem;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.tool.EclipseFileManager;
import org.eclipse.jdt.internal.compiler.tool.EclipseFileObject;
import org.eclipse.jdt.internal.compiler.util.Messages;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;

public class EclipseCompilerImpl
extends Main {
    private static final CompilationUnit[] NO_UNITS = new CompilationUnit[0];
    private HashMap<CompilationUnit, JavaFileObject> javaFileObjectMap;
    Iterable<? extends JavaFileObject> compilationUnits;
    public JavaFileManager fileManager;
    protected Processor[] processors;
    public DiagnosticListener<? super JavaFileObject> diagnosticListener;

    public EclipseCompilerImpl(PrintWriter printWriter, PrintWriter printWriter2, boolean bl) {
        super(printWriter, printWriter2, bl, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean call() {
        try {
            if (this.proceed) {
                this.globalProblemsCount = 0;
                this.globalErrorsCount = 0;
                this.globalWarningsCount = 0;
                this.globalTasksCount = 0;
                this.exportedClassFilesCounter = 0;
                this.performCompilation();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.logger.logException(illegalArgumentException);
            if (this.systemExitWhenFinished) {
                this.cleanup();
                System.exit(-1);
            }
            boolean bl = false;
            return bl;
        }
        catch (RuntimeException runtimeException) {
            this.logger.logException(runtimeException);
            boolean bl = false;
            return bl;
        }
        finally {
            this.cleanup();
        }
        return this.globalErrorsCount == 0;
    }

    private void cleanup() {
        this.logger.flush();
        this.logger.close();
        this.processors = null;
        try {
            if (this.fileManager != null) {
                this.fileManager.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public CompilationUnit[] getCompilationUnits() {
        if (this.compilationUnits == null) {
            return NO_UNITS;
        }
        ArrayList<1> arrayList = new ArrayList<1>();
        for (final JavaFileObject javaFileObject : this.compilationUnits) {
            if (javaFileObject.getKind() != JavaFileObject.Kind.SOURCE) {
                throw new IllegalArgumentException();
            }
            String string = javaFileObject.getName();
            string = string.replace('\\', '/');
            CompilationUnit compilationUnit = new CompilationUnit(null, string, null){

                @Override
                public char[] getContents() {
                    try {
                        return javaFileObject.getCharContent(true).toString().toCharArray();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        throw new AbortCompilationUnit(null, iOException, null);
                    }
                }
            };
            arrayList.add(compilationUnit);
            this.javaFileObjectMap.put(compilationUnit, javaFileObject);
        }
        CompilationUnit[] compilationUnitArray = new CompilationUnit[arrayList.size()];
        arrayList.toArray(compilationUnitArray);
        return compilationUnitArray;
    }

    @Override
    public IErrorHandlingPolicy getHandlingPolicy() {
        return new IErrorHandlingPolicy(){

            @Override
            public boolean proceedOnErrors() {
                return false;
            }

            @Override
            public boolean stopOnFirstError() {
                return false;
            }

            @Override
            public boolean ignoreAllErrors() {
                return false;
            }
        };
    }

    @Override
    public IProblemFactory getProblemFactory() {
        return new DefaultProblemFactory(){

            @Override
            public CategorizedProblem createProblem(final char[] cArray, final int n, final String[] stringArray, String[] stringArray2, final int n2, final int n3, final int n4, final int n5, final int n6) {
                DiagnosticListener<? super JavaFileObject> diagnosticListener = EclipseCompilerImpl.this.diagnosticListener;
                if (diagnosticListener != null) {
                    diagnosticListener.report((Diagnostic<? super JavaFileObject>)new Diagnostic<JavaFileObject>(){

                        @Override
                        public String getCode() {
                            return Integer.toString(n);
                        }

                        @Override
                        public long getColumnNumber() {
                            return n6;
                        }

                        @Override
                        public long getEndPosition() {
                            return n4;
                        }

                        @Override
                        public Diagnostic.Kind getKind() {
                            if ((n2 & 1) != 0) {
                                return Diagnostic.Kind.ERROR;
                            }
                            if ((n2 & 0x20) != 0) {
                                return Diagnostic.Kind.WARNING;
                            }
                            if ((n2 & 0) != 0) {
                                return Diagnostic.Kind.MANDATORY_WARNING;
                            }
                            return Diagnostic.Kind.OTHER;
                        }

                        @Override
                        public long getLineNumber() {
                            return n5;
                        }

                        @Override
                        public String getMessage(Locale locale) {
                            if (locale != null) {
                                this.setLocale(locale);
                            }
                            return this.getLocalizedMessage(n, stringArray);
                        }

                        @Override
                        public long getPosition() {
                            return n3;
                        }

                        @Override
                        public JavaFileObject getSource() {
                            File file = new File(new String(cArray));
                            if (file.exists()) {
                                return new EclipseFileObject(null, file.toURI(), JavaFileObject.Kind.SOURCE, null);
                            }
                            return null;
                        }

                        @Override
                        public long getStartPosition() {
                            return n3;
                        }
                    });
                }
                return super.createProblem(cArray, n, stringArray, stringArray2, n2, n3, n4, n5, n6);
            }

            @Override
            public CategorizedProblem createProblem(final char[] cArray, final int n, final String[] stringArray, int n2, String[] stringArray2, final int n3, final int n4, final int n5, final int n6, final int n7) {
                DiagnosticListener<? super JavaFileObject> diagnosticListener = EclipseCompilerImpl.this.diagnosticListener;
                if (diagnosticListener != null) {
                    diagnosticListener.report((Diagnostic<? super JavaFileObject>)new Diagnostic<JavaFileObject>(){

                        @Override
                        public String getCode() {
                            return Integer.toString(n);
                        }

                        @Override
                        public long getColumnNumber() {
                            return n7;
                        }

                        @Override
                        public long getEndPosition() {
                            return n5;
                        }

                        @Override
                        public Diagnostic.Kind getKind() {
                            if ((n3 & 1) != 0) {
                                return Diagnostic.Kind.ERROR;
                            }
                            if ((n3 & 0x400) != 0) {
                                return Diagnostic.Kind.NOTE;
                            }
                            if ((n3 & 0x20) != 0) {
                                return Diagnostic.Kind.WARNING;
                            }
                            if ((n3 & 0) != 0) {
                                return Diagnostic.Kind.MANDATORY_WARNING;
                            }
                            return Diagnostic.Kind.OTHER;
                        }

                        @Override
                        public long getLineNumber() {
                            return n6;
                        }

                        @Override
                        public String getMessage(Locale locale) {
                            if (locale != null) {
                                this.setLocale(locale);
                            }
                            return this.getLocalizedMessage(n, stringArray);
                        }

                        @Override
                        public long getPosition() {
                            return n4;
                        }

                        @Override
                        public JavaFileObject getSource() {
                            File file = new File(new String(cArray));
                            if (file.exists()) {
                                return new EclipseFileObject(null, file.toURI(), JavaFileObject.Kind.SOURCE, null);
                            }
                            return null;
                        }

                        @Override
                        public long getStartPosition() {
                            return n4;
                        }
                    });
                }
                return super.createProblem(cArray, n, stringArray, n2, stringArray2, n3, n4, n5, n6, n7);
            }
        };
    }

    @Override
    protected void initialize(PrintWriter printWriter, PrintWriter printWriter2, boolean bl, Map<String, String> map, CompilationProgress compilationProgress) {
        super.initialize(printWriter, printWriter2, bl, map, compilationProgress);
        this.javaFileObjectMap = new HashMap();
    }

    @Override
    protected void initializeAnnotationProcessorManager() {
        super.initializeAnnotationProcessorManager();
        if (this.batchCompiler.annotationProcessorManager != null && this.processors != null) {
            this.batchCompiler.annotationProcessorManager.setProcessors(this.processors);
        } else if (this.processors != null) {
            throw new UnsupportedOperationException("Cannot handle annotation processing");
        }
    }

    @Override
    public void outputClassFiles(CompilationResult compilationResult) {
        if (compilationResult != null && (!compilationResult.hasErrors() || this.proceedOnError)) {
            ClassFile[] classFileArray = compilationResult.getClassFiles();
            boolean bl = this.fileManager.hasLocation(StandardLocation.CLASS_OUTPUT);
            String string = this.destinationPath;
            File file = null;
            if (string != null) {
                file = new File(string);
                file.mkdirs();
            }
            int n = classFileArray.length;
            for (int i = 0; i < n; ++i) {
                ClassFile classFile = classFileArray[i];
                char[] cArray = classFile.fileName();
                int n2 = cArray.length;
                char[] cArray2 = new char[n2 + 6];
                System.arraycopy(cArray, 0, cArray2, 0, n2);
                System.arraycopy(SuffixConstants.SUFFIX_class, 0, cArray2, n2, 6);
                CharOperation.replace(cArray2, '/', File.separatorChar);
                String string2 = new String(cArray2);
                if (this.compilerOptions.verbose) {
                    this.out.println(Messages.bind(Messages.compilation_write, new String[]{String.valueOf(this.exportedClassFilesCounter + 1), string2}));
                }
                try {
                    Object object;
                    Object object2;
                    Serializable serializable;
                    JavaFileObject javaFileObject = this.fileManager.getJavaFileForOutput(StandardLocation.CLASS_OUTPUT, new String(cArray), JavaFileObject.Kind.CLASS, this.javaFileObjectMap.get(compilationResult.compilationUnit));
                    if (bl) {
                        if (string != null) {
                            int n3 = CharOperation.lastIndexOf(File.separatorChar, cArray2);
                            if (n3 != -1) {
                                serializable = new File(string, string2.substring(0, n3));
                                ((File)serializable).mkdirs();
                            }
                        } else {
                            object2 = javaFileObject.toUri().getPath();
                            int n4 = ((String)object2).lastIndexOf(47);
                            if (n4 != -1) {
                                object = new File(((String)object2).substring(0, n4));
                                ((File)object).mkdirs();
                            }
                        }
                    }
                    object2 = javaFileObject.openOutputStream();
                    serializable = null;
                    try {
                        object = new BufferedOutputStream((OutputStream)object2);
                        Throwable throwable = null;
                        try {
                            ((BufferedOutputStream)object).write(classFile.header, 0, classFile.headerOffset);
                            ((BufferedOutputStream)object).write(classFile.contents, 0, classFile.contentsOffset);
                            ((BufferedOutputStream)object).flush();
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (object != null) {
                                if (throwable != null) {
                                    try {
                                        ((FilterOutputStream)object).close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                } else {
                                    ((FilterOutputStream)object).close();
                                }
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        serializable = throwable;
                        throw throwable;
                    }
                    finally {
                        if (object2 != null) {
                            if (serializable != null) {
                                try {
                                    ((OutputStream)object2).close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)serializable).addSuppressed(throwable);
                                }
                            } else {
                                ((OutputStream)object2).close();
                            }
                        }
                    }
                }
                catch (IOException iOException) {
                    this.logger.logNoClassFileCreated(string, string2, iOException);
                }
                this.logger.logClassFile(bl, string, string2);
                ++this.exportedClassFilesCounter;
            }
            this.batchCompiler.lookupEnvironment.releaseClassFiles(classFileArray);
        }
    }

    @Override
    protected void setPaths(ArrayList arrayList, String string, ArrayList arrayList2, ArrayList arrayList3, ArrayList arrayList4, ArrayList arrayList5, String string2) {
        int n;
        Object object;
        Object object2;
        ArrayList arrayList6 = new ArrayList();
        EclipseFileManager eclipseFileManager = null;
        StandardJavaFileManager standardJavaFileManager = null;
        JavaFileManager javaFileManager = null;
        boolean bl = false;
        boolean bl2 = false;
        if (this.fileManager instanceof EclipseFileManager) {
            eclipseFileManager = (EclipseFileManager)this.fileManager;
        }
        if (this.fileManager instanceof StandardJavaFileManager) {
            standardJavaFileManager = (StandardJavaFileManager)this.fileManager;
        }
        javaFileManager = this.fileManager;
        if (eclipseFileManager != null && (eclipseFileManager.flags & 4) == 0 && (eclipseFileManager.flags & 2) != 0) {
            arrayList6.addAll(this.handleEndorseddirs(null));
        }
        Iterable<? extends File> iterable = null;
        if (standardJavaFileManager != null) {
            iterable = standardJavaFileManager.getLocation(StandardLocation.PLATFORM_CLASS_PATH);
            if (iterable != null) {
                for (File file : iterable) {
                    object2 = FileSystem.getClasspath(file.getAbsolutePath(), null, null, this.options);
                    if (object2 == null) continue;
                    arrayList6.add(object2);
                    bl = true;
                }
            }
        } else if (javaFileManager != null) {
            object = new ClasspathJsr199(this.fileManager, StandardLocation.PLATFORM_CLASS_PATH);
            arrayList6.add(object);
            bl = true;
        }
        if (eclipseFileManager != null && (eclipseFileManager.flags & 1) == 0 && (eclipseFileManager.flags & 2) != 0) {
            arrayList6.addAll(this.handleExtdirs(null));
        }
        if (standardJavaFileManager != null) {
            iterable = standardJavaFileManager.getLocation(StandardLocation.SOURCE_PATH);
            if (iterable != null) {
                for (File file : iterable) {
                    object2 = FileSystem.getClasspath(file.getAbsolutePath(), null, null, this.options);
                    if (object2 == null) continue;
                    arrayList6.add(object2);
                }
            }
            if ((iterable = standardJavaFileManager.getLocation(StandardLocation.CLASS_PATH)) != null) {
                for (File file : iterable) {
                    object2 = FileSystem.getClasspath(file.getAbsolutePath(), null, null, this.options);
                    if (object2 == null) continue;
                    arrayList6.add(object2);
                    bl2 = true;
                }
            }
        } else if (javaFileManager != null) {
            object = null;
            if (this.fileManager.hasLocation(StandardLocation.SOURCE_PATH)) {
                object = new ClasspathJsr199(this.fileManager, StandardLocation.SOURCE_PATH);
                arrayList6.add(object);
            }
            object = new ClasspathJsr199(this.fileManager, StandardLocation.CLASS_PATH);
            arrayList6.add(object);
            bl2 = true;
        }
        if (this.checkedClasspaths == null) {
            if (!bl) {
                arrayList6.addAll(this.handleBootclasspath(null, null));
            }
            if (!bl2) {
                arrayList6.addAll(this.handleClasspath(null, null));
            }
        }
        if ((n = (arrayList6 = FileSystem.ClasspathNormalizer.normalize(arrayList6)).size()) != 0) {
            this.checkedClasspaths = new FileSystem.Classpath[n];
            boolean bl3 = false;
            for (FileSystem.Classpath classpath : arrayList6) {
                this.checkedClasspaths[++var16_23] = classpath;
            }
        }
    }

    @Override
    protected void loggingExtraProblems() {
        super.loggingExtraProblems();
        for (final CategorizedProblem categorizedProblem : this.extraProblems) {
            if (this.diagnosticListener == null) continue;
            this.diagnosticListener.report((Diagnostic<? super JavaFileObject>)new Diagnostic<JavaFileObject>(){

                @Override
                public String getCode() {
                    return null;
                }

                @Override
                public long getColumnNumber() {
                    if (categorizedProblem instanceof DefaultProblem) {
                        return ((DefaultProblem)categorizedProblem).column;
                    }
                    return -1L;
                }

                @Override
                public long getEndPosition() {
                    if (categorizedProblem instanceof DefaultProblem) {
                        return ((DefaultProblem)categorizedProblem).getSourceEnd();
                    }
                    return -1L;
                }

                @Override
                public Diagnostic.Kind getKind() {
                    if (categorizedProblem.isError()) {
                        return Diagnostic.Kind.ERROR;
                    }
                    if (categorizedProblem.isWarning()) {
                        return Diagnostic.Kind.WARNING;
                    }
                    if (categorizedProblem instanceof DefaultProblem && ((DefaultProblem)categorizedProblem).isInfo()) {
                        return Diagnostic.Kind.NOTE;
                    }
                    return Diagnostic.Kind.OTHER;
                }

                @Override
                public long getLineNumber() {
                    if (categorizedProblem instanceof DefaultProblem) {
                        return ((DefaultProblem)categorizedProblem).getSourceLineNumber();
                    }
                    return -1L;
                }

                @Override
                public String getMessage(Locale locale) {
                    return categorizedProblem.getMessage();
                }

                @Override
                public long getPosition() {
                    if (categorizedProblem instanceof DefaultProblem) {
                        return ((DefaultProblem)categorizedProblem).getSourceStart();
                    }
                    return -1L;
                }

                @Override
                public JavaFileObject getSource() {
                    if (categorizedProblem instanceof DefaultProblem) {
                        File file = new File(new String(((DefaultProblem)categorizedProblem).getOriginatingFileName()));
                        if (file.exists()) {
                            Charset charset = EclipseCompilerImpl.this.fileManager instanceof EclipseFileManager ? ((EclipseFileManager)EclipseCompilerImpl.this.fileManager).charset : Charset.defaultCharset();
                            return new EclipseFileObject(null, file.toURI(), JavaFileObject.Kind.SOURCE, charset);
                        }
                        return null;
                    }
                    return null;
                }

                @Override
                public long getStartPosition() {
                    return this.getPosition();
                }
            });
        }
    }
}

