/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.model.types;

import java.beans.PropertyDescriptor;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.FetchType;
import org.grails.datastore.mapping.config.Property;
import org.grails.datastore.mapping.model.AbstractPersistentProperty;
import org.grails.datastore.mapping.model.IllegalMappingException;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.model.types.Basic;
import org.grails.datastore.mapping.model.types.Embedded;
import org.grails.datastore.mapping.model.types.EmbeddedCollection;
import org.grails.datastore.mapping.model.types.ManyToOne;

public abstract class Association<T extends Property>
extends AbstractPersistentProperty<T> {
    private static final Set<CascadeType> DEFAULT_OWNER_CASCADE = Collections.unmodifiableSet(new HashSet<CascadeType>(Collections.singletonList(CascadeType.ALL)));
    private static final Set<CascadeType> DEFAULT_CHILD_CASCADE = Collections.unmodifiableSet(new HashSet<CascadeType>(Collections.singletonList(CascadeType.PERSIST)));
    private PersistentEntity associatedEntity;
    private String referencedPropertyName;
    private boolean owningSide;
    private Set<CascadeType> cascadeOperations;
    private static final Map<String, CascadeType> cascadeTypeConversions = new LinkedHashMap<String, CascadeType>();

    public Association(PersistentEntity owner, MappingContext context, PropertyDescriptor descriptor) {
        super(owner, context, descriptor);
    }

    public Association(PersistentEntity owner, MappingContext context, String name, Class type) {
        super(owner, context, name, type);
    }

    private void buildCascadeOperations() {
        String cascade = ((Property)this.getMapping().getMappedForm()).getCascade();
        if (cascade != null) {
            String[] specifiedOperations = cascade.toLowerCase().split(",");
            this.cascadeOperations = new HashSet<CascadeType>();
            for (String operation : specifiedOperations) {
                String key = operation.trim();
                if (!cascadeTypeConversions.containsKey(key)) continue;
                this.cascadeOperations.add(cascadeTypeConversions.get(key));
            }
            this.cascadeOperations = Collections.unmodifiableSet(this.cascadeOperations);
        } else {
            this.cascadeOperations = this.isOwningSide() ? DEFAULT_OWNER_CASCADE : (this instanceof ManyToOne && this.isBidirectional() ? Collections.emptySet() : DEFAULT_CHILD_CASCADE);
        }
    }

    public FetchType getFetchStrategy() {
        return ((Property)this.getMapping().getMappedForm()).getFetchStrategy();
    }

    public boolean isBidirectional() {
        return this.associatedEntity != null && this.referencedPropertyName != null;
    }

    public Association getInverseSide() {
        PersistentProperty associatedProperty = this.associatedEntity.getPropertyByName(this.referencedPropertyName);
        if (associatedProperty == null) {
            return null;
        }
        if (associatedProperty instanceof Association) {
            return (Association)associatedProperty;
        }
        throw new IllegalMappingException("The inverse side [" + this.associatedEntity.getName() + "." + associatedProperty.getName() + "] of the association [" + this.getOwner().getName() + "." + this.getName() + "] is not valid. Associations can only map to other entities and collection types.");
    }

    public boolean doesCascade(CascadeType cascadeOperation) {
        return this.doesCascade(new CascadeType[]{cascadeOperation});
    }

    public boolean doesCascade(CascadeType ... cascadeOperations) {
        Set<CascadeType> cascades = this.getCascadeOperations();
        if (cascades.contains(CascadeType.ALL)) {
            return true;
        }
        if (cascadeOperations != null) {
            for (CascadeType cascadeOperation : cascadeOperations) {
                if (!cascades.contains(cascadeOperation)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isEmbedded() {
        return this instanceof Embedded || this instanceof EmbeddedCollection;
    }

    public boolean isBasic() {
        return this instanceof Basic;
    }

    protected Set<CascadeType> getCascadeOperations() {
        if (this.cascadeOperations == null) {
            this.buildCascadeOperations();
        }
        return this.cascadeOperations;
    }

    public boolean isOwningSide() {
        return this.owningSide;
    }

    public void setOwningSide(boolean owningSide) {
        this.owningSide = owningSide;
    }

    public void setAssociatedEntity(PersistentEntity associatedEntity) {
        this.associatedEntity = associatedEntity;
    }

    public PersistentEntity getAssociatedEntity() {
        return this.associatedEntity;
    }

    public void setReferencedPropertyName(String referencedPropertyName) {
        this.referencedPropertyName = referencedPropertyName;
    }

    public String getReferencedPropertyName() {
        return this.referencedPropertyName;
    }

    @Override
    public String toString() {
        return this.getOwner().getName() + "->" + this.getName();
    }

    public boolean isList() {
        return List.class.isAssignableFrom(this.getType());
    }

    public boolean isCircular() {
        PersistentEntity associatedEntity = this.getAssociatedEntity();
        if (associatedEntity == null) {
            return false;
        }
        return associatedEntity.getJavaClass().isAssignableFrom(this.owner.getJavaClass());
    }

    static {
        cascadeTypeConversions.put("all", CascadeType.ALL);
        cascadeTypeConversions.put("merge", CascadeType.MERGE);
        cascadeTypeConversions.put("save-update", CascadeType.PERSIST);
        cascadeTypeConversions.put("delete", CascadeType.REMOVE);
        cascadeTypeConversions.put("remove", CascadeType.REMOVE);
        cascadeTypeConversions.put("refresh", CascadeType.REFRESH);
        cascadeTypeConversions.put("persist", CascadeType.PERSIST);
    }
}

