#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: texmath
version: 0.9.4.4
id: texmath-0.9.4.4-6yl75GPsoBcJIx3V5ZF4yj
key: texmath-0.9.4.4-6yl75GPsoBcJIx3V5ZF4yj
license: GPL
maintainer: jgm@berkeley.edu
stability: Experimental
homepage: http://github.com/jgm/texmath
synopsis: Conversion between formats used to represent mathematics.
description:
    The texmath library provides functions to read and
    write TeX math, presentation MathML, and OMML (Office
    Math Markup Language, used in Microsoft Office).
    Support is also included for converting math formats
    to Gnu eqn and to pandoc'\''s native format (allowing
    conversion, via pandoc, to a variety of different
    markup formats).  The TeX reader supports basic LaTeX
    and AMS extensions, and it can parse and apply LaTeX
    macros.  (See <http://johnmacfarlane.net/texmath here>
    for a live demo of bidirectional conversion between LaTeX
    and MathML.)
    .
    The package also includes several utility modules which
    may be useful for anyone looking to manipulate either
    TeX math or MathML.  For example, a copy of the MathML
    operator dictionary is included.
    .
    Use the @executable@ flag to install a standalone
    executable, @texmath@, that by default reads a LaTeX
    formula from @stdin@ and writes MathML to @stdout@.
    With flags all the functionality exposed by
    '\''Text.TeXMath'\'' can be accessed through this executable.
    (Use the @--help@ flag for a description of all
    functionality)
    .
    The @texmath@ executable can also be used as a CGI
    script, when renamed as @texmath-cgi@.
    It will expect query parameters for @from@, @to@,
    @input@, and optionally @inline@, and return a JSON
    object with either @error@ and a message or
    @success@ and the converted result.
category: Text
author: John MacFarlane, Matthew Pickering
exposed: True
indefinite: False
exposed-modules:
    Text.TeXMath Text.TeXMath.Readers.MathML
    Text.TeXMath.Readers.MathML.EntityMap
    Text.TeXMath.Readers.MathML.MMLDict Text.TeXMath.Readers.OMML
    Text.TeXMath.Readers.TeX Text.TeXMath.Readers.TeX.Macros
    Text.TeXMath.Types Text.TeXMath.Unicode.Fonts
    Text.TeXMath.Unicode.ToASCII Text.TeXMath.Unicode.ToTeX
    Text.TeXMath.Unicode.ToUnicode Text.TeXMath.Writers.Eqn
    Text.TeXMath.Writers.MathML Text.TeXMath.Writers.OMML
    Text.TeXMath.Writers.Pandoc Text.TeXMath.Writers.TeX
hidden-modules: Text.TeXMath.Compat Text.TeXMath.Shared
                Text.TeXMath.TeX Paths_texmath
abi: a69aa9f68c78b26d6af5f088f8ff135e
trusted: False
import-dirs: /usr/lib/ghc-8.2.1/site-local/texmath-0.9.4.4
library-dirs: /usr/lib/ghc-8.2.1/site-local/texmath-0.9.4.4
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.1/texmath-0.9.4.4
hs-libraries: HStexmath-0.9.4.4-6yl75GPsoBcJIx3V5ZF4yj
depends:
    xml-1.3.14-5OPJvPT6yGP6QU1NbG18WH
    parsec-3.1.11-5WCVqUZr6ypLPXtYWYsMnh containers-0.5.10.2
    pandoc-types-1.17.2-74RToetYY2CLkQY2JumQyV
    mtl-2.2.1-19EL8AGBsN3DnnOhrC9xY3 base-4.10.0.0
    syb-0.7-2rRPTNxBP6YFePrCXw4i2o
abi-depends: xml-1.3.14-5OPJvPT6yGP6QU1NbG18WH=0fb3db3aece5460bbed64ec858b0682d
             parsec-3.1.11-5WCVqUZr6ypLPXtYWYsMnh=ec025cd9e2938e26fbdb8853642eb58e
             containers-0.5.10.2=e086202b65ca66a107fcba9d846fc3e0
             pandoc-types-1.17.2-74RToetYY2CLkQY2JumQyV=08f0be76fa0f38c2b8093991bde61962
             mtl-2.2.1-19EL8AGBsN3DnnOhrC9xY3=5531911f09693672654e6de645ce55e7
             base-4.10.0.0=32d562aa6d04d35ac79a0f49c17325ff
             syb-0.7-2rRPTNxBP6YFePrCXw4i2o=119e2c6ac6f570dd5e30835fe9c8c288
haddock-interfaces: /usr/share/doc/haskell-texmath/html/texmath.haddock
haddock-html: /usr/share/doc/haskell-texmath/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

