/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.umleditor.objectcatalog;

import ch.ehi.basics.i18n.MessageFormat;
import ch.ehi.basics.i18n.ResourceBundle;
import ch.ehi.basics.io.IndentPrintWriter;
import ch.ehi.basics.types.NlsString;
import ch.ehi.interlis.associations.AssociationDef;
import ch.ehi.interlis.associations.RoleDef;
import ch.ehi.interlis.attributes.AttributeDef;
import ch.ehi.interlis.attributes.DomainAttribute;
import ch.ehi.interlis.domainsandconstants.DomainDef;
import ch.ehi.interlis.domainsandconstants.Type;
import ch.ehi.interlis.domainsandconstants.basetypes.BooleanType;
import ch.ehi.interlis.domainsandconstants.basetypes.CoordinateType;
import ch.ehi.interlis.domainsandconstants.basetypes.EnumElement;
import ch.ehi.interlis.domainsandconstants.basetypes.Enumeration;
import ch.ehi.interlis.domainsandconstants.basetypes.HorizAlignment;
import ch.ehi.interlis.domainsandconstants.basetypes.NumericType;
import ch.ehi.interlis.domainsandconstants.basetypes.NumericalType;
import ch.ehi.interlis.domainsandconstants.basetypes.Text;
import ch.ehi.interlis.domainsandconstants.basetypes.VertAlignment;
import ch.ehi.interlis.domainsandconstants.linetypes.IliPolyline;
import ch.ehi.interlis.domainsandconstants.linetypes.IndividualSurface;
import ch.ehi.interlis.domainsandconstants.linetypes.Tesselation;
import ch.ehi.uml1_4.foundation.core.Artifact;
import ch.ehi.uml1_4.foundation.core.Association;
import ch.ehi.uml1_4.foundation.core.AssociationEnd;
import ch.ehi.uml1_4.foundation.core.Attribute;
import ch.ehi.uml1_4.foundation.core.Class;
import ch.ehi.uml1_4.foundation.core.Classifier;
import ch.ehi.uml1_4.foundation.core.ModelElement;
import ch.ehi.uml1_4.foundation.core.Namespace;
import ch.ehi.uml1_4.foundation.datatypes.Multiplicity;
import ch.ehi.uml1_4.foundation.datatypes.MultiplicityRange;
import ch.ehi.uml1_4.implementation.UmlModel;
import ch.ehi.uml1_4.modelmanagement.Package;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

public class HtmlWriter {
    static java.util.ResourceBundle rsrc = ResourceBundle.getBundle(HtmlWriter.class);
    private boolean linkElements;
    private IndentPrintWriter clsFile = null;
    private Writer out = null;
    private HashMap indexMap = new HashMap();
    private SortedMap sortedMap = new TreeMap();
    int numeration = 0;
    int iddP;
    double level = 0.0;
    int pass;
    String b = " ";
    double textIdent = 0.5;
    private static final int CONTENTS = 1;
    private static final int STRUCTURE = 2;
    private static final int BODY = 3;
    private static final int INDEX = 4;
    private static String nl = null;
    private boolean suppressChNr = false;

    public void doObjectCatalog(Namespace apackage, Writer out) throws IOException {
        this.out = out;
        this.linkElements = true;
        out.write("<HTML>");
        this.newline();
        out.write("<HEAD>");
        this.newline();
        out.write("<TITLE>" + this.formatText("CTobjcatTitle", HtmlWriter.encodeString(apackage.getDefLangName())) + "</TITLE>");
        this.newline();
        out.write("<STYLE TYPE='text/css'>A {text-decoration: none }TD{border-bottom: solid black; border-bottom-width: 1px}</STYLE>");
        out.write("</HEAD>");
        this.newline();
        out.write("<body link=\"#000000\" vlink=\"#000000\" alink=\"#000000\">");
        this.newline();
        this.pass = 1;
        this.walkTree(apackage);
        this.pass = 2;
        this.walkTree(apackage);
        this.pass = 3;
        this.walkTree(apackage);
        this.pass = 4;
        this.walkTree(apackage);
        out.write("</BODY>");
        this.newline();
        out.write("</HTML>");
        this.newline();
    }

    public void visitPackage(Namespace apackage) throws IOException {
        int[] objNumerationId;
        Object obj;
        ++this.numeration;
        String defLangName = HtmlWriter.encodeString(apackage.getDefLangName());
        String aName = this.numeration + "_" + defLangName;
        String value = this.suppressChNr ? defLangName : this.numeration + " " + defLangName;
        if (this.pass == 1) {
            int[] sectionNumbers = new int[]{this.numeration};
            this.indexMap.put(apackage, sectionNumbers);
        }
        String concatedValue = "";
        String aNameStructure = "";
        if (this.linkElements) {
            int[] numerationId = (int[])this.indexMap.get(apackage);
            concatedValue = this.suppressChNr ? defLangName : Integer.toString(numerationId[0]) + " " + defLangName;
            aNameStructure = Integer.toString(numerationId[0]) + "_" + defLangName;
        } else {
            concatedValue = defLangName;
        }
        if (this.pass == 2) {
            if (this.linkElements) {
                this.out.write("<p style=\"text-indent:" + Double.toString(this.level) + "cm; line-height: 15%; margin-left: 0\"><a href=\"#" + aNameStructure + "\">" + concatedValue + "</a></p>");
                this.newline();
            } else {
                this.out.write("<p style=\"text-indent:" + Double.toString(this.level) + "cm; line-height: 15%; margin-left: 0\">" + concatedValue + "</p>");
                this.newline();
            }
        }
        if (this.pass == 1) {
            this.out.write("<p style=\"text-indent: 0; line-height: 15%; margin-left: 0\"><a href=\"#" + aName + "\">" + value + "</a></p>");
            this.newline();
        }
        if (this.pass == 3) {
            this.out.write("<H1><a name=\"" + aName + "\">" + value + "</a></H1>");
            this.newline();
            if (apackage instanceof UmlModel) {
                UmlModel model = (UmlModel)apackage;
                String author = HtmlWriter.encodeDescription(model.getAuthor());
                String version = HtmlWriter.encodeString(model.getVersion());
                this.out.write("<table border=\"0\">");
                this.out.write("<tr>");
                this.newline();
                this.out.write("<td style=\"border-bottom: none\"><i>" + rsrc.getString("CTauthor") + "</i></td>");
                this.newline();
                this.out.write("<td style=\"border-bottom: none\"><font face=\"Arial\" size=\"3\">" + author + "</font></td>");
                this.newline();
                this.out.write("</tr>");
                this.newline();
                this.out.write("<tr>");
                this.newline();
                this.out.write("<td style=\"border-bottom: none\"><i>" + rsrc.getString("CTversion") + "</i></td>");
                this.newline();
                this.out.write("<td style=\"border-bottom: none\"><font face=\"Arial\" size=\"3\">" + version + "</font></td>");
                this.newline();
                this.out.write("</tr>");
                this.newline();
                this.out.write("</table>");
            }
            String documentation = HtmlWriter.encodeDescription(HtmlWriter.mapNlsString(apackage.getDocumentation()));
            this.out.write(documentation);
            this.newline();
        }
        Iterator classi = apackage.iteratorOwnedElement();
        ArrayList elev = new ArrayList();
        while (classi.hasNext()) {
            Object obj2 = classi.next();
            if (!(obj2 instanceof Package) && !(obj2 instanceof Artifact) || ((ModelElement)obj2).getDefLangName().startsWith("<")) continue;
            elev.add(obj2);
        }
        Collections.sort(elev, new CompareByName());
        classi = elev.iterator();
        boolean hasHeader = false;
        this.iddP = 1;
        while (classi.hasNext()) {
            obj = classi.next();
            if (!hasHeader) {
                String aNamePackage = this.numeration + "." + this.iddP + "_Packages";
                int[] packageSectionNo = new int[]{this.numeration, this.iddP};
                this.indexMap.put("Pakete", packageSectionNo);
                if (this.pass == 3) {
                    if (this.suppressChNr) {
                        this.out.write("<H2><a name=\"" + aNamePackage + "\">" + rsrc.getString("CTpackages") + "</a></H2>");
                        this.newline();
                    } else {
                        this.out.write("<H2><a name=\"" + aNamePackage + "\">" + this.numeration + "." + this.iddP + " " + rsrc.getString("CTpackages") + "</a></H2>");
                        this.newline();
                    }
                    this.out.write("<UL>");
                    this.newline();
                }
                if (this.pass == 1) {
                    if (this.suppressChNr) {
                        this.out.write("<p style=\"text-indent: 0; line-height: 15%; margin-left: 0\"><a href=\"#" + aNamePackage + "\">" + rsrc.getString("CTpackages") + "</a></p>");
                        this.newline();
                    } else {
                        this.out.write("<p style=\"text-indent: 0; line-height: 15%; margin-left: 0\"><a href=\"#" + aNamePackage + "\">" + this.numeration + "." + this.iddP + " " + rsrc.getString("CTpackages") + "</a></p>");
                        this.newline();
                    }
                }
                hasHeader = true;
                ++this.iddP;
            }
            String defLangModelElement = HtmlWriter.encodeString(((ModelElement)obj).getDefLangName());
            if (this.pass != 3) continue;
            objNumerationId = (int[])this.indexMap.get(obj);
            this.out.write("<LI><a href=\"#" + objNumerationId[0] + "_" + defLangModelElement + "\">" + defLangModelElement + "</a></LI>");
            this.newline();
        }
        if (hasHeader && this.pass == 3) {
            this.out.write("</UL>");
            this.newline();
        }
        elev.clear();
        classi = apackage.iteratorOwnedElement();
        while (classi.hasNext()) {
            obj = classi.next();
            if (!(!(obj instanceof Class) || obj instanceof AssociationDef && (((AssociationDef)obj).isStructureAttribute() || ((AssociationDef)obj).isReferenceAttribute()) || obj instanceof AssociationDef && ((AssociationDef)obj).sizeConnection() == 2 && ((AssociationDef)obj).sizeFeature() == 0)) {
                elev.add(obj);
                continue;
            }
            if (!this.isEnumDomainDef(obj)) continue;
            elev.add(obj);
        }
        Collections.sort(elev, new CompareByName());
        classi = elev.iterator();
        hasHeader = false;
        while (classi.hasNext()) {
            obj = classi.next();
            if (!hasHeader) {
                if (this.pass == 3) {
                    if (this.suppressChNr) {
                        this.out.write("<H2><a name=\"" + this.numeration + "." + this.iddP + "\">" + rsrc.getString("CTclasses") + "</a></H2>");
                        this.newline();
                    } else {
                        this.out.write("<H2><a name=\"" + this.numeration + "." + this.iddP + "\">" + this.numeration + "." + this.iddP + " " + rsrc.getString("CTclasses") + "</a></H2>");
                        this.newline();
                    }
                    this.out.write("<UL>");
                    this.newline();
                }
                if (this.pass == 1) {
                    int[] classesSectionNo = new int[]{this.numeration, this.iddP};
                    this.indexMap.put("Klassen", classesSectionNo);
                    if (this.suppressChNr) {
                        this.out.write("<p style=\"text-indent: 0; line-height: 15%; margin-left: 0\"><a href=\"#" + this.numeration + "." + this.iddP + "\">" + rsrc.getString("CTclasses") + "</a></p>");
                        this.newline();
                    } else {
                        this.out.write("<p style=\"text-indent: 0; line-height: 15%; margin-left: 0\"><a href=\"#" + this.numeration + "." + this.iddP + "\">" + this.numeration + "." + this.iddP + " " + rsrc.getString("CTclasses") + "</a></p>");
                        this.newline();
                    }
                }
                hasHeader = true;
                ++this.iddP;
            }
            String defLangClass = HtmlWriter.encodeString(((Classifier)obj).getDefLangName());
            if (this.pass != 3) continue;
            objNumerationId = (int[])this.indexMap.get(obj);
            this.out.write("<LI><a href=\"#" + objNumerationId[0] + "." + objNumerationId[1] + "_" + defLangClass + "\">" + defLangClass + "</a></LI>");
            this.newline();
        }
        if (hasHeader && this.pass == 3) {
            this.out.write("</UL>");
            this.newline();
        }
    }

    public void visitClass(Class aclass) throws IOException {
        if (aclass instanceof AssociationDef && (((AssociationDef)aclass).isStructureAttribute() || ((AssociationDef)aclass).isReferenceAttribute())) {
            return;
        }
        if (aclass instanceof Association && ((Association)((Object)aclass)).sizeConnection() == 2 && aclass.sizeFeature() == 0) {
            return;
        }
        String classDefName = HtmlWriter.encodeString(aclass.getDefLangName());
        if (this.pass == 1) {
            int[] sectionNumbers = new int[]{this.numeration, this.iddP};
            this.indexMap.put(aclass, sectionNumbers);
        }
        String value = "";
        String aName = "";
        if (this.linkElements) {
            int[] numerationId = (int[])this.indexMap.get(aclass);
            String numeration = Integer.toString(numerationId[0]) + "." + Integer.toString(numerationId[1]);
            aName = numeration + "_" + classDefName;
            value = this.suppressChNr ? classDefName : numeration + " " + classDefName;
        } else {
            value = classDefName;
        }
        if (this.pass == 3) {
            this.out.write("<H2><a name=\"" + aName + "\">" + value + "</a></H2>");
            this.newline();
            if (this.clsFile != null) {
                this.clsFile.println(aclass.getDefLangName());
            }
        }
        if (this.pass == 1) {
            this.out.write("<p style=\"text-indent: 0; line-height: 15%; margin-left: 0\"><a href=\"#" + aName + "\">" + value + "</a></P>");
            this.newline();
        }
        if (this.pass == 2) {
            if (this.linkElements) {
                this.out.write("<p style=\"text-indent:" + Double.toString(this.level) + "cm; line-height: 15%; margin-left: 0\"><a href=\"#" + aName + "\">" + value + "</a></p>");
                this.newline();
            } else {
                this.out.write("<p style=\"text-indent:" + Double.toString(this.level) + "cm; line-height: 15%; margin-left: 0\">" + value + "</p>");
                this.newline();
            }
        }
        ++this.iddP;
        if (this.pass == 3) {
            this.out.write(HtmlWriter.encodeDescription(HtmlWriter.mapNlsString(aclass.getDocumentation())));
            this.newline();
            if (aclass.iteratorFeature().hasNext() || aclass.iteratorAssociation().hasNext() || aclass instanceof Association && ((Association)((Object)aclass)).iteratorConnection().hasNext()) {
                Object obj2;
                this.out.write("<TABLE border=\"0\" frame=hsides roles=rows cellspacing=\"0\" cellpadding=\"5\" height=\"1\">");
                this.newline();
                this.out.write("<COL>");
                this.newline();
                this.out.write("<COL>");
                this.newline();
                this.out.write("<COL>");
                this.newline();
                this.out.write("<COL>");
                this.newline();
                this.out.write("<TR><TD width=\"85\" bgcolor=\"#C0C0C0\" align=\"left\"><font face=\"Arial\">" + rsrc.getString("CTtabName") + "</font></TD>");
                this.newline();
                this.out.write("<TD width=\"125\" bgcolor=\"#C0C0C0\" align=\"left\"><font face=\"Arial\">" + rsrc.getString("CTtabMultiplicity") + "</font></TD>");
                this.newline();
                this.out.write("<TD width=\"111\"bgcolor=\"#C0C0C0\" align=\"left\"><font face=\"Arial\">" + rsrc.getString("CTtabType") + "</font></TD>");
                this.newline();
                this.out.write("<TD widht=\"135\"bgcolor=\"#C0C0C0\" align=\"left\"><font face=\"Arial\">" + rsrc.getString("CTtabDescription") + "</font></TD></TR>");
                this.newline();
                boolean createSeperator = true;
                ArrayList elev = new ArrayList();
                if (aclass instanceof Association) {
                    Iterator rolei = ((Association)((Object)aclass)).iteratorConnection();
                    while (rolei.hasNext()) {
                        obj2 = rolei.next();
                        if (!(obj2 instanceof AssociationEnd)) continue;
                        elev.add(obj2);
                    }
                    Collections.sort(elev, new CompareByName());
                    for (Object obj2 : elev) {
                        this.visitRole((AssociationEnd)obj2, createSeperator);
                        createSeperator = false;
                    }
                }
                elev.clear();
                createSeperator = true;
                Iterator attri = aclass.iteratorFeature();
                while (attri.hasNext()) {
                    obj2 = attri.next();
                    if (!(obj2 instanceof Attribute)) continue;
                    elev.add(obj2);
                }
                for (Object obj2 : elev) {
                    this.visitAttribute((Attribute)obj2, createSeperator);
                    createSeperator = false;
                }
                elev.clear();
                createSeperator = true;
                Iterator rolei = aclass.iteratorAssociation();
                while (rolei.hasNext()) {
                    Object obj3 = rolei.next();
                    Association assoc = ((AssociationEnd)obj3).getAssociation();
                    Iterator opprolei = assoc.iteratorConnection();
                    while (opprolei.hasNext()) {
                        AssociationEnd opprole = (AssociationEnd)opprolei.next();
                        if (opprole == obj3 || assoc instanceof AssociationDef && ((AssociationDef)assoc).isStructureAttribute() && ((RoleDef)opprole).getIliAttributeKind() == 2) continue;
                        elev.add(opprole);
                    }
                }
                Collections.sort(elev, new CompareByName());
                for (Object obj3 : elev) {
                    this.visitRole((RoleDef)obj3, createSeperator);
                    createSeperator = false;
                }
                this.out.write("</TABLE>");
                this.newline();
            }
        }
    }

    public void visitAttribute(Attribute attr, boolean createSeperator) throws IOException {
        String typeLabel = HtmlWriter.getAttrType(attr);
        if (this.pass == 3) {
            String style = "";
            if (createSeperator) {
                style = " STYLE=\"border-top: solid black; border-top-width: 2px\"";
            }
            if (this.clsFile != null) {
                this.clsFile.indent();
                this.clsFile.println(attr.getDefLangName());
            }
            this.out.write("<TR><TD " + style + ">" + HtmlWriter.encodeString(attr.getDefLangName()) + "</TD><TD " + style + ">" + HtmlWriter.mapMultiplicity(attr.getMultiplicity()) + "</TD><TD " + style + ">" + HtmlWriter.encodeString(typeLabel) + "</TD><TD " + style + ">" + HtmlWriter.encodeDescription(HtmlWriter.mapNlsString(attr.getDocumentation())) + "</TD></TR>");
            this.newline();
            Type type = null;
            DomainAttribute attrType = (DomainAttribute)((AttributeDef)attr).getAttrType();
            if (attrType.containsDirect()) {
                type = attrType.getDirect();
            }
            if (type != null && type instanceof Enumeration && this.pass == 3) {
                if (this.clsFile != null) {
                    this.clsFile.indent();
                }
                Iterator elei = this.getEnumEleIterator((Enumeration)type);
                while (elei.hasNext()) {
                    EnumElement ele = (EnumElement)elei.next();
                    String eleName = this.getEnumEleName(ele);
                    if (this.clsFile != null) {
                        this.clsFile.println(eleName);
                    }
                    this.out.write("<TR><TD " + style + ">" + "</TD><TD " + style + ">" + "</TD><TD " + style + ">" + HtmlWriter.encodeString(eleName) + "</TD><TD " + style + ">" + HtmlWriter.encodeDescription(HtmlWriter.mapNlsString(ele.getDocumentation())) + "</TD></TR>");
                    this.newline();
                }
                if (this.clsFile != null) {
                    this.clsFile.unindent();
                }
            }
            if (this.clsFile != null) {
                this.clsFile.unindent();
            }
        }
    }

    public void visitRole(AssociationEnd role, boolean createSeperator) throws IOException {
        String type = role.getParticipant().getDefLangName();
        if (this.pass == 3) {
            String style = "";
            if (createSeperator) {
                style = " STYLE=\"border-top: solid black; border-top-width: 2px\"";
            }
            this.out.write("<TR><TD" + style + ">" + HtmlWriter.encodeString(role.getDefLangName()) + "</TD><TD" + style + ">" + HtmlWriter.mapMultiplicity(role.getMultiplicity()) + "</TD><TD" + style + ">" + HtmlWriter.encodeString(type) + "</TD><TD" + style + ">" + HtmlWriter.encodeDescription(HtmlWriter.mapNlsString(role.getDocumentation())) + "</TD></TR>");
            this.newline();
            if (this.clsFile != null) {
                this.clsFile.indent();
                this.clsFile.println(role.getDefLangName());
                this.clsFile.unindent();
            }
        }
    }

    public void doStruct(Namespace apackage, Writer out) throws IOException {
        this.out = out;
        this.linkElements = false;
        out.write("<HTML>");
        this.newline();
        out.write("<HEAD>");
        this.newline();
        out.write("<TITLE>" + this.formatText("CTstructTitle", HtmlWriter.encodeString(apackage.getDefLangName())) + "</TITLE>");
        this.newline();
        out.write("</HEAD>");
        this.newline();
        out.write("<body link=\"#000000\" vlink=\"#000000\" alink=\"#000000\">");
        this.newline();
        this.pass = 2;
        this.walkTree(apackage);
        out.write("</BODY>");
        this.newline();
        out.write("</HTML>");
        this.newline();
    }

    public static String getAttrType(Attribute attr) {
        String ret = "";
        if (attr instanceof AttributeDef && ((AttributeDef)attr).containsAttrType()) {
            Type type = null;
            DomainAttribute attrType = (DomainAttribute)((AttributeDef)attr).getAttrType();
            if (attrType.containsDomainDef()) {
                type = attrType.getDomainDef().getType();
                ret = attrType.getDomainDef().getDefLangName();
                return ret;
            }
            if (attrType.containsDirect()) {
                type = attrType.getDirect();
            }
            if (type instanceof Text) {
                ret = rsrc.getString("CTtypeTEXT");
            } else if (type instanceof NumericType) {
                NumericType num = (NumericType)type;
                ret = num.getMinDec() != null && num.getMaxDec() != null ? num.getMinDec().toString() + ".." + num.getMaxDec().toString() : rsrc.getString("CTtypeNUMERIC");
                if (num.containsUnitDef()) {
                    ret = ret + "[" + num.getUnitDef().getDefLangName() + "]";
                }
            } else if (type instanceof NumericalType) {
                ret = rsrc.getString("CTtypeNUMERIC");
            } else if (type instanceof BooleanType) {
                ret = rsrc.getString("CTtypeBOOLEAN");
            } else if (type instanceof HorizAlignment) {
                ret = rsrc.getString("CTtypeHALIGNMENT");
            } else if (type instanceof VertAlignment) {
                ret = rsrc.getString("CTtypeVALIGNMENT");
            } else if (type instanceof Enumeration) {
                ret = attrType.containsDomainDef() ? attrType.getDomainDef().getDefLangName() : rsrc.getString("CTtypeENUM");
            } else if (type instanceof CoordinateType) {
                ret = rsrc.getString("CTtypeCOORD");
            } else if (type instanceof IndividualSurface) {
                ret = rsrc.getString("CTtypeSURFACE");
            } else if (type instanceof Tesselation) {
                ret = rsrc.getString("CTtypeAREA");
            } else if (type instanceof IliPolyline) {
                ret = rsrc.getString("CTtypePOLYLINE");
            }
        }
        return ret;
    }

    private void newline() throws IOException {
        if (nl == null) {
            nl = System.getProperty("line.separator");
        }
        this.out.write(nl);
    }

    public static String mapNlsString(NlsString str) {
        if (str == null) {
            return "";
        }
        String ret = str.getValue();
        return ret != null ? ret : "";
    }

    public static String mapMultiplicity(Multiplicity m) {
        if (m == null) {
            return "";
        }
        StringBuffer ret = new StringBuffer();
        Iterator rangei = m.iteratorRange();
        String sep = "";
        while (rangei.hasNext()) {
            MultiplicityRange range = (MultiplicityRange)rangei.next();
            long lower = range.getLower();
            ret.append(sep);
            ret.append(lower);
            long upper = range.getUpper();
            if (lower == upper) continue;
            ret.append("..");
            if (upper == Long.MAX_VALUE) {
                ret.append("n");
            } else {
                ret.append(upper);
            }
            sep = ";";
        }
        return ret.toString();
    }

    public static String encodeDescription(String doc) {
        String line;
        if (doc == null || doc.length() == 0) {
            return "";
        }
        StringBuffer ret = new StringBuffer();
        String beg = "<P>";
        String end = "</P>";
        int last = 0;
        int next = doc.indexOf("\n", last);
        while (next > -1) {
            line = doc.substring(last, next);
            ret.append(beg + HtmlWriter.encodeString(line) + end);
            last = next + 1;
            next = doc.indexOf("\n", last);
        }
        line = doc.substring(last);
        ret.append(beg + HtmlWriter.encodeString(line) + end);
        return ret.toString();
    }

    public static String encodeString(String s) {
        StringBuffer str = new StringBuffer();
        int len = s != null ? s.length() : 0;
        block9: for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '<': {
                    str.append("&lt;");
                    continue block9;
                }
                case '>': {
                    str.append("&gt;");
                    continue block9;
                }
                case '&': {
                    str.append("&amp;");
                    continue block9;
                }
                case '\"': {
                    str.append("&quot;");
                    continue block9;
                }
                case '\u00e4': {
                    str.append("&auml;");
                    continue block9;
                }
                case '\u00f6': {
                    str.append("&ouml;");
                    continue block9;
                }
                case '\u00fc': {
                    str.append("&uuml;");
                    continue block9;
                }
                default: {
                    str.append(ch);
                }
            }
        }
        return str.toString();
    }

    private String formatText(String resourceName, String param0) {
        return MessageFormat.format(rsrc, resourceName, param0);
    }

    private void walkTree(Namespace apackage) throws IOException {
        if (this.pass == 1 || this.pass == 3) {
            this.out.write("<font face=\"Arial\">");
            this.newline();
            if (this.pass == 1) {
                this.out.write("<H1>" + rsrc.getString("CTContents") + "</H1>");
                this.newline();
            }
            ArrayList<Namespace> todo = new ArrayList<Namespace>();
            todo.add(apackage);
            while (!todo.isEmpty()) {
                Namespace current = (Namespace)todo.get(0);
                if (!current.getDefLangName().startsWith("<")) {
                    if (current instanceof Class) {
                        this.visitClass((Class)current);
                    } else if (this.isEnumDomainDef(current)) {
                        this.visitEnumDomainDef((DomainDef)current);
                    } else {
                        this.visitPackage(current);
                    }
                    Iterator childi = current.iteratorOwnedElement();
                    ArrayList classv = new ArrayList();
                    ArrayList packv = new ArrayList();
                    while (childi.hasNext()) {
                        Object obj = childi.next();
                        if (obj instanceof Package || obj instanceof Artifact) {
                            packv.add(obj);
                            continue;
                        }
                        if (obj instanceof Class) {
                            classv.add(obj);
                            continue;
                        }
                        if (!this.isEnumDomainDef(obj)) continue;
                        classv.add(obj);
                    }
                    Collections.sort(classv, new CompareByName());
                    todo.addAll(1, classv);
                    Collections.sort(packv, new CompareByName());
                    todo.addAll(packv);
                }
                todo.remove(0);
            }
            this.resetCounters();
            this.out.write("</font>");
            this.newline();
        }
        if (this.pass == 4) {
            this.out.write("<font face=\"Arial\">");
            this.newline();
            this.out.write("<H1>" + rsrc.getString("CTIndex") + "</H1>");
            this.newline();
            ArrayList sortedModelElements = new ArrayList();
            for (Object obj : this.indexMap.keySet()) {
                if (!(obj instanceof ModelElement)) continue;
                sortedModelElements.add(obj);
            }
            Collections.sort(sortedModelElements, new CompareByNameAndIdx());
            this.out.write("<font face=\"Arial\" size=\"3\">");
            this.newline();
            this.out.write("<p>");
            this.newline();
            for (char i = 'A'; i <= 'Z'; i = (char)((char)(i + 1))) {
                Iterator itSortedNames = sortedModelElements.iterator();
                boolean writtenChar = false;
                while (itSortedNames.hasNext()) {
                    String name = null;
                    name = ((ModelElement)itSortedNames.next()).getDefLangName();
                    if (name == null || name.length() <= 0 || Character.toUpperCase(name.charAt(0)) != i || writtenChar) continue;
                    this.out.write("  <a href=\"#" + name + "\"><u>" + i + "&nbsp;</u></a>");
                    this.newline();
                    writtenChar = true;
                }
                if (writtenChar) continue;
                this.out.write("  " + i + "&nbsp;");
                this.newline();
            }
            this.out.write("</p>");
            this.out.write("</font>");
            this.newline();
            this.out.write("<br>");
            this.newline();
            String lastName = null;
            boolean check = false;
            for (int a = 0; a < sortedModelElements.size(); ++a) {
                ModelElement modelElement = (ModelElement)sortedModelElements.get(a);
                String name = modelElement.getDefLangName();
                if (name == null) {
                    name = "";
                }
                int[] sectionNumbers = (int[])this.indexMap.get(modelElement);
                int sectionNumbersLength = sectionNumbers.length;
                String sectionNumber = null;
                if (sectionNumbersLength == 2) {
                    sectionNumber = Integer.toString(sectionNumbers[0]) + "." + Integer.toString(sectionNumbers[1]);
                } else if (sectionNumbersLength == 1) {
                    sectionNumber = Integer.toString(sectionNumbers[0]);
                }
                if (name.equals(lastName)) {
                    this.out.write(",&nbsp;<a href=\"#" + sectionNumber + "_" + HtmlWriter.encodeString(name) + "\" name=\"" + name + "\">" + sectionNumber + "</a>");
                    this.newline();
                } else {
                    if (check) {
                        this.out.write("</p>");
                    }
                    this.out.write("<p style=\"text-indent: 0; line-height: 15%; margin-left: 0\">");
                    this.out.write("<a href=\"#" + sectionNumber + "_" + HtmlWriter.encodeString(name) + "\" name=\"" + name + "\">" + HtmlWriter.encodeString(name) + " " + sectionNumber + "</a>");
                    this.newline();
                    check = true;
                }
                lastName = name;
            }
            this.out.write("</font>");
            this.newline();
        }
        if (this.pass == 2) {
            this.out.write("<font face=\"Arial\">");
            this.newline();
            this.out.write("<H1>" + rsrc.getString("CTStructure") + "</H1>");
            this.newline();
            this.walkTreeRecursiv(apackage);
            this.out.write("</font>");
            this.newline();
        }
        this.resetCounters();
    }

    private void resetCounters() {
        this.numeration = 0;
        this.iddP = 1;
    }

    private void walkTreeRecursiv(Namespace aPackage) throws IOException {
        if (aPackage.getDefLangName().startsWith("<")) {
            return;
        }
        this.visitPackage(aPackage);
        Iterator childi = aPackage.iteratorOwnedElement();
        ArrayList elev = new ArrayList();
        while (childi.hasNext()) {
            Object obj = childi.next();
            if (!(obj instanceof Package) && !(obj instanceof Artifact) && !(obj instanceof Class) && !this.isEnumDomainDef(obj)) continue;
            elev.add(obj);
        }
        Collections.sort(elev, new CompareByName());
        for (Object obj : elev) {
            if (obj instanceof Package || obj instanceof Artifact) {
                this.level += 0.5;
                this.walkTreeRecursiv((Namespace)obj);
                this.level -= 0.5;
                continue;
            }
            if (obj instanceof Class) {
                this.level += 0.5;
                this.visitClass((Class)obj);
                this.level -= 0.5;
                continue;
            }
            if (!this.isEnumDomainDef(obj)) continue;
            this.level += 0.5;
            this.visitEnumDomainDef((DomainDef)obj);
            this.level -= 0.5;
        }
    }

    private boolean isEnumDomainDef(Object obj) {
        if (!(obj instanceof DomainDef)) {
            return false;
        }
        DomainDef def = (DomainDef)obj;
        return def.getType() instanceof Enumeration;
    }

    private void visitEnumDomainDef(DomainDef domdef) throws IOException {
        String domDefName = HtmlWriter.encodeString(domdef.getDefLangName());
        Enumeration def = (Enumeration)domdef.getType();
        if (this.pass == 1) {
            int[] sectionNumbers = new int[]{this.numeration, this.iddP};
            this.indexMap.put(domdef, sectionNumbers);
        }
        String value = "";
        String aName = "";
        if (this.linkElements) {
            int[] numerationId = (int[])this.indexMap.get(domdef);
            String numeration = Integer.toString(numerationId[0]) + "." + Integer.toString(numerationId[1]);
            aName = numeration + "_" + domDefName;
            value = this.suppressChNr ? domDefName : numeration + " " + domDefName;
        } else {
            value = domDefName;
        }
        if (this.pass == 3) {
            this.out.write("<H2><a name=\"" + aName + "\">" + value + "</a></H2>");
            this.newline();
        }
        if (this.pass == 1) {
            this.out.write("<p style=\"text-indent: 0; line-height: 15%; margin-left: 0\"><a href=\"#" + aName + "\">" + value + "</a></P>");
            this.newline();
            if (this.clsFile != null) {
                this.clsFile.println(domdef.getDefLangName());
            }
        }
        if (this.pass == 2) {
            if (this.linkElements) {
                this.out.write("<p style=\"text-indent:" + Double.toString(this.level) + "cm; line-height: 15%; margin-left: 0\"><a href=\"#" + aName + "\">" + value + "</a></p>");
                this.newline();
            } else {
                this.out.write("<p style=\"text-indent:" + Double.toString(this.level) + "cm; line-height: 15%; margin-left: 0\">" + value + "</p>");
                this.newline();
            }
        }
        ++this.iddP;
        if (this.pass == 3) {
            this.out.write(HtmlWriter.encodeDescription(HtmlWriter.mapNlsString(domdef.getDocumentation())));
            this.newline();
            this.out.write("<TABLE border=\"0\" frame=hsides roles=rows cellspacing=\"0\" cellpadding=\"5\" height=\"1\">");
            this.newline();
            this.out.write("<COL>");
            this.newline();
            this.out.write("<COL>");
            this.newline();
            this.out.write("<COL>");
            this.newline();
            this.out.write("<COL>");
            this.newline();
            this.out.write("<TR><TD width=\"85\" bgcolor=\"#C0C0C0\" align=\"left\"><font face=\"Arial\">" + rsrc.getString("CTtabName") + "</font></TD>");
            this.newline();
            this.out.write("<TD widht=\"135\"bgcolor=\"#C0C0C0\" align=\"left\"><font face=\"Arial\">" + rsrc.getString("CTtabDescription") + "</font></TD></TR>");
            this.newline();
            boolean createSeperator = true;
            Iterator elei = this.getEnumEleIterator(def);
            if (this.clsFile != null) {
                this.clsFile.indent();
            }
            while (elei.hasNext()) {
                EnumElement ele = (EnumElement)elei.next();
                if (this.pass != 3) continue;
                String style = "";
                String eleName = this.getEnumEleName(ele);
                this.out.write("<TR><TD" + style + ">" + HtmlWriter.encodeString(eleName) + "</TD><TD" + style + ">" + HtmlWriter.encodeDescription(HtmlWriter.mapNlsString(ele.getDocumentation())) + "</TD></TR>");
                this.newline();
                if (this.clsFile == null) continue;
                this.clsFile.println(eleName);
            }
            if (this.clsFile != null) {
                this.clsFile.unindent();
            }
            this.out.write("</TABLE>");
            this.newline();
        }
    }

    private String getEnumEleName(EnumElement ele) {
        StringBuffer ret = new StringBuffer(ele.getDefLangName());
        Enumeration parent = ele.getEnumeration();
        while (parent.containsParent()) {
            EnumElement parentEle = parent.getParent();
            ret.insert(0, ".");
            ret.insert(0, parentEle.getDefLangName());
            parent = parentEle.getEnumeration();
        }
        return ret.toString();
    }

    private void getEnumEleSubEles(List accu, Enumeration def) {
        Iterator elei = def.iteratorEnumElement();
        while (elei.hasNext()) {
            EnumElement ele = (EnumElement)elei.next();
            if (ele.containsChild()) {
                this.getEnumEleSubEles(accu, ele.getChild());
                continue;
            }
            accu.add(ele);
        }
    }

    private Iterator getEnumEleIterator(Enumeration def) {
        ArrayList accu = new ArrayList();
        this.getEnumEleSubEles(accu, def);
        return accu.iterator();
    }

    public void setChapterNumbering(boolean suppress) {
        this.suppressChNr = suppress;
    }

    class CompareByName
    implements Comparator {
        CompareByName() {
        }

        public int compare(Object o1, Object o2) {
            String name2;
            if (!(o1 instanceof ModelElement)) {
                // empty if block
            }
            if (!(o2 instanceof ModelElement)) {
                // empty if block
            }
            ModelElement e1 = (ModelElement)o1;
            ModelElement e2 = (ModelElement)o2;
            String name1 = e1.getDefLangName();
            if (name1 == null) {
                name1 = "";
            }
            if ((name2 = e2.getDefLangName()) == null) {
                name2 = "";
            }
            int compareName = name1.compareTo(name2);
            return compareName;
        }
    }

    class CompareByNameAndIdx
    implements Comparator {
        CompareByNameAndIdx() {
        }

        public int compare(Object o1, Object o2) {
            int compareName;
            String name2;
            if (!(o1 instanceof ModelElement)) {
                // empty if block
            }
            if (!(o2 instanceof ModelElement)) {
                // empty if block
            }
            ModelElement e1 = (ModelElement)o1;
            ModelElement e2 = (ModelElement)o2;
            String name1 = e1.getDefLangName();
            if (name1 == null) {
                name1 = "";
            }
            if ((name2 = e2.getDefLangName()) == null) {
                name2 = "";
            }
            if ((compareName = name1.compareTo(name2)) == 0) {
                int[] ae1 = (int[])HtmlWriter.this.indexMap.get(e1);
                int[] ae2 = (int[])HtmlWriter.this.indexMap.get(e2);
                int compareFirstIndex = new Integer(ae1[0]).compareTo(new Integer(ae2[0]));
                return compareFirstIndex;
            }
            return compareName;
        }
    }
}

