/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security.dialogs.remember;

import java.awt.Component;
import java.awt.Container;
import net.sourceforge.jnlp.security.SecurityDialog;
import net.sourceforge.jnlp.security.appletextendedsecurity.UnsignedAppletActionEntry;
import net.sourceforge.jnlp.security.appletextendedsecurity.UnsignedAppletTrustConfirmation;
import net.sourceforge.jnlp.security.dialogresults.BasicDialogValue;
import net.sourceforge.jnlp.security.dialogresults.DialogResult;
import net.sourceforge.jnlp.security.dialogs.remember.ExecuteAppletAction;
import net.sourceforge.jnlp.security.dialogs.remember.RememberableDialog;
import net.sourceforge.jnlp.security.dialogs.remember.SavedRememberAction;

public class RememberDialog {
    public void setOrUpdateRememberedState(SecurityDialog dialog) {
        RememberableDialog found = this.findRememberablePanel(dialog.getSecurityDialogPanel());
        if (found == null) {
            return;
        }
        String value = BasicDialogValue.writeNUll();
        if (found.getValue() != null) {
            value = found.getValue().writeValue();
        }
        SavedRememberAction action = new SavedRememberAction(RememberDialog.createAction(found.getRemeberAction().isRemember(), found.getValue()), value);
        this.setOrUpdateRememberedState(dialog, found.getRemeberAction().isCodebase(), action);
    }

    public void setOrUpdateRememberedState(SecurityDialog dialog, boolean wholeCodebase, SavedRememberAction action) {
        RememberableDialog found = this.findRememberablePanel(dialog.getSecurityDialogPanel());
        if (found == null) {
            return;
        }
        UnsignedAppletTrustConfirmation.updateAppletAction(found.getFile(), action, wholeCodebase, found.getClass());
    }

    public SavedRememberAction getRememberedState(SecurityDialog dialog) {
        RememberableDialog found = this.findRememberablePanel(dialog.getSecurityDialogPanel());
        if (found != null) {
            return this.getRememberedState(found);
        }
        return null;
    }

    public SavedRememberAction getRememberedState(RememberableDialog found) {
        UnsignedAppletActionEntry entry = UnsignedAppletTrustConfirmation.getStoredEntry(found.getFile(), found.getClass());
        if (entry != null) {
            SavedRememberAction action = entry.getAppletSecurityActions().getActionEntry(found.getClass());
            return action;
        }
        return null;
    }

    public RememberableDialog findRememberablePanel(Container search) {
        if (search == null) {
            return null;
        }
        if (search instanceof RememberableDialog) {
            return (RememberableDialog)((Object)search);
        }
        for (Component comp : search.getComponents()) {
            if (!(comp instanceof RememberableDialog)) continue;
            return (RememberableDialog)((Object)comp);
        }
        for (Component comp : search.getComponents()) {
            RememberableDialog candidate;
            if (!(comp instanceof Container) || (candidate = this.findRememberablePanel((Container)comp)) == null) continue;
            return candidate;
        }
        return null;
    }

    public static ExecuteAppletAction createAction(boolean pernament, DialogResult value) {
        if (value == null) {
            return ExecuteAppletAction.NO;
        }
        if (value.toBoolean()) {
            if (pernament) {
                return ExecuteAppletAction.ALWAYS;
            }
            return ExecuteAppletAction.YES;
        }
        if (pernament) {
            return ExecuteAppletAction.NEVER;
        }
        return ExecuteAppletAction.NO;
    }

    public static RememberDialog getInstance() {
        return RememberDialogueHolder.getRememberDialogue();
    }

    private static class RememberDialogueHolder {
        private static final RememberDialog INSTANCE = new RememberDialog();

        private RememberDialogueHolder() {
        }

        private static RememberDialog getRememberDialogue() {
            return INSTANCE;
        }
    }
}

