/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.timeline;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import org.netbeans.lib.profiler.charts.ChartConfigurationListener;
import org.netbeans.lib.profiler.charts.swing.Utils;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.snaptracer.TracerProbe;
import org.netbeans.modules.profiler.snaptracer.impl.probes.ProbePresenter;
import org.netbeans.modules.profiler.snaptracer.impl.swing.HeaderButton;
import org.netbeans.modules.profiler.snaptracer.impl.swing.HeaderLabel;
import org.netbeans.modules.profiler.snaptracer.impl.swing.ScrollBar;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.Bundle;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineChart;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineSupport;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.VerticalTimelineLayout;

final class ProbesPanel
extends JPanel {
    private final ListPanel listPanel;
    private final JViewport viewport;
    private final HeaderButton increaseB;
    private final HeaderButton decreaseB;
    private final HeaderButton resetB;

    ProbesPanel(final TimelineSupport timelineSupport) {
        final TimelineChart timelineChart = timelineSupport.getChart();
        this.listPanel = new ListPanel(new VerticalTimelineLayout(timelineChart)){

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.height = Utils.checkedInt((double)timelineChart.getChartContext().getViewHeight());
                return dimension;
            }

            @Override
            protected void updateSelection() {
                int n = this.getComponentCount();
                for (int i = 0; i < n; ++i) {
                    ((ProbePresenter)this.getComponent(i)).setSelected(timelineChart.isRowSelected(timelineChart.getRow(i)));
                }
            }
        };
        this.viewport = new JViewport(){

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                point.y += this.getViewPosition().y;
                return ProbesPanel.this.listPanel.getToolTipText(point);
            }
        };
        ToolTipManager.sharedInstance().registerComponent(this.viewport);
        this.viewport.setOpaque(true);
        this.viewport.setBackground(new Color(247, 247, 247));
        this.viewport.setView(this.listPanel);
        this.viewport.setViewPosition(new Point(0, 0));
        final ViewportUpdater viewportUpdater = new ViewportUpdater(this.viewport);
        timelineChart.addConfigurationListener((ChartConfigurationListener)new ChartConfigurationListener.Adapter(){

            public void contentsWillBeUpdated(long l, long l2, double d, double d2, long l3, long l4, double d3, double d4) {
                if (l4 != l2) {
                    SwingUtilities.invokeLater(viewportUpdater.forPoint(new Point(0, Utils.checkedInt((double)l2))));
                }
            }
        });
        JPanel jPanel = new JPanel(new GridLayout(1, 3));
        jPanel.setPreferredSize(new Dimension(100, new ScrollBar((int)0).getPreferredSize().height));
        jPanel.setOpaque(false);
        this.increaseB = new HeaderButton(null, Icons.getIcon((String)"TracerIcons.Increment")){

            @Override
            protected void performAction(ActionEvent actionEvent) {
                timelineChart.increaseRowHeights((actionEvent.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) == 0);
            }
        };
        this.increaseB.setToolTipText(Bundle.TOOLTIP_IncreaseRowsHeight());
        jPanel.add(this.increaseB);
        this.decreaseB = new HeaderButton(null, Icons.getIcon((String)"TracerIcons.Decrement")){

            @Override
            protected void performAction(ActionEvent actionEvent) {
                timelineChart.decreaseRowHeights((actionEvent.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) == 0);
            }
        };
        this.decreaseB.setToolTipText(Bundle.TOOLTIP_DecreaseRowsHeight());
        jPanel.add(this.decreaseB);
        this.resetB = new HeaderButton(null, Icons.getIcon((String)"TracerIcons.Reset")){

            @Override
            protected void performAction(ActionEvent actionEvent) {
                timelineChart.resetRowHeights();
            }
        };
        this.resetB.setToolTipText(Bundle.TOOLTIP_ResetRowsHeight());
        jPanel.add(this.resetB);
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.add((Component)new HeaderLabel(Bundle.LBL_Probes()), "North");
        this.add((Component)this.viewport, "Center");
        this.add((Component)jPanel, "South");
        timelineChart.addRowListener(new TimelineChart.RowListener(){

            @Override
            public void rowsAdded(List<TimelineChart.Row> list) {
                for (TimelineChart.Row row : list) {
                    TracerProbe tracerProbe = timelineSupport.getProbe(row);
                    ProbesPanel.this.listPanel.add((Component)new ProbePresenter(tracerProbe, timelineSupport.getDescriptor(tracerProbe)), row.getIndex());
                }
                ProbesPanel.this.listPanel.sync();
                ProbesPanel.this.revalidate();
                ProbesPanel.this.repaint();
                ProbesPanel.this.refreshButtons(true);
            }

            @Override
            public void rowsRemoved(List<TimelineChart.Row> list) {
                for (TimelineChart.Row row : list) {
                    ProbesPanel.this.listPanel.remove(row.getIndex());
                }
                ProbesPanel.this.listPanel.sync();
                ProbesPanel.this.revalidate();
                ProbesPanel.this.repaint();
                ProbesPanel.this.refreshButtons(timelineChart.hasRows());
            }

            @Override
            public void rowsResized(List<TimelineChart.Row> list) {
                ProbesPanel.this.listPanel.sync();
                ProbesPanel.this.revalidate();
                ProbesPanel.this.repaint();
            }
        });
        this.refreshButtons(timelineChart.hasRows());
    }

    @Override
    public void setCursor(Cursor cursor) {
        this.viewport.setCursor(cursor);
    }

    Component getMouseTarget() {
        return this.viewport;
    }

    void updateSelection() {
        this.listPanel.updateSelection();
    }

    private void refreshButtons(boolean bl) {
        this.increaseB.setEnabled(bl);
        this.decreaseB.setEnabled(bl);
        this.resetB.setEnabled(bl);
    }

    private static class ListPanel
    extends JPanel {
        ListPanel(LayoutManager layoutManager) {
            super(layoutManager);
            this.setOpaque(false);
        }

        protected void updateSelection() {
        }

        String getToolTipText(Point point) {
            String string = null;
            Component component = this.getComponentAt(point);
            if (component instanceof JComponent) {
                string = (String)((JComponent)component).getClientProperty("ToolTipHelper");
            }
            return string;
        }

        private void sync() {
            this.doLayout();
            this.repaint();
        }
    }

    private static class ViewportUpdater
    implements Runnable {
        private final JViewport viewport;
        private Point point;

        ViewportUpdater(JViewport jViewport) {
            this.viewport = jViewport;
        }

        Runnable forPoint(Point point) {
            this.point = point;
            return this;
        }

        @Override
        public void run() {
            this.viewport.setViewPosition(this.point);
        }
    }
}

