#ifndef EFL_GENERATED_ELM_ATSPI_BRIDGE_HH
#define EFL_GENERATED_ELM_ATSPI_BRIDGE_HH

extern "C"
{
#include <Efl.h>
}
#include <Eo.hh>

#include <eo_cxx_interop.hh>

extern "C"
{
#include "elm_atspi_bridge.eo.h"
}

#include "eo_base.eo.hh"

namespace elm {

struct atspi_bridge;

}

/// @cond EO_CXX_ABSTRACT
namespace eo_cxx {

namespace elm {

struct atspi_bridge
{
   bool connected_get() const;

   template <typename F>
   ::efl::eo::signal_connection
   callback_connected_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_ATSPI_BRIDGE_EVENT_CONNECTED, priority_,
            &::efl::eo::_detail::event_callback<::elm::atspi_bridge, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::atspi_bridge, function_type>,
         ELM_ATSPI_BRIDGE_EVENT_CONNECTED );
   }

   template <typename T>
   void
   callback_connected_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_ATSPI_BRIDGE_EVENT_CONNECTED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_disconnected_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_ATSPI_BRIDGE_EVENT_DISCONNECTED, priority_,
            &::efl::eo::_detail::event_callback<::elm::atspi_bridge, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::atspi_bridge, function_type>,
         ELM_ATSPI_BRIDGE_EVENT_DISCONNECTED );
   }

   template <typename T>
   void
   callback_disconnected_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_ATSPI_BRIDGE_EVENT_DISCONNECTED, info));
   }



   static Eo_Class const* _eo_class()
   {
      return(ELM_ATSPI_BRIDGE_CLASS);
   }

   operator ::elm::atspi_bridge() const;
   operator ::elm::atspi_bridge&();
   operator ::elm::atspi_bridge const&() const;

   /// @cond LOCAL
   template <typename D>
   struct address_of
   {
      operator ::elm::atspi_bridge*() const { return static_cast<::elm::atspi_bridge*>(static_cast<D const*>(this)->p); }
      operator ::elm::atspi_bridge const*() const { return static_cast<::elm::atspi_bridge const*>(static_cast<D const*>(this)->p); }
   };

   template <typename D>
   struct address_const_of
   {
      operator ::elm::atspi_bridge const*() const { return static_cast<::elm::atspi_bridge const*>(static_cast<D const*>(this)->p); }
   };
   /// @endcond

private:

   /// @internal
   Eo* _concrete_eo_ptr() const
   {
      return static_cast<::efl::eo::concrete const*>(static_cast<void const*>(this))->_eo_ptr();
   }

};

}

}
/// @endcond

namespace elm {

/// @brief Class atspi_bridge
struct atspi_bridge
      : ::efl::eo::concrete
      , EO_CXX_INHERIT(eo::base)
{
   //@{
   /**
      @brief Constructs a new elm::atspi_bridge object.

      Constructs a new elm::atspi_bridge object. If you want this object to be a child
      of another Eo object, use an @ref efl::eo::parent expression, like the example.

      Example:
      @code
      elm::atspi_bridge my_atspi_bridge(efl::eo::parent = parent_object);
      @endcode

      @see atspi_bridge(Eo* eo)
   */
   explicit atspi_bridge(::efl::eo::parent_type _p)
      : atspi_bridge(_ctors_call(_p))
   {}

   explicit atspi_bridge()
      : atspi_bridge(_ctors_call(::efl::eo::parent = nullptr))
   {}
   //@}

   /// @brief Eo Constructor.
   ///
   /// Constructs the object from an Eo* pointer stealing its ownership.
   ///
   /// @param eo The Eo object pointer.
   ///
   explicit atspi_bridge(Eo* eo)
      : ::efl::eo::concrete(eo)
   {}

   /// @brief nullptr_t Constructor.
   ///
   /// Constructs an empty (null) object.
   ///
   explicit atspi_bridge(std::nullptr_t)
      : ::efl::eo::concrete(nullptr)
   {}

   /// @brief Copy Constructor.
   ///
   atspi_bridge(atspi_bridge const& other)
      : atspi_bridge(eo_ref(other._eo_ptr()))
   {}

   ~atspi_bridge() {}

   bool connected_get() const;

   template <typename F>
   ::efl::eo::signal_connection
   callback_callback_add_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EO_BASE_EVENT_CALLBACK_ADD, priority_,
            &::efl::eo::_detail::event_callback<::elm::atspi_bridge, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::atspi_bridge, function_type>,
         EO_BASE_EVENT_CALLBACK_ADD );
   }

   template <typename T>
   void
   callback_callback_add_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EO_BASE_EVENT_CALLBACK_ADD, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_callback_del_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EO_BASE_EVENT_CALLBACK_DEL, priority_,
            &::efl::eo::_detail::event_callback<::elm::atspi_bridge, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::atspi_bridge, function_type>,
         EO_BASE_EVENT_CALLBACK_DEL );
   }

   template <typename T>
   void
   callback_callback_del_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EO_BASE_EVENT_CALLBACK_DEL, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_connected_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_ATSPI_BRIDGE_EVENT_CONNECTED, priority_,
            &::efl::eo::_detail::event_callback<::elm::atspi_bridge, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::atspi_bridge, function_type>,
         ELM_ATSPI_BRIDGE_EVENT_CONNECTED );
   }

   template <typename T>
   void
   callback_connected_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_ATSPI_BRIDGE_EVENT_CONNECTED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_del_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EO_BASE_EVENT_DEL, priority_,
            &::efl::eo::_detail::event_callback<::elm::atspi_bridge, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::atspi_bridge, function_type>,
         EO_BASE_EVENT_DEL );
   }

   template <typename T>
   void
   callback_del_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EO_BASE_EVENT_DEL, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_disconnected_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_ATSPI_BRIDGE_EVENT_DISCONNECTED, priority_,
            &::efl::eo::_detail::event_callback<::elm::atspi_bridge, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::atspi_bridge, function_type>,
         ELM_ATSPI_BRIDGE_EVENT_DISCONNECTED );
   }

   template <typename T>
   void
   callback_disconnected_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_ATSPI_BRIDGE_EVENT_DISCONNECTED, info));
   }



   static Eo_Class const* _eo_class()
   {
      return(ELM_ATSPI_BRIDGE_CLASS);
   }

   /// @cond LOCAL
   struct address_of
      : ::eo_cxx::elm::atspi_bridge::address_of<address_of>
      , ::eo_cxx::eo::base::address_of<address_of>
      , ::efl::eo::detail::concrete_address_of
   {
      explicit address_of(::elm::atspi_bridge* p)
         : ::efl::eo::detail::concrete_address_of(p)
      {}
   };
   address_of operator&() { return address_of(this); }

   struct address_const_of
      : ::eo_cxx::elm::atspi_bridge::address_const_of<address_const_of>
      , ::eo_cxx::eo::base::address_const_of<address_const_of>
      , ::efl::eo::detail::concrete_address_const_of
   {
      explicit address_const_of(::elm::atspi_bridge const* p)
         : ::efl::eo::detail::concrete_address_const_of(p)
      {}
   };
   address_const_of operator&() const { return address_const_of(this); }

   /// @endcond

private:

   /// @internal
   static Eo* _ctors_call(::efl::eo::parent_type _p)
   {
      Eo* _ret_eo = eo_add_ref(ELM_ATSPI_BRIDGE_CLASS, _p._eo_raw);

      return _ret_eo;
   }

   /// @internal
   Eo* _concrete_eo_ptr() const { return _eo_ptr(); }
};

static_assert(sizeof(::elm::atspi_bridge) == sizeof(Eo*), "");
static_assert(std::is_standard_layout<::elm::atspi_bridge>::value, "");

}


#include "elm_atspi_bridge.eo.impl.hh"

#endif // EFL_GENERATED_ELM_ATSPI_BRIDGE_HH

