/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.protocol;

import com.sun.corba.se.impl.corba.ServerRequestImpl;
import com.sun.corba.se.impl.encoding.CodeSetComponentInfo;
import com.sun.corba.se.impl.encoding.MarshalInputStream;
import com.sun.corba.se.impl.encoding.OSFCodeSetRegistry;
import com.sun.corba.se.impl.logging.ORBUtilSystemException;
import com.sun.corba.se.impl.logging.POASystemException;
import com.sun.corba.se.impl.orbutil.ORBUtility;
import com.sun.corba.se.impl.protocol.RequestCanceledException;
import com.sun.corba.se.impl.protocol.SpecialMethod;
import com.sun.corba.se.pept.encoding.OutputObject;
import com.sun.corba.se.pept.protocol.MessageMediator;
import com.sun.corba.se.spi.ior.IOR;
import com.sun.corba.se.spi.ior.ObjectAdapterId;
import com.sun.corba.se.spi.ior.ObjectKey;
import com.sun.corba.se.spi.ior.ObjectKeyTemplate;
import com.sun.corba.se.spi.ior.iiop.GIOPVersion;
import com.sun.corba.se.spi.oa.NullServant;
import com.sun.corba.se.spi.oa.OADestroyed;
import com.sun.corba.se.spi.oa.OAInvocationInfo;
import com.sun.corba.se.spi.oa.ObjectAdapter;
import com.sun.corba.se.spi.oa.ObjectAdapterFactory;
import com.sun.corba.se.spi.orb.ORB;
import com.sun.corba.se.spi.orb.ORBVersion;
import com.sun.corba.se.spi.orb.ORBVersionFactory;
import com.sun.corba.se.spi.protocol.CorbaMessageMediator;
import com.sun.corba.se.spi.protocol.CorbaServerRequestDispatcher;
import com.sun.corba.se.spi.protocol.ForwardException;
import com.sun.corba.se.spi.protocol.RequestDispatcherRegistry;
import com.sun.corba.se.spi.servicecontext.CodeSetServiceContext;
import com.sun.corba.se.spi.servicecontext.ORBVersionServiceContext;
import com.sun.corba.se.spi.servicecontext.SendingContextServiceContext;
import com.sun.corba.se.spi.servicecontext.ServiceContext;
import com.sun.corba.se.spi.servicecontext.ServiceContexts;
import com.sun.corba.se.spi.servicecontext.UEInfoServiceContext;
import com.sun.corba.se.spi.transport.CorbaConnection;
import org.omg.CORBA.Any;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.DynamicImplementation;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.InvokeHandler;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.UnknownException;

public class CorbaServerRequestDispatcherImpl
implements CorbaServerRequestDispatcher {
    protected ORB orb;
    private ORBUtilSystemException wrapper;
    private POASystemException poaWrapper;

    public CorbaServerRequestDispatcherImpl(ORB orb) {
        this.orb = orb;
        this.wrapper = ORBUtilSystemException.get(orb, "rpc.protocol");
        this.poaWrapper = POASystemException.get(orb, "rpc.protocol");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IOR locate(ObjectKey okey) {
        try {
            if (this.orb.subcontractDebugFlag) {
                this.dprint(".locate->");
            }
            ObjectKeyTemplate oktemp = okey.getTemplate();
            try {
                this.checkServerId(okey);
            }
            catch (ForwardException fex) {
                IOR iOR = fex.getIOR();
                if (this.orb.subcontractDebugFlag) {
                    this.dprint(".locate<-");
                }
                return iOR;
            }
            this.findObjectAdapter(oktemp);
            IOR iOR = null;
            return iOR;
        }
        finally {
            if (this.orb.subcontractDebugFlag) {
                this.dprint(".locate<-");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatch(MessageMediator messageMediator) {
        CorbaMessageMediator request = (CorbaMessageMediator)messageMediator;
        try {
            if (this.orb.subcontractDebugFlag) {
                this.dprint(".dispatch->: " + this.opAndId(request));
            }
            this.consumeServiceContexts(request);
            ((MarshalInputStream)((Object)request.getInputObject())).performORBVersionSpecificInit();
            ObjectKey okey = request.getObjectKey();
            try {
                this.checkServerId(okey);
            }
            catch (ForwardException fex) {
                if (this.orb.subcontractDebugFlag) {
                    this.dprint(".dispatch: " + this.opAndId(request) + ": bad server id");
                }
                request.getProtocolHandler().createLocationForward(request, fex.getIOR(), null);
                if (this.orb.subcontractDebugFlag) {
                    this.dprint(".dispatch<-: " + this.opAndId(request));
                }
                return;
            }
            String operation = request.getOperationName();
            ObjectAdapter objectAdapter = null;
            try {
                byte[] objectId = okey.getId().getId();
                ObjectKeyTemplate oktemp = okey.getTemplate();
                objectAdapter = this.findObjectAdapter(oktemp);
                Object servant = this.getServantWithPI(request, objectAdapter, objectId, oktemp, operation);
                this.dispatchToServant(servant, request, objectId, objectAdapter);
            }
            catch (ForwardException ex) {
                if (this.orb.subcontractDebugFlag) {
                    this.dprint(".dispatch: " + this.opAndId(request) + ": ForwardException caught");
                }
                request.getProtocolHandler().createLocationForward(request, ex.getIOR(), null);
            }
            catch (OADestroyed ex) {
                if (this.orb.subcontractDebugFlag) {
                    this.dprint(".dispatch: " + this.opAndId(request) + ": OADestroyed exception caught");
                }
                this.dispatch(request);
            }
            catch (RequestCanceledException ex) {
                if (this.orb.subcontractDebugFlag) {
                    this.dprint(".dispatch: " + this.opAndId(request) + ": RequestCanceledException caught");
                }
                throw ex;
            }
            catch (UnknownException ex) {
                if (this.orb.subcontractDebugFlag) {
                    this.dprint(".dispatch: " + this.opAndId(request) + ": UnknownException caught " + ex);
                }
                if (ex.originalEx instanceof RequestCanceledException) {
                    throw (RequestCanceledException)ex.originalEx;
                }
                ServiceContexts contexts = new ServiceContexts(this.orb);
                UEInfoServiceContext usc = new UEInfoServiceContext(ex.originalEx);
                contexts.put(usc);
                UNKNOWN sysex = this.wrapper.unknownExceptionInDispatch(CompletionStatus.COMPLETED_MAYBE, ex);
                request.getProtocolHandler().createSystemExceptionResponse(request, sysex, contexts);
            }
            catch (Throwable ex) {
                if (this.orb.subcontractDebugFlag) {
                    this.dprint(".dispatch: " + this.opAndId(request) + ": other exception " + ex);
                }
                request.getProtocolHandler().handleThrowableDuringServerDispatch(request, ex, CompletionStatus.COMPLETED_MAYBE);
            }
            return;
        }
        finally {
            if (this.orb.subcontractDebugFlag) {
                this.dprint(".dispatch<-: " + this.opAndId(request));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseServant(ObjectAdapter objectAdapter) {
        try {
            if (this.orb.subcontractDebugFlag) {
                this.dprint(".releaseServant->");
            }
            if (objectAdapter == null) {
                if (this.orb.subcontractDebugFlag) {
                    this.dprint(".releaseServant: null object adapter");
                }
                return;
            }
            try {
                objectAdapter.returnServant();
            }
            finally {
                objectAdapter.exit();
                this.orb.popInvocationInfo();
            }
        }
        finally {
            if (this.orb.subcontractDebugFlag) {
                this.dprint(".releaseServant<-");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getServant(ObjectAdapter objectAdapter, byte[] objectId, String operation) throws OADestroyed {
        try {
            if (this.orb.subcontractDebugFlag) {
                this.dprint(".getServant->");
            }
            OAInvocationInfo info = objectAdapter.makeInvocationInfo(objectId);
            info.setOperation(operation);
            this.orb.pushInvocationInfo(info);
            objectAdapter.getInvocationServant(info);
            Object object = info.getServantContainer();
            return object;
        }
        finally {
            if (this.orb.subcontractDebugFlag) {
                this.dprint(".getServant<-");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getServantWithPI(CorbaMessageMediator request, ObjectAdapter objectAdapter, byte[] objectId, ObjectKeyTemplate oktemp, String operation) throws OADestroyed {
        try {
            if (this.orb.subcontractDebugFlag) {
                this.dprint(".getServantWithPI->");
            }
            this.orb.getPIHandler().initializeServerPIInfo(request, objectAdapter, objectId, oktemp);
            this.orb.getPIHandler().invokeServerPIStartingPoint();
            objectAdapter.enter();
            if (request != null) {
                request.setExecuteReturnServantInResponseConstructor(true);
            }
            Object servant = this.getServant(objectAdapter, objectId, operation);
            String mdi = "unknown";
            if (servant instanceof NullServant) {
                this.handleNullServant(operation, (NullServant)servant);
            } else {
                mdi = objectAdapter.getInterfaces(servant, objectId)[0];
            }
            this.orb.getPIHandler().setServerPIInfo(servant, mdi);
            if (servant != null && !(servant instanceof DynamicImplementation) && !(servant instanceof org.omg.PortableServer.DynamicImplementation) || SpecialMethod.getSpecialMethod(operation) != null) {
                this.orb.getPIHandler().invokeServerPIIntermediatePoint();
            }
            Object object = servant;
            return object;
        }
        finally {
            if (this.orb.subcontractDebugFlag) {
                this.dprint(".getServantWithPI<-");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkServerId(ObjectKey okey) {
        try {
            if (this.orb.subcontractDebugFlag) {
                this.dprint(".checkServerId->");
            }
            ObjectKeyTemplate oktemp = okey.getTemplate();
            int sId = oktemp.getServerId();
            int scid = oktemp.getSubcontractId();
            if (!this.orb.isLocalServerId(scid, sId)) {
                if (this.orb.subcontractDebugFlag) {
                    this.dprint(".checkServerId: bad server id");
                }
                this.orb.handleBadServerId(okey);
            }
        }
        finally {
            if (this.orb.subcontractDebugFlag) {
                this.dprint(".checkServerId<-");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectAdapter findObjectAdapter(ObjectKeyTemplate oktemp) {
        try {
            int scid;
            RequestDispatcherRegistry scr;
            ObjectAdapterFactory oaf;
            if (this.orb.subcontractDebugFlag) {
                this.dprint(".findObjectAdapter->");
            }
            if ((oaf = (scr = this.orb.getRequestDispatcherRegistry()).getObjectAdapterFactory(scid = oktemp.getSubcontractId())) == null) {
                if (this.orb.subcontractDebugFlag) {
                    this.dprint(".findObjectAdapter: failed to find ObjectAdapterFactory");
                }
                throw this.wrapper.noObjectAdapterFactory();
            }
            ObjectAdapterId oaid = oktemp.getObjectAdapterId();
            ObjectAdapter oa = oaf.find(oaid);
            if (oa == null) {
                if (this.orb.subcontractDebugFlag) {
                    this.dprint(".findObjectAdapter: failed to find ObjectAdaptor");
                }
                throw this.wrapper.badAdapterId();
            }
            ObjectAdapter objectAdapter = oa;
            return objectAdapter;
        }
        finally {
            if (this.orb.subcontractDebugFlag) {
                this.dprint(".findObjectAdapter<-");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleNullServant(String operation, NullServant nserv) {
        try {
            SpecialMethod specialMethod;
            if (this.orb.subcontractDebugFlag) {
                this.dprint(".handleNullServant->: " + operation);
            }
            if ((specialMethod = SpecialMethod.getSpecialMethod(operation)) == null || !specialMethod.isNonExistentMethod()) {
                if (this.orb.subcontractDebugFlag) {
                    this.dprint(".handleNullServant: " + operation + ": throwing OBJECT_NOT_EXIST");
                }
                throw nserv.getException();
            }
        }
        finally {
            if (this.orb.subcontractDebugFlag) {
                this.dprint(".handleNullServant<-: " + operation);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void consumeServiceContexts(CorbaMessageMediator request) {
        try {
            ServiceContext sc;
            if (this.orb.subcontractDebugFlag) {
                this.dprint(".consumeServiceContexts->: " + this.opAndId(request));
            }
            ServiceContexts ctxts = request.getRequestServiceContexts();
            GIOPVersion giopVersion = request.getGIOPVersion();
            boolean hasCodeSetContext = this.processCodeSetContext(request, ctxts);
            if (this.orb.subcontractDebugFlag) {
                this.dprint(".consumeServiceContexts: " + this.opAndId(request) + ": GIOP version: " + giopVersion);
                this.dprint(".consumeServiceContexts: " + this.opAndId(request) + ": as code set context? " + hasCodeSetContext);
            }
            if ((sc = ctxts.get(6)) != null) {
                SendingContextServiceContext scsc = (SendingContextServiceContext)sc;
                IOR ior = scsc.getIOR();
                try {
                    ((CorbaConnection)request.getConnection()).setCodeBaseIOR(ior);
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    throw this.wrapper.badStringifiedIor(t);
                }
            }
            boolean isForeignORB = false;
            if (giopVersion.equals(GIOPVersion.V1_0) && hasCodeSetContext) {
                if (this.orb.subcontractDebugFlag) {
                    this.dprint(".consumeServiceCOntexts: " + this.opAndId(request) + ": Determined to be an old Sun ORB");
                }
                this.orb.setORBVersion(ORBVersionFactory.getOLD());
            } else {
                isForeignORB = true;
            }
            sc = ctxts.get(1313165056);
            if (sc != null) {
                ORBVersionServiceContext ovsc = (ORBVersionServiceContext)sc;
                ORBVersion version = ovsc.getVersion();
                this.orb.setORBVersion(version);
                isForeignORB = false;
            }
            if (isForeignORB) {
                if (this.orb.subcontractDebugFlag) {
                    this.dprint(".consumeServiceContexts: " + this.opAndId(request) + ": Determined to be a foreign ORB");
                }
                this.orb.setORBVersion(ORBVersionFactory.getFOREIGN());
            }
        }
        finally {
            if (this.orb.subcontractDebugFlag) {
                this.dprint(".consumeServiceContexts<-: " + this.opAndId(request));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CorbaMessageMediator dispatchToServant(Object servant, CorbaMessageMediator req, byte[] objectId, ObjectAdapter objectAdapter) {
        try {
            Object dynimpl;
            if (this.orb.subcontractDebugFlag) {
                this.dprint(".dispatchToServant->: " + this.opAndId(req));
            }
            CorbaMessageMediator response = null;
            String operation = req.getOperationName();
            SpecialMethod method = SpecialMethod.getSpecialMethod(operation);
            if (method != null) {
                if (this.orb.subcontractDebugFlag) {
                    this.dprint(".dispatchToServant: " + this.opAndId(req) + ": Handling special method");
                }
                CorbaMessageMediator corbaMessageMediator = response = method.invoke(servant, req, objectId, objectAdapter);
                return corbaMessageMediator;
            }
            if (servant instanceof DynamicImplementation) {
                if (this.orb.subcontractDebugFlag) {
                    this.dprint(".dispatchToServant: " + this.opAndId(req) + ": Handling old style DSI type servant");
                }
                dynimpl = (DynamicImplementation)servant;
                ServerRequestImpl sreq = new ServerRequestImpl(req, this.orb);
                ((DynamicImplementation)dynimpl).invoke(sreq);
                response = this.handleDynamicResult(sreq, req);
            } else if (servant instanceof org.omg.PortableServer.DynamicImplementation) {
                if (this.orb.subcontractDebugFlag) {
                    this.dprint(".dispatchToServant: " + this.opAndId(req) + ": Handling POA DSI type servant");
                }
                dynimpl = (org.omg.PortableServer.DynamicImplementation)servant;
                ServerRequestImpl sreq = new ServerRequestImpl(req, this.orb);
                ((org.omg.PortableServer.DynamicImplementation)dynimpl).invoke(sreq);
                response = this.handleDynamicResult(sreq, req);
            } else {
                if (this.orb.subcontractDebugFlag) {
                    this.dprint(".dispatchToServant: " + this.opAndId(req) + ": Handling invoke handler type servant");
                }
                InvokeHandler invhandle = (InvokeHandler)servant;
                OutputStream stream = invhandle._invoke(operation, (InputStream)((Object)req.getInputObject()), req);
                response = (CorbaMessageMediator)((OutputObject)((Object)stream)).getMessageMediator();
            }
            CorbaMessageMediator corbaMessageMediator = response;
            return corbaMessageMediator;
        }
        finally {
            if (this.orb.subcontractDebugFlag) {
                this.dprint(".dispatchToServant<-: " + this.opAndId(req));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CorbaMessageMediator handleDynamicResult(ServerRequestImpl sreq, CorbaMessageMediator req) {
        try {
            if (this.orb.subcontractDebugFlag) {
                this.dprint(".handleDynamicResult->: " + this.opAndId(req));
            }
            CorbaMessageMediator response = null;
            Any excany = sreq.checkResultCalled();
            if (excany == null) {
                if (this.orb.subcontractDebugFlag) {
                    this.dprint(".handleDynamicResult: " + this.opAndId(req) + ": handling normal result");
                }
                response = this.sendingReply(req);
                OutputStream os = (OutputStream)((Object)response.getOutputObject());
                sreq.marshalReplyParams(os);
            } else {
                if (this.orb.subcontractDebugFlag) {
                    this.dprint(".handleDynamicResult: " + this.opAndId(req) + ": handling error");
                }
                response = this.sendingReply(req, excany);
            }
            CorbaMessageMediator corbaMessageMediator = response;
            return corbaMessageMediator;
        }
        finally {
            if (this.orb.subcontractDebugFlag) {
                this.dprint(".handleDynamicResult<-: " + this.opAndId(req));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CorbaMessageMediator sendingReply(CorbaMessageMediator req) {
        try {
            if (this.orb.subcontractDebugFlag) {
                this.dprint(".sendingReply->: " + this.opAndId(req));
            }
            ServiceContexts scs = new ServiceContexts(this.orb);
            CorbaMessageMediator corbaMessageMediator = req.getProtocolHandler().createResponse(req, scs);
            return corbaMessageMediator;
        }
        finally {
            if (this.orb.subcontractDebugFlag) {
                this.dprint(".sendingReply<-: " + this.opAndId(req));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CorbaMessageMediator sendingReply(CorbaMessageMediator req, Any excany) {
        try {
            CorbaMessageMediator resp;
            if (this.orb.subcontractDebugFlag) {
                this.dprint(".sendingReply/Any->: " + this.opAndId(req));
            }
            ServiceContexts scs = new ServiceContexts(this.orb);
            String repId = null;
            try {
                repId = excany.type().id();
            }
            catch (BadKind e) {
                throw this.wrapper.problemWithExceptionTypecode(e);
            }
            if (ORBUtility.isSystemException(repId)) {
                if (this.orb.subcontractDebugFlag) {
                    this.dprint(".sendingReply/Any: " + this.opAndId(req) + ": handling system exception");
                }
                InputStream in = excany.create_input_stream();
                SystemException ex = ORBUtility.readSystemException(in);
                resp = req.getProtocolHandler().createSystemExceptionResponse(req, ex, scs);
            } else {
                if (this.orb.subcontractDebugFlag) {
                    this.dprint(".sendingReply/Any: " + this.opAndId(req) + ": handling user exception");
                }
                resp = req.getProtocolHandler().createUserExceptionResponse(req, scs);
                OutputStream os = (OutputStream)((Object)resp.getOutputObject());
                excany.write_value(os);
            }
            CorbaMessageMediator corbaMessageMediator = resp;
            return corbaMessageMediator;
        }
        finally {
            if (this.orb.subcontractDebugFlag) {
                this.dprint(".sendingReply/Any<-: " + this.opAndId(req));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean processCodeSetContext(CorbaMessageMediator request, ServiceContexts contexts) {
        try {
            ServiceContext sc;
            if (this.orb.subcontractDebugFlag) {
                this.dprint(".processCodeSetContext->: " + this.opAndId(request));
            }
            if ((sc = contexts.get(1)) != null) {
                if (request.getConnection() == null) {
                    boolean bl = true;
                    return bl;
                }
                if (request.getGIOPVersion().equals(GIOPVersion.V1_0)) {
                    boolean bl = true;
                    return bl;
                }
                CodeSetServiceContext cssc = (CodeSetServiceContext)sc;
                CodeSetComponentInfo.CodeSetContext csctx = cssc.getCodeSetContext();
                if (((CorbaConnection)request.getConnection()).getCodeSetContext() == null) {
                    if (this.orb.subcontractDebugFlag) {
                        this.dprint(".processCodeSetContext: " + this.opAndId(request) + ": Setting code sets to: " + csctx);
                    }
                    ((CorbaConnection)request.getConnection()).setCodeSetContext(csctx);
                    if (csctx.getCharCodeSet() != OSFCodeSetRegistry.ISO_8859_1.getNumber()) {
                        ((MarshalInputStream)((Object)request.getInputObject())).resetCodeSetConverters();
                    }
                }
            }
            boolean bl = sc != null;
            return bl;
        }
        finally {
            if (this.orb.subcontractDebugFlag) {
                this.dprint(".processCodeSetContext<-: " + this.opAndId(request));
            }
        }
    }

    protected void dprint(String msg) {
        ORBUtility.dprint("CorbaServerRequestDispatcherImpl", msg);
    }

    protected String opAndId(CorbaMessageMediator mediator) {
        return ORBUtility.operationNameAndRequestId(mediator);
    }
}

