/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.MutableBigInteger;
import java.math.RoundingMode;
import java.util.Arrays;

public class BigDecimal
extends Number
implements Comparable<BigDecimal> {
    private volatile BigInteger intVal;
    private int scale;
    private transient int precision;
    private transient String stringCache;
    static final long INFLATED = Long.MIN_VALUE;
    private transient long intCompact;
    private static final int MAX_COMPACT_DIGITS = 18;
    private static final int MAX_BIGINT_BITS = 62;
    private static final long serialVersionUID = 6108874887143696463L;
    private static final ThreadLocal<StringBuilderHelper> threadLocalStringBuilderHelper = new ThreadLocal<StringBuilderHelper>(){

        @Override
        protected StringBuilderHelper initialValue() {
            return new StringBuilderHelper();
        }
    };
    private static final BigDecimal[] zeroThroughTen = new BigDecimal[]{new BigDecimal(BigInteger.ZERO, 0L, 0, 1), new BigDecimal(BigInteger.ONE, 1L, 0, 1), new BigDecimal(BigInteger.valueOf(2L), 2L, 0, 1), new BigDecimal(BigInteger.valueOf(3L), 3L, 0, 1), new BigDecimal(BigInteger.valueOf(4L), 4L, 0, 1), new BigDecimal(BigInteger.valueOf(5L), 5L, 0, 1), new BigDecimal(BigInteger.valueOf(6L), 6L, 0, 1), new BigDecimal(BigInteger.valueOf(7L), 7L, 0, 1), new BigDecimal(BigInteger.valueOf(8L), 8L, 0, 1), new BigDecimal(BigInteger.valueOf(9L), 9L, 0, 1), new BigDecimal(BigInteger.TEN, 10L, 0, 2)};
    private static final BigDecimal[] ZERO_SCALED_BY = new BigDecimal[]{zeroThroughTen[0], new BigDecimal(BigInteger.ZERO, 0L, 1, 1), new BigDecimal(BigInteger.ZERO, 0L, 2, 1), new BigDecimal(BigInteger.ZERO, 0L, 3, 1), new BigDecimal(BigInteger.ZERO, 0L, 4, 1), new BigDecimal(BigInteger.ZERO, 0L, 5, 1), new BigDecimal(BigInteger.ZERO, 0L, 6, 1), new BigDecimal(BigInteger.ZERO, 0L, 7, 1), new BigDecimal(BigInteger.ZERO, 0L, 8, 1), new BigDecimal(BigInteger.ZERO, 0L, 9, 1), new BigDecimal(BigInteger.ZERO, 0L, 10, 1), new BigDecimal(BigInteger.ZERO, 0L, 11, 1), new BigDecimal(BigInteger.ZERO, 0L, 12, 1), new BigDecimal(BigInteger.ZERO, 0L, 13, 1), new BigDecimal(BigInteger.ZERO, 0L, 14, 1), new BigDecimal(BigInteger.ZERO, 0L, 15, 1)};
    private static final long HALF_LONG_MAX_VALUE = 0x3FFFFFFFFFFFFFFFL;
    private static final long HALF_LONG_MIN_VALUE = -4611686018427387904L;
    public static final BigDecimal ZERO = zeroThroughTen[0];
    public static final BigDecimal ONE = zeroThroughTen[1];
    public static final BigDecimal TEN = zeroThroughTen[10];
    public static final int ROUND_UP = 0;
    public static final int ROUND_DOWN = 1;
    public static final int ROUND_CEILING = 2;
    public static final int ROUND_FLOOR = 3;
    public static final int ROUND_HALF_UP = 4;
    public static final int ROUND_HALF_DOWN = 5;
    public static final int ROUND_HALF_EVEN = 6;
    public static final int ROUND_UNNECESSARY = 7;
    private static final long[] LONG_TEN_POWERS_TABLE = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};
    private static volatile BigInteger[] BIG_TEN_POWERS_TABLE = new BigInteger[]{BigInteger.ONE, BigInteger.valueOf(10L), BigInteger.valueOf(100L), BigInteger.valueOf(1000L), BigInteger.valueOf(10000L), BigInteger.valueOf(100000L), BigInteger.valueOf(1000000L), BigInteger.valueOf(10000000L), BigInteger.valueOf(100000000L), BigInteger.valueOf(1000000000L), BigInteger.valueOf(10000000000L), BigInteger.valueOf(100000000000L), BigInteger.valueOf(1000000000000L), BigInteger.valueOf(10000000000000L), BigInteger.valueOf(100000000000000L), BigInteger.valueOf(1000000000000000L), BigInteger.valueOf(10000000000000000L), BigInteger.valueOf(100000000000000000L), BigInteger.valueOf(1000000000000000000L)};
    private static final int BIG_TEN_POWERS_TABLE_INITLEN = BIG_TEN_POWERS_TABLE.length;
    private static final int BIG_TEN_POWERS_TABLE_MAX = 16 * BIG_TEN_POWERS_TABLE_INITLEN;
    private static final long[] THRESHOLDS_TABLE = new long[]{Long.MAX_VALUE, 0xCCCCCCCCCCCCCCCL, 92233720368547758L, 9223372036854775L, 922337203685477L, 92233720368547L, 9223372036854L, 922337203685L, 92233720368L, 9223372036L, 922337203L, 92233720L, 0x8CBCCCL, 922337L, 92233L, 9223L, 922L, 92L, 9L};

    BigDecimal(BigInteger intVal, long val, int scale, int prec) {
        this.scale = scale;
        this.precision = prec;
        this.intCompact = val;
        this.intVal = intVal;
    }

    public BigDecimal(char[] in, int offset, int len) {
        if (offset + len > in.length || offset < 0) {
            throw new NumberFormatException();
        }
        int prec = 0;
        int scl = 0;
        long rs = 0L;
        BigInteger rb = null;
        try {
            boolean isneg = false;
            if (in[offset] == '-') {
                isneg = true;
                ++offset;
                --len;
            } else if (in[offset] == '+') {
                ++offset;
                --len;
            }
            boolean dot = false;
            int cfirst = offset;
            long exp = 0L;
            boolean isCompact = len <= 18;
            char[] coeff = isCompact ? null : new char[len];
            int idx = 0;
            while (len > 0) {
                char c = in[offset];
                if (c >= '0' && c <= '9' || Character.isDigit(c)) {
                    if (isCompact) {
                        int digit = Character.digit(c, 10);
                        if (digit == 0) {
                            if (prec == 0) {
                                prec = 1;
                            } else if (rs != 0L) {
                                rs *= 10L;
                                ++prec;
                            }
                        } else {
                            if (prec != 1 || rs != 0L) {
                                ++prec;
                            }
                            rs = rs * 10L + (long)digit;
                        }
                    } else if (c == '0' || Character.digit(c, 10) == 0) {
                        if (prec == 0) {
                            coeff[idx] = c;
                            prec = 1;
                        } else if (idx != 0) {
                            coeff[idx++] = c;
                            ++prec;
                        }
                    } else {
                        if (prec != 1 || idx != 0) {
                            ++prec;
                        }
                        coeff[idx++] = c;
                    }
                    if (dot) {
                        ++scl;
                    }
                } else if (c == '.') {
                    if (dot) {
                        throw new NumberFormatException();
                    }
                    dot = true;
                } else {
                    boolean negexp;
                    if (c != 'e' && c != 'E') {
                        throw new NumberFormatException();
                    }
                    c = in[++offset];
                    --len;
                    boolean bl = negexp = c == '-';
                    if (negexp || c == '+') {
                        c = in[++offset];
                        --len;
                    }
                    if (len <= 0) {
                        throw new NumberFormatException();
                    }
                    while (len > 10 && Character.digit(c, 10) == 0) {
                        c = in[++offset];
                        --len;
                    }
                    if (len > 10) {
                        throw new NumberFormatException();
                    }
                    while (true) {
                        int v;
                        if (c >= '0' && c <= '9') {
                            v = c - 48;
                        } else {
                            v = Character.digit(c, 10);
                            if (v < 0) {
                                throw new NumberFormatException();
                            }
                        }
                        exp = exp * 10L + (long)v;
                        if (len == 1) break;
                        c = in[++offset];
                        --len;
                    }
                    if (negexp) {
                        exp = -exp;
                    }
                    if ((long)((int)exp) == exp) break;
                    throw new NumberFormatException();
                }
                ++offset;
                --len;
            }
            if (prec == 0) {
                throw new NumberFormatException();
            }
            if (exp != 0L) {
                long adjustedScale = (long)scl - exp;
                if (adjustedScale > Integer.MAX_VALUE || adjustedScale < Integer.MIN_VALUE) {
                    throw new NumberFormatException("Scale out of range.");
                }
                scl = (int)adjustedScale;
            }
            if (isCompact) {
                rs = isneg ? -rs : rs;
            } else {
                char[] quick;
                if (!isneg) {
                    quick = coeff.length != prec ? Arrays.copyOf(coeff, prec) : coeff;
                } else {
                    quick = new char[prec + 1];
                    quick[0] = 45;
                    System.arraycopy(coeff, 0, quick, 1, prec);
                }
                rb = new BigInteger(quick);
                rs = BigDecimal.compactValFor(rb);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new NumberFormatException();
        }
        catch (NegativeArraySizeException e) {
            throw new NumberFormatException();
        }
        this.scale = scl;
        this.precision = prec;
        this.intCompact = rs;
        this.intVal = rs != Long.MIN_VALUE ? null : rb;
    }

    public BigDecimal(char[] in, int offset, int len, MathContext mc) {
        this(in, offset, len);
        if (mc.precision > 0) {
            this.roundThis(mc);
        }
    }

    public BigDecimal(char[] in) {
        this(in, 0, in.length);
    }

    public BigDecimal(char[] in, MathContext mc) {
        this(in, 0, in.length, mc);
    }

    public BigDecimal(String val) {
        this(val.toCharArray(), 0, val.length());
    }

    public BigDecimal(String val, MathContext mc) {
        this(val.toCharArray(), 0, val.length());
        if (mc.precision > 0) {
            this.roundThis(mc);
        }
    }

    public BigDecimal(double val) {
        BigInteger b;
        if (Double.isInfinite(val) || Double.isNaN(val)) {
            throw new NumberFormatException("Infinite or NaN");
        }
        long valBits = Double.doubleToLongBits(val);
        int sign = valBits >> 63 == 0L ? 1 : -1;
        int exponent = (int)(valBits >> 52 & 0x7FFL);
        long significand = exponent == 0 ? (valBits & 0xFFFFFFFFFFFFFL) << 1 : valBits & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
        exponent -= 1075;
        if (significand == 0L) {
            this.intVal = BigInteger.ZERO;
            this.intCompact = 0L;
            this.precision = 1;
            return;
        }
        while ((significand & 1L) == 0L) {
            significand >>= 1;
            ++exponent;
        }
        long s = (long)sign * significand;
        if (exponent < 0) {
            b = BigInteger.valueOf(5L).pow(-exponent).multiply(s);
            this.scale = -exponent;
        } else {
            b = exponent > 0 ? BigInteger.valueOf(2L).pow(exponent).multiply(s) : BigInteger.valueOf(s);
        }
        this.intCompact = BigDecimal.compactValFor(b);
        this.intVal = this.intCompact != Long.MIN_VALUE ? null : b;
    }

    public BigDecimal(double val, MathContext mc) {
        this(val);
        if (mc.precision > 0) {
            this.roundThis(mc);
        }
    }

    public BigDecimal(BigInteger val) {
        this.intCompact = BigDecimal.compactValFor(val);
        this.intVal = this.intCompact != Long.MIN_VALUE ? null : val;
    }

    public BigDecimal(BigInteger val, MathContext mc) {
        this(val);
        if (mc.precision > 0) {
            this.roundThis(mc);
        }
    }

    public BigDecimal(BigInteger unscaledVal, int scale) {
        this(unscaledVal);
        this.scale = scale;
    }

    public BigDecimal(BigInteger unscaledVal, int scale, MathContext mc) {
        this(unscaledVal);
        this.scale = scale;
        if (mc.precision > 0) {
            this.roundThis(mc);
        }
    }

    public BigDecimal(int val) {
        this.intCompact = val;
    }

    public BigDecimal(int val, MathContext mc) {
        this.intCompact = val;
        if (mc.precision > 0) {
            this.roundThis(mc);
        }
    }

    public BigDecimal(long val) {
        this.intCompact = val;
        this.intVal = val == Long.MIN_VALUE ? BigInteger.valueOf(val) : null;
    }

    public BigDecimal(long val, MathContext mc) {
        this(val);
        if (mc.precision > 0) {
            this.roundThis(mc);
        }
    }

    public static BigDecimal valueOf(long unscaledVal, int scale) {
        if (scale == 0) {
            return BigDecimal.valueOf(unscaledVal);
        }
        if (unscaledVal == 0L) {
            if (scale > 0 && scale < ZERO_SCALED_BY.length) {
                return ZERO_SCALED_BY[scale];
            }
            return new BigDecimal(BigInteger.ZERO, 0L, scale, 1);
        }
        return new BigDecimal(unscaledVal == Long.MIN_VALUE ? BigInteger.valueOf(unscaledVal) : null, unscaledVal, scale, 0);
    }

    public static BigDecimal valueOf(long val) {
        if (val >= 0L && val < (long)zeroThroughTen.length) {
            return zeroThroughTen[(int)val];
        }
        if (val != Long.MIN_VALUE) {
            return new BigDecimal(null, val, 0, 0);
        }
        return new BigDecimal(BigInteger.valueOf(val), val, 0, 0);
    }

    public static BigDecimal valueOf(double val) {
        return new BigDecimal(Double.toString(val));
    }

    public BigDecimal add(BigDecimal augend) {
        long sum;
        long xs = this.intCompact;
        long ys = augend.intCompact;
        BigInteger fst = xs != Long.MIN_VALUE ? null : this.intVal;
        BigInteger snd = ys != Long.MIN_VALUE ? null : augend.intVal;
        int rscale = this.scale;
        long sdiff = (long)rscale - (long)augend.scale;
        if (sdiff != 0L) {
            int raise;
            if (sdiff < 0L) {
                raise = this.checkScale(-sdiff);
                rscale = augend.scale;
                if (xs == Long.MIN_VALUE || (xs = BigDecimal.longMultiplyPowerTen(xs, raise)) == Long.MIN_VALUE) {
                    fst = this.bigMultiplyPowerTen(raise);
                }
            } else {
                raise = augend.checkScale(sdiff);
                if (ys == Long.MIN_VALUE || (ys = BigDecimal.longMultiplyPowerTen(ys, raise)) == Long.MIN_VALUE) {
                    snd = augend.bigMultiplyPowerTen(raise);
                }
            }
        }
        if (xs != Long.MIN_VALUE && ys != Long.MIN_VALUE && (((sum = xs + ys) ^ xs) & (sum ^ ys)) >= 0L) {
            return BigDecimal.valueOf(sum, rscale);
        }
        if (fst == null) {
            fst = BigInteger.valueOf(xs);
        }
        if (snd == null) {
            snd = BigInteger.valueOf(ys);
        }
        BigInteger sum2 = fst.add(snd);
        return fst.signum == snd.signum ? new BigDecimal(sum2, Long.MIN_VALUE, rscale, 0) : new BigDecimal(sum2, rscale);
    }

    public BigDecimal add(BigDecimal augend, MathContext mc) {
        boolean augendIsZero;
        if (mc.precision == 0) {
            return this.add(augend);
        }
        BigDecimal lhs = this;
        this.inflate();
        augend.inflate();
        boolean lhsIsZero = lhs.signum() == 0;
        boolean bl = augendIsZero = augend.signum() == 0;
        if (lhsIsZero || augendIsZero) {
            int scaleDiff;
            BigDecimal result;
            int preferredScale = Math.max(lhs.scale(), augend.scale());
            if (lhsIsZero && augendIsZero) {
                return new BigDecimal(BigInteger.ZERO, 0L, preferredScale, 0);
            }
            BigDecimal bigDecimal = result = lhsIsZero ? BigDecimal.doRound(augend, mc) : BigDecimal.doRound(lhs, mc);
            if (result.scale() == preferredScale) {
                return result;
            }
            if (result.scale() > preferredScale) {
                BigDecimal scaledResult = new BigDecimal(result.intVal, result.intCompact, result.scale, 0);
                scaledResult.stripZerosToMatchScale(preferredScale);
                return scaledResult;
            }
            int precisionDiff = mc.precision - result.precision();
            if (precisionDiff >= (scaleDiff = preferredScale - result.scale())) {
                return result.setScale(preferredScale);
            }
            return result.setScale(result.scale() + precisionDiff);
        }
        long padding = (long)lhs.scale - (long)augend.scale;
        if (padding != 0L) {
            BigDecimal[] arg = this.preAlign(lhs, augend, padding, mc);
            BigDecimal.matchScale(arg);
            lhs = arg[0];
            augend = arg[1];
        }
        BigDecimal d = new BigDecimal(lhs.inflate().add(augend.inflate()), lhs.scale);
        return BigDecimal.doRound(d, mc);
    }

    private BigDecimal[] preAlign(BigDecimal lhs, BigDecimal augend, long padding, MathContext mc) {
        BigDecimal small;
        BigDecimal big;
        assert (padding != 0L);
        if (padding < 0L) {
            big = lhs;
            small = augend;
        } else {
            big = augend;
            small = lhs;
        }
        long estResultUlpScale = (long)big.scale - (long)big.precision() + (long)mc.precision;
        long smallHighDigitPos = (long)small.scale - (long)small.precision() + 1L;
        if (smallHighDigitPos > (long)(big.scale + 2) && smallHighDigitPos > estResultUlpScale + 2L) {
            small = BigDecimal.valueOf(small.signum(), this.checkScale(Math.max((long)big.scale, estResultUlpScale) + 3L));
        }
        BigDecimal[] result = new BigDecimal[]{big, small};
        return result;
    }

    public BigDecimal subtract(BigDecimal subtrahend) {
        return this.add(subtrahend.negate());
    }

    public BigDecimal subtract(BigDecimal subtrahend, MathContext mc) {
        BigDecimal nsubtrahend = subtrahend.negate();
        if (mc.precision == 0) {
            return this.add(nsubtrahend);
        }
        return this.add(nsubtrahend, mc);
    }

    public BigDecimal multiply(BigDecimal multiplicand) {
        long x = this.intCompact;
        long y = multiplicand.intCompact;
        int productScale = this.checkScale((long)this.scale + (long)multiplicand.scale);
        if (x != Long.MIN_VALUE && y != Long.MIN_VALUE) {
            long product = x * y;
            long prec = this.precision() + multiplicand.precision();
            if (prec < 19L || prec < 21L && (y == 0L || product / y == x)) {
                return BigDecimal.valueOf(product, productScale);
            }
            return new BigDecimal(BigInteger.valueOf(x).multiply(y), Long.MIN_VALUE, productScale, 0);
        }
        BigInteger rb = x == Long.MIN_VALUE && y == Long.MIN_VALUE ? this.intVal.multiply(multiplicand.intVal) : (x != Long.MIN_VALUE ? multiplicand.intVal.multiply(x) : this.intVal.multiply(y));
        return new BigDecimal(rb, Long.MIN_VALUE, productScale, 0);
    }

    public BigDecimal multiply(BigDecimal multiplicand, MathContext mc) {
        if (mc.precision == 0) {
            return this.multiply(multiplicand);
        }
        return BigDecimal.doRound(this.multiply(multiplicand), mc);
    }

    public BigDecimal divide(BigDecimal divisor, int scale, int roundingMode) {
        if (roundingMode < 0 || roundingMode > 7) {
            throw new IllegalArgumentException("Invalid rounding mode");
        }
        BigDecimal dividend = this;
        if (this.checkScale((long)scale + (long)divisor.scale) > this.scale) {
            dividend = this.setScale(scale + divisor.scale, 7);
        } else {
            divisor = divisor.setScale(this.checkScale((long)this.scale - (long)scale), 7);
        }
        return BigDecimal.divideAndRound(dividend.intCompact, dividend.intVal, divisor.intCompact, divisor.intVal, scale, roundingMode, scale);
    }

    private static BigDecimal divideAndRound(long ldividend, BigInteger bdividend, long ldivisor, BigInteger bdivisor, int scale, int roundingMode, int preferredScale) {
        BigDecimal res;
        int qsign;
        boolean isRemainderZero;
        boolean isLongDivision;
        long q = 0L;
        long r = 0L;
        MutableBigInteger mq = null;
        MutableBigInteger mr = null;
        MutableBigInteger mdivisor = null;
        boolean bl = isLongDivision = ldividend != Long.MIN_VALUE && ldivisor != Long.MIN_VALUE;
        if (isLongDivision) {
            q = ldividend / ldivisor;
            if (roundingMode == 1 && scale == preferredScale) {
                return new BigDecimal(null, q, scale, 0);
            }
            r = ldividend % ldivisor;
            isRemainderZero = r == 0L;
            qsign = ldividend < 0L == ldivisor < 0L ? 1 : -1;
        } else {
            if (bdividend == null) {
                bdividend = BigInteger.valueOf(ldividend);
            }
            MutableBigInteger mdividend = new MutableBigInteger(bdividend.mag);
            mq = new MutableBigInteger();
            if (ldivisor != Long.MIN_VALUE) {
                r = mdividend.divide(ldivisor, mq);
                isRemainderZero = r == 0L;
                qsign = ldivisor < 0L ? -bdividend.signum : bdividend.signum;
            } else {
                mdivisor = new MutableBigInteger(bdivisor.mag);
                mr = mdividend.divide(mdivisor, mq);
                isRemainderZero = mr.isZero();
                qsign = bdividend.signum != bdivisor.signum ? -1 : 1;
            }
        }
        boolean increment = false;
        if (!isRemainderZero) {
            if (roundingMode == 7) {
                throw new ArithmeticException("Rounding necessary");
            }
            if (roundingMode == 0) {
                increment = true;
            } else if (roundingMode == 1) {
                increment = false;
            } else if (roundingMode == 2) {
                increment = qsign > 0;
            } else if (roundingMode == 3) {
                increment = qsign < 0;
            } else {
                int cmpFracHalf = isLongDivision || ldivisor != Long.MIN_VALUE ? (r <= -4611686018427387904L || r > 0x3FFFFFFFFFFFFFFFL ? 1 : BigDecimal.longCompareMagnitude(2L * r, ldivisor)) : mr.compareHalf(mdivisor);
                if (cmpFracHalf < 0) {
                    increment = false;
                } else if (cmpFracHalf > 0) {
                    increment = true;
                } else if (roundingMode == 4) {
                    increment = true;
                } else if (roundingMode == 5) {
                    increment = false;
                } else {
                    boolean bl2 = isLongDivision ? (q & 1L) != 0L : (increment = mq.isOdd());
                }
            }
        }
        if (isLongDivision) {
            res = new BigDecimal(null, increment ? q + (long)qsign : q, scale, 0);
        } else {
            if (increment) {
                mq.add(MutableBigInteger.ONE);
            }
            res = mq.toBigDecimal(qsign, scale);
        }
        if (isRemainderZero && preferredScale != scale) {
            res.stripZerosToMatchScale(preferredScale);
        }
        return res;
    }

    public BigDecimal divide(BigDecimal divisor, int scale, RoundingMode roundingMode) {
        return this.divide(divisor, scale, roundingMode.oldMode);
    }

    public BigDecimal divide(BigDecimal divisor, int roundingMode) {
        return this.divide(divisor, this.scale, roundingMode);
    }

    public BigDecimal divide(BigDecimal divisor, RoundingMode roundingMode) {
        return this.divide(divisor, this.scale, roundingMode.oldMode);
    }

    public BigDecimal divide(BigDecimal divisor) {
        BigDecimal quotient;
        if (divisor.signum() == 0) {
            if (this.signum() == 0) {
                throw new ArithmeticException("Division undefined");
            }
            throw new ArithmeticException("Division by zero");
        }
        int preferredScale = BigDecimal.saturateLong((long)this.scale - (long)divisor.scale);
        if (this.signum() == 0) {
            return preferredScale >= 0 && preferredScale < ZERO_SCALED_BY.length ? ZERO_SCALED_BY[preferredScale] : BigDecimal.valueOf(0L, preferredScale);
        }
        this.inflate();
        divisor.inflate();
        MathContext mc = new MathContext((int)Math.min((long)this.precision() + (long)Math.ceil(10.0 * (double)divisor.precision() / 3.0), Integer.MAX_VALUE), RoundingMode.UNNECESSARY);
        try {
            quotient = this.divide(divisor, mc);
        }
        catch (ArithmeticException e) {
            throw new ArithmeticException("Non-terminating decimal expansion; no exact representable decimal result.");
        }
        int quotientScale = quotient.scale();
        if (preferredScale > quotientScale) {
            return quotient.setScale(preferredScale, 7);
        }
        return quotient;
    }

    public BigDecimal divide(BigDecimal divisor, MathContext mc) {
        int yscale;
        int mcp = mc.precision;
        if (mcp == 0) {
            return this.divide(divisor);
        }
        BigDecimal dividend = this;
        long preferredScale = (long)dividend.scale - (long)divisor.scale;
        if (divisor.signum() == 0) {
            if (dividend.signum() == 0) {
                throw new ArithmeticException("Division undefined");
            }
            throw new ArithmeticException("Division by zero");
        }
        if (dividend.signum() == 0) {
            return new BigDecimal(BigInteger.ZERO, 0L, BigDecimal.saturateLong(preferredScale), 1);
        }
        int xscale = dividend.precision();
        if ((dividend = new BigDecimal(dividend.intVal, dividend.intCompact, xscale, xscale)).compareMagnitude(divisor = new BigDecimal(divisor.intVal, divisor.intCompact, yscale = divisor.precision(), yscale)) > 0) {
            yscale = --divisor.scale;
        }
        int scl = this.checkScale(preferredScale + (long)yscale - (long)xscale + (long)mcp);
        if (this.checkScale((long)mcp + (long)yscale) > xscale) {
            dividend = dividend.setScale(mcp + yscale, 7);
        } else {
            divisor = divisor.setScale(this.checkScale((long)xscale - (long)mcp), 7);
        }
        BigDecimal quotient = BigDecimal.divideAndRound(dividend.intCompact, dividend.intVal, divisor.intCompact, divisor.intVal, scl, mc.roundingMode.oldMode, this.checkScale(preferredScale));
        quotient = BigDecimal.doRound(quotient, mc);
        return quotient;
    }

    public BigDecimal divideToIntegralValue(BigDecimal divisor) {
        int preferredScale = BigDecimal.saturateLong((long)this.scale - (long)divisor.scale);
        if (this.compareMagnitude(divisor) < 0) {
            return BigDecimal.valueOf(0L, preferredScale);
        }
        if (this.signum() == 0 && divisor.signum() != 0) {
            return this.setScale(preferredScale, 7);
        }
        int maxDigits = (int)Math.min((long)this.precision() + (long)Math.ceil(10.0 * (double)divisor.precision() / 3.0) + Math.abs((long)this.scale() - (long)divisor.scale()) + 2L, Integer.MAX_VALUE);
        BigDecimal quotient = this.divide(divisor, new MathContext(maxDigits, RoundingMode.DOWN));
        if (quotient.scale > 0) {
            quotient = quotient.setScale(0, RoundingMode.DOWN);
            quotient.stripZerosToMatchScale(preferredScale);
        }
        if (quotient.scale < preferredScale) {
            quotient = quotient.setScale(preferredScale, 7);
        }
        return quotient;
    }

    public BigDecimal divideToIntegralValue(BigDecimal divisor, MathContext mc) {
        int precisionDiff;
        if (mc.precision == 0 || this.compareMagnitude(divisor) < 0) {
            return this.divideToIntegralValue(divisor);
        }
        int preferredScale = BigDecimal.saturateLong((long)this.scale - (long)divisor.scale);
        BigDecimal result = this.divide(divisor, new MathContext(mc.precision, RoundingMode.DOWN));
        if (result.scale() < 0) {
            BigDecimal product = result.multiply(divisor);
            if (this.subtract(product).compareMagnitude(divisor) >= 0) {
                throw new ArithmeticException("Division impossible");
            }
        } else if (result.scale() > 0) {
            result = result.setScale(0, RoundingMode.DOWN);
        }
        if (preferredScale > result.scale() && (precisionDiff = mc.precision - result.precision()) > 0) {
            return result.setScale(result.scale() + Math.min(precisionDiff, preferredScale - result.scale));
        }
        result.stripZerosToMatchScale(preferredScale);
        return result;
    }

    public BigDecimal remainder(BigDecimal divisor) {
        BigDecimal[] divrem = this.divideAndRemainder(divisor);
        return divrem[1];
    }

    public BigDecimal remainder(BigDecimal divisor, MathContext mc) {
        BigDecimal[] divrem = this.divideAndRemainder(divisor, mc);
        return divrem[1];
    }

    public BigDecimal[] divideAndRemainder(BigDecimal divisor) {
        BigDecimal[] result;
        result = new BigDecimal[]{this.divideToIntegralValue(divisor), this.subtract(result[0].multiply(divisor))};
        return result;
    }

    public BigDecimal[] divideAndRemainder(BigDecimal divisor, MathContext mc) {
        if (mc.precision == 0) {
            return this.divideAndRemainder(divisor);
        }
        BigDecimal[] result = new BigDecimal[2];
        BigDecimal lhs = this;
        result[0] = lhs.divideToIntegralValue(divisor, mc);
        result[1] = lhs.subtract(result[0].multiply(divisor));
        return result;
    }

    public BigDecimal pow(int n) {
        if (n < 0 || n > 999999999) {
            throw new ArithmeticException("Invalid operation");
        }
        int newScale = this.checkScale((long)this.scale * (long)n);
        this.inflate();
        return new BigDecimal(this.intVal.pow(n), newScale);
    }

    public BigDecimal pow(int n, MathContext mc) {
        if (mc.precision == 0) {
            return this.pow(n);
        }
        if (n < -999999999 || n > 999999999) {
            throw new ArithmeticException("Invalid operation");
        }
        if (n == 0) {
            return ONE;
        }
        this.inflate();
        BigDecimal lhs = this;
        MathContext workmc = mc;
        int mag = Math.abs(n);
        if (mc.precision > 0) {
            int elength = BigDecimal.longDigitLength(mag);
            if (elength > mc.precision) {
                throw new ArithmeticException("Invalid operation");
            }
            workmc = new MathContext(mc.precision + elength + 1, mc.roundingMode);
        }
        BigDecimal acc = ONE;
        boolean seenbit = false;
        int i = 1;
        while (true) {
            if ((mag += mag) < 0) {
                seenbit = true;
                acc = acc.multiply(lhs, workmc);
            }
            if (i == 31) break;
            if (seenbit) {
                acc = acc.multiply(acc, workmc);
            }
            ++i;
        }
        if (n < 0) {
            acc = ONE.divide(acc, workmc);
        }
        return BigDecimal.doRound(acc, mc);
    }

    public BigDecimal abs() {
        return this.signum() < 0 ? this.negate() : this;
    }

    public BigDecimal abs(MathContext mc) {
        return this.signum() < 0 ? this.negate(mc) : this.plus(mc);
    }

    public BigDecimal negate() {
        BigDecimal result;
        if (this.intCompact != Long.MIN_VALUE) {
            result = BigDecimal.valueOf(-this.intCompact, this.scale);
        } else {
            result = new BigDecimal(this.intVal.negate(), this.scale);
            result.precision = this.precision;
        }
        return result;
    }

    public BigDecimal negate(MathContext mc) {
        return this.negate().plus(mc);
    }

    public BigDecimal plus() {
        return this;
    }

    public BigDecimal plus(MathContext mc) {
        if (mc.precision == 0) {
            return this;
        }
        return BigDecimal.doRound(this, mc);
    }

    public int signum() {
        return this.intCompact != Long.MIN_VALUE ? Long.signum(this.intCompact) : this.intVal.signum();
    }

    public int scale() {
        return this.scale;
    }

    public int precision() {
        int result = this.precision;
        if (result == 0) {
            long s = this.intCompact;
            result = s != Long.MIN_VALUE ? BigDecimal.longDigitLength(s) : BigDecimal.bigDigitLength(this.inflate());
            this.precision = result;
        }
        return result;
    }

    public BigInteger unscaledValue() {
        return this.inflate();
    }

    public BigDecimal round(MathContext mc) {
        return this.plus(mc);
    }

    public BigDecimal setScale(int newScale, RoundingMode roundingMode) {
        return this.setScale(newScale, roundingMode.oldMode);
    }

    public BigDecimal setScale(int newScale, int roundingMode) {
        if (roundingMode < 0 || roundingMode > 7) {
            throw new IllegalArgumentException("Invalid rounding mode");
        }
        int oldScale = this.scale;
        if (newScale == oldScale) {
            return this;
        }
        if (this.signum() == 0) {
            return BigDecimal.valueOf(0L, newScale);
        }
        long rs = this.intCompact;
        if (newScale > oldScale) {
            int raise = this.checkScale((long)newScale - (long)oldScale);
            BigInteger rb = null;
            if (rs == Long.MIN_VALUE || (rs = BigDecimal.longMultiplyPowerTen(rs, raise)) == Long.MIN_VALUE) {
                rb = this.bigMultiplyPowerTen(raise);
            }
            return new BigDecimal(rb, rs, newScale, this.precision > 0 ? this.precision + raise : 0);
        }
        int drop = this.checkScale((long)oldScale - (long)newScale);
        if (drop < LONG_TEN_POWERS_TABLE.length) {
            return BigDecimal.divideAndRound(rs, this.intVal, LONG_TEN_POWERS_TABLE[drop], null, newScale, roundingMode, newScale);
        }
        return BigDecimal.divideAndRound(rs, this.intVal, Long.MIN_VALUE, BigDecimal.bigTenToThe(drop), newScale, roundingMode, newScale);
    }

    public BigDecimal setScale(int newScale) {
        return this.setScale(newScale, 7);
    }

    public BigDecimal movePointLeft(int n) {
        int newScale = this.checkScale((long)this.scale + (long)n);
        BigDecimal num = new BigDecimal(this.intVal, this.intCompact, newScale, 0);
        return num.scale < 0 ? num.setScale(0, 7) : num;
    }

    public BigDecimal movePointRight(int n) {
        int newScale = this.checkScale((long)this.scale - (long)n);
        BigDecimal num = new BigDecimal(this.intVal, this.intCompact, newScale, 0);
        return num.scale < 0 ? num.setScale(0, 7) : num;
    }

    public BigDecimal scaleByPowerOfTen(int n) {
        return new BigDecimal(this.intVal, this.intCompact, this.checkScale((long)this.scale - (long)n), this.precision);
    }

    public BigDecimal stripTrailingZeros() {
        this.inflate();
        BigDecimal result = new BigDecimal(this.intVal, this.scale);
        result.stripZerosToMatchScale(Long.MIN_VALUE);
        return result;
    }

    @Override
    public int compareTo(BigDecimal val) {
        int ysign;
        int xsign;
        if (this.scale == val.scale) {
            long xs = this.intCompact;
            long ys = val.intCompact;
            if (xs != Long.MIN_VALUE && ys != Long.MIN_VALUE) {
                return xs != ys ? (xs > ys ? 1 : -1) : 0;
            }
        }
        if ((xsign = this.signum()) != (ysign = val.signum())) {
            return xsign > ysign ? 1 : -1;
        }
        if (xsign == 0) {
            return 0;
        }
        int cmp = this.compareMagnitude(val);
        return xsign > 0 ? cmp : -cmp;
    }

    private int compareMagnitude(BigDecimal val) {
        long ys = val.intCompact;
        long xs = this.intCompact;
        if (xs == 0L) {
            return ys == 0L ? 0 : -1;
        }
        if (ys == 0L) {
            return 1;
        }
        int sdiff = this.scale - val.scale;
        if (sdiff != 0) {
            int yae;
            int xae = this.precision() - this.scale;
            if (xae < (yae = val.precision() - val.scale)) {
                return -1;
            }
            if (xae > yae) {
                return 1;
            }
            BigInteger rb = null;
            if (sdiff < 0) {
                if ((xs == Long.MIN_VALUE || (xs = BigDecimal.longMultiplyPowerTen(xs, -sdiff)) == Long.MIN_VALUE) && ys == Long.MIN_VALUE) {
                    rb = this.bigMultiplyPowerTen(-sdiff);
                    return rb.compareMagnitude(val.intVal);
                }
            } else if ((ys == Long.MIN_VALUE || (ys = BigDecimal.longMultiplyPowerTen(ys, sdiff)) == Long.MIN_VALUE) && xs == Long.MIN_VALUE) {
                rb = val.bigMultiplyPowerTen(sdiff);
                return this.intVal.compareMagnitude(rb);
            }
        }
        if (xs != Long.MIN_VALUE) {
            return ys != Long.MIN_VALUE ? BigDecimal.longCompareMagnitude(xs, ys) : -1;
        }
        if (ys != Long.MIN_VALUE) {
            return 1;
        }
        return this.intVal.compareMagnitude(val.intVal);
    }

    public boolean equals(Object x) {
        if (!(x instanceof BigDecimal)) {
            return false;
        }
        BigDecimal xDec = (BigDecimal)x;
        if (x == this) {
            return true;
        }
        if (this.scale != xDec.scale) {
            return false;
        }
        long s = this.intCompact;
        long xs = xDec.intCompact;
        if (s != Long.MIN_VALUE) {
            if (xs == Long.MIN_VALUE) {
                xs = BigDecimal.compactValFor(xDec.intVal);
            }
            return xs == s;
        }
        if (xs != Long.MIN_VALUE) {
            return xs == BigDecimal.compactValFor(this.intVal);
        }
        return this.inflate().equals(xDec.inflate());
    }

    public BigDecimal min(BigDecimal val) {
        return this.compareTo(val) <= 0 ? this : val;
    }

    public BigDecimal max(BigDecimal val) {
        return this.compareTo(val) >= 0 ? this : val;
    }

    public int hashCode() {
        if (this.intCompact != Long.MIN_VALUE) {
            long val2 = this.intCompact < 0L ? -this.intCompact : this.intCompact;
            int temp = (int)((long)((int)(val2 >>> 32) * 31) + (val2 & 0xFFFFFFFFL));
            return 31 * (this.intCompact < 0L ? -temp : temp) + this.scale;
        }
        return 31 * this.intVal.hashCode() + this.scale;
    }

    public String toString() {
        String sc = this.stringCache;
        if (sc == null) {
            this.stringCache = sc = this.layoutChars(true);
        }
        return sc;
    }

    public String toEngineeringString() {
        return this.layoutChars(false);
    }

    public String toPlainString() {
        BigDecimal bd = this;
        if (bd.scale < 0) {
            bd = bd.setScale(0);
        }
        bd.inflate();
        if (bd.scale == 0) {
            return bd.intVal.toString();
        }
        return bd.getValueString(bd.signum(), bd.intVal.abs().toString(), bd.scale);
    }

    private String getValueString(int signum, String intString, int scale) {
        StringBuilder buf;
        int insertionPoint = intString.length() - scale;
        if (insertionPoint == 0) {
            return (signum < 0 ? "-0." : "0.") + intString;
        }
        if (insertionPoint > 0) {
            buf = new StringBuilder(intString);
            buf.insert(insertionPoint, '.');
            if (signum < 0) {
                buf.insert(0, '-');
            }
        } else {
            buf = new StringBuilder(3 - insertionPoint + intString.length());
            buf.append(signum < 0 ? "-0." : "0.");
            for (int i = 0; i < -insertionPoint; ++i) {
                buf.append('0');
            }
            buf.append(intString);
        }
        return buf.toString();
    }

    public BigInteger toBigInteger() {
        return this.setScale(0, 1).inflate();
    }

    public BigInteger toBigIntegerExact() {
        return this.setScale(0, 7).inflate();
    }

    @Override
    public long longValue() {
        return this.intCompact != Long.MIN_VALUE && this.scale == 0 ? this.intCompact : this.toBigInteger().longValue();
    }

    public long longValueExact() {
        if (this.intCompact != Long.MIN_VALUE && this.scale == 0) {
            return this.intCompact;
        }
        if (this.precision() - this.scale > 19) {
            throw new ArithmeticException("Overflow");
        }
        if (this.signum() == 0) {
            return 0L;
        }
        if (this.precision() - this.scale <= 0) {
            throw new ArithmeticException("Rounding necessary");
        }
        BigDecimal num = this.setScale(0, 7);
        if (num.precision() >= 19) {
            LongOverflow.check(num);
        }
        return num.inflate().longValue();
    }

    @Override
    public int intValue() {
        return this.intCompact != Long.MIN_VALUE && this.scale == 0 ? (int)this.intCompact : this.toBigInteger().intValue();
    }

    public int intValueExact() {
        long num = this.longValueExact();
        if ((long)((int)num) != num) {
            throw new ArithmeticException("Overflow");
        }
        return (int)num;
    }

    public short shortValueExact() {
        long num = this.longValueExact();
        if ((long)((short)num) != num) {
            throw new ArithmeticException("Overflow");
        }
        return (short)num;
    }

    public byte byteValueExact() {
        long num = this.longValueExact();
        if ((long)((byte)num) != num) {
            throw new ArithmeticException("Overflow");
        }
        return (byte)num;
    }

    @Override
    public float floatValue() {
        if (this.scale == 0 && this.intCompact != Long.MIN_VALUE) {
            return this.intCompact;
        }
        return Float.parseFloat(this.toString());
    }

    @Override
    public double doubleValue() {
        if (this.scale == 0 && this.intCompact != Long.MIN_VALUE) {
            return this.intCompact;
        }
        return Double.parseDouble(this.toString());
    }

    public BigDecimal ulp() {
        return BigDecimal.valueOf(1L, this.scale());
    }

    private String layoutChars(boolean sci) {
        StringBuilder buf;
        block20: {
            long adjusted;
            block22: {
                int sig;
                int coeffLen;
                char[] coeff;
                int offset;
                block23: {
                    block21: {
                        block19: {
                            if (this.scale == 0) {
                                return this.intCompact != Long.MIN_VALUE ? Long.toString(this.intCompact) : this.intVal.toString();
                            }
                            StringBuilderHelper sbHelper = threadLocalStringBuilderHelper.get();
                            if (this.intCompact != Long.MIN_VALUE) {
                                offset = sbHelper.putIntCompact(Math.abs(this.intCompact));
                                coeff = sbHelper.getCompactCharArray();
                            } else {
                                offset = 0;
                                coeff = this.intVal.abs().toString().toCharArray();
                            }
                            buf = sbHelper.getStringBuilder();
                            if (this.signum() < 0) {
                                buf.append('-');
                            }
                            coeffLen = coeff.length - offset;
                            adjusted = -((long)this.scale) + (long)(coeffLen - 1);
                            if (this.scale < 0 || adjusted < -6L) break block19;
                            int pad = this.scale - coeffLen;
                            if (pad >= 0) {
                                buf.append('0');
                                buf.append('.');
                                while (pad > 0) {
                                    buf.append('0');
                                    --pad;
                                }
                                buf.append(coeff, offset, coeffLen);
                            } else {
                                buf.append(coeff, offset, -pad);
                                buf.append('.');
                                buf.append(coeff, -pad + offset, this.scale);
                            }
                            break block20;
                        }
                        if (!sci) break block21;
                        buf.append(coeff[offset]);
                        if (coeffLen > 1) {
                            buf.append('.');
                            buf.append(coeff, offset + 1, coeffLen - 1);
                        }
                        break block22;
                    }
                    sig = (int)(adjusted % 3L);
                    if (sig < 0) {
                        sig += 3;
                    }
                    adjusted -= (long)sig;
                    ++sig;
                    if (this.signum() != 0) break block23;
                    switch (sig) {
                        case 1: {
                            buf.append('0');
                            break block22;
                        }
                        case 2: {
                            buf.append("0.00");
                            adjusted += 3L;
                            break block22;
                        }
                        case 3: {
                            buf.append("0.0");
                            adjusted += 3L;
                            break block22;
                        }
                        default: {
                            throw new AssertionError((Object)("Unexpected sig value " + sig));
                        }
                    }
                }
                if (sig >= coeffLen) {
                    buf.append(coeff, offset, coeffLen);
                    for (int i = sig - coeffLen; i > 0; --i) {
                        buf.append('0');
                    }
                } else {
                    buf.append(coeff, offset, sig);
                    buf.append('.');
                    buf.append(coeff, offset + sig, coeffLen - sig);
                }
            }
            if (adjusted != 0L) {
                buf.append('E');
                if (adjusted > 0L) {
                    buf.append('+');
                }
                buf.append(adjusted);
            }
        }
        return buf.toString();
    }

    private static BigInteger bigTenToThe(int n) {
        if (n < 0) {
            return BigInteger.ZERO;
        }
        if (n < BIG_TEN_POWERS_TABLE_MAX) {
            BigInteger[] pows = BIG_TEN_POWERS_TABLE;
            if (n < pows.length) {
                return pows[n];
            }
            return BigDecimal.expandBigIntegerTenPowers(n);
        }
        char[] tenpow = new char[n + 1];
        tenpow[0] = 49;
        for (int i = 1; i <= n; ++i) {
            tenpow[i] = 48;
        }
        return new BigInteger(tenpow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BigInteger expandBigIntegerTenPowers(int n) {
        Class<BigDecimal> clazz = BigDecimal.class;
        synchronized (BigDecimal.class) {
            BigInteger[] pows = BIG_TEN_POWERS_TABLE;
            int curLen = pows.length;
            if (curLen <= n) {
                int newLen;
                for (newLen = curLen << 1; newLen <= n; newLen <<= 1) {
                }
                pows = Arrays.copyOf(pows, newLen);
                for (int i = curLen; i < newLen; ++i) {
                    pows[i] = pows[i - 1].multiply(BigInteger.TEN);
                }
                BIG_TEN_POWERS_TABLE = pows;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return pows[n];
        }
    }

    private static long longMultiplyPowerTen(long val, int n) {
        if (val == 0L || n <= 0) {
            return val;
        }
        long[] tab = LONG_TEN_POWERS_TABLE;
        long[] bounds = THRESHOLDS_TABLE;
        if (n < tab.length && n < bounds.length) {
            long tenpower = tab[n];
            if (val == 1L) {
                return tenpower;
            }
            if (Math.abs(val) <= bounds[n]) {
                return val * tenpower;
            }
        }
        return Long.MIN_VALUE;
    }

    private BigInteger bigMultiplyPowerTen(int n) {
        if (n <= 0) {
            return this.inflate();
        }
        if (this.intCompact != Long.MIN_VALUE) {
            return BigDecimal.bigTenToThe(n).multiply(this.intCompact);
        }
        return this.intVal.multiply(BigDecimal.bigTenToThe(n));
    }

    private BigInteger inflate() {
        if (this.intVal == null) {
            this.intVal = BigInteger.valueOf(this.intCompact);
        }
        return this.intVal;
    }

    private static void matchScale(BigDecimal[] val) {
        if (val[0].scale == val[1].scale) {
            return;
        }
        if (val[0].scale < val[1].scale) {
            val[0] = val[0].setScale(val[1].scale, 7);
        } else if (val[1].scale < val[0].scale) {
            val[1] = val[1].setScale(val[0].scale, 7);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.intVal == null) {
            String message = "BigDecimal: null intVal in stream";
            throw new StreamCorruptedException(message);
        }
        this.intCompact = BigDecimal.compactValFor(this.intVal);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        this.inflate();
        s.defaultWriteObject();
    }

    private static int longDigitLength(long x) {
        long[] tab;
        int r;
        assert (x != Long.MIN_VALUE);
        if (x < 0L) {
            x = -x;
        }
        if (x < 10L) {
            return 1;
        }
        int n = 64;
        int y = (int)(x >>> 32);
        if (y == 0) {
            n -= 32;
            y = (int)x;
        }
        if (y >>> 16 == 0) {
            n -= 16;
            y <<= 16;
        }
        if (y >>> 24 == 0) {
            n -= 8;
            y <<= 8;
        }
        if (y >>> 28 == 0) {
            n -= 4;
            y <<= 4;
        }
        if (y >>> 30 == 0) {
            n -= 2;
            y <<= 2;
        }
        return (r = ((y >>> 31) + n) * 1233 >>> 12) >= (tab = LONG_TEN_POWERS_TABLE).length || x < tab[r] ? r : r + 1;
    }

    private static int bigDigitLength(BigInteger b) {
        if (b.signum == 0) {
            return 1;
        }
        int r = (int)(((long)b.bitLength() + 1L) * 646456993L >>> 31);
        return b.compareMagnitude(BigDecimal.bigTenToThe(r)) < 0 ? r : r + 1;
    }

    private BigDecimal stripZerosToMatchScale(long preferredScale) {
        BigInteger[] qr;
        this.inflate();
        while (this.intVal.compareMagnitude(BigInteger.TEN) >= 0 && (long)this.scale > preferredScale && !this.intVal.testBit(0) && (qr = this.intVal.divideAndRemainder(BigInteger.TEN))[1].signum() == 0) {
            this.intVal = qr[0];
            this.scale = this.checkScale((long)this.scale - 1L);
            if (this.precision <= 0) continue;
            --this.precision;
        }
        if (this.intVal != null) {
            this.intCompact = BigDecimal.compactValFor(this.intVal);
        }
        return this;
    }

    private int checkScale(long val) {
        int asInt = (int)val;
        if ((long)asInt != val) {
            BigInteger b;
            int n = asInt = val > Integer.MAX_VALUE ? Integer.MAX_VALUE : Integer.MIN_VALUE;
            if (this.intCompact != 0L && ((b = this.intVal) == null || b.signum() != 0)) {
                throw new ArithmeticException(asInt > 0 ? "Underflow" : "Overflow");
            }
        }
        return asInt;
    }

    private BigDecimal roundOp(MathContext mc) {
        BigDecimal rounded = BigDecimal.doRound(this, mc);
        return rounded;
    }

    private void roundThis(MathContext mc) {
        BigDecimal rounded = BigDecimal.doRound(this, mc);
        if (rounded == this) {
            return;
        }
        this.intVal = rounded.intVal;
        this.intCompact = rounded.intCompact;
        this.scale = rounded.scale;
        this.precision = rounded.precision;
    }

    private static BigDecimal doRound(BigDecimal d, MathContext mc) {
        int drop;
        int mcp = mc.precision;
        while ((drop = d.precision() - mcp) > 0) {
            int newScale = d.checkScale((long)d.scale - (long)drop);
            int mode = mc.roundingMode.oldMode;
            if (drop < LONG_TEN_POWERS_TABLE.length) {
                d = BigDecimal.divideAndRound(d.intCompact, d.intVal, LONG_TEN_POWERS_TABLE[drop], null, newScale, mode, newScale);
                continue;
            }
            d = BigDecimal.divideAndRound(d.intCompact, d.intVal, Long.MIN_VALUE, BigDecimal.bigTenToThe(drop), newScale, mode, newScale);
        }
        return d;
    }

    private static long compactValFor(BigInteger b) {
        int[] m = b.mag;
        int len = m.length;
        if (len == 0) {
            return 0L;
        }
        int d = m[0];
        if (len > 2 || len == 2 && d < 0) {
            return Long.MIN_VALUE;
        }
        long u = len == 2 ? ((long)m[1] & 0xFFFFFFFFL) + ((long)d << 32) : (long)d & 0xFFFFFFFFL;
        return b.signum < 0 ? -u : u;
    }

    private static int longCompareMagnitude(long x, long y) {
        if (x < 0L) {
            x = -x;
        }
        if (y < 0L) {
            y = -y;
        }
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    private static int saturateLong(long s) {
        int i = (int)s;
        return s == (long)i ? i : (s < 0L ? Integer.MIN_VALUE : Integer.MAX_VALUE);
    }

    private static void print(String name, BigDecimal bd) {
        System.err.format("%s:\tintCompact %d\tintVal %d\tscale %d\tprecision %d%n", name, bd.intCompact, bd.intVal, bd.scale, bd.precision);
    }

    private BigDecimal audit() {
        if (this.intCompact == Long.MIN_VALUE) {
            if (this.intVal == null) {
                BigDecimal.print("audit", this);
                throw new AssertionError((Object)"null intVal");
            }
            if (this.precision > 0 && this.precision != BigDecimal.bigDigitLength(this.intVal)) {
                BigDecimal.print("audit", this);
                throw new AssertionError((Object)"precision mismatch");
            }
        } else {
            long val;
            if (this.intVal != null && (val = this.intVal.longValue()) != this.intCompact) {
                BigDecimal.print("audit", this);
                throw new AssertionError((Object)("Inconsistent state, intCompact=" + this.intCompact + "\t intVal=" + val));
            }
            if (this.precision > 0 && this.precision != BigDecimal.longDigitLength(this.intCompact)) {
                BigDecimal.print("audit", this);
                throw new AssertionError((Object)"precision mismatch");
            }
        }
        return this;
    }

    static class StringBuilderHelper {
        final StringBuilder sb = new StringBuilder();
        final char[] cmpCharArray = new char[19];
        static final char[] DIGIT_TENS = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
        static final char[] DIGIT_ONES = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

        StringBuilderHelper() {
        }

        StringBuilder getStringBuilder() {
            this.sb.setLength(0);
            return this.sb;
        }

        char[] getCompactCharArray() {
            return this.cmpCharArray;
        }

        int putIntCompact(long intCompact) {
            int r;
            assert (intCompact >= 0L);
            int charPos = this.cmpCharArray.length;
            while (intCompact > Integer.MAX_VALUE) {
                long q = intCompact / 100L;
                r = (int)(intCompact - q * 100L);
                intCompact = q;
                this.cmpCharArray[--charPos] = DIGIT_ONES[r];
                this.cmpCharArray[--charPos] = DIGIT_TENS[r];
            }
            int i2 = (int)intCompact;
            while (i2 >= 100) {
                int q2 = i2 / 100;
                r = i2 - q2 * 100;
                i2 = q2;
                this.cmpCharArray[--charPos] = DIGIT_ONES[r];
                this.cmpCharArray[--charPos] = DIGIT_TENS[r];
            }
            this.cmpCharArray[--charPos] = DIGIT_ONES[i2];
            if (i2 >= 10) {
                this.cmpCharArray[--charPos] = DIGIT_TENS[i2];
            }
            return charPos;
        }
    }

    private static class LongOverflow {
        private static final BigInteger LONGMIN = BigInteger.valueOf(Long.MIN_VALUE);
        private static final BigInteger LONGMAX = BigInteger.valueOf(Long.MAX_VALUE);

        private LongOverflow() {
        }

        public static void check(BigDecimal num) {
            num.inflate();
            if (num.intVal.compareTo(LONGMIN) < 0 || num.intVal.compareTo(LONGMAX) > 0) {
                throw new ArithmeticException("Overflow");
            }
        }
    }
}

