/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import com.sun.beans.decoder.DocumentHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.PatternSyntaxException;
import javax.swing.ImageIcon;
import javax.swing.UIDefaults;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.DefaultSynthStyleFactory;
import javax.swing.plaf.synth.ImagePainter;
import javax.swing.plaf.synth.ParsedSynthStyle;
import javax.swing.plaf.synth.SynthGraphicsUtils;
import javax.swing.plaf.synth.SynthPainter;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

class SynthParser
extends DefaultHandler {
    private static final String ELEMENT_SYNTH = "synth";
    private static final String ELEMENT_STYLE = "style";
    private static final String ELEMENT_STATE = "state";
    private static final String ELEMENT_FONT = "font";
    private static final String ELEMENT_COLOR = "color";
    private static final String ELEMENT_IMAGE_PAINTER = "imagePainter";
    private static final String ELEMENT_PAINTER = "painter";
    private static final String ELEMENT_PROPERTY = "property";
    private static final String ELEMENT_SYNTH_GRAPHICS = "graphicsUtils";
    private static final String ELEMENT_IMAGE_ICON = "imageIcon";
    private static final String ELEMENT_BIND = "bind";
    private static final String ELEMENT_BIND_KEY = "bindKey";
    private static final String ELEMENT_INSETS = "insets";
    private static final String ELEMENT_OPAQUE = "opaque";
    private static final String ELEMENT_DEFAULTS_PROPERTY = "defaultsProperty";
    private static final String ELEMENT_INPUT_MAP = "inputMap";
    private static final String ATTRIBUTE_ACTION = "action";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_IDREF = "idref";
    private static final String ATTRIBUTE_CLONE = "clone";
    private static final String ATTRIBUTE_VALUE = "value";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_STYLE = "style";
    private static final String ATTRIBUTE_SIZE = "size";
    private static final String ATTRIBUTE_TYPE = "type";
    private static final String ATTRIBUTE_TOP = "top";
    private static final String ATTRIBUTE_LEFT = "left";
    private static final String ATTRIBUTE_BOTTOM = "bottom";
    private static final String ATTRIBUTE_RIGHT = "right";
    private static final String ATTRIBUTE_KEY = "key";
    private static final String ATTRIBUTE_SOURCE_INSETS = "sourceInsets";
    private static final String ATTRIBUTE_DEST_INSETS = "destinationInsets";
    private static final String ATTRIBUTE_PATH = "path";
    private static final String ATTRIBUTE_STRETCH = "stretch";
    private static final String ATTRIBUTE_PAINT_CENTER = "paintCenter";
    private static final String ATTRIBUTE_METHOD = "method";
    private static final String ATTRIBUTE_DIRECTION = "direction";
    private static final String ATTRIBUTE_CENTER = "center";
    private DocumentHandler _handler;
    private int _depth;
    private DefaultSynthStyleFactory _factory;
    private List<ParsedSynthStyle.StateInfo> _stateInfos;
    private ParsedSynthStyle _style;
    private ParsedSynthStyle.StateInfo _stateInfo;
    private List<String> _inputMapBindings;
    private String _inputMapID;
    private Map<String, Object> _mapping = new HashMap<String, Object>();
    private URL _urlResourceBase;
    private Class<?> _classResourceBase;
    private List<ColorType> _colorTypes;
    private Map<String, Object> _defaultsMap;
    private List<ParsedSynthStyle.PainterInfo> _stylePainters;
    private List<ParsedSynthStyle.PainterInfo> _statePainters;

    SynthParser() {
        this._stateInfos = new ArrayList<ParsedSynthStyle.StateInfo>();
        this._colorTypes = new ArrayList<ColorType>();
        this._inputMapBindings = new ArrayList<String>();
        this._stylePainters = new ArrayList<ParsedSynthStyle.PainterInfo>();
        this._statePainters = new ArrayList<ParsedSynthStyle.PainterInfo>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputStream inputStream, DefaultSynthStyleFactory factory, URL urlResourceBase, Class<?> classResourceBase, Map<String, Object> defaultsMap) throws ParseException, IllegalArgumentException {
        if (inputStream == null || factory == null || urlResourceBase == null && classResourceBase == null) {
            throw new IllegalArgumentException("You must supply an InputStream, StyleFactory and Class or URL");
        }
        assert (urlResourceBase == null || classResourceBase == null);
        this._factory = factory;
        this._classResourceBase = classResourceBase;
        this._urlResourceBase = urlResourceBase;
        this._defaultsMap = defaultsMap;
        try {
            try {
                SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
                saxParser.parse((InputStream)new BufferedInputStream(inputStream), (DefaultHandler)this);
            }
            catch (ParserConfigurationException e) {
                throw new ParseException("Error parsing: " + e, 0);
            }
            catch (SAXException se) {
                throw new ParseException("Error parsing: " + se + " " + se.getException(), 0);
            }
            catch (IOException ioe) {
                throw new ParseException("Error parsing: " + ioe, 0);
            }
        }
        finally {
            this.reset();
        }
    }

    private URL getResource(String path) {
        if (this._classResourceBase != null) {
            return this._classResourceBase.getResource(path);
        }
        try {
            return new URL(this._urlResourceBase, path);
        }
        catch (MalformedURLException mue) {
            return null;
        }
    }

    private void reset() {
        this._handler = null;
        this._depth = 0;
        this._mapping.clear();
        this._stateInfos.clear();
        this._colorTypes.clear();
        this._statePainters.clear();
        this._stylePainters.clear();
    }

    private boolean isForwarding() {
        return this._depth > 0;
    }

    private DocumentHandler getHandler() {
        if (this._handler == null) {
            this._handler = new DocumentHandler();
            if (this._urlResourceBase != null) {
                URL[] urls = new URL[]{this.getResource(".")};
                ClassLoader parent = Thread.currentThread().getContextClassLoader();
                URLClassLoader urlLoader = new URLClassLoader(urls, parent);
                this._handler.setClassLoader(urlLoader);
            } else {
                this._handler.setClassLoader(this._classResourceBase.getClassLoader());
            }
            for (String key : this._mapping.keySet()) {
                this._handler.setVariable(key, this._mapping.get(key));
            }
        }
        return this._handler;
    }

    private Object checkCast(Object value, Class type) throws SAXException {
        if (!type.isInstance(value)) {
            throw new SAXException("Expected type " + type + " got " + value.getClass());
        }
        return value;
    }

    private Object lookup(String key, Class type) throws SAXException {
        if (this._handler != null && this._handler.hasVariable(key)) {
            return this.checkCast(this._handler.getVariable(key), type);
        }
        Object value = this._mapping.get(key);
        if (value == null) {
            throw new SAXException("ID " + key + " has not been defined");
        }
        return this.checkCast(value, type);
    }

    private void register(String key, Object value) throws SAXException {
        if (key != null) {
            if (this._mapping.get(key) != null || this._handler != null && this._handler.hasVariable(key)) {
                throw new SAXException("ID " + key + " is already defined");
            }
            if (this._handler != null) {
                this._handler.setVariable(key, value);
            } else {
                this._mapping.put(key, value);
            }
        }
    }

    private int nextInt(StringTokenizer tok, String errorMsg) throws SAXException {
        if (!tok.hasMoreTokens()) {
            throw new SAXException(errorMsg);
        }
        try {
            return Integer.parseInt(tok.nextToken());
        }
        catch (NumberFormatException nfe) {
            throw new SAXException(errorMsg);
        }
    }

    private Insets parseInsets(String insets, String errorMsg) throws SAXException {
        StringTokenizer tokenizer = new StringTokenizer(insets);
        return new Insets(this.nextInt(tokenizer, errorMsg), this.nextInt(tokenizer, errorMsg), this.nextInt(tokenizer, errorMsg), this.nextInt(tokenizer, errorMsg));
    }

    private void startStyle(Attributes attributes) throws SAXException {
        String id = null;
        this._style = null;
        for (int i = attributes.getLength() - 1; i >= 0; --i) {
            String key = attributes.getQName(i);
            if (key.equals(ATTRIBUTE_CLONE)) {
                this._style = (ParsedSynthStyle)((ParsedSynthStyle)this.lookup(attributes.getValue(i), ParsedSynthStyle.class)).clone();
                continue;
            }
            if (!key.equals(ATTRIBUTE_ID)) continue;
            id = attributes.getValue(i);
        }
        if (this._style == null) {
            this._style = new ParsedSynthStyle();
        }
        this.register(id, this._style);
    }

    private void endStyle() {
        int size = this._stylePainters.size();
        if (size > 0) {
            this._style.setPainters(this._stylePainters.toArray(new ParsedSynthStyle.PainterInfo[size]));
            this._stylePainters.clear();
        }
        if ((size = this._stateInfos.size()) > 0) {
            this._style.setStateInfo(this._stateInfos.toArray(new ParsedSynthStyle.StateInfo[size]));
            this._stateInfos.clear();
        }
        this._style = null;
    }

    private void startState(Attributes attributes) throws SAXException {
        Object stateInfo = null;
        int state = 0;
        String id = null;
        this._stateInfo = null;
        for (int i = attributes.getLength() - 1; i >= 0; --i) {
            String key = attributes.getQName(i);
            if (key.equals(ATTRIBUTE_ID)) {
                id = attributes.getValue(i);
                continue;
            }
            if (key.equals(ATTRIBUTE_IDREF)) {
                this._stateInfo = (ParsedSynthStyle.StateInfo)this.lookup(attributes.getValue(i), ParsedSynthStyle.StateInfo.class);
                continue;
            }
            if (key.equals(ATTRIBUTE_CLONE)) {
                this._stateInfo = (ParsedSynthStyle.StateInfo)((ParsedSynthStyle.StateInfo)this.lookup(attributes.getValue(i), ParsedSynthStyle.StateInfo.class)).clone();
                continue;
            }
            if (!key.equals(ATTRIBUTE_VALUE)) continue;
            StringTokenizer tokenizer = new StringTokenizer(attributes.getValue(i));
            while (tokenizer.hasMoreTokens()) {
                String stateString = tokenizer.nextToken().toUpperCase().intern();
                if (stateString == "ENABLED") {
                    state |= 1;
                    continue;
                }
                if (stateString == "MOUSE_OVER") {
                    state |= 2;
                    continue;
                }
                if (stateString == "PRESSED") {
                    state |= 4;
                    continue;
                }
                if (stateString == "DISABLED") {
                    state |= 8;
                    continue;
                }
                if (stateString == "FOCUSED") {
                    state |= 0x100;
                    continue;
                }
                if (stateString == "SELECTED") {
                    state |= 0x200;
                    continue;
                }
                if (stateString == "DEFAULT") {
                    state |= 0x400;
                    continue;
                }
                if (stateString == "AND") continue;
                throw new SAXException("Unknown state: " + state);
            }
        }
        if (this._stateInfo == null) {
            this._stateInfo = new ParsedSynthStyle.StateInfo();
        }
        this._stateInfo.setComponentState(state);
        this.register(id, this._stateInfo);
        this._stateInfos.add(this._stateInfo);
    }

    private void endState() {
        int size = this._statePainters.size();
        if (size > 0) {
            this._stateInfo.setPainters(this._statePainters.toArray(new ParsedSynthStyle.PainterInfo[size]));
            this._statePainters.clear();
        }
        this._stateInfo = null;
    }

    private void startFont(Attributes attributes) throws SAXException {
        Font font = null;
        int style = 0;
        int size = 0;
        String id = null;
        String name = null;
        for (int i = attributes.getLength() - 1; i >= 0; --i) {
            String key = attributes.getQName(i);
            if (key.equals(ATTRIBUTE_ID)) {
                id = attributes.getValue(i);
                continue;
            }
            if (key.equals(ATTRIBUTE_IDREF)) {
                font = (Font)this.lookup(attributes.getValue(i), Font.class);
                continue;
            }
            if (key.equals(ATTRIBUTE_NAME)) {
                name = attributes.getValue(i);
                continue;
            }
            if (key.equals(ATTRIBUTE_SIZE)) {
                try {
                    size = Integer.parseInt(attributes.getValue(i));
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new SAXException("Invalid font size: " + attributes.getValue(i));
                }
            }
            if (!key.equals("style")) continue;
            StringTokenizer tok = new StringTokenizer(attributes.getValue(i));
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken().intern();
                if (token == "BOLD") {
                    style = (style | 0) ^ 0 | 1;
                    continue;
                }
                if (token != "ITALIC") continue;
                style |= 2;
            }
        }
        if (font == null) {
            if (name == null) {
                throw new SAXException("You must define a name for the font");
            }
            if (size == 0) {
                throw new SAXException("You must define a size for the font");
            }
            font = new FontUIResource(name, style, size);
        } else if (name != null || size != 0 || style != 0) {
            throw new SAXException("Name, size and style are not for use with idref");
        }
        this.register(id, font);
        if (this._stateInfo != null) {
            this._stateInfo.setFont(font);
        } else if (this._style != null) {
            this._style.setFont(font);
        }
    }

    private void startColor(Attributes attributes) throws SAXException {
        Color color = null;
        String id = null;
        this._colorTypes.clear();
        for (int i = attributes.getLength() - 1; i >= 0; --i) {
            String key = attributes.getQName(i);
            if (key.equals(ATTRIBUTE_ID)) {
                id = attributes.getValue(i);
                continue;
            }
            if (key.equals(ATTRIBUTE_IDREF)) {
                color = (Color)this.lookup(attributes.getValue(i), Color.class);
                continue;
            }
            if (key.equals(ATTRIBUTE_NAME)) continue;
            if (key.equals(ATTRIBUTE_VALUE)) {
                String value = attributes.getValue(i);
                if (value.startsWith("#")) {
                    try {
                        boolean hasAlpha;
                        int argb;
                        int length = value.length();
                        if (length < 8) {
                            argb = Integer.decode(value);
                            hasAlpha = false;
                        } else if (length == 8) {
                            argb = Integer.decode(value);
                            hasAlpha = true;
                        } else if (length == 9) {
                            int rgb = Integer.decode('#' + value.substring(3, 9));
                            int a = Integer.decode(value.substring(0, 3));
                            argb = a << 24 | rgb;
                            hasAlpha = true;
                        } else {
                            throw new SAXException("Invalid Color value: " + value);
                        }
                        color = new ColorUIResource(new Color(argb, hasAlpha));
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        throw new SAXException("Invalid Color value: " + value);
                    }
                }
                try {
                    color = new ColorUIResource((Color)Color.class.getField(value.toUpperCase()).get(Color.class));
                    continue;
                }
                catch (NoSuchFieldException nsfe) {
                    throw new SAXException("Invalid color name: " + value);
                }
                catch (IllegalAccessException iae) {
                    throw new SAXException("Invalid color name: " + value);
                }
            }
            if (!key.equals(ATTRIBUTE_TYPE)) continue;
            StringTokenizer tokenizer = new StringTokenizer(attributes.getValue(i));
            while (tokenizer.hasMoreTokens()) {
                Class typeClass;
                String typeName = tokenizer.nextToken();
                int classIndex = typeName.lastIndexOf(46);
                if (classIndex == -1) {
                    typeClass = ColorType.class;
                    classIndex = 0;
                } else {
                    try {
                        typeClass = Class.forName(typeName.substring(0, classIndex));
                    }
                    catch (ClassNotFoundException cnfe) {
                        throw new SAXException("Unknown class: " + typeName.substring(0, classIndex));
                    }
                    ++classIndex;
                }
                try {
                    this._colorTypes.add((ColorType)this.checkCast(typeClass.getField(typeName.substring(classIndex)).get(typeClass), ColorType.class));
                }
                catch (NoSuchFieldException nsfe) {
                    throw new SAXException("Unable to find color type: " + typeName);
                }
                catch (IllegalAccessException iae) {
                    throw new SAXException("Unable to find color type: " + typeName);
                }
            }
        }
        if (color == null) {
            throw new SAXException("color: you must specificy a value");
        }
        this.register(id, color);
        if (this._stateInfo != null && this._colorTypes.size() > 0) {
            Color[] colors = this._stateInfo.getColors();
            int max = 0;
            for (int counter = this._colorTypes.size() - 1; counter >= 0; --counter) {
                max = Math.max(max, this._colorTypes.get(counter).getID());
            }
            if (colors == null || colors.length <= max) {
                Color[] newColors = new Color[max + 1];
                if (colors != null) {
                    System.arraycopy(colors, 0, newColors, 0, colors.length);
                }
                colors = newColors;
            }
            for (int counter = this._colorTypes.size() - 1; counter >= 0; --counter) {
                colors[this._colorTypes.get((int)counter).getID()] = color;
            }
            this._stateInfo.setColors(colors);
        }
    }

    private void startProperty(Attributes attributes, Object property) throws SAXException {
        Object value = null;
        String key = null;
        int iType = 0;
        String aValue = null;
        for (int i = attributes.getLength() - 1; i >= 0; --i) {
            String aName = attributes.getQName(i);
            if (aName.equals(ATTRIBUTE_TYPE)) {
                String type = attributes.getValue(i).toUpperCase();
                if (type.equals("IDREF")) {
                    iType = 0;
                    continue;
                }
                if (type.equals("BOOLEAN")) {
                    iType = 1;
                    continue;
                }
                if (type.equals("DIMENSION")) {
                    iType = 2;
                    continue;
                }
                if (type.equals("INSETS")) {
                    iType = 3;
                    continue;
                }
                if (type.equals("INTEGER")) {
                    iType = 4;
                    continue;
                }
                if (type.equals("STRING")) {
                    iType = 5;
                    continue;
                }
                throw new SAXException(property + " unknown type, use" + "idref, boolean, dimension, insets or integer");
            }
            if (aName.equals(ATTRIBUTE_VALUE)) {
                aValue = attributes.getValue(i);
                continue;
            }
            if (!aName.equals(ATTRIBUTE_KEY)) continue;
            key = attributes.getValue(i);
        }
        if (aValue != null) {
            switch (iType) {
                case 0: {
                    value = this.lookup(aValue, Object.class);
                    break;
                }
                case 1: {
                    if (aValue.toUpperCase().equals("TRUE")) {
                        value = Boolean.TRUE;
                        break;
                    }
                    value = Boolean.FALSE;
                    break;
                }
                case 2: {
                    StringTokenizer tok = new StringTokenizer(aValue);
                    value = new DimensionUIResource(this.nextInt(tok, "Invalid dimension"), this.nextInt(tok, "Invalid dimension"));
                    break;
                }
                case 3: {
                    value = this.parseInsets(aValue, property + " invalid insets");
                    break;
                }
                case 4: {
                    try {
                        value = new Integer(Integer.parseInt(aValue));
                        break;
                    }
                    catch (NumberFormatException nfe) {
                        throw new SAXException(property + " invalid value");
                    }
                }
                case 5: {
                    value = aValue;
                }
            }
        }
        if (value == null || key == null) {
            throw new SAXException(property + ": you must supply a " + "key and value");
        }
        if (property == ELEMENT_DEFAULTS_PROPERTY) {
            this._defaultsMap.put(key, value);
        } else if (this._stateInfo != null) {
            if (this._stateInfo.getData() == null) {
                this._stateInfo.setData(new HashMap());
            }
            this._stateInfo.getData().put(key, value);
        } else if (this._style != null) {
            if (this._style.getData() == null) {
                this._style.setData(new HashMap());
            }
            this._style.getData().put(key, value);
        }
    }

    private void startGraphics(Attributes attributes) throws SAXException {
        SynthGraphicsUtils graphics = null;
        for (int i = attributes.getLength() - 1; i >= 0; --i) {
            String key = attributes.getQName(i);
            if (!key.equals(ATTRIBUTE_IDREF)) continue;
            graphics = (SynthGraphicsUtils)this.lookup(attributes.getValue(i), SynthGraphicsUtils.class);
        }
        if (graphics == null) {
            throw new SAXException("graphicsUtils: you must supply an idref");
        }
        if (this._style != null) {
            this._style.setGraphicsUtils(graphics);
        }
    }

    private void startInsets(Attributes attributes) throws SAXException {
        int top = 0;
        int bottom = 0;
        int left = 0;
        int right = 0;
        Insets insets = null;
        String id = null;
        for (int i = attributes.getLength() - 1; i >= 0; --i) {
            String key = attributes.getQName(i);
            try {
                if (key.equals(ATTRIBUTE_IDREF)) {
                    insets = (Insets)this.lookup(attributes.getValue(i), Insets.class);
                    continue;
                }
                if (key.equals(ATTRIBUTE_ID)) {
                    id = attributes.getValue(i);
                    continue;
                }
                if (key.equals(ATTRIBUTE_TOP)) {
                    top = Integer.parseInt(attributes.getValue(i));
                    continue;
                }
                if (key.equals(ATTRIBUTE_LEFT)) {
                    left = Integer.parseInt(attributes.getValue(i));
                    continue;
                }
                if (key.equals(ATTRIBUTE_BOTTOM)) {
                    bottom = Integer.parseInt(attributes.getValue(i));
                    continue;
                }
                if (!key.equals(ATTRIBUTE_RIGHT)) continue;
                right = Integer.parseInt(attributes.getValue(i));
                continue;
            }
            catch (NumberFormatException nfe) {
                throw new SAXException("insets: bad integer value for " + attributes.getValue(i));
            }
        }
        if (insets == null) {
            insets = new InsetsUIResource(top, left, bottom, right);
        }
        this.register(id, insets);
        if (this._style != null) {
            this._style.setInsets(insets);
        }
    }

    private void startBind(Attributes attributes) throws SAXException {
        ParsedSynthStyle style = null;
        String path = null;
        int type = -1;
        for (int i = attributes.getLength() - 1; i >= 0; --i) {
            String key = attributes.getQName(i);
            if (key.equals("style")) {
                style = (ParsedSynthStyle)this.lookup(attributes.getValue(i), ParsedSynthStyle.class);
                continue;
            }
            if (key.equals(ATTRIBUTE_TYPE)) {
                String typeS = attributes.getValue(i).toUpperCase();
                if (typeS.equals("NAME")) {
                    type = 0;
                    continue;
                }
                if (typeS.equals("REGION")) {
                    type = 1;
                    continue;
                }
                throw new SAXException("bind: unknown type " + typeS);
            }
            if (!key.equals(ATTRIBUTE_KEY)) continue;
            path = attributes.getValue(i);
        }
        if (style == null || path == null || type == -1) {
            throw new SAXException("bind: you must specify a style, type and key");
        }
        try {
            this._factory.addStyle(style, path, type);
        }
        catch (PatternSyntaxException pse) {
            throw new SAXException("bind: " + path + " is not a valid " + "regular expression");
        }
    }

    private void startPainter(Attributes attributes, String type) throws SAXException {
        Insets sourceInsets = null;
        Insets destInsets = null;
        String path = null;
        boolean paintCenter = true;
        boolean stretch = true;
        SynthPainter painter = null;
        String method = null;
        String id = null;
        int direction = -1;
        boolean center = false;
        boolean stretchSpecified = false;
        boolean paintCenterSpecified = false;
        for (int i = attributes.getLength() - 1; i >= 0; --i) {
            String key = attributes.getQName(i);
            String value = attributes.getValue(i);
            if (key.equals(ATTRIBUTE_ID)) {
                id = value;
                continue;
            }
            if (key.equals(ATTRIBUTE_METHOD)) {
                method = value.toLowerCase(Locale.ENGLISH);
                continue;
            }
            if (key.equals(ATTRIBUTE_IDREF)) {
                painter = (SynthPainter)this.lookup(value, SynthPainter.class);
                continue;
            }
            if (key.equals(ATTRIBUTE_PATH)) {
                path = value;
                continue;
            }
            if (key.equals(ATTRIBUTE_SOURCE_INSETS)) {
                sourceInsets = this.parseInsets(value, type + ": sourceInsets must be top left bottom right");
                continue;
            }
            if (key.equals(ATTRIBUTE_DEST_INSETS)) {
                destInsets = this.parseInsets(value, type + ": destinationInsets must be top left bottom right");
                continue;
            }
            if (key.equals(ATTRIBUTE_PAINT_CENTER)) {
                paintCenter = value.toLowerCase().equals("true");
                paintCenterSpecified = true;
                continue;
            }
            if (key.equals(ATTRIBUTE_STRETCH)) {
                stretch = value.toLowerCase().equals("true");
                stretchSpecified = true;
                continue;
            }
            if (key.equals(ATTRIBUTE_DIRECTION)) {
                if ((value = value.toUpperCase().intern()) == "EAST") {
                    direction = 3;
                    continue;
                }
                if (value == "NORTH") {
                    direction = 1;
                    continue;
                }
                if (value == "SOUTH") {
                    direction = 5;
                    continue;
                }
                if (value == "WEST") {
                    direction = 7;
                    continue;
                }
                if (value == "TOP") {
                    direction = 1;
                    continue;
                }
                if (value == "LEFT") {
                    direction = 2;
                    continue;
                }
                if (value == "BOTTOM") {
                    direction = 3;
                    continue;
                }
                if (value == "RIGHT") {
                    direction = 4;
                    continue;
                }
                if (value == "HORIZONTAL") {
                    direction = 0;
                    continue;
                }
                if (value == "VERTICAL") {
                    direction = 1;
                    continue;
                }
                if (value == "HORIZONTAL_SPLIT") {
                    direction = 1;
                    continue;
                }
                if (value == "VERTICAL_SPLIT") {
                    direction = 0;
                    continue;
                }
                throw new SAXException(type + ": unknown direction");
            }
            if (!key.equals(ATTRIBUTE_CENTER)) continue;
            center = value.toLowerCase().equals("true");
        }
        if (painter == null) {
            if (type == ELEMENT_PAINTER) {
                throw new SAXException(type + ": you must specify an idref");
            }
            if (sourceInsets == null && !center) {
                throw new SAXException("property: you must specify sourceInsets");
            }
            if (path == null) {
                throw new SAXException("property: you must specify a path");
            }
            if (center && (sourceInsets != null || destInsets != null || paintCenterSpecified || stretchSpecified)) {
                throw new SAXException("The attributes: sourceInsets, destinationInsets, paintCenter and stretch  are not legal when center is true");
            }
            painter = new ImagePainter(!stretch, paintCenter, sourceInsets, destInsets, this.getResource(path), center);
        }
        this.register(id, painter);
        if (this._stateInfo != null) {
            this.addPainterOrMerge(this._statePainters, method, painter, direction);
        } else if (this._style != null) {
            this.addPainterOrMerge(this._stylePainters, method, painter, direction);
        }
    }

    private void addPainterOrMerge(List<ParsedSynthStyle.PainterInfo> painters, String method, SynthPainter painter, int direction) {
        ParsedSynthStyle.PainterInfo painterInfo = new ParsedSynthStyle.PainterInfo(method, painter, direction);
        for (ParsedSynthStyle.PainterInfo infoObject : painters) {
            ParsedSynthStyle.PainterInfo info = infoObject;
            if (!painterInfo.equalsPainter(info)) continue;
            info.addPainter(painter);
            return;
        }
        painters.add(painterInfo);
    }

    private void startImageIcon(Attributes attributes) throws SAXException {
        String path = null;
        String id = null;
        for (int i = attributes.getLength() - 1; i >= 0; --i) {
            String key = attributes.getQName(i);
            if (key.equals(ATTRIBUTE_ID)) {
                id = attributes.getValue(i);
                continue;
            }
            if (!key.equals(ATTRIBUTE_PATH)) continue;
            path = attributes.getValue(i);
        }
        if (path == null) {
            throw new SAXException("imageIcon: you must specify a path");
        }
        this.register(id, new LazyImageIcon(this.getResource(path)));
    }

    private void startOpaque(Attributes attributes) {
        if (this._style != null) {
            this._style.setOpaque(true);
            for (int i = attributes.getLength() - 1; i >= 0; --i) {
                String key = attributes.getQName(i);
                if (!key.equals(ATTRIBUTE_VALUE)) continue;
                this._style.setOpaque("true".equals(attributes.getValue(i).toLowerCase()));
            }
        }
    }

    private void startInputMap(Attributes attributes) throws SAXException {
        this._inputMapBindings.clear();
        this._inputMapID = null;
        if (this._style != null) {
            for (int i = attributes.getLength() - 1; i >= 0; --i) {
                String key = attributes.getQName(i);
                if (!key.equals(ATTRIBUTE_ID)) continue;
                this._inputMapID = attributes.getValue(i);
            }
        }
    }

    private void endInputMap() throws SAXException {
        if (this._inputMapID != null) {
            this.register(this._inputMapID, new UIDefaults.LazyInputMap(this._inputMapBindings.toArray(new Object[this._inputMapBindings.size()])));
        }
        this._inputMapBindings.clear();
        this._inputMapID = null;
    }

    private void startBindKey(Attributes attributes) throws SAXException {
        if (this._inputMapID == null) {
            return;
        }
        if (this._style != null) {
            String key = null;
            String value = null;
            for (int i = attributes.getLength() - 1; i >= 0; --i) {
                String aKey = attributes.getQName(i);
                if (aKey.equals(ATTRIBUTE_KEY)) {
                    key = attributes.getValue(i);
                    continue;
                }
                if (!aKey.equals(ATTRIBUTE_ACTION)) continue;
                value = attributes.getValue(i);
            }
            if (key == null || value == null) {
                throw new SAXException("bindKey: you must supply a key and action");
            }
            this._inputMapBindings.add(key);
            this._inputMapBindings.add(value);
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
        if (this.isForwarding()) {
            return this.getHandler().resolveEntity(publicId, systemId);
        }
        return null;
    }

    @Override
    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
        if (this.isForwarding()) {
            this.getHandler().notationDecl(name, publicId, systemId);
        }
    }

    @Override
    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        if (this.isForwarding()) {
            this.getHandler().unparsedEntityDecl(name, publicId, systemId, notationName);
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        if (this.isForwarding()) {
            this.getHandler().setDocumentLocator(locator);
        }
    }

    @Override
    public void startDocument() throws SAXException {
        if (this.isForwarding()) {
            this.getHandler().startDocument();
        }
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.isForwarding()) {
            this.getHandler().endDocument();
        }
    }

    @Override
    public void startElement(String uri, String local, String name, Attributes attributes) throws SAXException {
        if ((name = name.intern()) == "style") {
            this.startStyle(attributes);
        } else if (name == ELEMENT_STATE) {
            this.startState(attributes);
        } else if (name == ELEMENT_FONT) {
            this.startFont(attributes);
        } else if (name == ELEMENT_COLOR) {
            this.startColor(attributes);
        } else if (name == ELEMENT_PAINTER) {
            this.startPainter(attributes, name);
        } else if (name == ELEMENT_IMAGE_PAINTER) {
            this.startPainter(attributes, name);
        } else if (name == ELEMENT_PROPERTY) {
            this.startProperty(attributes, ELEMENT_PROPERTY);
        } else if (name == ELEMENT_DEFAULTS_PROPERTY) {
            this.startProperty(attributes, ELEMENT_DEFAULTS_PROPERTY);
        } else if (name == ELEMENT_SYNTH_GRAPHICS) {
            this.startGraphics(attributes);
        } else if (name == ELEMENT_INSETS) {
            this.startInsets(attributes);
        } else if (name == ELEMENT_BIND) {
            this.startBind(attributes);
        } else if (name == ELEMENT_BIND_KEY) {
            this.startBindKey(attributes);
        } else if (name == ELEMENT_IMAGE_ICON) {
            this.startImageIcon(attributes);
        } else if (name == ELEMENT_OPAQUE) {
            this.startOpaque(attributes);
        } else if (name == ELEMENT_INPUT_MAP) {
            this.startInputMap(attributes);
        } else if (name != ELEMENT_SYNTH) {
            if (this._depth++ == 0) {
                this.getHandler().startDocument();
            }
            this.getHandler().startElement(uri, local, name, attributes);
        }
    }

    @Override
    public void endElement(String uri, String local, String name) throws SAXException {
        if (this.isForwarding()) {
            this.getHandler().endElement(uri, local, name);
            --this._depth;
            if (!this.isForwarding()) {
                this.getHandler().startDocument();
            }
        } else if ((name = name.intern()) == "style") {
            this.endStyle();
        } else if (name == ELEMENT_STATE) {
            this.endState();
        } else if (name == ELEMENT_INPUT_MAP) {
            this.endInputMap();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.isForwarding()) {
            this.getHandler().characters(ch, start, length);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.isForwarding()) {
            this.getHandler().ignorableWhitespace(ch, start, length);
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        if (this.isForwarding()) {
            this.getHandler().processingInstruction(target, data);
        }
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        if (this.isForwarding()) {
            this.getHandler().warning(e);
        }
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        if (this.isForwarding()) {
            this.getHandler().error(e);
        }
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        if (this.isForwarding()) {
            this.getHandler().fatalError(e);
        }
        throw e;
    }

    private static class LazyImageIcon
    extends ImageIcon
    implements UIResource {
        private URL location;

        public LazyImageIcon(URL location) {
            this.location = location;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.getImage() != null) {
                super.paintIcon(c, g, x, y);
            }
        }

        @Override
        public int getIconWidth() {
            if (this.getImage() != null) {
                return super.getIconWidth();
            }
            return 0;
        }

        @Override
        public int getIconHeight() {
            if (this.getImage() != null) {
                return super.getIconHeight();
            }
            return 0;
        }

        @Override
        public Image getImage() {
            if (this.location != null) {
                this.setImage(Toolkit.getDefaultToolkit().getImage(this.location));
                this.location = null;
            }
            return super.getImage();
        }
    }
}

