/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.modules.output.graphics;

import org.jfree.layouting.modules.output.graphics.GraphicsContentInterceptor;
import org.jfree.layouting.modules.output.graphics.GraphicsOutputProcessorMetaData;
import org.jfree.layouting.modules.output.graphics.LogicalPageDrawable;
import org.jfree.layouting.modules.output.graphics.PhysicalPageDrawable;
import org.jfree.layouting.output.OutputProcessorMetaData;
import org.jfree.layouting.output.pageable.AbstractPageableProcessor;
import org.jfree.layouting.output.pageable.LogicalPageKey;
import org.jfree.layouting.output.pageable.PageFlowSelector;
import org.jfree.layouting.output.pageable.PhysicalPageKey;
import org.jfree.layouting.renderer.model.page.LogicalPageBox;
import org.jfree.layouting.renderer.model.page.PageGrid;
import org.jfree.layouting.renderer.model.page.PhysicalPageBox;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.fonts.awt.AWTFontRegistry;
import org.pentaho.reporting.libraries.fonts.registry.DefaultFontStorage;
import org.pentaho.reporting.libraries.fonts.registry.FontRegistry;
import org.pentaho.reporting.libraries.fonts.registry.FontStorage;

public class GraphicsOutputProcessor
extends AbstractPageableProcessor {
    private OutputProcessorMetaData metaData;
    private GraphicsContentInterceptor interceptor;

    public GraphicsOutputProcessor(Configuration configuration) {
        super(configuration);
        DefaultFontStorage defaultFontStorage = new DefaultFontStorage((FontRegistry)new AWTFontRegistry());
        this.metaData = new GraphicsOutputProcessorMetaData((FontStorage)defaultFontStorage, false);
    }

    public OutputProcessorMetaData getMetaData() {
        return this.metaData;
    }

    public GraphicsContentInterceptor getInterceptor() {
        return this.interceptor;
    }

    public void setInterceptor(GraphicsContentInterceptor graphicsContentInterceptor) {
        this.interceptor = graphicsContentInterceptor;
    }

    protected PageFlowSelector getFlowSelector() {
        return this.getInterceptor();
    }

    protected void processPhysicalPage(PageGrid pageGrid, LogicalPageBox logicalPageBox, int n, int n2, PhysicalPageKey physicalPageKey) {
        PhysicalPageBox physicalPageBox = pageGrid.getPage(n, n2);
        LogicalPageDrawable logicalPageDrawable = new LogicalPageDrawable(logicalPageBox);
        PhysicalPageDrawable physicalPageDrawable = new PhysicalPageDrawable(logicalPageDrawable, physicalPageBox);
        this.interceptor.processPhysicalPage(physicalPageKey, physicalPageDrawable);
    }

    protected void processLogicalPage(LogicalPageKey logicalPageKey, LogicalPageBox logicalPageBox) {
        LogicalPageDrawable logicalPageDrawable = new LogicalPageDrawable(logicalPageBox);
        this.interceptor.processLogicalPage(logicalPageKey, logicalPageDrawable);
    }
}

