/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho.layoutprocessor;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.text.SimpleDateFormat;
import org.jfree.layouting.util.AttributeMap;
import org.jfree.report.DataFlags;
import org.jfree.report.DataRow;
import org.jfree.report.DataSourceException;
import org.jfree.report.data.DefaultDataFlags;
import org.jfree.report.expressions.Expression;
import org.jfree.report.expressions.FormulaExpression;
import org.jfree.report.flow.FlowController;
import org.jfree.report.flow.layoutprocessor.LayoutController;
import org.jfree.report.flow.layoutprocessor.LayoutControllerUtil;
import org.jfree.report.flow.layoutprocessor.SectionLayoutController;
import org.jfree.report.structure.DetailSection;
import org.jfree.report.structure.Element;
import org.jfree.report.structure.Group;
import org.libreoffice.report.pentaho.layoutprocessor.AbstractReportElementLayoutController;
import org.libreoffice.report.pentaho.layoutprocessor.TableCellLayoutController;
import org.libreoffice.report.pentaho.model.FormattedTextElement;
import org.libreoffice.report.pentaho.model.ReportElement;
import org.pentaho.reporting.libraries.formula.lvalues.ContextLookup;
import org.pentaho.reporting.libraries.formula.lvalues.LValue;

public class FormatValueUtility {
    private static final String BOOLEAN_VALUE = "boolean-value";
    private static final String STRING_VALUE = "string-value";
    public static final String VALUE_TYPE = "value-type";
    private static final String VALUE = "value";
    private static SimpleDateFormat dateFormat;
    private static SimpleDateFormat timeFormat;

    private FormatValueUtility() {
    }

    public static String applyValueForVariable(Object value, AttributeMap variableSection) {
        String ret = null;
        if (value instanceof Time) {
            variableSection.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", VALUE_TYPE, (Object)"time");
            ret = FormatValueUtility.formatTime((Time)value);
            variableSection.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "time-value", (Object)ret);
        } else if (value instanceof Date) {
            variableSection.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", VALUE_TYPE, (Object)"date");
            ret = FormatValueUtility.formatDate((java.util.Date)value);
            variableSection.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "date-value", (Object)ret);
        } else if (value instanceof java.util.Date) {
            variableSection.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", VALUE_TYPE, (Object)"date");
            ret = FormatValueUtility.formatDate((java.util.Date)value);
            variableSection.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "date-value", (Object)ret);
        } else if (value instanceof Number) {
            variableSection.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", VALUE_TYPE, (Object)"float");
            variableSection.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", VALUE, (Object)String.valueOf(value));
        } else if (value instanceof Boolean) {
            variableSection.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", VALUE_TYPE, (Object)"boolean");
            if (Boolean.TRUE.equals(value)) {
                variableSection.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", BOOLEAN_VALUE, (Object)"true");
            } else {
                variableSection.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", BOOLEAN_VALUE, (Object)"false");
            }
        } else if (value != null) {
            variableSection.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", VALUE_TYPE, (Object)"string");
            variableSection.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", STRING_VALUE, (Object)String.valueOf(value));
        } else {
            variableSection.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", VALUE_TYPE, (Object)"void");
        }
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void applyValueForCell(Object value, AttributeMap variableSection, String valueType) {
        if (value instanceof Time) {
            variableSection.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", VALUE_TYPE, (Object)"time");
            variableSection.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "time-value", (Object)FormatValueUtility.formatTime((Time)value));
            return;
        } else if (value instanceof Date) {
            variableSection.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", VALUE_TYPE, (Object)"date");
            variableSection.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "date-value", (Object)FormatValueUtility.formatDate((java.util.Date)value));
            return;
        } else if (value instanceof java.util.Date) {
            variableSection.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", VALUE_TYPE, (Object)"date");
            variableSection.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "date-value", (Object)FormatValueUtility.formatDate((java.util.Date)value));
            return;
        } else if (value instanceof BigDecimal) {
            variableSection.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", VALUE_TYPE, (Object)"float");
            variableSection.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", VALUE, (Object)String.valueOf(value));
            return;
        } else if (value instanceof Number) {
            variableSection.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", VALUE_TYPE, (Object)"float");
            variableSection.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", VALUE, (Object)String.valueOf(value));
            return;
        } else if (value instanceof Boolean) {
            variableSection.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", VALUE_TYPE, (Object)"boolean");
            if (Boolean.TRUE.equals(value)) {
                variableSection.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", BOOLEAN_VALUE, (Object)"true");
                return;
            } else {
                variableSection.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", BOOLEAN_VALUE, (Object)"false");
            }
            return;
        } else if (value != null) {
            try {
                Float number = Float.valueOf(String.valueOf(value));
                FormatValueUtility.applyValueForCell(number, variableSection, valueType);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                if ("string".equals(valueType)) return;
                variableSection.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", VALUE_TYPE, (Object)"string");
                return;
            }
        } else {
            variableSection.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", VALUE_TYPE, (Object)"void");
        }
    }

    private static synchronized String formatDate(java.util.Date date) {
        if (dateFormat == null) {
            dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.'S'Z'");
        }
        return dateFormat.format(date);
    }

    private static synchronized String formatTime(java.util.Date date) {
        if (timeFormat == null) {
            timeFormat = new SimpleDateFormat("'PT'HH'H'mm'M'ss'S'");
        }
        return timeFormat.format(date);
    }

    public static DataFlags computeDataFlag(FormattedTextElement element, FlowController flowController) throws DataSourceException {
        FormulaExpression formulaExpression = element.getValueExpression();
        Object result = LayoutControllerUtil.evaluateExpression(flowController, element, formulaExpression);
        if (result == null) {
            return null;
        }
        if (result instanceof DataFlags) {
            return (DataFlags)result;
        }
        return new DefaultDataFlags(null, result, true);
    }

    public static boolean shouldPrint(LayoutController ref, ReportElement text) throws DataSourceException {
        Object o;
        boolean isValueChanged;
        if (ref instanceof AbstractReportElementLayoutController) {
            isValueChanged = ((AbstractReportElementLayoutController)ref).isValueChanged();
        } else if (ref instanceof TableCellLayoutController) {
            isValueChanged = ((TableCellLayoutController)ref).isValueChanged();
        } else {
            throw new AssertionError((Object)"org.libreoffice.report.pentaho.layoutprocessor.FormatValueUtility.shouldPrint expects an implementor of isValueChanged as first argument");
        }
        if (!(isValueChanged || text.isPrintRepeatedValues() || text.isPrintWhenGroupChange() && FormatValueUtility.isGroupChanged(ref))) {
            return false;
        }
        Expression dc = text.getDisplayCondition();
        return dc == null || !Boolean.FALSE.equals(o = LayoutControllerUtil.evaluateExpression(ref.getFlowController(), text, dc));
    }

    private static boolean isGroupChanged(LayoutController ref) {
        SectionLayoutController slc = FormatValueUtility.findGroupOrDetail(ref);
        if (slc == null) {
            return true;
        }
        return slc.getIterationCount() == 0;
    }

    private static SectionLayoutController findGroupOrDetail(LayoutController ref) {
        LayoutController parent = ref.getParent();
        while (parent != null) {
            if (!(parent instanceof SectionLayoutController)) {
                parent = parent.getParent();
                continue;
            }
            SectionLayoutController slc = (SectionLayoutController)parent;
            Element element = slc.getElement();
            if (!(element instanceof Group) && !(element instanceof DetailSection)) {
                parent = parent.getParent();
                continue;
            }
            return (SectionLayoutController)parent;
        }
        return null;
    }

    public static boolean isReferenceChanged(LayoutController ref, LValue lValue) {
        if (lValue instanceof ContextLookup) {
            ContextLookup rval = (ContextLookup)lValue;
            String s = rval.getName();
            DataRow view = ref.getFlowController().getMasterRow().getGlobalView();
            try {
                DataFlags flags = view.getFlags(s);
                if (flags != null && flags.isChanged()) {
                    return true;
                }
            }
            catch (DataSourceException dataSourceException) {
                // empty catch block
            }
        }
        LValue[] childValues = lValue.getChildValues();
        for (int i = 0; i < childValues.length; ++i) {
            LValue value = childValues[i];
            if (!FormatValueUtility.isReferenceChanged(ref, value)) continue;
            return true;
        }
        return false;
    }
}

