/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.resolver.computed.position;

import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.keys.box.BoxStyleKeys;
import org.jfree.layouting.input.style.keys.box.DisplayModel;
import org.jfree.layouting.input.style.keys.box.DisplayRole;
import org.jfree.layouting.input.style.keys.box.Floating;
import org.jfree.layouting.input.style.keys.positioning.Position;
import org.jfree.layouting.input.style.keys.positioning.PositioningStyleKeys;
import org.jfree.layouting.input.style.values.CSSConstant;
import org.jfree.layouting.input.style.values.CSSFunctionValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.resolver.computed.ConstantsResolveHandler;

public class PositionResolveHandler
extends ConstantsResolveHandler {
    public PositionResolveHandler() {
        this.addNormalizeValue(Position.ABSOLUTE);
        this.addNormalizeValue(Position.FIXED);
        this.addNormalizeValue(Position.RELATIVE);
        this.addNormalizeValue(Position.STATIC);
        this.setFallback(Position.STATIC);
    }

    public StyleKey[] getRequiredStyles() {
        return new StyleKey[]{BoxStyleKeys.DISPLAY_MODEL};
    }

    public void resolve(LayoutProcess layoutProcess, LayoutElement layoutElement, StyleKey styleKey) {
        LayoutContext layoutContext = layoutElement.getLayoutContext();
        CSSValue cSSValue = layoutContext.getValue(BoxStyleKeys.DISPLAY_MODEL);
        if (DisplayRole.NONE.equals(cSSValue)) {
            layoutContext.setValue(PositioningStyleKeys.POSITION, Position.STATIC);
            return;
        }
        CSSValue cSSValue2 = layoutContext.getValue(styleKey);
        if (cSSValue2 instanceof CSSFunctionValue) {
            CSSFunctionValue cSSFunctionValue = (CSSFunctionValue)cSSValue2;
            if ("running".equals(cSSFunctionValue.getFunctionName())) {
                layoutContext.setValue(BoxStyleKeys.DISPLAY_MODEL, DisplayModel.BLOCK_INSIDE);
                layoutContext.setValue(BoxStyleKeys.DISPLAY_ROLE, DisplayRole.BLOCK);
                return;
            }
            layoutContext.setValue(PositioningStyleKeys.POSITION, Position.STATIC);
            return;
        }
        CSSConstant cSSConstant = (CSSConstant)this.resolveValue(layoutProcess, layoutElement, styleKey);
        layoutContext.setValue(PositioningStyleKeys.POSITION, cSSConstant);
        if (Position.ABSOLUTE.equals(cSSConstant) || Position.FIXED.equals(cSSConstant)) {
            layoutContext.setValue(BoxStyleKeys.DISPLAY_MODEL, DisplayModel.BLOCK_INSIDE);
            layoutContext.setValue(BoxStyleKeys.DISPLAY_ROLE, DisplayRole.BLOCK);
            layoutContext.setValue(BoxStyleKeys.FLOAT, Floating.NONE);
        }
    }
}

