/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.modules.output.graphics;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import org.jfree.layouting.modules.output.graphics.LogicalPageDrawable;
import org.jfree.layouting.modules.output.graphics.PageDrawable;
import org.jfree.layouting.renderer.model.page.PhysicalPageBox;
import org.jfree.layouting.util.geom.StrictGeomUtility;

public class PhysicalPageDrawable
implements PageDrawable {
    private LogicalPageDrawable pageDrawable;
    private PageFormat pageFormat;
    private long globalX;
    private long globalY;

    public PhysicalPageDrawable(LogicalPageDrawable logicalPageDrawable, PhysicalPageBox physicalPageBox) {
        this.pageDrawable = logicalPageDrawable;
        this.pageFormat = new PageFormat();
        this.globalX = physicalPageBox.getGlobalX();
        this.globalY = physicalPageBox.getGlobalY();
        if (physicalPageBox.getWidth() < physicalPageBox.getHeight()) {
            Paper paper = new Paper();
            paper.setSize(StrictGeomUtility.toExternalValue(physicalPageBox.getWidth()), StrictGeomUtility.toExternalValue(physicalPageBox.getHeight()));
            paper.setImageableArea(StrictGeomUtility.toExternalValue(physicalPageBox.getImageableX()), StrictGeomUtility.toExternalValue(physicalPageBox.getImageableY()), StrictGeomUtility.toExternalValue(physicalPageBox.getImageableWidth()), StrictGeomUtility.toExternalValue(physicalPageBox.getImageableHeight()));
            this.pageFormat.setPaper(paper);
            this.pageFormat.setOrientation(1);
        } else {
            Paper paper = new Paper();
            paper.setSize(StrictGeomUtility.toExternalValue(physicalPageBox.getHeight()), StrictGeomUtility.toExternalValue(physicalPageBox.getWidth()));
            paper.setImageableArea(StrictGeomUtility.toExternalValue(physicalPageBox.getImageableY()), StrictGeomUtility.toExternalValue(physicalPageBox.getImageableX()), StrictGeomUtility.toExternalValue(physicalPageBox.getImageableHeight()), StrictGeomUtility.toExternalValue(physicalPageBox.getImageableWidth()));
            this.pageFormat.setPaper(paper);
            this.pageFormat.setOrientation(0);
        }
    }

    public PageFormat getPageFormat() {
        return this.pageFormat;
    }

    public Dimension getPreferredSize() {
        return new Dimension((int)this.pageFormat.getWidth(), (int)this.pageFormat.getHeight());
    }

    public boolean isPreserveAspectRatio() {
        return true;
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        graphics2D.translate(this.globalX, this.globalY);
        graphics2D.translate(this.pageFormat.getImageableX(), this.pageFormat.getImageableY());
        this.pageDrawable.draw(graphics2D, new Rectangle2D.Double(0.0, 0.0, this.pageFormat.getImageableWidth(), this.pageFormat.getImageableHeight()));
        graphics2D.dispose();
    }
}

