/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.spelling.hunspell;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.rules.spelling.hunspell.HunspellRule;
import org.languagetool.rules.spelling.morfologik.MorfologikMultiSpeller;
import org.languagetool.tokenizers.CompoundWordTokenizer;
import org.languagetool.tools.StringTools;

public abstract class CompoundAwareHunspellRule
extends HunspellRule {
    private static final int MAX_SUGGESTIONS = 20;
    private final CompoundWordTokenizer wordSplitter;
    private final MorfologikMultiSpeller morfoSpeller;

    protected abstract void filterForLanguage(List<String> var1);

    public CompoundAwareHunspellRule(ResourceBundle messages, Language language, CompoundWordTokenizer wordSplitter, MorfologikMultiSpeller morfoSpeller) {
        super(messages, language);
        this.wordSplitter = wordSplitter;
        this.morfoSpeller = morfoSpeller;
    }

    @Override
    public List<String> getSuggestions(String word) throws IOException {
        if (this.needsInit) {
            this.init();
        }
        List<String> candidates = this.getCandidates(word);
        List<String> simpleSuggestions = this.getCorrectWords(candidates);
        List<String> noSplitSuggestions = this.morfoSpeller.getSuggestions(word);
        if (StringTools.startsWithUppercase(word) && !StringTools.isAllUppercase(word)) {
            List<String> noSplitLowercaseSuggestions = this.morfoSpeller.getSuggestions(word.toLowerCase());
            for (String suggestion : noSplitLowercaseSuggestions) {
                noSplitSuggestions.add(StringTools.uppercaseFirstChar(suggestion));
            }
        }
        ArrayList<String> suggestions = new ArrayList<String>();
        for (int i = 0; i < Math.max(simpleSuggestions.size(), noSplitSuggestions.size()); ++i) {
            if (i < simpleSuggestions.size()) {
                suggestions.add(simpleSuggestions.get(i));
            }
            if (i >= noSplitSuggestions.size()) continue;
            suggestions.add(noSplitSuggestions.get(i));
        }
        this.filterDupes(suggestions);
        this.filterForLanguage(suggestions);
        List<String> sortedSuggestions = this.sortSuggestionByQuality(word, suggestions);
        return sortedSuggestions.subList(0, Math.min(20, sortedSuggestions.size()));
    }

    protected List<String> getCandidates(String word) {
        return this.wordSplitter.tokenize(word);
    }

    protected List<String> getCandidates(List<String> parts) {
        int partCount = 0;
        ArrayList<String> candidates = new ArrayList<String>();
        for (String part : parts) {
            if (this.hunspellDict.misspelled(part)) {
                boolean doUpperCase = partCount > 0 && !StringTools.startsWithUppercase(part);
                List<String> suggestions = this.morfoSpeller.getSuggestions(doUpperCase ? StringTools.uppercaseFirstChar(part) : part);
                if (suggestions.size() == 0) {
                    suggestions = this.morfoSpeller.getSuggestions(doUpperCase ? StringTools.lowercaseFirstChar(part) : part);
                }
                for (String suggestion : suggestions) {
                    ArrayList<String> partsCopy = new ArrayList<String>(parts);
                    if (partCount > 0 && parts.get(partCount).startsWith("-") && parts.get(partCount).length() > 1) {
                        partsCopy.set(partCount, "-" + StringTools.uppercaseFirstChar(suggestion.substring(1)));
                    } else if (partCount > 0 && !parts.get(partCount - 1).endsWith("-")) {
                        partsCopy.set(partCount, suggestion.toLowerCase());
                    } else {
                        partsCopy.set(partCount, suggestion);
                    }
                    String candidate = String.join((CharSequence)"", partsCopy);
                    if (!this.isMisspelled(candidate)) {
                        candidates.add(candidate);
                    }
                    if (partCount >= parts.size() - 1 || !part.endsWith("s") || !suggestion.endsWith("-")) continue;
                    partsCopy.set(partCount, suggestion.substring(0, suggestion.length() - 1));
                    String infixCandidate = String.join((CharSequence)"", partsCopy);
                    if (this.isMisspelled(infixCandidate)) continue;
                    candidates.add(infixCandidate);
                }
            }
            ++partCount;
        }
        return candidates;
    }

    protected List<String> sortSuggestionByQuality(String misspelling, List<String> suggestions) {
        return suggestions;
    }

    private void filterDupes(List<String> words) {
        HashSet<String> seen = new HashSet<String>();
        Iterator<String> iterator = words.iterator();
        while (iterator.hasNext()) {
            String word = iterator.next();
            if (seen.contains(word)) {
                iterator.remove();
            }
            seen.add(word);
        }
    }

    private List<String> getCorrectWords(List<String> wordsOrPhrases) {
        ArrayList<String> result = new ArrayList<String>();
        for (String wordOrPhrase : wordsOrPhrases) {
            String[] words = this.tokenizeText(wordOrPhrase);
            boolean wordIsOkay = true;
            for (String word : words) {
                if (!this.hunspellDict.misspelled(word)) continue;
                wordIsOkay = false;
                break;
            }
            if (!wordIsOkay) continue;
            result.add(wordOrPhrase);
        }
        return result;
    }
}

