/*
 * Descriptions for errors generated from
 * [MS-ERREF] http://msdn.microsoft.com/en-us/library/cc704588.aspx
 */

#ifndef _NTSTATUS_GEN_H
#define _NTSTATUS_GEN_H
#define NT_STATUS_SUCCESS NT_STATUS(0x0)
#define NT_STATUS_WAIT_0 NT_STATUS(0x0)
#define NT_STATUS_WAIT_1 NT_STATUS(0x1)
#define NT_STATUS_WAIT_2 NT_STATUS(0x2)
#define NT_STATUS_WAIT_3 NT_STATUS(0x3)
#define NT_STATUS_WAIT_63 NT_STATUS(0x3f)
#define NT_STATUS_ABANDONED NT_STATUS(0x80)
#define NT_STATUS_ABANDONED_WAIT_0 NT_STATUS(0x80)
#define NT_STATUS_ABANDONED_WAIT_63 NT_STATUS(0xbf)
#define NT_STATUS_USER_APC NT_STATUS(0xc0)
#define NT_STATUS_ALERTED NT_STATUS(0x101)
#define NT_STATUS_TIMEOUT NT_STATUS(0x102)
#define NT_STATUS_PENDING NT_STATUS(0x103)
#define NT_STATUS_REPARSE NT_STATUS(0x104)
#define NT_STATUS_MORE_ENTRIES NT_STATUS(0x105)
#define NT_STATUS_NOT_ALL_ASSIGNED NT_STATUS(0x106)
#define NT_STATUS_SOME_NOT_MAPPED NT_STATUS(0x107)
#define NT_STATUS_OPLOCK_BREAK_IN_PROGRESS NT_STATUS(0x108)
#define NT_STATUS_VOLUME_MOUNTED NT_STATUS(0x109)
#define NT_STATUS_RXACT_COMMITTED NT_STATUS(0x10a)
#define NT_STATUS_NOTIFY_CLEANUP NT_STATUS(0x10b)
#define NT_STATUS_NOTIFY_ENUM_DIR NT_STATUS(0x10c)
#define NT_STATUS_NO_QUOTAS_FOR_ACCOUNT NT_STATUS(0x10d)
#define NT_STATUS_PRIMARY_TRANSPORT_CONNECT_FAILED NT_STATUS(0x10e)
#define NT_STATUS_PAGE_FAULT_TRANSITION NT_STATUS(0x110)
#define NT_STATUS_PAGE_FAULT_DEMAND_ZERO NT_STATUS(0x111)
#define NT_STATUS_PAGE_FAULT_COPY_ON_WRITE NT_STATUS(0x112)
#define NT_STATUS_PAGE_FAULT_GUARD_PAGE NT_STATUS(0x113)
#define NT_STATUS_PAGE_FAULT_PAGING_FILE NT_STATUS(0x114)
#define NT_STATUS_CACHE_PAGE_LOCKED NT_STATUS(0x115)
#define NT_STATUS_CRASH_DUMP NT_STATUS(0x116)
#define NT_STATUS_BUFFER_ALL_ZEROS NT_STATUS(0x117)
#define NT_STATUS_REPARSE_OBJECT NT_STATUS(0x118)
#define NT_STATUS_RESOURCE_REQUIREMENTS_CHANGED NT_STATUS(0x119)
#define NT_STATUS_TRANSLATION_COMPLETE NT_STATUS(0x120)
#define NT_STATUS_DS_MEMBERSHIP_EVALUATED_LOCALLY NT_STATUS(0x121)
#define NT_STATUS_NOTHING_TO_TERMINATE NT_STATUS(0x122)
#define NT_STATUS_PROCESS_NOT_IN_JOB NT_STATUS(0x123)
#define NT_STATUS_PROCESS_IN_JOB NT_STATUS(0x124)
#define NT_STATUS_VOLSNAP_HIBERNATE_READY NT_STATUS(0x125)
#define NT_STATUS_FSFILTER_OP_COMPLETED_SUCCESSFULLY NT_STATUS(0x126)
#define NT_STATUS_INTERRUPT_VECTOR_ALREADY_CONNECTED NT_STATUS(0x127)
#define NT_STATUS_INTERRUPT_STILL_CONNECTED NT_STATUS(0x128)
#define NT_STATUS_PROCESS_CLONED NT_STATUS(0x129)
#define NT_STATUS_FILE_LOCKED_WITH_ONLY_READERS NT_STATUS(0x12a)
#define NT_STATUS_FILE_LOCKED_WITH_WRITERS NT_STATUS(0x12b)
#define NT_STATUS_RESOURCEMANAGER_READ_ONLY NT_STATUS(0x202)
#define NT_STATUS_WAIT_FOR_OPLOCK NT_STATUS(0x367)
#define NT_STATUS_DBG_EXCEPTION_HANDLED NT_STATUS(0x10001)
#define NT_STATUS_DBG_CONTINUE NT_STATUS(0x10002)
#define NT_STATUS_FLT_IO_COMPLETE NT_STATUS(0x1c0001)
#define NT_STATUS_FILE_NOT_AVAILABLE NT_STATUS(0xc0000467L)
#define NT_STATUS_SHARE_UNAVAILABLE NT_STATUS(0xc0000480L)
#define NT_STATUS_CALLBACK_RETURNED_THREAD_AFFINITY NT_STATUS(0xc0000721L)
#define NT_STATUS_OBJECT_NAME_EXISTS NT_STATUS(0x40000000)
#define NT_STATUS_THREAD_WAS_SUSPENDED NT_STATUS(0x40000001)
#define NT_STATUS_WORKING_SET_LIMIT_RANGE NT_STATUS(0x40000002)
#define NT_STATUS_IMAGE_NOT_AT_BASE NT_STATUS(0x40000003)
#define NT_STATUS_RXACT_STATE_CREATED NT_STATUS(0x40000004)
#define NT_STATUS_SEGMENT_NOTIFICATION NT_STATUS(0x40000005)
#define NT_STATUS_LOCAL_USER_SESSION_KEY NT_STATUS(0x40000006)
#define NT_STATUS_BAD_CURRENT_DIRECTORY NT_STATUS(0x40000007)
#define NT_STATUS_SERIAL_MORE_WRITES NT_STATUS(0x40000008)
#define NT_STATUS_REGISTRY_RECOVERED NT_STATUS(0x40000009)
#define NT_STATUS_FT_READ_RECOVERY_FROM_BACKUP NT_STATUS(0x4000000a)
#define NT_STATUS_FT_WRITE_RECOVERY NT_STATUS(0x4000000b)
#define NT_STATUS_SERIAL_COUNTER_TIMEOUT NT_STATUS(0x4000000c)
#define NT_STATUS_NULL_LM_PASSWORD NT_STATUS(0x4000000d)
#define NT_STATUS_IMAGE_MACHINE_TYPE_MISMATCH NT_STATUS(0x4000000e)
#define NT_STATUS_RECEIVE_PARTIAL NT_STATUS(0x4000000f)
#define NT_STATUS_RECEIVE_EXPEDITED NT_STATUS(0x40000010)
#define NT_STATUS_RECEIVE_PARTIAL_EXPEDITED NT_STATUS(0x40000011)
#define NT_STATUS_EVENT_DONE NT_STATUS(0x40000012)
#define NT_STATUS_EVENT_PENDING NT_STATUS(0x40000013)
#define NT_STATUS_CHECKING_FILE_SYSTEM NT_STATUS(0x40000014)
#define NT_STATUS_FATAL_APP_EXIT NT_STATUS(0x40000015)
#define NT_STATUS_PREDEFINED_HANDLE NT_STATUS(0x40000016)
#define NT_STATUS_WAS_UNLOCKED NT_STATUS(0x40000017)
#define NT_STATUS_SERVICE_NOTIFICATION NT_STATUS(0x40000018)
#define NT_STATUS_WAS_LOCKED NT_STATUS(0x40000019)
#define NT_STATUS_LOG_HARD_ERROR NT_STATUS(0x4000001a)
#define NT_STATUS_ALREADY_WIN32 NT_STATUS(0x4000001b)
#define NT_STATUS_WX86_UNSIMULATE NT_STATUS(0x4000001c)
#define NT_STATUS_WX86_CONTINUE NT_STATUS(0x4000001d)
#define NT_STATUS_WX86_SINGLE_STEP NT_STATUS(0x4000001e)
#define NT_STATUS_WX86_BREAKPOINT NT_STATUS(0x4000001f)
#define NT_STATUS_WX86_EXCEPTION_CONTINUE NT_STATUS(0x40000020)
#define NT_STATUS_WX86_EXCEPTION_LASTCHANCE NT_STATUS(0x40000021)
#define NT_STATUS_WX86_EXCEPTION_CHAIN NT_STATUS(0x40000022)
#define NT_STATUS_IMAGE_MACHINE_TYPE_MISMATCH_EXE NT_STATUS(0x40000023)
#define NT_STATUS_NO_YIELD_PERFORMED NT_STATUS(0x40000024)
#define NT_STATUS_TIMER_RESUME_IGNORED NT_STATUS(0x40000025)
#define NT_STATUS_ARBITRATION_UNHANDLED NT_STATUS(0x40000026)
#define NT_STATUS_CARDBUS_NOT_SUPPORTED NT_STATUS(0x40000027)
#define NT_STATUS_WX86_CREATEWX86TIB NT_STATUS(0x40000028)
#define NT_STATUS_MP_PROCESSOR_MISMATCH NT_STATUS(0x40000029)
#define NT_STATUS_HIBERNATED NT_STATUS(0x4000002a)
#define NT_STATUS_RESUME_HIBERNATION NT_STATUS(0x4000002b)
#define NT_STATUS_FIRMWARE_UPDATED NT_STATUS(0x4000002c)
#define NT_STATUS_DRIVERS_LEAKING_LOCKED_PAGES NT_STATUS(0x4000002d)
#define NT_STATUS_MESSAGE_RETRIEVED NT_STATUS(0x4000002e)
#define NT_STATUS_SYSTEM_POWERSTATE_TRANSITION NT_STATUS(0x4000002f)
#define NT_STATUS_ALPC_CHECK_COMPLETION_LIST NT_STATUS(0x40000030)
#define NT_STATUS_SYSTEM_POWERSTATE_COMPLEX_TRANSITION NT_STATUS(0x40000031)
#define NT_STATUS_ACCESS_AUDIT_BY_POLICY NT_STATUS(0x40000032)
#define NT_STATUS_ABANDON_HIBERFILE NT_STATUS(0x40000033)
#define NT_STATUS_BIZRULES_NOT_ENABLED NT_STATUS(0x40000034)
#define NT_STATUS_WAKE_SYSTEM NT_STATUS(0x40000294)
#define NT_STATUS_DS_SHUTTING_DOWN NT_STATUS(0x40000370)
#define NT_STATUS_DBG_REPLY_LATER NT_STATUS(0x40010001)
#define NT_STATUS_DBG_UNABLE_TO_PROVIDE_HANDLE NT_STATUS(0x40010002)
#define NT_STATUS_DBG_TERMINATE_THREAD NT_STATUS(0x40010003)
#define NT_STATUS_DBG_TERMINATE_PROCESS NT_STATUS(0x40010004)
#define NT_STATUS_DBG_CONTROL_C NT_STATUS(0x40010005)
#define NT_STATUS_DBG_PRINTEXCEPTION_C NT_STATUS(0x40010006)
#define NT_STATUS_DBG_RIPEXCEPTION NT_STATUS(0x40010007)
#define NT_STATUS_DBG_CONTROL_BREAK NT_STATUS(0x40010008)
#define NT_STATUS_DBG_COMMAND_EXCEPTION NT_STATUS(0x40010009)
#define NT_STATUS_RPC_UUID_LOCAL_ONLY NT_STATUS(0x40020056)
#define NT_STATUS_RPC_SEND_INCOMPLETE NT_STATUS(0x400200af)
#define NT_STATUS_CTX_CDM_CONNECT NT_STATUS(0x400a0004)
#define NT_STATUS_CTX_CDM_DISCONNECT NT_STATUS(0x400a0005)
#define NT_STATUS_SXS_RELEASE_ACTIVATION_CONTEXT NT_STATUS(0x4015000d)
#define NT_STATUS_RECOVERY_NOT_NEEDED NT_STATUS(0x40190034)
#define NT_STATUS_RM_ALREADY_STARTED NT_STATUS(0x40190035)
#define NT_STATUS_LOG_NO_RESTART NT_STATUS(0x401a000c)
#define NT_STATUS_VIDEO_DRIVER_DEBUG_REPORT_REQUEST NT_STATUS(0x401b00ec)
#define NT_STATUS_GRAPHICS_PARTIAL_DATA_POPULATED NT_STATUS(0x401e000a)
#define NT_STATUS_GRAPHICS_DRIVER_MISMATCH NT_STATUS(0x401e0117)
#define NT_STATUS_GRAPHICS_MODE_NOT_PINNED NT_STATUS(0x401e0307)
#define NT_STATUS_GRAPHICS_NO_PREFERRED_MODE NT_STATUS(0x401e031e)
#define NT_STATUS_GRAPHICS_DATASET_IS_EMPTY NT_STATUS(0x401e034b)
#define NT_STATUS_GRAPHICS_NO_MORE_ELEMENTS_IN_DATASET NT_STATUS(0x401e034c)
#define NT_STATUS_GRAPHICS_PATH_CONTENT_GEOMETRY_TRANSFORMATION_NOT_PINNED NT_STATUS(0x401e0351)
#define NT_STATUS_GRAPHICS_UNKNOWN_CHILD_STATUS NT_STATUS(0x401e042f)
#define NT_STATUS_GRAPHICS_LEADLINK_START_DEFERRED NT_STATUS(0x401e0437)
#define NT_STATUS_GRAPHICS_POLLING_TOO_FREQUENTLY NT_STATUS(0x401e0439)
#define NT_STATUS_GRAPHICS_START_DEFERRED NT_STATUS(0x401e043a)
#define NT_STATUS_NDIS_INDICATION_REQUIRED NT_STATUS(0x40230001)
#define NT_STATUS_GUARD_PAGE_VIOLATION NT_STATUS(0x80000001L)
#define NT_STATUS_DATATYPE_MISALIGNMENT NT_STATUS(0x80000002L)
#define NT_STATUS_BREAKPOINT NT_STATUS(0x80000003L)
#define NT_STATUS_SINGLE_STEP NT_STATUS(0x80000004L)
#define NT_STATUS_BUFFER_OVERFLOW NT_STATUS(0x80000005L)
#define NT_STATUS_NO_MORE_FILES NT_STATUS(0x80000006L)
#define NT_STATUS_WAKE_SYSTEM_DEBUGGER NT_STATUS(0x80000007L)
#define NT_STATUS_HANDLES_CLOSED NT_STATUS(0x8000000aL)
#define NT_STATUS_NO_INHERITANCE NT_STATUS(0x8000000bL)
#define NT_STATUS_GUID_SUBSTITUTION_MADE NT_STATUS(0x8000000cL)
#define NT_STATUS_PARTIAL_COPY NT_STATUS(0x8000000dL)
#define NT_STATUS_DEVICE_PAPER_EMPTY NT_STATUS(0x8000000eL)
#define NT_STATUS_DEVICE_POWERED_OFF NT_STATUS(0x8000000fL)
#define NT_STATUS_DEVICE_OFF_LINE NT_STATUS(0x80000010L)
#define NT_STATUS_DEVICE_BUSY NT_STATUS(0x80000011L)
#define NT_STATUS_NO_MORE_EAS NT_STATUS(0x80000012L)
#define NT_STATUS_INVALID_EA_NAME NT_STATUS(0x80000013L)
#define NT_STATUS_EA_LIST_INCONSISTENT NT_STATUS(0x80000014L)
#define NT_STATUS_INVALID_EA_FLAG NT_STATUS(0x80000015L)
#define NT_STATUS_VERIFY_REQUIRED NT_STATUS(0x80000016L)
#define NT_STATUS_EXTRANEOUS_INFORMATION NT_STATUS(0x80000017L)
#define NT_STATUS_RXACT_COMMIT_NECESSARY NT_STATUS(0x80000018L)
#define NT_STATUS_NO_MORE_ENTRIES NT_STATUS(0x8000001aL)
#define NT_STATUS_FILEMARK_DETECTED NT_STATUS(0x8000001bL)
#define NT_STATUS_MEDIA_CHANGED NT_STATUS(0x8000001cL)
#define NT_STATUS_BUS_RESET NT_STATUS(0x8000001dL)
#define NT_STATUS_END_OF_MEDIA NT_STATUS(0x8000001eL)
#define NT_STATUS_BEGINNING_OF_MEDIA NT_STATUS(0x8000001fL)
#define NT_STATUS_MEDIA_CHECK NT_STATUS(0x80000020L)
#define NT_STATUS_SETMARK_DETECTED NT_STATUS(0x80000021L)
#define NT_STATUS_NO_DATA_DETECTED NT_STATUS(0x80000022L)
#define NT_STATUS_REDIRECTOR_HAS_OPEN_HANDLES NT_STATUS(0x80000023L)
#define NT_STATUS_SERVER_HAS_OPEN_HANDLES NT_STATUS(0x80000024L)
#define NT_STATUS_ALREADY_DISCONNECTED NT_STATUS(0x80000025L)
#define NT_STATUS_LONGJUMP NT_STATUS(0x80000026L)
#define NT_STATUS_CLEANER_CARTRIDGE_INSTALLED NT_STATUS(0x80000027L)
#define NT_STATUS_PLUGPLAY_QUERY_VETOED NT_STATUS(0x80000028L)
#define NT_STATUS_UNWIND_CONSOLIDATE NT_STATUS(0x80000029L)
#define NT_STATUS_REGISTRY_HIVE_RECOVERED NT_STATUS(0x8000002aL)
#define NT_STATUS_DLL_MIGHT_BE_INSECURE NT_STATUS(0x8000002bL)
#define NT_STATUS_DLL_MIGHT_BE_INCOMPATIBLE NT_STATUS(0x8000002cL)
#define NT_STATUS_STOPPED_ON_SYMLINK NT_STATUS(0x8000002dL)
#define NT_STATUS_DEVICE_REQUIRES_CLEANING NT_STATUS(0x80000288L)
#define NT_STATUS_DEVICE_DOOR_OPEN NT_STATUS(0x80000289L)
#define NT_STATUS_DATA_LOST_REPAIR NT_STATUS(0x80000803L)
#define NT_STATUS_DBG_EXCEPTION_NOT_HANDLED NT_STATUS(0x80010001L)
#define NT_STATUS_CLUSTER_NODE_ALREADY_UP NT_STATUS(0x80130001L)
#define NT_STATUS_CLUSTER_NODE_ALREADY_DOWN NT_STATUS(0x80130002L)
#define NT_STATUS_CLUSTER_NETWORK_ALREADY_ONLINE NT_STATUS(0x80130003L)
#define NT_STATUS_CLUSTER_NETWORK_ALREADY_OFFLINE NT_STATUS(0x80130004L)
#define NT_STATUS_CLUSTER_NODE_ALREADY_MEMBER NT_STATUS(0x80130005L)
#define NT_STATUS_COULD_NOT_RESIZE_LOG NT_STATUS(0x80190009L)
#define NT_STATUS_NO_TXF_METADATA NT_STATUS(0x80190029L)
#define NT_STATUS_CANT_RECOVER_WITH_HANDLE_OPEN NT_STATUS(0x80190031L)
#define NT_STATUS_TXF_METADATA_ALREADY_PRESENT NT_STATUS(0x80190041L)
#define NT_STATUS_TRANSACTION_SCOPE_CALLBACKS_NOT_SET NT_STATUS(0x80190042L)
#define NT_STATUS_VIDEO_HUNG_DISPLAY_DRIVER_THREAD_RECOVERED NT_STATUS(0x801b00ebL)
#define NT_STATUS_FLT_BUFFER_TOO_SMALL NT_STATUS(0x801c0001L)
#define NT_STATUS_FVE_PARTIAL_METADATA NT_STATUS(0x80210001L)
#define NT_STATUS_FVE_TRANSIENT_STATE NT_STATUS(0x80210002L)
#define NT_STATUS_UNSUCCESSFUL NT_STATUS(0xc0000001L)
#define NT_STATUS_NOT_IMPLEMENTED NT_STATUS(0xc0000002L)
#define NT_STATUS_INVALID_INFO_CLASS NT_STATUS(0xc0000003L)
#define NT_STATUS_INFO_LENGTH_MISMATCH NT_STATUS(0xc0000004L)
#define NT_STATUS_ACCESS_VIOLATION NT_STATUS(0xc0000005L)
#define NT_STATUS_IN_PAGE_ERROR NT_STATUS(0xc0000006L)
#define NT_STATUS_PAGEFILE_QUOTA NT_STATUS(0xc0000007L)
#define NT_STATUS_INVALID_HANDLE NT_STATUS(0xc0000008L)
#define NT_STATUS_BAD_INITIAL_STACK NT_STATUS(0xc0000009L)
#define NT_STATUS_BAD_INITIAL_PC NT_STATUS(0xc000000aL)
#define NT_STATUS_INVALID_CID NT_STATUS(0xc000000bL)
#define NT_STATUS_TIMER_NOT_CANCELED NT_STATUS(0xc000000cL)
#define NT_STATUS_INVALID_PARAMETER NT_STATUS(0xc000000dL)
#define NT_STATUS_NO_SUCH_DEVICE NT_STATUS(0xc000000eL)
#define NT_STATUS_NO_SUCH_FILE NT_STATUS(0xc000000fL)
#define NT_STATUS_INVALID_DEVICE_REQUEST NT_STATUS(0xc0000010L)
#define NT_STATUS_END_OF_FILE NT_STATUS(0xc0000011L)
#define NT_STATUS_WRONG_VOLUME NT_STATUS(0xc0000012L)
#define NT_STATUS_NO_MEDIA_IN_DEVICE NT_STATUS(0xc0000013L)
#define NT_STATUS_UNRECOGNIZED_MEDIA NT_STATUS(0xc0000014L)
#define NT_STATUS_NONEXISTENT_SECTOR NT_STATUS(0xc0000015L)
#define NT_STATUS_MORE_PROCESSING_REQUIRED NT_STATUS(0xc0000016L)
#define NT_STATUS_NO_MEMORY NT_STATUS(0xc0000017L)
#define NT_STATUS_CONFLICTING_ADDRESSES NT_STATUS(0xc0000018L)
#define NT_STATUS_NOT_MAPPED_VIEW NT_STATUS(0xc0000019L)
#define NT_STATUS_UNABLE_TO_FREE_VM NT_STATUS(0xc000001aL)
#define NT_STATUS_UNABLE_TO_DELETE_SECTION NT_STATUS(0xc000001bL)
#define NT_STATUS_INVALID_SYSTEM_SERVICE NT_STATUS(0xc000001cL)
#define NT_STATUS_ILLEGAL_INSTRUCTION NT_STATUS(0xc000001dL)
#define NT_STATUS_INVALID_LOCK_SEQUENCE NT_STATUS(0xc000001eL)
#define NT_STATUS_INVALID_VIEW_SIZE NT_STATUS(0xc000001fL)
#define NT_STATUS_INVALID_FILE_FOR_SECTION NT_STATUS(0xc0000020L)
#define NT_STATUS_ALREADY_COMMITTED NT_STATUS(0xc0000021L)
#define NT_STATUS_ACCESS_DENIED NT_STATUS(0xc0000022L)
#define NT_STATUS_BUFFER_TOO_SMALL NT_STATUS(0xc0000023L)
#define NT_STATUS_OBJECT_TYPE_MISMATCH NT_STATUS(0xc0000024L)
#define NT_STATUS_NONCONTINUABLE_EXCEPTION NT_STATUS(0xc0000025L)
#define NT_STATUS_INVALID_DISPOSITION NT_STATUS(0xc0000026L)
#define NT_STATUS_UNWIND NT_STATUS(0xc0000027L)
#define NT_STATUS_BAD_STACK NT_STATUS(0xc0000028L)
#define NT_STATUS_INVALID_UNWIND_TARGET NT_STATUS(0xc0000029L)
#define NT_STATUS_NOT_LOCKED NT_STATUS(0xc000002aL)
#define NT_STATUS_PARITY_ERROR NT_STATUS(0xc000002bL)
#define NT_STATUS_UNABLE_TO_DECOMMIT_VM NT_STATUS(0xc000002cL)
#define NT_STATUS_NOT_COMMITTED NT_STATUS(0xc000002dL)
#define NT_STATUS_INVALID_PORT_ATTRIBUTES NT_STATUS(0xc000002eL)
#define NT_STATUS_PORT_MESSAGE_TOO_LONG NT_STATUS(0xc000002fL)
#define NT_STATUS_INVALID_PARAMETER_MIX NT_STATUS(0xc0000030L)
#define NT_STATUS_INVALID_QUOTA_LOWER NT_STATUS(0xc0000031L)
#define NT_STATUS_DISK_CORRUPT_ERROR NT_STATUS(0xc0000032L)
#define NT_STATUS_OBJECT_NAME_INVALID NT_STATUS(0xc0000033L)
#define NT_STATUS_OBJECT_NAME_NOT_FOUND NT_STATUS(0xc0000034L)
#define NT_STATUS_OBJECT_NAME_COLLISION NT_STATUS(0xc0000035L)
#define NT_STATUS_PORT_DISCONNECTED NT_STATUS(0xc0000037L)
#define NT_STATUS_DEVICE_ALREADY_ATTACHED NT_STATUS(0xc0000038L)
#define NT_STATUS_OBJECT_PATH_INVALID NT_STATUS(0xc0000039L)
#define NT_STATUS_OBJECT_PATH_NOT_FOUND NT_STATUS(0xc000003aL)
#define NT_STATUS_OBJECT_PATH_SYNTAX_BAD NT_STATUS(0xc000003bL)
#define NT_STATUS_DATA_OVERRUN NT_STATUS(0xc000003cL)
#define NT_STATUS_DATA_LATE_ERROR NT_STATUS(0xc000003dL)
#define NT_STATUS_DATA_ERROR NT_STATUS(0xc000003eL)
#define NT_STATUS_CRC_ERROR NT_STATUS(0xc000003fL)
#define NT_STATUS_SECTION_TOO_BIG NT_STATUS(0xc0000040L)
#define NT_STATUS_PORT_CONNECTION_REFUSED NT_STATUS(0xc0000041L)
#define NT_STATUS_INVALID_PORT_HANDLE NT_STATUS(0xc0000042L)
#define NT_STATUS_SHARING_VIOLATION NT_STATUS(0xc0000043L)
#define NT_STATUS_QUOTA_EXCEEDED NT_STATUS(0xc0000044L)
#define NT_STATUS_INVALID_PAGE_PROTECTION NT_STATUS(0xc0000045L)
#define NT_STATUS_MUTANT_NOT_OWNED NT_STATUS(0xc0000046L)
#define NT_STATUS_SEMAPHORE_LIMIT_EXCEEDED NT_STATUS(0xc0000047L)
#define NT_STATUS_PORT_ALREADY_SET NT_STATUS(0xc0000048L)
#define NT_STATUS_SECTION_NOT_IMAGE NT_STATUS(0xc0000049L)
#define NT_STATUS_SUSPEND_COUNT_EXCEEDED NT_STATUS(0xc000004aL)
#define NT_STATUS_THREAD_IS_TERMINATING NT_STATUS(0xc000004bL)
#define NT_STATUS_BAD_WORKING_SET_LIMIT NT_STATUS(0xc000004cL)
#define NT_STATUS_INCOMPATIBLE_FILE_MAP NT_STATUS(0xc000004dL)
#define NT_STATUS_SECTION_PROTECTION NT_STATUS(0xc000004eL)
#define NT_STATUS_EAS_NOT_SUPPORTED NT_STATUS(0xc000004fL)
#define NT_STATUS_EA_TOO_LARGE NT_STATUS(0xc0000050L)
#define NT_STATUS_NONEXISTENT_EA_ENTRY NT_STATUS(0xc0000051L)
#define NT_STATUS_NO_EAS_ON_FILE NT_STATUS(0xc0000052L)
#define NT_STATUS_EA_CORRUPT_ERROR NT_STATUS(0xc0000053L)
#define NT_STATUS_FILE_LOCK_CONFLICT NT_STATUS(0xc0000054L)
#define NT_STATUS_LOCK_NOT_GRANTED NT_STATUS(0xc0000055L)
#define NT_STATUS_DELETE_PENDING NT_STATUS(0xc0000056L)
#define NT_STATUS_CTL_FILE_NOT_SUPPORTED NT_STATUS(0xc0000057L)
#define NT_STATUS_UNKNOWN_REVISION NT_STATUS(0xc0000058L)
#define NT_STATUS_REVISION_MISMATCH NT_STATUS(0xc0000059L)
#define NT_STATUS_INVALID_OWNER NT_STATUS(0xc000005aL)
#define NT_STATUS_INVALID_PRIMARY_GROUP NT_STATUS(0xc000005bL)
#define NT_STATUS_NO_IMPERSONATION_TOKEN NT_STATUS(0xc000005cL)
#define NT_STATUS_CANT_DISABLE_MANDATORY NT_STATUS(0xc000005dL)
#define NT_STATUS_NO_LOGON_SERVERS NT_STATUS(0xc000005eL)
#define NT_STATUS_NO_SUCH_LOGON_SESSION NT_STATUS(0xc000005fL)
#define NT_STATUS_NO_SUCH_PRIVILEGE NT_STATUS(0xc0000060L)
#define NT_STATUS_PRIVILEGE_NOT_HELD NT_STATUS(0xc0000061L)
#define NT_STATUS_INVALID_ACCOUNT_NAME NT_STATUS(0xc0000062L)
#define NT_STATUS_USER_EXISTS NT_STATUS(0xc0000063L)
#define NT_STATUS_NO_SUCH_USER NT_STATUS(0xc0000064L)
#define NT_STATUS_GROUP_EXISTS NT_STATUS(0xc0000065L)
#define NT_STATUS_NO_SUCH_GROUP NT_STATUS(0xc0000066L)
#define NT_STATUS_MEMBER_IN_GROUP NT_STATUS(0xc0000067L)
#define NT_STATUS_MEMBER_NOT_IN_GROUP NT_STATUS(0xc0000068L)
#define NT_STATUS_LAST_ADMIN NT_STATUS(0xc0000069L)
#define NT_STATUS_WRONG_PASSWORD NT_STATUS(0xc000006aL)
#define NT_STATUS_ILL_FORMED_PASSWORD NT_STATUS(0xc000006bL)
#define NT_STATUS_PASSWORD_RESTRICTION NT_STATUS(0xc000006cL)
#define NT_STATUS_LOGON_FAILURE NT_STATUS(0xc000006dL)
#define NT_STATUS_ACCOUNT_RESTRICTION NT_STATUS(0xc000006eL)
#define NT_STATUS_INVALID_LOGON_HOURS NT_STATUS(0xc000006fL)
#define NT_STATUS_INVALID_WORKSTATION NT_STATUS(0xc0000070L)
#define NT_STATUS_PASSWORD_EXPIRED NT_STATUS(0xc0000071L)
#define NT_STATUS_ACCOUNT_DISABLED NT_STATUS(0xc0000072L)
#define NT_STATUS_NONE_MAPPED NT_STATUS(0xc0000073L)
#define NT_STATUS_TOO_MANY_LUIDS_REQUESTED NT_STATUS(0xc0000074L)
#define NT_STATUS_LUIDS_EXHAUSTED NT_STATUS(0xc0000075L)
#define NT_STATUS_INVALID_SUB_AUTHORITY NT_STATUS(0xc0000076L)
#define NT_STATUS_INVALID_ACL NT_STATUS(0xc0000077L)
#define NT_STATUS_INVALID_SID NT_STATUS(0xc0000078L)
#define NT_STATUS_INVALID_SECURITY_DESCR NT_STATUS(0xc0000079L)
#define NT_STATUS_PROCEDURE_NOT_FOUND NT_STATUS(0xc000007aL)
#define NT_STATUS_INVALID_IMAGE_FORMAT NT_STATUS(0xc000007bL)
#define NT_STATUS_NO_TOKEN NT_STATUS(0xc000007cL)
#define NT_STATUS_BAD_INHERITANCE_ACL NT_STATUS(0xc000007dL)
#define NT_STATUS_RANGE_NOT_LOCKED NT_STATUS(0xc000007eL)
#define NT_STATUS_DISK_FULL NT_STATUS(0xc000007fL)
#define NT_STATUS_SERVER_DISABLED NT_STATUS(0xc0000080L)
#define NT_STATUS_SERVER_NOT_DISABLED NT_STATUS(0xc0000081L)
#define NT_STATUS_TOO_MANY_GUIDS_REQUESTED NT_STATUS(0xc0000082L)
#define NT_STATUS_GUIDS_EXHAUSTED NT_STATUS(0xc0000083L)
#define NT_STATUS_INVALID_ID_AUTHORITY NT_STATUS(0xc0000084L)
#define NT_STATUS_AGENTS_EXHAUSTED NT_STATUS(0xc0000085L)
#define NT_STATUS_INVALID_VOLUME_LABEL NT_STATUS(0xc0000086L)
#define NT_STATUS_SECTION_NOT_EXTENDED NT_STATUS(0xc0000087L)
#define NT_STATUS_NOT_MAPPED_DATA NT_STATUS(0xc0000088L)
#define NT_STATUS_RESOURCE_DATA_NOT_FOUND NT_STATUS(0xc0000089L)
#define NT_STATUS_RESOURCE_TYPE_NOT_FOUND NT_STATUS(0xc000008aL)
#define NT_STATUS_RESOURCE_NAME_NOT_FOUND NT_STATUS(0xc000008bL)
#define NT_STATUS_ARRAY_BOUNDS_EXCEEDED NT_STATUS(0xc000008cL)
#define NT_STATUS_FLOAT_DENORMAL_OPERAND NT_STATUS(0xc000008dL)
#define NT_STATUS_FLOAT_DIVIDE_BY_ZERO NT_STATUS(0xc000008eL)
#define NT_STATUS_FLOAT_INEXACT_RESULT NT_STATUS(0xc000008fL)
#define NT_STATUS_FLOAT_INVALID_OPERATION NT_STATUS(0xc0000090L)
#define NT_STATUS_FLOAT_OVERFLOW NT_STATUS(0xc0000091L)
#define NT_STATUS_FLOAT_STACK_CHECK NT_STATUS(0xc0000092L)
#define NT_STATUS_FLOAT_UNDERFLOW NT_STATUS(0xc0000093L)
#define NT_STATUS_INTEGER_DIVIDE_BY_ZERO NT_STATUS(0xc0000094L)
#define NT_STATUS_INTEGER_OVERFLOW NT_STATUS(0xc0000095L)
#define NT_STATUS_PRIVILEGED_INSTRUCTION NT_STATUS(0xc0000096L)
#define NT_STATUS_TOO_MANY_PAGING_FILES NT_STATUS(0xc0000097L)
#define NT_STATUS_FILE_INVALID NT_STATUS(0xc0000098L)
#define NT_STATUS_ALLOTTED_SPACE_EXCEEDED NT_STATUS(0xc0000099L)
#define NT_STATUS_INSUFFICIENT_RESOURCES NT_STATUS(0xc000009aL)
#define NT_STATUS_DFS_EXIT_PATH_FOUND NT_STATUS(0xc000009bL)
#define NT_STATUS_DEVICE_DATA_ERROR NT_STATUS(0xc000009cL)
#define NT_STATUS_DEVICE_NOT_CONNECTED NT_STATUS(0xc000009dL)
#define NT_STATUS_FREE_VM_NOT_AT_BASE NT_STATUS(0xc000009fL)
#define NT_STATUS_MEMORY_NOT_ALLOCATED NT_STATUS(0xc00000a0L)
#define NT_STATUS_WORKING_SET_QUOTA NT_STATUS(0xc00000a1L)
#define NT_STATUS_MEDIA_WRITE_PROTECTED NT_STATUS(0xc00000a2L)
#define NT_STATUS_DEVICE_NOT_READY NT_STATUS(0xc00000a3L)
#define NT_STATUS_INVALID_GROUP_ATTRIBUTES NT_STATUS(0xc00000a4L)
#define NT_STATUS_BAD_IMPERSONATION_LEVEL NT_STATUS(0xc00000a5L)
#define NT_STATUS_CANT_OPEN_ANONYMOUS NT_STATUS(0xc00000a6L)
#define NT_STATUS_BAD_VALIDATION_CLASS NT_STATUS(0xc00000a7L)
#define NT_STATUS_BAD_TOKEN_TYPE NT_STATUS(0xc00000a8L)
#define NT_STATUS_BAD_MASTER_BOOT_RECORD NT_STATUS(0xc00000a9L)
#define NT_STATUS_INSTRUCTION_MISALIGNMENT NT_STATUS(0xc00000aaL)
#define NT_STATUS_INSTANCE_NOT_AVAILABLE NT_STATUS(0xc00000abL)
#define NT_STATUS_PIPE_NOT_AVAILABLE NT_STATUS(0xc00000acL)
#define NT_STATUS_INVALID_PIPE_STATE NT_STATUS(0xc00000adL)
#define NT_STATUS_PIPE_BUSY NT_STATUS(0xc00000aeL)
#define NT_STATUS_ILLEGAL_FUNCTION NT_STATUS(0xc00000afL)
#define NT_STATUS_PIPE_DISCONNECTED NT_STATUS(0xc00000b0L)
#define NT_STATUS_PIPE_CLOSING NT_STATUS(0xc00000b1L)
#define NT_STATUS_PIPE_CONNECTED NT_STATUS(0xc00000b2L)
#define NT_STATUS_PIPE_LISTENING NT_STATUS(0xc00000b3L)
#define NT_STATUS_INVALID_READ_MODE NT_STATUS(0xc00000b4L)
#define NT_STATUS_IO_TIMEOUT NT_STATUS(0xc00000b5L)
#define NT_STATUS_FILE_FORCED_CLOSED NT_STATUS(0xc00000b6L)
#define NT_STATUS_PROFILING_NOT_STARTED NT_STATUS(0xc00000b7L)
#define NT_STATUS_PROFILING_NOT_STOPPED NT_STATUS(0xc00000b8L)
#define NT_STATUS_COULD_NOT_INTERPRET NT_STATUS(0xc00000b9L)
#define NT_STATUS_FILE_IS_A_DIRECTORY NT_STATUS(0xc00000baL)
#define NT_STATUS_NOT_SUPPORTED NT_STATUS(0xc00000bbL)
#define NT_STATUS_REMOTE_NOT_LISTENING NT_STATUS(0xc00000bcL)
#define NT_STATUS_DUPLICATE_NAME NT_STATUS(0xc00000bdL)
#define NT_STATUS_BAD_NETWORK_PATH NT_STATUS(0xc00000beL)
#define NT_STATUS_NETWORK_BUSY NT_STATUS(0xc00000bfL)
#define NT_STATUS_DEVICE_DOES_NOT_EXIST NT_STATUS(0xc00000c0L)
#define NT_STATUS_TOO_MANY_COMMANDS NT_STATUS(0xc00000c1L)
#define NT_STATUS_ADAPTER_HARDWARE_ERROR NT_STATUS(0xc00000c2L)
#define NT_STATUS_INVALID_NETWORK_RESPONSE NT_STATUS(0xc00000c3L)
#define NT_STATUS_UNEXPECTED_NETWORK_ERROR NT_STATUS(0xc00000c4L)
#define NT_STATUS_BAD_REMOTE_ADAPTER NT_STATUS(0xc00000c5L)
#define NT_STATUS_PRINT_QUEUE_FULL NT_STATUS(0xc00000c6L)
#define NT_STATUS_NO_SPOOL_SPACE NT_STATUS(0xc00000c7L)
#define NT_STATUS_PRINT_CANCELLED NT_STATUS(0xc00000c8L)
#define NT_STATUS_NETWORK_NAME_DELETED NT_STATUS(0xc00000c9L)
#define NT_STATUS_NETWORK_ACCESS_DENIED NT_STATUS(0xc00000caL)
#define NT_STATUS_BAD_DEVICE_TYPE NT_STATUS(0xc00000cbL)
#define NT_STATUS_BAD_NETWORK_NAME NT_STATUS(0xc00000ccL)
#define NT_STATUS_TOO_MANY_NAMES NT_STATUS(0xc00000cdL)
#define NT_STATUS_TOO_MANY_SESSIONS NT_STATUS(0xc00000ceL)
#define NT_STATUS_SHARING_PAUSED NT_STATUS(0xc00000cfL)
#define NT_STATUS_REQUEST_NOT_ACCEPTED NT_STATUS(0xc00000d0L)
#define NT_STATUS_REDIRECTOR_PAUSED NT_STATUS(0xc00000d1L)
#define NT_STATUS_NET_WRITE_FAULT NT_STATUS(0xc00000d2L)
#define NT_STATUS_PROFILING_AT_LIMIT NT_STATUS(0xc00000d3L)
#define NT_STATUS_NOT_SAME_DEVICE NT_STATUS(0xc00000d4L)
#define NT_STATUS_FILE_RENAMED NT_STATUS(0xc00000d5L)
#define NT_STATUS_VIRTUAL_CIRCUIT_CLOSED NT_STATUS(0xc00000d6L)
#define NT_STATUS_NO_SECURITY_ON_OBJECT NT_STATUS(0xc00000d7L)
#define NT_STATUS_CANT_WAIT NT_STATUS(0xc00000d8L)
#define NT_STATUS_PIPE_EMPTY NT_STATUS(0xc00000d9L)
#define NT_STATUS_CANT_ACCESS_DOMAIN_INFO NT_STATUS(0xc00000daL)
#define NT_STATUS_CANT_TERMINATE_SELF NT_STATUS(0xc00000dbL)
#define NT_STATUS_INVALID_SERVER_STATE NT_STATUS(0xc00000dcL)
#define NT_STATUS_INVALID_DOMAIN_STATE NT_STATUS(0xc00000ddL)
#define NT_STATUS_INVALID_DOMAIN_ROLE NT_STATUS(0xc00000deL)
#define NT_STATUS_NO_SUCH_DOMAIN NT_STATUS(0xc00000dfL)
#define NT_STATUS_DOMAIN_EXISTS NT_STATUS(0xc00000e0L)
#define NT_STATUS_DOMAIN_LIMIT_EXCEEDED NT_STATUS(0xc00000e1L)
#define NT_STATUS_OPLOCK_NOT_GRANTED NT_STATUS(0xc00000e2L)
#define NT_STATUS_INVALID_OPLOCK_PROTOCOL NT_STATUS(0xc00000e3L)
#define NT_STATUS_INTERNAL_DB_CORRUPTION NT_STATUS(0xc00000e4L)
#define NT_STATUS_INTERNAL_ERROR NT_STATUS(0xc00000e5L)
#define NT_STATUS_GENERIC_NOT_MAPPED NT_STATUS(0xc00000e6L)
#define NT_STATUS_BAD_DESCRIPTOR_FORMAT NT_STATUS(0xc00000e7L)
#define NT_STATUS_INVALID_USER_BUFFER NT_STATUS(0xc00000e8L)
#define NT_STATUS_UNEXPECTED_IO_ERROR NT_STATUS(0xc00000e9L)
#define NT_STATUS_UNEXPECTED_MM_CREATE_ERR NT_STATUS(0xc00000eaL)
#define NT_STATUS_UNEXPECTED_MM_MAP_ERROR NT_STATUS(0xc00000ebL)
#define NT_STATUS_UNEXPECTED_MM_EXTEND_ERR NT_STATUS(0xc00000ecL)
#define NT_STATUS_NOT_LOGON_PROCESS NT_STATUS(0xc00000edL)
#define NT_STATUS_LOGON_SESSION_EXISTS NT_STATUS(0xc00000eeL)
#define NT_STATUS_INVALID_PARAMETER_1 NT_STATUS(0xc00000efL)
#define NT_STATUS_INVALID_PARAMETER_2 NT_STATUS(0xc00000f0L)
#define NT_STATUS_INVALID_PARAMETER_3 NT_STATUS(0xc00000f1L)
#define NT_STATUS_INVALID_PARAMETER_4 NT_STATUS(0xc00000f2L)
#define NT_STATUS_INVALID_PARAMETER_5 NT_STATUS(0xc00000f3L)
#define NT_STATUS_INVALID_PARAMETER_6 NT_STATUS(0xc00000f4L)
#define NT_STATUS_INVALID_PARAMETER_7 NT_STATUS(0xc00000f5L)
#define NT_STATUS_INVALID_PARAMETER_8 NT_STATUS(0xc00000f6L)
#define NT_STATUS_INVALID_PARAMETER_9 NT_STATUS(0xc00000f7L)
#define NT_STATUS_INVALID_PARAMETER_10 NT_STATUS(0xc00000f8L)
#define NT_STATUS_INVALID_PARAMETER_11 NT_STATUS(0xc00000f9L)
#define NT_STATUS_INVALID_PARAMETER_12 NT_STATUS(0xc00000faL)
#define NT_STATUS_REDIRECTOR_NOT_STARTED NT_STATUS(0xc00000fbL)
#define NT_STATUS_REDIRECTOR_STARTED NT_STATUS(0xc00000fcL)
#define NT_STATUS_STACK_OVERFLOW NT_STATUS(0xc00000fdL)
#define NT_STATUS_NO_SUCH_PACKAGE NT_STATUS(0xc00000feL)
#define NT_STATUS_BAD_FUNCTION_TABLE NT_STATUS(0xc00000ffL)
#define NT_STATUS_VARIABLE_NOT_FOUND NT_STATUS(0xc0000100L)
#define NT_STATUS_DIRECTORY_NOT_EMPTY NT_STATUS(0xc0000101L)
#define NT_STATUS_FILE_CORRUPT_ERROR NT_STATUS(0xc0000102L)
#define NT_STATUS_NOT_A_DIRECTORY NT_STATUS(0xc0000103L)
#define NT_STATUS_BAD_LOGON_SESSION_STATE NT_STATUS(0xc0000104L)
#define NT_STATUS_LOGON_SESSION_COLLISION NT_STATUS(0xc0000105L)
#define NT_STATUS_NAME_TOO_LONG NT_STATUS(0xc0000106L)
#define NT_STATUS_FILES_OPEN NT_STATUS(0xc0000107L)
#define NT_STATUS_CONNECTION_IN_USE NT_STATUS(0xc0000108L)
#define NT_STATUS_MESSAGE_NOT_FOUND NT_STATUS(0xc0000109L)
#define NT_STATUS_PROCESS_IS_TERMINATING NT_STATUS(0xc000010aL)
#define NT_STATUS_INVALID_LOGON_TYPE NT_STATUS(0xc000010bL)
#define NT_STATUS_NO_GUID_TRANSLATION NT_STATUS(0xc000010cL)
#define NT_STATUS_CANNOT_IMPERSONATE NT_STATUS(0xc000010dL)
#define NT_STATUS_IMAGE_ALREADY_LOADED NT_STATUS(0xc000010eL)
#define NT_STATUS_NO_LDT NT_STATUS(0xc0000117L)
#define NT_STATUS_INVALID_LDT_SIZE NT_STATUS(0xc0000118L)
#define NT_STATUS_INVALID_LDT_OFFSET NT_STATUS(0xc0000119L)
#define NT_STATUS_INVALID_LDT_DESCRIPTOR NT_STATUS(0xc000011aL)
#define NT_STATUS_INVALID_IMAGE_NE_FORMAT NT_STATUS(0xc000011bL)
#define NT_STATUS_RXACT_INVALID_STATE NT_STATUS(0xc000011cL)
#define NT_STATUS_RXACT_COMMIT_FAILURE NT_STATUS(0xc000011dL)
#define NT_STATUS_MAPPED_FILE_SIZE_ZERO NT_STATUS(0xc000011eL)
#define NT_STATUS_TOO_MANY_OPENED_FILES NT_STATUS(0xc000011fL)
#define NT_STATUS_CANCELLED NT_STATUS(0xc0000120L)
#define NT_STATUS_CANNOT_DELETE NT_STATUS(0xc0000121L)
#define NT_STATUS_INVALID_COMPUTER_NAME NT_STATUS(0xc0000122L)
#define NT_STATUS_FILE_DELETED NT_STATUS(0xc0000123L)
#define NT_STATUS_SPECIAL_ACCOUNT NT_STATUS(0xc0000124L)
#define NT_STATUS_SPECIAL_GROUP NT_STATUS(0xc0000125L)
#define NT_STATUS_SPECIAL_USER NT_STATUS(0xc0000126L)
#define NT_STATUS_MEMBERS_PRIMARY_GROUP NT_STATUS(0xc0000127L)
#define NT_STATUS_FILE_CLOSED NT_STATUS(0xc0000128L)
#define NT_STATUS_TOO_MANY_THREADS NT_STATUS(0xc0000129L)
#define NT_STATUS_THREAD_NOT_IN_PROCESS NT_STATUS(0xc000012aL)
#define NT_STATUS_TOKEN_ALREADY_IN_USE NT_STATUS(0xc000012bL)
#define NT_STATUS_PAGEFILE_QUOTA_EXCEEDED NT_STATUS(0xc000012cL)
#define NT_STATUS_COMMITMENT_LIMIT NT_STATUS(0xc000012dL)
#define NT_STATUS_INVALID_IMAGE_LE_FORMAT NT_STATUS(0xc000012eL)
#define NT_STATUS_INVALID_IMAGE_NOT_MZ NT_STATUS(0xc000012fL)
#define NT_STATUS_INVALID_IMAGE_PROTECT NT_STATUS(0xc0000130L)
#define NT_STATUS_INVALID_IMAGE_WIN_16 NT_STATUS(0xc0000131L)
#define NT_STATUS_LOGON_SERVER_CONFLICT NT_STATUS(0xc0000132L)
#define NT_STATUS_TIME_DIFFERENCE_AT_DC NT_STATUS(0xc0000133L)
#define NT_STATUS_SYNCHRONIZATION_REQUIRED NT_STATUS(0xc0000134L)
#define NT_STATUS_DLL_NOT_FOUND NT_STATUS(0xc0000135L)
#define NT_STATUS_OPEN_FAILED NT_STATUS(0xc0000136L)
#define NT_STATUS_IO_PRIVILEGE_FAILED NT_STATUS(0xc0000137L)
#define NT_STATUS_ORDINAL_NOT_FOUND NT_STATUS(0xc0000138L)
#define NT_STATUS_ENTRYPOINT_NOT_FOUND NT_STATUS(0xc0000139L)
#define NT_STATUS_CONTROL_C_EXIT NT_STATUS(0xc000013aL)
#define NT_STATUS_LOCAL_DISCONNECT NT_STATUS(0xc000013bL)
#define NT_STATUS_REMOTE_DISCONNECT NT_STATUS(0xc000013cL)
#define NT_STATUS_REMOTE_RESOURCES NT_STATUS(0xc000013dL)
#define NT_STATUS_LINK_FAILED NT_STATUS(0xc000013eL)
#define NT_STATUS_LINK_TIMEOUT NT_STATUS(0xc000013fL)
#define NT_STATUS_INVALID_CONNECTION NT_STATUS(0xc0000140L)
#define NT_STATUS_INVALID_ADDRESS NT_STATUS(0xc0000141L)
#define NT_STATUS_DLL_INIT_FAILED NT_STATUS(0xc0000142L)
#define NT_STATUS_MISSING_SYSTEMFILE NT_STATUS(0xc0000143L)
#define NT_STATUS_UNHANDLED_EXCEPTION NT_STATUS(0xc0000144L)
#define NT_STATUS_APP_INIT_FAILURE NT_STATUS(0xc0000145L)
#define NT_STATUS_PAGEFILE_CREATE_FAILED NT_STATUS(0xc0000146L)
#define NT_STATUS_NO_PAGEFILE NT_STATUS(0xc0000147L)
#define NT_STATUS_INVALID_LEVEL NT_STATUS(0xc0000148L)
#define NT_STATUS_WRONG_PASSWORD_CORE NT_STATUS(0xc0000149L)
#define NT_STATUS_ILLEGAL_FLOAT_CONTEXT NT_STATUS(0xc000014aL)
#define NT_STATUS_PIPE_BROKEN NT_STATUS(0xc000014bL)
#define NT_STATUS_REGISTRY_CORRUPT NT_STATUS(0xc000014cL)
#define NT_STATUS_REGISTRY_IO_FAILED NT_STATUS(0xc000014dL)
#define NT_STATUS_NO_EVENT_PAIR NT_STATUS(0xc000014eL)
#define NT_STATUS_UNRECOGNIZED_VOLUME NT_STATUS(0xc000014fL)
#define NT_STATUS_SERIAL_NO_DEVICE_INITED NT_STATUS(0xc0000150L)
#define NT_STATUS_NO_SUCH_ALIAS NT_STATUS(0xc0000151L)
#define NT_STATUS_MEMBER_NOT_IN_ALIAS NT_STATUS(0xc0000152L)
#define NT_STATUS_MEMBER_IN_ALIAS NT_STATUS(0xc0000153L)
#define NT_STATUS_ALIAS_EXISTS NT_STATUS(0xc0000154L)
#define NT_STATUS_LOGON_NOT_GRANTED NT_STATUS(0xc0000155L)
#define NT_STATUS_TOO_MANY_SECRETS NT_STATUS(0xc0000156L)
#define NT_STATUS_SECRET_TOO_LONG NT_STATUS(0xc0000157L)
#define NT_STATUS_INTERNAL_DB_ERROR NT_STATUS(0xc0000158L)
#define NT_STATUS_FULLSCREEN_MODE NT_STATUS(0xc0000159L)
#define NT_STATUS_TOO_MANY_CONTEXT_IDS NT_STATUS(0xc000015aL)
#define NT_STATUS_LOGON_TYPE_NOT_GRANTED NT_STATUS(0xc000015bL)
#define NT_STATUS_NOT_REGISTRY_FILE NT_STATUS(0xc000015cL)
#define NT_STATUS_NT_CROSS_ENCRYPTION_REQUIRED NT_STATUS(0xc000015dL)
#define NT_STATUS_DOMAIN_CTRLR_CONFIG_ERROR NT_STATUS(0xc000015eL)
#define NT_STATUS_FT_MISSING_MEMBER NT_STATUS(0xc000015fL)
#define NT_STATUS_ILL_FORMED_SERVICE_ENTRY NT_STATUS(0xc0000160L)
#define NT_STATUS_ILLEGAL_CHARACTER NT_STATUS(0xc0000161L)
#define NT_STATUS_UNMAPPABLE_CHARACTER NT_STATUS(0xc0000162L)
#define NT_STATUS_UNDEFINED_CHARACTER NT_STATUS(0xc0000163L)
#define NT_STATUS_FLOPPY_VOLUME NT_STATUS(0xc0000164L)
#define NT_STATUS_FLOPPY_ID_MARK_NOT_FOUND NT_STATUS(0xc0000165L)
#define NT_STATUS_FLOPPY_WRONG_CYLINDER NT_STATUS(0xc0000166L)
#define NT_STATUS_FLOPPY_UNKNOWN_ERROR NT_STATUS(0xc0000167L)
#define NT_STATUS_FLOPPY_BAD_REGISTERS NT_STATUS(0xc0000168L)
#define NT_STATUS_DISK_RECALIBRATE_FAILED NT_STATUS(0xc0000169L)
#define NT_STATUS_DISK_OPERATION_FAILED NT_STATUS(0xc000016aL)
#define NT_STATUS_DISK_RESET_FAILED NT_STATUS(0xc000016bL)
#define NT_STATUS_SHARED_IRQ_BUSY NT_STATUS(0xc000016cL)
#define NT_STATUS_FT_ORPHANING NT_STATUS(0xc000016dL)
#define NT_STATUS_BIOS_FAILED_TO_CONNECT_INTERRUPT NT_STATUS(0xc000016eL)
#define NT_STATUS_PARTITION_FAILURE NT_STATUS(0xc0000172L)
#define NT_STATUS_INVALID_BLOCK_LENGTH NT_STATUS(0xc0000173L)
#define NT_STATUS_DEVICE_NOT_PARTITIONED NT_STATUS(0xc0000174L)
#define NT_STATUS_UNABLE_TO_LOCK_MEDIA NT_STATUS(0xc0000175L)
#define NT_STATUS_UNABLE_TO_UNLOAD_MEDIA NT_STATUS(0xc0000176L)
#define NT_STATUS_EOM_OVERFLOW NT_STATUS(0xc0000177L)
#define NT_STATUS_NO_MEDIA NT_STATUS(0xc0000178L)
#define NT_STATUS_NO_SUCH_MEMBER NT_STATUS(0xc000017aL)
#define NT_STATUS_INVALID_MEMBER NT_STATUS(0xc000017bL)
#define NT_STATUS_KEY_DELETED NT_STATUS(0xc000017cL)
#define NT_STATUS_NO_LOG_SPACE NT_STATUS(0xc000017dL)
#define NT_STATUS_TOO_MANY_SIDS NT_STATUS(0xc000017eL)
#define NT_STATUS_LM_CROSS_ENCRYPTION_REQUIRED NT_STATUS(0xc000017fL)
#define NT_STATUS_KEY_HAS_CHILDREN NT_STATUS(0xc0000180L)
#define NT_STATUS_CHILD_MUST_BE_VOLATILE NT_STATUS(0xc0000181L)
#define NT_STATUS_DEVICE_CONFIGURATION_ERROR NT_STATUS(0xc0000182L)
#define NT_STATUS_DRIVER_INTERNAL_ERROR NT_STATUS(0xc0000183L)
#define NT_STATUS_INVALID_DEVICE_STATE NT_STATUS(0xc0000184L)
#define NT_STATUS_IO_DEVICE_ERROR NT_STATUS(0xc0000185L)
#define NT_STATUS_DEVICE_PROTOCOL_ERROR NT_STATUS(0xc0000186L)
#define NT_STATUS_BACKUP_CONTROLLER NT_STATUS(0xc0000187L)
#define NT_STATUS_LOG_FILE_FULL NT_STATUS(0xc0000188L)
#define NT_STATUS_TOO_LATE NT_STATUS(0xc0000189L)
#define NT_STATUS_NO_TRUST_LSA_SECRET NT_STATUS(0xc000018aL)
#define NT_STATUS_NO_TRUST_SAM_ACCOUNT NT_STATUS(0xc000018bL)
#define NT_STATUS_TRUSTED_DOMAIN_FAILURE NT_STATUS(0xc000018cL)
#define NT_STATUS_TRUSTED_RELATIONSHIP_FAILURE NT_STATUS(0xc000018dL)
#define NT_STATUS_EVENTLOG_FILE_CORRUPT NT_STATUS(0xc000018eL)
#define NT_STATUS_EVENTLOG_CANT_START NT_STATUS(0xc000018fL)
#define NT_STATUS_TRUST_FAILURE NT_STATUS(0xc0000190L)
#define NT_STATUS_MUTANT_LIMIT_EXCEEDED NT_STATUS(0xc0000191L)
#define NT_STATUS_NETLOGON_NOT_STARTED NT_STATUS(0xc0000192L)
#define NT_STATUS_ACCOUNT_EXPIRED NT_STATUS(0xc0000193L)
#define NT_STATUS_POSSIBLE_DEADLOCK NT_STATUS(0xc0000194L)
#define NT_STATUS_NETWORK_CREDENTIAL_CONFLICT NT_STATUS(0xc0000195L)
#define NT_STATUS_REMOTE_SESSION_LIMIT NT_STATUS(0xc0000196L)
#define NT_STATUS_EVENTLOG_FILE_CHANGED NT_STATUS(0xc0000197L)
#define NT_STATUS_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT NT_STATUS(0xc0000198L)
#define NT_STATUS_NOLOGON_WORKSTATION_TRUST_ACCOUNT NT_STATUS(0xc0000199L)
#define NT_STATUS_NOLOGON_SERVER_TRUST_ACCOUNT NT_STATUS(0xc000019aL)
#define NT_STATUS_DOMAIN_TRUST_INCONSISTENT NT_STATUS(0xc000019bL)
#define NT_STATUS_FS_DRIVER_REQUIRED NT_STATUS(0xc000019cL)
#define NT_STATUS_IMAGE_ALREADY_LOADED_AS_DLL NT_STATUS(0xc000019dL)
#define NT_STATUS_INCOMPATIBLE_WITH_GLOBAL_SHORT_NAME_REGISTRY_SETTING NT_STATUS(0xc000019eL)
#define NT_STATUS_SHORT_NAMES_NOT_ENABLED_ON_VOLUME NT_STATUS(0xc000019fL)
#define NT_STATUS_SECURITY_STREAM_IS_INCONSISTENT NT_STATUS(0xc00001a0L)
#define NT_STATUS_INVALID_LOCK_RANGE NT_STATUS(0xc00001a1L)
#define NT_STATUS_INVALID_ACE_CONDITION NT_STATUS(0xc00001a2L)
#define NT_STATUS_IMAGE_SUBSYSTEM_NOT_PRESENT NT_STATUS(0xc00001a3L)
#define NT_STATUS_NOTIFICATION_GUID_ALREADY_DEFINED NT_STATUS(0xc00001a4L)
#define NT_STATUS_NETWORK_OPEN_RESTRICTION NT_STATUS(0xc0000201L)
#define NT_STATUS_NO_USER_SESSION_KEY NT_STATUS(0xc0000202L)
#define NT_STATUS_USER_SESSION_DELETED NT_STATUS(0xc0000203L)
#define NT_STATUS_RESOURCE_LANG_NOT_FOUND NT_STATUS(0xc0000204L)
#define NT_STATUS_INSUFF_SERVER_RESOURCES NT_STATUS(0xc0000205L)
#define NT_STATUS_INVALID_BUFFER_SIZE NT_STATUS(0xc0000206L)
#define NT_STATUS_INVALID_ADDRESS_COMPONENT NT_STATUS(0xc0000207L)
#define NT_STATUS_INVALID_ADDRESS_WILDCARD NT_STATUS(0xc0000208L)
#define NT_STATUS_TOO_MANY_ADDRESSES NT_STATUS(0xc0000209L)
#define NT_STATUS_ADDRESS_ALREADY_EXISTS NT_STATUS(0xc000020aL)
#define NT_STATUS_ADDRESS_CLOSED NT_STATUS(0xc000020bL)
#define NT_STATUS_CONNECTION_DISCONNECTED NT_STATUS(0xc000020cL)
#define NT_STATUS_CONNECTION_RESET NT_STATUS(0xc000020dL)
#define NT_STATUS_TOO_MANY_NODES NT_STATUS(0xc000020eL)
#define NT_STATUS_TRANSACTION_ABORTED NT_STATUS(0xc000020fL)
#define NT_STATUS_TRANSACTION_TIMED_OUT NT_STATUS(0xc0000210L)
#define NT_STATUS_TRANSACTION_NO_RELEASE NT_STATUS(0xc0000211L)
#define NT_STATUS_TRANSACTION_NO_MATCH NT_STATUS(0xc0000212L)
#define NT_STATUS_TRANSACTION_RESPONDED NT_STATUS(0xc0000213L)
#define NT_STATUS_TRANSACTION_INVALID_ID NT_STATUS(0xc0000214L)
#define NT_STATUS_TRANSACTION_INVALID_TYPE NT_STATUS(0xc0000215L)
#define NT_STATUS_NOT_SERVER_SESSION NT_STATUS(0xc0000216L)
#define NT_STATUS_NOT_CLIENT_SESSION NT_STATUS(0xc0000217L)
#define NT_STATUS_CANNOT_LOAD_REGISTRY_FILE NT_STATUS(0xc0000218L)
#define NT_STATUS_DEBUG_ATTACH_FAILED NT_STATUS(0xc0000219L)
#define NT_STATUS_SYSTEM_PROCESS_TERMINATED NT_STATUS(0xc000021aL)
#define NT_STATUS_DATA_NOT_ACCEPTED NT_STATUS(0xc000021bL)
#define NT_STATUS_NO_BROWSER_SERVERS_FOUND NT_STATUS(0xc000021cL)
#define NT_STATUS_VDM_HARD_ERROR NT_STATUS(0xc000021dL)
#define NT_STATUS_DRIVER_CANCEL_TIMEOUT NT_STATUS(0xc000021eL)
#define NT_STATUS_REPLY_MESSAGE_MISMATCH NT_STATUS(0xc000021fL)
#define NT_STATUS_MAPPED_ALIGNMENT NT_STATUS(0xc0000220L)
#define NT_STATUS_IMAGE_CHECKSUM_MISMATCH NT_STATUS(0xc0000221L)
#define NT_STATUS_LOST_WRITEBEHIND_DATA NT_STATUS(0xc0000222L)
#define NT_STATUS_CLIENT_SERVER_PARAMETERS_INVALID NT_STATUS(0xc0000223L)
#define NT_STATUS_PASSWORD_MUST_CHANGE NT_STATUS(0xc0000224L)
#define NT_STATUS_NOT_FOUND NT_STATUS(0xc0000225L)
#define NT_STATUS_NOT_TINY_STREAM NT_STATUS(0xc0000226L)
#define NT_STATUS_RECOVERY_FAILURE NT_STATUS(0xc0000227L)
#define NT_STATUS_STACK_OVERFLOW_READ NT_STATUS(0xc0000228L)
#define NT_STATUS_FAIL_CHECK NT_STATUS(0xc0000229L)
#define NT_STATUS_DUPLICATE_OBJECTID NT_STATUS(0xc000022aL)
#define NT_STATUS_OBJECTID_EXISTS NT_STATUS(0xc000022bL)
#define NT_STATUS_CONVERT_TO_LARGE NT_STATUS(0xc000022cL)
#define NT_STATUS_RETRY NT_STATUS(0xc000022dL)
#define NT_STATUS_FOUND_OUT_OF_SCOPE NT_STATUS(0xc000022eL)
#define NT_STATUS_ALLOCATE_BUCKET NT_STATUS(0xc000022fL)
#define NT_STATUS_PROPSET_NOT_FOUND NT_STATUS(0xc0000230L)
#define NT_STATUS_MARSHALL_OVERFLOW NT_STATUS(0xc0000231L)
#define NT_STATUS_INVALID_VARIANT NT_STATUS(0xc0000232L)
#define NT_STATUS_DOMAIN_CONTROLLER_NOT_FOUND NT_STATUS(0xc0000233L)
#define NT_STATUS_ACCOUNT_LOCKED_OUT NT_STATUS(0xc0000234L)
#define NT_STATUS_HANDLE_NOT_CLOSABLE NT_STATUS(0xc0000235L)
#define NT_STATUS_CONNECTION_REFUSED NT_STATUS(0xc0000236L)
#define NT_STATUS_GRACEFUL_DISCONNECT NT_STATUS(0xc0000237L)
#define NT_STATUS_ADDRESS_ALREADY_ASSOCIATED NT_STATUS(0xc0000238L)
#define NT_STATUS_ADDRESS_NOT_ASSOCIATED NT_STATUS(0xc0000239L)
#define NT_STATUS_CONNECTION_INVALID NT_STATUS(0xc000023aL)
#define NT_STATUS_CONNECTION_ACTIVE NT_STATUS(0xc000023bL)
#define NT_STATUS_NETWORK_UNREACHABLE NT_STATUS(0xc000023cL)
#define NT_STATUS_HOST_UNREACHABLE NT_STATUS(0xc000023dL)
#define NT_STATUS_PROTOCOL_UNREACHABLE NT_STATUS(0xc000023eL)
#define NT_STATUS_PORT_UNREACHABLE NT_STATUS(0xc000023fL)
#define NT_STATUS_REQUEST_ABORTED NT_STATUS(0xc0000240L)
#define NT_STATUS_CONNECTION_ABORTED NT_STATUS(0xc0000241L)
#define NT_STATUS_BAD_COMPRESSION_BUFFER NT_STATUS(0xc0000242L)
#define NT_STATUS_USER_MAPPED_FILE NT_STATUS(0xc0000243L)
#define NT_STATUS_AUDIT_FAILED NT_STATUS(0xc0000244L)
#define NT_STATUS_TIMER_RESOLUTION_NOT_SET NT_STATUS(0xc0000245L)
#define NT_STATUS_CONNECTION_COUNT_LIMIT NT_STATUS(0xc0000246L)
#define NT_STATUS_LOGIN_TIME_RESTRICTION NT_STATUS(0xc0000247L)
#define NT_STATUS_LOGIN_WKSTA_RESTRICTION NT_STATUS(0xc0000248L)
#define NT_STATUS_IMAGE_MP_UP_MISMATCH NT_STATUS(0xc0000249L)
#define NT_STATUS_INSUFFICIENT_LOGON_INFO NT_STATUS(0xc0000250L)
#define NT_STATUS_BAD_DLL_ENTRYPOINT NT_STATUS(0xc0000251L)
#define NT_STATUS_BAD_SERVICE_ENTRYPOINT NT_STATUS(0xc0000252L)
#define NT_STATUS_LPC_REPLY_LOST NT_STATUS(0xc0000253L)
#define NT_STATUS_IP_ADDRESS_CONFLICT1 NT_STATUS(0xc0000254L)
#define NT_STATUS_IP_ADDRESS_CONFLICT2 NT_STATUS(0xc0000255L)
#define NT_STATUS_REGISTRY_QUOTA_LIMIT NT_STATUS(0xc0000256L)
#define NT_STATUS_PATH_NOT_COVERED NT_STATUS(0xc0000257L)
#define NT_STATUS_NO_CALLBACK_ACTIVE NT_STATUS(0xc0000258L)
#define NT_STATUS_LICENSE_QUOTA_EXCEEDED NT_STATUS(0xc0000259L)
#define NT_STATUS_PWD_TOO_SHORT NT_STATUS(0xc000025aL)
#define NT_STATUS_PWD_TOO_RECENT NT_STATUS(0xc000025bL)
#define NT_STATUS_PWD_HISTORY_CONFLICT NT_STATUS(0xc000025cL)
#define NT_STATUS_PLUGPLAY_NO_DEVICE NT_STATUS(0xc000025eL)
#define NT_STATUS_UNSUPPORTED_COMPRESSION NT_STATUS(0xc000025fL)
#define NT_STATUS_INVALID_HW_PROFILE NT_STATUS(0xc0000260L)
#define NT_STATUS_INVALID_PLUGPLAY_DEVICE_PATH NT_STATUS(0xc0000261L)
#define NT_STATUS_DRIVER_ORDINAL_NOT_FOUND NT_STATUS(0xc0000262L)
#define NT_STATUS_DRIVER_ENTRYPOINT_NOT_FOUND NT_STATUS(0xc0000263L)
#define NT_STATUS_RESOURCE_NOT_OWNED NT_STATUS(0xc0000264L)
#define NT_STATUS_TOO_MANY_LINKS NT_STATUS(0xc0000265L)
#define NT_STATUS_QUOTA_LIST_INCONSISTENT NT_STATUS(0xc0000266L)
#define NT_STATUS_FILE_IS_OFFLINE NT_STATUS(0xc0000267L)
#define NT_STATUS_EVALUATION_EXPIRATION NT_STATUS(0xc0000268L)
#define NT_STATUS_ILLEGAL_DLL_RELOCATION NT_STATUS(0xc0000269L)
#define NT_STATUS_LICENSE_VIOLATION NT_STATUS(0xc000026aL)
#define NT_STATUS_DLL_INIT_FAILED_LOGOFF NT_STATUS(0xc000026bL)
#define NT_STATUS_DRIVER_UNABLE_TO_LOAD NT_STATUS(0xc000026cL)
#define NT_STATUS_DFS_UNAVAILABLE NT_STATUS(0xc000026dL)
#define NT_STATUS_VOLUME_DISMOUNTED NT_STATUS(0xc000026eL)
#define NT_STATUS_WX86_INTERNAL_ERROR NT_STATUS(0xc000026fL)
#define NT_STATUS_WX86_FLOAT_STACK_CHECK NT_STATUS(0xc0000270L)
#define NT_STATUS_VALIDATE_CONTINUE NT_STATUS(0xc0000271L)
#define NT_STATUS_NO_MATCH NT_STATUS(0xc0000272L)
#define NT_STATUS_NO_MORE_MATCHES NT_STATUS(0xc0000273L)
#define NT_STATUS_NOT_A_REPARSE_POINT NT_STATUS(0xc0000275L)
#define NT_STATUS_IO_REPARSE_TAG_INVALID NT_STATUS(0xc0000276L)
#define NT_STATUS_IO_REPARSE_TAG_MISMATCH NT_STATUS(0xc0000277L)
#define NT_STATUS_IO_REPARSE_DATA_INVALID NT_STATUS(0xc0000278L)
#define NT_STATUS_IO_REPARSE_TAG_NOT_HANDLED NT_STATUS(0xc0000279L)
#define NT_STATUS_REPARSE_POINT_NOT_RESOLVED NT_STATUS(0xc0000280L)
#define NT_STATUS_DIRECTORY_IS_A_REPARSE_POINT NT_STATUS(0xc0000281L)
#define NT_STATUS_RANGE_LIST_CONFLICT NT_STATUS(0xc0000282L)
#define NT_STATUS_SOURCE_ELEMENT_EMPTY NT_STATUS(0xc0000283L)
#define NT_STATUS_DESTINATION_ELEMENT_FULL NT_STATUS(0xc0000284L)
#define NT_STATUS_ILLEGAL_ELEMENT_ADDRESS NT_STATUS(0xc0000285L)
#define NT_STATUS_MAGAZINE_NOT_PRESENT NT_STATUS(0xc0000286L)
#define NT_STATUS_REINITIALIZATION_NEEDED NT_STATUS(0xc0000287L)
#define NT_STATUS_ENCRYPTION_FAILED NT_STATUS(0xc000028aL)
#define NT_STATUS_DECRYPTION_FAILED NT_STATUS(0xc000028bL)
#define NT_STATUS_RANGE_NOT_FOUND NT_STATUS(0xc000028cL)
#define NT_STATUS_NO_RECOVERY_POLICY NT_STATUS(0xc000028dL)
#define NT_STATUS_NO_EFS NT_STATUS(0xc000028eL)
#define NT_STATUS_WRONG_EFS NT_STATUS(0xc000028fL)
#define NT_STATUS_NO_USER_KEYS NT_STATUS(0xc0000290L)
#define NT_STATUS_FILE_NOT_ENCRYPTED NT_STATUS(0xc0000291L)
#define NT_STATUS_NOT_EXPORT_FORMAT NT_STATUS(0xc0000292L)
#define NT_STATUS_FILE_ENCRYPTED NT_STATUS(0xc0000293L)
#define NT_STATUS_WMI_GUID_NOT_FOUND NT_STATUS(0xc0000295L)
#define NT_STATUS_WMI_INSTANCE_NOT_FOUND NT_STATUS(0xc0000296L)
#define NT_STATUS_WMI_ITEMID_NOT_FOUND NT_STATUS(0xc0000297L)
#define NT_STATUS_WMI_TRY_AGAIN NT_STATUS(0xc0000298L)
#define NT_STATUS_SHARED_POLICY NT_STATUS(0xc0000299L)
#define NT_STATUS_POLICY_OBJECT_NOT_FOUND NT_STATUS(0xc000029aL)
#define NT_STATUS_POLICY_ONLY_IN_DS NT_STATUS(0xc000029bL)
#define NT_STATUS_VOLUME_NOT_UPGRADED NT_STATUS(0xc000029cL)
#define NT_STATUS_REMOTE_STORAGE_NOT_ACTIVE NT_STATUS(0xc000029dL)
#define NT_STATUS_REMOTE_STORAGE_MEDIA_ERROR NT_STATUS(0xc000029eL)
#define NT_STATUS_NO_TRACKING_SERVICE NT_STATUS(0xc000029fL)
#define NT_STATUS_SERVER_SID_MISMATCH NT_STATUS(0xc00002a0L)
#define NT_STATUS_DS_NO_ATTRIBUTE_OR_VALUE NT_STATUS(0xc00002a1L)
#define NT_STATUS_DS_INVALID_ATTRIBUTE_SYNTAX NT_STATUS(0xc00002a2L)
#define NT_STATUS_DS_ATTRIBUTE_TYPE_UNDEFINED NT_STATUS(0xc00002a3L)
#define NT_STATUS_DS_ATTRIBUTE_OR_VALUE_EXISTS NT_STATUS(0xc00002a4L)
#define NT_STATUS_DS_BUSY NT_STATUS(0xc00002a5L)
#define NT_STATUS_DS_UNAVAILABLE NT_STATUS(0xc00002a6L)
#define NT_STATUS_DS_NO_RIDS_ALLOCATED NT_STATUS(0xc00002a7L)
#define NT_STATUS_DS_NO_MORE_RIDS NT_STATUS(0xc00002a8L)
#define NT_STATUS_DS_INCORRECT_ROLE_OWNER NT_STATUS(0xc00002a9L)
#define NT_STATUS_DS_RIDMGR_INIT_ERROR NT_STATUS(0xc00002aaL)
#define NT_STATUS_DS_OBJ_CLASS_VIOLATION NT_STATUS(0xc00002abL)
#define NT_STATUS_DS_CANT_ON_NON_LEAF NT_STATUS(0xc00002acL)
#define NT_STATUS_DS_CANT_ON_RDN NT_STATUS(0xc00002adL)
#define NT_STATUS_DS_CANT_MOD_OBJ_CLASS NT_STATUS(0xc00002aeL)
#define NT_STATUS_DS_CROSS_DOM_MOVE_FAILED NT_STATUS(0xc00002afL)
#define NT_STATUS_DS_GC_NOT_AVAILABLE NT_STATUS(0xc00002b0L)
#define NT_STATUS_DIRECTORY_SERVICE_REQUIRED NT_STATUS(0xc00002b1L)
#define NT_STATUS_REPARSE_ATTRIBUTE_CONFLICT NT_STATUS(0xc00002b2L)
#define NT_STATUS_CANT_ENABLE_DENY_ONLY NT_STATUS(0xc00002b3L)
#define NT_STATUS_FLOAT_MULTIPLE_FAULTS NT_STATUS(0xc00002b4L)
#define NT_STATUS_FLOAT_MULTIPLE_TRAPS NT_STATUS(0xc00002b5L)
#define NT_STATUS_DEVICE_REMOVED NT_STATUS(0xc00002b6L)
#define NT_STATUS_JOURNAL_DELETE_IN_PROGRESS NT_STATUS(0xc00002b7L)
#define NT_STATUS_JOURNAL_NOT_ACTIVE NT_STATUS(0xc00002b8L)
#define NT_STATUS_NOINTERFACE NT_STATUS(0xc00002b9L)
#define NT_STATUS_DS_ADMIN_LIMIT_EXCEEDED NT_STATUS(0xc00002c1L)
#define NT_STATUS_DRIVER_FAILED_SLEEP NT_STATUS(0xc00002c2L)
#define NT_STATUS_MUTUAL_AUTHENTICATION_FAILED NT_STATUS(0xc00002c3L)
#define NT_STATUS_CORRUPT_SYSTEM_FILE NT_STATUS(0xc00002c4L)
#define NT_STATUS_DATATYPE_MISALIGNMENT_ERROR NT_STATUS(0xc00002c5L)
#define NT_STATUS_WMI_READ_ONLY NT_STATUS(0xc00002c6L)
#define NT_STATUS_WMI_SET_FAILURE NT_STATUS(0xc00002c7L)
#define NT_STATUS_COMMITMENT_MINIMUM NT_STATUS(0xc00002c8L)
#define NT_STATUS_REG_NAT_CONSUMPTION NT_STATUS(0xc00002c9L)
#define NT_STATUS_TRANSPORT_FULL NT_STATUS(0xc00002caL)
#define NT_STATUS_DS_SAM_INIT_FAILURE NT_STATUS(0xc00002cbL)
#define NT_STATUS_ONLY_IF_CONNECTED NT_STATUS(0xc00002ccL)
#define NT_STATUS_DS_SENSITIVE_GROUP_VIOLATION NT_STATUS(0xc00002cdL)
#define NT_STATUS_PNP_RESTART_ENUMERATION NT_STATUS(0xc00002ceL)
#define NT_STATUS_JOURNAL_ENTRY_DELETED NT_STATUS(0xc00002cfL)
#define NT_STATUS_DS_CANT_MOD_PRIMARYGROUPID NT_STATUS(0xc00002d0L)
#define NT_STATUS_SYSTEM_IMAGE_BAD_SIGNATURE NT_STATUS(0xc00002d1L)
#define NT_STATUS_PNP_REBOOT_REQUIRED NT_STATUS(0xc00002d2L)
#define NT_STATUS_POWER_STATE_INVALID NT_STATUS(0xc00002d3L)
#define NT_STATUS_DS_INVALID_GROUP_TYPE NT_STATUS(0xc00002d4L)
#define NT_STATUS_DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN NT_STATUS(0xc00002d5L)
#define NT_STATUS_DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN NT_STATUS(0xc00002d6L)
#define NT_STATUS_DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER NT_STATUS(0xc00002d7L)
#define NT_STATUS_DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER NT_STATUS(0xc00002d8L)
#define NT_STATUS_DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER NT_STATUS(0xc00002d9L)
#define NT_STATUS_DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER NT_STATUS(0xc00002daL)
#define NT_STATUS_DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER NT_STATUS(0xc00002dbL)
#define NT_STATUS_DS_HAVE_PRIMARY_MEMBERS NT_STATUS(0xc00002dcL)
#define NT_STATUS_WMI_NOT_SUPPORTED NT_STATUS(0xc00002ddL)
#define NT_STATUS_INSUFFICIENT_POWER NT_STATUS(0xc00002deL)
#define NT_STATUS_SAM_NEED_BOOTKEY_PASSWORD NT_STATUS(0xc00002dfL)
#define NT_STATUS_SAM_NEED_BOOTKEY_FLOPPY NT_STATUS(0xc00002e0L)
#define NT_STATUS_DS_CANT_START NT_STATUS(0xc00002e1L)
#define NT_STATUS_DS_INIT_FAILURE NT_STATUS(0xc00002e2L)
#define NT_STATUS_SAM_INIT_FAILURE NT_STATUS(0xc00002e3L)
#define NT_STATUS_DS_GC_REQUIRED NT_STATUS(0xc00002e4L)
#define NT_STATUS_DS_LOCAL_MEMBER_OF_LOCAL_ONLY NT_STATUS(0xc00002e5L)
#define NT_STATUS_DS_NO_FPO_IN_UNIVERSAL_GROUPS NT_STATUS(0xc00002e6L)
#define NT_STATUS_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED NT_STATUS(0xc00002e7L)
#define NT_STATUS_CURRENT_DOMAIN_NOT_ALLOWED NT_STATUS(0xc00002e9L)
#define NT_STATUS_CANNOT_MAKE NT_STATUS(0xc00002eaL)
#define NT_STATUS_SYSTEM_SHUTDOWN NT_STATUS(0xc00002ebL)
#define NT_STATUS_DS_INIT_FAILURE_CONSOLE NT_STATUS(0xc00002ecL)
#define NT_STATUS_DS_SAM_INIT_FAILURE_CONSOLE NT_STATUS(0xc00002edL)
#define NT_STATUS_UNFINISHED_CONTEXT_DELETED NT_STATUS(0xc00002eeL)
#define NT_STATUS_NO_TGT_REPLY NT_STATUS(0xc00002efL)
#define NT_STATUS_OBJECTID_NOT_FOUND NT_STATUS(0xc00002f0L)
#define NT_STATUS_NO_IP_ADDRESSES NT_STATUS(0xc00002f1L)
#define NT_STATUS_WRONG_CREDENTIAL_HANDLE NT_STATUS(0xc00002f2L)
#define NT_STATUS_CRYPTO_SYSTEM_INVALID NT_STATUS(0xc00002f3L)
#define NT_STATUS_MAX_REFERRALS_EXCEEDED NT_STATUS(0xc00002f4L)
#define NT_STATUS_MUST_BE_KDC NT_STATUS(0xc00002f5L)
#define NT_STATUS_STRONG_CRYPTO_NOT_SUPPORTED NT_STATUS(0xc00002f6L)
#define NT_STATUS_TOO_MANY_PRINCIPALS NT_STATUS(0xc00002f7L)
#define NT_STATUS_NO_PA_DATA NT_STATUS(0xc00002f8L)
#define NT_STATUS_PKINIT_NAME_MISMATCH NT_STATUS(0xc00002f9L)
#define NT_STATUS_SMARTCARD_LOGON_REQUIRED NT_STATUS(0xc00002faL)
#define NT_STATUS_KDC_INVALID_REQUEST NT_STATUS(0xc00002fbL)
#define NT_STATUS_KDC_UNABLE_TO_REFER NT_STATUS(0xc00002fcL)
#define NT_STATUS_KDC_UNKNOWN_ETYPE NT_STATUS(0xc00002fdL)
#define NT_STATUS_SHUTDOWN_IN_PROGRESS NT_STATUS(0xc00002feL)
#define NT_STATUS_SERVER_SHUTDOWN_IN_PROGRESS NT_STATUS(0xc00002ffL)
#define NT_STATUS_NOT_SUPPORTED_ON_SBS NT_STATUS(0xc0000300L)
#define NT_STATUS_WMI_GUID_DISCONNECTED NT_STATUS(0xc0000301L)
#define NT_STATUS_WMI_ALREADY_DISABLED NT_STATUS(0xc0000302L)
#define NT_STATUS_WMI_ALREADY_ENABLED NT_STATUS(0xc0000303L)
#define NT_STATUS_MFT_TOO_FRAGMENTED NT_STATUS(0xc0000304L)
#define NT_STATUS_COPY_PROTECTION_FAILURE NT_STATUS(0xc0000305L)
#define NT_STATUS_CSS_AUTHENTICATION_FAILURE NT_STATUS(0xc0000306L)
#define NT_STATUS_CSS_KEY_NOT_PRESENT NT_STATUS(0xc0000307L)
#define NT_STATUS_CSS_KEY_NOT_ESTABLISHED NT_STATUS(0xc0000308L)
#define NT_STATUS_CSS_SCRAMBLED_SECTOR NT_STATUS(0xc0000309L)
#define NT_STATUS_CSS_REGION_MISMATCH NT_STATUS(0xc000030aL)
#define NT_STATUS_CSS_RESETS_EXHAUSTED NT_STATUS(0xc000030bL)
#define NT_STATUS_PKINIT_FAILURE NT_STATUS(0xc0000320L)
#define NT_STATUS_SMARTCARD_SUBSYSTEM_FAILURE NT_STATUS(0xc0000321L)
#define NT_STATUS_NO_KERB_KEY NT_STATUS(0xc0000322L)
#define NT_STATUS_HOST_DOWN NT_STATUS(0xc0000350L)
#define NT_STATUS_UNSUPPORTED_PREAUTH NT_STATUS(0xc0000351L)
#define NT_STATUS_EFS_ALG_BLOB_TOO_BIG NT_STATUS(0xc0000352L)
#define NT_STATUS_PORT_NOT_SET NT_STATUS(0xc0000353L)
#define NT_STATUS_DEBUGGER_INACTIVE NT_STATUS(0xc0000354L)
#define NT_STATUS_DS_VERSION_CHECK_FAILURE NT_STATUS(0xc0000355L)
#define NT_STATUS_AUDITING_DISABLED NT_STATUS(0xc0000356L)
#define NT_STATUS_PRENT4_MACHINE_ACCOUNT NT_STATUS(0xc0000357L)
#define NT_STATUS_DS_AG_CANT_HAVE_UNIVERSAL_MEMBER NT_STATUS(0xc0000358L)
#define NT_STATUS_INVALID_IMAGE_WIN_32 NT_STATUS(0xc0000359L)
#define NT_STATUS_INVALID_IMAGE_WIN_64 NT_STATUS(0xc000035aL)
#define NT_STATUS_BAD_BINDINGS NT_STATUS(0xc000035bL)
#define NT_STATUS_NETWORK_SESSION_EXPIRED NT_STATUS(0xc000035cL)
#define NT_STATUS_APPHELP_BLOCK NT_STATUS(0xc000035dL)
#define NT_STATUS_ALL_SIDS_FILTERED NT_STATUS(0xc000035eL)
#define NT_STATUS_NOT_SAFE_MODE_DRIVER NT_STATUS(0xc000035fL)
#define NT_STATUS_ACCESS_DISABLED_BY_POLICY_DEFAULT NT_STATUS(0xc0000361L)
#define NT_STATUS_ACCESS_DISABLED_BY_POLICY_PATH NT_STATUS(0xc0000362L)
#define NT_STATUS_ACCESS_DISABLED_BY_POLICY_PUBLISHER NT_STATUS(0xc0000363L)
#define NT_STATUS_ACCESS_DISABLED_BY_POLICY_OTHER NT_STATUS(0xc0000364L)
#define NT_STATUS_FAILED_DRIVER_ENTRY NT_STATUS(0xc0000365L)
#define NT_STATUS_DEVICE_ENUMERATION_ERROR NT_STATUS(0xc0000366L)
#define NT_STATUS_MOUNT_POINT_NOT_RESOLVED NT_STATUS(0xc0000368L)
#define NT_STATUS_INVALID_DEVICE_OBJECT_PARAMETER NT_STATUS(0xc0000369L)
#define NT_STATUS_MCA_OCCURED NT_STATUS(0xc000036aL)
#define NT_STATUS_DRIVER_BLOCKED_CRITICAL NT_STATUS(0xc000036bL)
#define NT_STATUS_DRIVER_BLOCKED NT_STATUS(0xc000036cL)
#define NT_STATUS_DRIVER_DATABASE_ERROR NT_STATUS(0xc000036dL)
#define NT_STATUS_SYSTEM_HIVE_TOO_LARGE NT_STATUS(0xc000036eL)
#define NT_STATUS_INVALID_IMPORT_OF_NON_DLL NT_STATUS(0xc000036fL)
#define NT_STATUS_NO_SECRETS NT_STATUS(0xc0000371L)
#define NT_STATUS_ACCESS_DISABLED_NO_SAFER_UI_BY_POLICY NT_STATUS(0xc0000372L)
#define NT_STATUS_FAILED_STACK_SWITCH NT_STATUS(0xc0000373L)
#define NT_STATUS_HEAP_CORRUPTION NT_STATUS(0xc0000374L)
#define NT_STATUS_SMARTCARD_WRONG_PIN NT_STATUS(0xc0000380L)
#define NT_STATUS_SMARTCARD_CARD_BLOCKED NT_STATUS(0xc0000381L)
#define NT_STATUS_SMARTCARD_CARD_NOT_AUTHENTICATED NT_STATUS(0xc0000382L)
#define NT_STATUS_SMARTCARD_NO_CARD NT_STATUS(0xc0000383L)
#define NT_STATUS_SMARTCARD_NO_KEY_CONTAINER NT_STATUS(0xc0000384L)
#define NT_STATUS_SMARTCARD_NO_CERTIFICATE NT_STATUS(0xc0000385L)
#define NT_STATUS_SMARTCARD_NO_KEYSET NT_STATUS(0xc0000386L)
#define NT_STATUS_SMARTCARD_IO_ERROR NT_STATUS(0xc0000387L)
#define NT_STATUS_DOWNGRADE_DETECTED NT_STATUS(0xc0000388L)
#define NT_STATUS_SMARTCARD_CERT_REVOKED NT_STATUS(0xc0000389L)
#define NT_STATUS_ISSUING_CA_UNTRUSTED NT_STATUS(0xc000038aL)
#define NT_STATUS_REVOCATION_OFFLINE_C NT_STATUS(0xc000038bL)
#define NT_STATUS_PKINIT_CLIENT_FAILURE NT_STATUS(0xc000038cL)
#define NT_STATUS_SMARTCARD_CERT_EXPIRED NT_STATUS(0xc000038dL)
#define NT_STATUS_DRIVER_FAILED_PRIOR_UNLOAD NT_STATUS(0xc000038eL)
#define NT_STATUS_SMARTCARD_SILENT_CONTEXT NT_STATUS(0xc000038fL)
#define NT_STATUS_PER_USER_TRUST_QUOTA_EXCEEDED NT_STATUS(0xc0000401L)
#define NT_STATUS_ALL_USER_TRUST_QUOTA_EXCEEDED NT_STATUS(0xc0000402L)
#define NT_STATUS_USER_DELETE_TRUST_QUOTA_EXCEEDED NT_STATUS(0xc0000403L)
#define NT_STATUS_DS_NAME_NOT_UNIQUE NT_STATUS(0xc0000404L)
#define NT_STATUS_DS_DUPLICATE_ID_FOUND NT_STATUS(0xc0000405L)
#define NT_STATUS_DS_GROUP_CONVERSION_ERROR NT_STATUS(0xc0000406L)
#define NT_STATUS_VOLSNAP_PREPARE_HIBERNATE NT_STATUS(0xc0000407L)
#define NT_STATUS_USER2USER_REQUIRED NT_STATUS(0xc0000408L)
#define NT_STATUS_STACK_BUFFER_OVERRUN NT_STATUS(0xc0000409L)
#define NT_STATUS_NO_S4U_PROT_SUPPORT NT_STATUS(0xc000040aL)
#define NT_STATUS_CROSSREALM_DELEGATION_FAILURE NT_STATUS(0xc000040bL)
#define NT_STATUS_REVOCATION_OFFLINE_KDC NT_STATUS(0xc000040cL)
#define NT_STATUS_ISSUING_CA_UNTRUSTED_KDC NT_STATUS(0xc000040dL)
#define NT_STATUS_KDC_CERT_EXPIRED NT_STATUS(0xc000040eL)
#define NT_STATUS_KDC_CERT_REVOKED NT_STATUS(0xc000040fL)
#define NT_STATUS_PARAMETER_QUOTA_EXCEEDED NT_STATUS(0xc0000410L)
#define NT_STATUS_HIBERNATION_FAILURE NT_STATUS(0xc0000411L)
#define NT_STATUS_DELAY_LOAD_FAILED NT_STATUS(0xc0000412L)
#define NT_STATUS_AUTHENTICATION_FIREWALL_FAILED NT_STATUS(0xc0000413L)
#define NT_STATUS_VDM_DISALLOWED NT_STATUS(0xc0000414L)
#define NT_STATUS_HUNG_DISPLAY_DRIVER_THREAD NT_STATUS(0xc0000415L)
#define NT_STATUS_INSUFFICIENT_RESOURCE_FOR_SPECIFIED_SHARED_SECTION_SIZE NT_STATUS(0xc0000416L)
#define NT_STATUS_INVALID_CRUNTIME_PARAMETER NT_STATUS(0xc0000417L)
#define NT_STATUS_NTLM_BLOCKED NT_STATUS(0xc0000418L)
#define NT_STATUS_DS_SRC_SID_EXISTS_IN_FOREST NT_STATUS(0xc0000419L)
#define NT_STATUS_DS_DOMAIN_NAME_EXISTS_IN_FOREST NT_STATUS(0xc000041aL)
#define NT_STATUS_DS_FLAT_NAME_EXISTS_IN_FOREST NT_STATUS(0xc000041bL)
#define NT_STATUS_INVALID_USER_PRINCIPAL_NAME NT_STATUS(0xc000041cL)
#define NT_STATUS_ASSERTION_FAILURE NT_STATUS(0xc0000420L)
#define NT_STATUS_VERIFIER_STOP NT_STATUS(0xc0000421L)
#define NT_STATUS_CALLBACK_POP_STACK NT_STATUS(0xc0000423L)
#define NT_STATUS_INCOMPATIBLE_DRIVER_BLOCKED NT_STATUS(0xc0000424L)
#define NT_STATUS_HIVE_UNLOADED NT_STATUS(0xc0000425L)
#define NT_STATUS_COMPRESSION_DISABLED NT_STATUS(0xc0000426L)
#define NT_STATUS_FILE_SYSTEM_LIMITATION NT_STATUS(0xc0000427L)
#define NT_STATUS_INVALID_IMAGE_HASH NT_STATUS(0xc0000428L)
#define NT_STATUS_NOT_CAPABLE NT_STATUS(0xc0000429L)
#define NT_STATUS_REQUEST_OUT_OF_SEQUENCE NT_STATUS(0xc000042aL)
#define NT_STATUS_IMPLEMENTATION_LIMIT NT_STATUS(0xc000042bL)
#define NT_STATUS_ELEVATION_REQUIRED NT_STATUS(0xc000042cL)
#define NT_STATUS_NO_SECURITY_CONTEXT NT_STATUS(0xc000042dL)
#define NT_STATUS_PKU2U_CERT_FAILURE NT_STATUS(0xc000042eL)
#define NT_STATUS_BEYOND_VDL NT_STATUS(0xc0000432L)
#define NT_STATUS_ENCOUNTERED_WRITE_IN_PROGRESS NT_STATUS(0xc0000433L)
#define NT_STATUS_PTE_CHANGED NT_STATUS(0xc0000434L)
#define NT_STATUS_PURGE_FAILED NT_STATUS(0xc0000435L)
#define NT_STATUS_CRED_REQUIRES_CONFIRMATION NT_STATUS(0xc0000440L)
#define NT_STATUS_CS_ENCRYPTION_INVALID_SERVER_RESPONSE NT_STATUS(0xc0000441L)
#define NT_STATUS_CS_ENCRYPTION_UNSUPPORTED_SERVER NT_STATUS(0xc0000442L)
#define NT_STATUS_CS_ENCRYPTION_EXISTING_ENCRYPTED_FILE NT_STATUS(0xc0000443L)
#define NT_STATUS_CS_ENCRYPTION_NEW_ENCRYPTED_FILE NT_STATUS(0xc0000444L)
#define NT_STATUS_CS_ENCRYPTION_FILE_NOT_CSE NT_STATUS(0xc0000445L)
#define NT_STATUS_INVALID_LABEL NT_STATUS(0xc0000446L)
#define NT_STATUS_DRIVER_PROCESS_TERMINATED NT_STATUS(0xc0000450L)
#define NT_STATUS_AMBIGUOUS_SYSTEM_DEVICE NT_STATUS(0xc0000451L)
#define NT_STATUS_SYSTEM_DEVICE_NOT_FOUND NT_STATUS(0xc0000452L)
#define NT_STATUS_RESTART_BOOT_APPLICATION NT_STATUS(0xc0000453L)
#define NT_STATUS_INSUFFICIENT_NVRAM_RESOURCES NT_STATUS(0xc0000454L)
#define NT_STATUS_NO_RANGES_PROCESSED NT_STATUS(0xc0000460L)
#define NT_STATUS_DEVICE_FEATURE_NOT_SUPPORTED NT_STATUS(0xc0000463L)
#define NT_STATUS_DEVICE_UNREACHABLE NT_STATUS(0xc0000464L)
#define NT_STATUS_INVALID_TOKEN NT_STATUS(0xc0000465L)
#define NT_STATUS_SERVER_UNAVAILABLE NT_STATUS(0xc0000466L)
#define NT_STATUS_INVALID_TASK_NAME NT_STATUS(0xc0000500L)
#define NT_STATUS_INVALID_TASK_INDEX NT_STATUS(0xc0000501L)
#define NT_STATUS_THREAD_ALREADY_IN_TASK NT_STATUS(0xc0000502L)
#define NT_STATUS_CALLBACK_BYPASS NT_STATUS(0xc0000503L)
#define NT_STATUS_FAIL_FAST_EXCEPTION NT_STATUS(0xc0000602L)
#define NT_STATUS_IMAGE_CERT_REVOKED NT_STATUS(0xc0000603L)
#define NT_STATUS_PORT_CLOSED NT_STATUS(0xc0000700L)
#define NT_STATUS_MESSAGE_LOST NT_STATUS(0xc0000701L)
#define NT_STATUS_INVALID_MESSAGE NT_STATUS(0xc0000702L)
#define NT_STATUS_REQUEST_CANCELED NT_STATUS(0xc0000703L)
#define NT_STATUS_RECURSIVE_DISPATCH NT_STATUS(0xc0000704L)
#define NT_STATUS_LPC_RECEIVE_BUFFER_EXPECTED NT_STATUS(0xc0000705L)
#define NT_STATUS_LPC_INVALID_CONNECTION_USAGE NT_STATUS(0xc0000706L)
#define NT_STATUS_LPC_REQUESTS_NOT_ALLOWED NT_STATUS(0xc0000707L)
#define NT_STATUS_RESOURCE_IN_USE NT_STATUS(0xc0000708L)
#define NT_STATUS_HARDWARE_MEMORY_ERROR NT_STATUS(0xc0000709L)
#define NT_STATUS_THREADPOOL_HANDLE_EXCEPTION NT_STATUS(0xc000070aL)
#define NT_STATUS_THREADPOOL_SET_EVENT_ON_COMPLETION_FAILED NT_STATUS(0xc000070bL)
#define NT_STATUS_THREADPOOL_RELEASE_SEMAPHORE_ON_COMPLETION_FAILED NT_STATUS(0xc000070cL)
#define NT_STATUS_THREADPOOL_RELEASE_MUTEX_ON_COMPLETION_FAILED NT_STATUS(0xc000070dL)
#define NT_STATUS_THREADPOOL_FREE_LIBRARY_ON_COMPLETION_FAILED NT_STATUS(0xc000070eL)
#define NT_STATUS_THREADPOOL_RELEASED_DURING_OPERATION NT_STATUS(0xc000070fL)
#define NT_STATUS_CALLBACK_RETURNED_WHILE_IMPERSONATING NT_STATUS(0xc0000710L)
#define NT_STATUS_APC_RETURNED_WHILE_IMPERSONATING NT_STATUS(0xc0000711L)
#define NT_STATUS_PROCESS_IS_PROTECTED NT_STATUS(0xc0000712L)
#define NT_STATUS_MCA_EXCEPTION NT_STATUS(0xc0000713L)
#define NT_STATUS_CERTIFICATE_MAPPING_NOT_UNIQUE NT_STATUS(0xc0000714L)
#define NT_STATUS_SYMLINK_CLASS_DISABLED NT_STATUS(0xc0000715L)
#define NT_STATUS_INVALID_IDN_NORMALIZATION NT_STATUS(0xc0000716L)
#define NT_STATUS_NO_UNICODE_TRANSLATION NT_STATUS(0xc0000717L)
#define NT_STATUS_ALREADY_REGISTERED NT_STATUS(0xc0000718L)
#define NT_STATUS_CONTEXT_MISMATCH NT_STATUS(0xc0000719L)
#define NT_STATUS_PORT_ALREADY_HAS_COMPLETION_LIST NT_STATUS(0xc000071aL)
#define NT_STATUS_CALLBACK_RETURNED_THREAD_PRIORITY NT_STATUS(0xc000071bL)
#define NT_STATUS_INVALID_THREAD NT_STATUS(0xc000071cL)
#define NT_STATUS_CALLBACK_RETURNED_TRANSACTION NT_STATUS(0xc000071dL)
#define NT_STATUS_CALLBACK_RETURNED_LDR_LOCK NT_STATUS(0xc000071eL)
#define NT_STATUS_CALLBACK_RETURNED_LANG NT_STATUS(0xc000071fL)
#define NT_STATUS_CALLBACK_RETURNED_PRI_BACK NT_STATUS(0xc0000720L)
#define NT_STATUS_DISK_REPAIR_DISABLED NT_STATUS(0xc0000800L)
#define NT_STATUS_DS_DOMAIN_RENAME_IN_PROGRESS NT_STATUS(0xc0000801L)
#define NT_STATUS_DISK_QUOTA_EXCEEDED NT_STATUS(0xc0000802L)
#define NT_STATUS_CONTENT_BLOCKED NT_STATUS(0xc0000804L)
#define NT_STATUS_BAD_CLUSTERS NT_STATUS(0xc0000805L)
#define NT_STATUS_VOLUME_DIRTY NT_STATUS(0xc0000806L)
#define NT_STATUS_FILE_CHECKED_OUT NT_STATUS(0xc0000901L)
#define NT_STATUS_CHECKOUT_REQUIRED NT_STATUS(0xc0000902L)
#define NT_STATUS_BAD_FILE_TYPE NT_STATUS(0xc0000903L)
#define NT_STATUS_FILE_TOO_LARGE NT_STATUS(0xc0000904L)
#define NT_STATUS_FORMS_AUTH_REQUIRED NT_STATUS(0xc0000905L)
#define NT_STATUS_VIRUS_INFECTED NT_STATUS(0xc0000906L)
#define NT_STATUS_VIRUS_DELETED NT_STATUS(0xc0000907L)
#define NT_STATUS_BAD_MCFG_TABLE NT_STATUS(0xc0000908L)
#define NT_STATUS_CANNOT_BREAK_OPLOCK NT_STATUS(0xc0000909L)
#define NT_STATUS_WOW_ASSERTION NT_STATUS(0xc0009898L)
#define NT_STATUS_INVALID_SIGNATURE NT_STATUS(0xc000a000L)
#define NT_STATUS_HMAC_NOT_SUPPORTED NT_STATUS(0xc000a001L)
#define NT_STATUS_IPSEC_QUEUE_OVERFLOW NT_STATUS(0xc000a010L)
#define NT_STATUS_ND_QUEUE_OVERFLOW NT_STATUS(0xc000a011L)
#define NT_STATUS_HOPLIMIT_EXCEEDED NT_STATUS(0xc000a012L)
#define NT_STATUS_PROTOCOL_NOT_SUPPORTED NT_STATUS(0xc000a013L)
#define NT_STATUS_LOST_WRITEBEHIND_DATA_NETWORK_DISCONNECTED NT_STATUS(0xc000a080L)
#define NT_STATUS_LOST_WRITEBEHIND_DATA_NETWORK_SERVER_ERROR NT_STATUS(0xc000a081L)
#define NT_STATUS_LOST_WRITEBEHIND_DATA_LOCAL_DISK_ERROR NT_STATUS(0xc000a082L)
#define NT_STATUS_XML_PARSE_ERROR NT_STATUS(0xc000a083L)
#define NT_STATUS_XMLDSIG_ERROR NT_STATUS(0xc000a084L)
#define NT_STATUS_WRONG_COMPARTMENT NT_STATUS(0xc000a085L)
#define NT_STATUS_AUTHIP_FAILURE NT_STATUS(0xc000a086L)
#define NT_STATUS_DS_OID_MAPPED_GROUP_CANT_HAVE_MEMBERS NT_STATUS(0xc000a087L)
#define NT_STATUS_DS_OID_NOT_FOUND NT_STATUS(0xc000a088L)
#define NT_STATUS_HASH_NOT_SUPPORTED NT_STATUS(0xc000a100L)
#define NT_STATUS_HASH_NOT_PRESENT NT_STATUS(0xc000a101L)
#define NT_STATUS_OFFLOAD_READ_FLT_NOT_SUPPORTED NT_STATUS(0xc000a2a1L)
#define NT_STATUS_OFFLOAD_WRITE_FLT_NOT_SUPPORTED NT_STATUS(0xc000a2a2L)
#define NT_STATUS_OFFLOAD_READ_FILE_NOT_SUPPORTED NT_STATUS(0xc000a2a3L)
#define NT_STATUS_OFFLOAD_WRITE_FILE_NOT_SUPPORTED NT_STATUS(0xc000a2a4L)
#define NT_STATUS_DBG_NO_STATE_CHANGE NT_STATUS(0xc0010001L)
#define NT_STATUS_DBG_APP_NOT_IDLE NT_STATUS(0xc0010002L)
#define NT_STATUS_RPC_INVALID_STRING_BINDING NT_STATUS(0xc0020001L)
#define NT_STATUS_RPC_WRONG_KIND_OF_BINDING NT_STATUS(0xc0020002L)
#define NT_STATUS_RPC_INVALID_BINDING NT_STATUS(0xc0020003L)
#define NT_STATUS_RPC_PROTSEQ_NOT_SUPPORTED NT_STATUS(0xc0020004L)
#define NT_STATUS_RPC_INVALID_RPC_PROTSEQ NT_STATUS(0xc0020005L)
#define NT_STATUS_RPC_INVALID_STRING_UUID NT_STATUS(0xc0020006L)
#define NT_STATUS_RPC_INVALID_ENDPOINT_FORMAT NT_STATUS(0xc0020007L)
#define NT_STATUS_RPC_INVALID_NET_ADDR NT_STATUS(0xc0020008L)
#define NT_STATUS_RPC_NO_ENDPOINT_FOUND NT_STATUS(0xc0020009L)
#define NT_STATUS_RPC_INVALID_TIMEOUT NT_STATUS(0xc002000aL)
#define NT_STATUS_RPC_OBJECT_NOT_FOUND NT_STATUS(0xc002000bL)
#define NT_STATUS_RPC_ALREADY_REGISTERED NT_STATUS(0xc002000cL)
#define NT_STATUS_RPC_TYPE_ALREADY_REGISTERED NT_STATUS(0xc002000dL)
#define NT_STATUS_RPC_ALREADY_LISTENING NT_STATUS(0xc002000eL)
#define NT_STATUS_RPC_NO_PROTSEQS_REGISTERED NT_STATUS(0xc002000fL)
#define NT_STATUS_RPC_NOT_LISTENING NT_STATUS(0xc0020010L)
#define NT_STATUS_RPC_UNKNOWN_MGR_TYPE NT_STATUS(0xc0020011L)
#define NT_STATUS_RPC_UNKNOWN_IF NT_STATUS(0xc0020012L)
#define NT_STATUS_RPC_NO_BINDINGS NT_STATUS(0xc0020013L)
#define NT_STATUS_RPC_NO_PROTSEQS NT_STATUS(0xc0020014L)
#define NT_STATUS_RPC_CANT_CREATE_ENDPOINT NT_STATUS(0xc0020015L)
#define NT_STATUS_RPC_OUT_OF_RESOURCES NT_STATUS(0xc0020016L)
#define NT_STATUS_RPC_SERVER_UNAVAILABLE NT_STATUS(0xc0020017L)
#define NT_STATUS_RPC_SERVER_TOO_BUSY NT_STATUS(0xc0020018L)
#define NT_STATUS_RPC_INVALID_NETWORK_OPTIONS NT_STATUS(0xc0020019L)
#define NT_STATUS_RPC_NO_CALL_ACTIVE NT_STATUS(0xc002001aL)
#define NT_STATUS_RPC_CALL_FAILED NT_STATUS(0xc002001bL)
#define NT_STATUS_RPC_CALL_FAILED_DNE NT_STATUS(0xc002001cL)
#define NT_STATUS_RPC_PROTOCOL_ERROR NT_STATUS(0xc002001dL)
#define NT_STATUS_RPC_UNSUPPORTED_TRANS_SYN NT_STATUS(0xc002001fL)
#define NT_STATUS_RPC_UNSUPPORTED_TYPE NT_STATUS(0xc0020021L)
#define NT_STATUS_RPC_INVALID_TAG NT_STATUS(0xc0020022L)
#define NT_STATUS_RPC_INVALID_BOUND NT_STATUS(0xc0020023L)
#define NT_STATUS_RPC_NO_ENTRY_NAME NT_STATUS(0xc0020024L)
#define NT_STATUS_RPC_INVALID_NAME_SYNTAX NT_STATUS(0xc0020025L)
#define NT_STATUS_RPC_UNSUPPORTED_NAME_SYNTAX NT_STATUS(0xc0020026L)
#define NT_STATUS_RPC_UUID_NO_ADDRESS NT_STATUS(0xc0020028L)
#define NT_STATUS_RPC_DUPLICATE_ENDPOINT NT_STATUS(0xc0020029L)
#define NT_STATUS_RPC_UNKNOWN_AUTHN_TYPE NT_STATUS(0xc002002aL)
#define NT_STATUS_RPC_MAX_CALLS_TOO_SMALL NT_STATUS(0xc002002bL)
#define NT_STATUS_RPC_STRING_TOO_LONG NT_STATUS(0xc002002cL)
#define NT_STATUS_RPC_PROTSEQ_NOT_FOUND NT_STATUS(0xc002002dL)
#define NT_STATUS_RPC_PROCNUM_OUT_OF_RANGE NT_STATUS(0xc002002eL)
#define NT_STATUS_RPC_BINDING_HAS_NO_AUTH NT_STATUS(0xc002002fL)
#define NT_STATUS_RPC_UNKNOWN_AUTHN_SERVICE NT_STATUS(0xc0020030L)
#define NT_STATUS_RPC_UNKNOWN_AUTHN_LEVEL NT_STATUS(0xc0020031L)
#define NT_STATUS_RPC_INVALID_AUTH_IDENTITY NT_STATUS(0xc0020032L)
#define NT_STATUS_RPC_UNKNOWN_AUTHZ_SERVICE NT_STATUS(0xc0020033L)
#define NT_STATUS_EPT_INVALID_ENTRY NT_STATUS(0xc0020034L)
#define NT_STATUS_EPT_CANT_PERFORM_OP NT_STATUS(0xc0020035L)
#define NT_STATUS_EPT_NOT_REGISTERED NT_STATUS(0xc0020036L)
#define NT_STATUS_RPC_NOTHING_TO_EXPORT NT_STATUS(0xc0020037L)
#define NT_STATUS_RPC_INCOMPLETE_NAME NT_STATUS(0xc0020038L)
#define NT_STATUS_RPC_INVALID_VERS_OPTION NT_STATUS(0xc0020039L)
#define NT_STATUS_RPC_NO_MORE_MEMBERS NT_STATUS(0xc002003aL)
#define NT_STATUS_RPC_NOT_ALL_OBJS_UNEXPORTED NT_STATUS(0xc002003bL)
#define NT_STATUS_RPC_INTERFACE_NOT_FOUND NT_STATUS(0xc002003cL)
#define NT_STATUS_RPC_ENTRY_ALREADY_EXISTS NT_STATUS(0xc002003dL)
#define NT_STATUS_RPC_ENTRY_NOT_FOUND NT_STATUS(0xc002003eL)
#define NT_STATUS_RPC_NAME_SERVICE_UNAVAILABLE NT_STATUS(0xc002003fL)
#define NT_STATUS_RPC_INVALID_NAF_ID NT_STATUS(0xc0020040L)
#define NT_STATUS_RPC_CANNOT_SUPPORT NT_STATUS(0xc0020041L)
#define NT_STATUS_RPC_NO_CONTEXT_AVAILABLE NT_STATUS(0xc0020042L)
#define NT_STATUS_RPC_INTERNAL_ERROR NT_STATUS(0xc0020043L)
#define NT_STATUS_RPC_ZERO_DIVIDE NT_STATUS(0xc0020044L)
#define NT_STATUS_RPC_ADDRESS_ERROR NT_STATUS(0xc0020045L)
#define NT_STATUS_RPC_FP_DIV_ZERO NT_STATUS(0xc0020046L)
#define NT_STATUS_RPC_FP_UNDERFLOW NT_STATUS(0xc0020047L)
#define NT_STATUS_RPC_FP_OVERFLOW NT_STATUS(0xc0020048L)
#define NT_STATUS_RPC_CALL_IN_PROGRESS NT_STATUS(0xc0020049L)
#define NT_STATUS_RPC_NO_MORE_BINDINGS NT_STATUS(0xc002004aL)
#define NT_STATUS_RPC_GROUP_MEMBER_NOT_FOUND NT_STATUS(0xc002004bL)
#define NT_STATUS_EPT_CANT_CREATE NT_STATUS(0xc002004cL)
#define NT_STATUS_RPC_INVALID_OBJECT NT_STATUS(0xc002004dL)
#define NT_STATUS_RPC_NO_INTERFACES NT_STATUS(0xc002004fL)
#define NT_STATUS_RPC_CALL_CANCELLED NT_STATUS(0xc0020050L)
#define NT_STATUS_RPC_BINDING_INCOMPLETE NT_STATUS(0xc0020051L)
#define NT_STATUS_RPC_COMM_FAILURE NT_STATUS(0xc0020052L)
#define NT_STATUS_RPC_UNSUPPORTED_AUTHN_LEVEL NT_STATUS(0xc0020053L)
#define NT_STATUS_RPC_NO_PRINC_NAME NT_STATUS(0xc0020054L)
#define NT_STATUS_RPC_NOT_RPC_ERROR NT_STATUS(0xc0020055L)
#define NT_STATUS_RPC_SEC_PKG_ERROR NT_STATUS(0xc0020057L)
#define NT_STATUS_RPC_NOT_CANCELLED NT_STATUS(0xc0020058L)
#define NT_STATUS_RPC_INVALID_ASYNC_HANDLE NT_STATUS(0xc0020062L)
#define NT_STATUS_RPC_INVALID_ASYNC_CALL NT_STATUS(0xc0020063L)
#define NT_STATUS_RPC_PROXY_ACCESS_DENIED NT_STATUS(0xc0020064L)
#define NT_STATUS_RPC_NO_MORE_ENTRIES NT_STATUS(0xc0030001L)
#define NT_STATUS_RPC_SS_CHAR_TRANS_OPEN_FAIL NT_STATUS(0xc0030002L)
#define NT_STATUS_RPC_SS_CHAR_TRANS_SHORT_FILE NT_STATUS(0xc0030003L)
#define NT_STATUS_RPC_SS_IN_NULL_CONTEXT NT_STATUS(0xc0030004L)
#define NT_STATUS_RPC_SS_CONTEXT_MISMATCH NT_STATUS(0xc0030005L)
#define NT_STATUS_RPC_SS_CONTEXT_DAMAGED NT_STATUS(0xc0030006L)
#define NT_STATUS_RPC_SS_HANDLES_MISMATCH NT_STATUS(0xc0030007L)
#define NT_STATUS_RPC_SS_CANNOT_GET_CALL_HANDLE NT_STATUS(0xc0030008L)
#define NT_STATUS_RPC_NULL_REF_POINTER NT_STATUS(0xc0030009L)
#define NT_STATUS_RPC_ENUM_VALUE_OUT_OF_RANGE NT_STATUS(0xc003000aL)
#define NT_STATUS_RPC_BYTE_COUNT_TOO_SMALL NT_STATUS(0xc003000bL)
#define NT_STATUS_RPC_BAD_STUB_DATA NT_STATUS(0xc003000cL)
#define NT_STATUS_RPC_INVALID_ES_ACTION NT_STATUS(0xc0030059L)
#define NT_STATUS_RPC_WRONG_ES_VERSION NT_STATUS(0xc003005aL)
#define NT_STATUS_RPC_WRONG_STUB_VERSION NT_STATUS(0xc003005bL)
#define NT_STATUS_RPC_INVALID_PIPE_OBJECT NT_STATUS(0xc003005cL)
#define NT_STATUS_RPC_INVALID_PIPE_OPERATION NT_STATUS(0xc003005dL)
#define NT_STATUS_RPC_WRONG_PIPE_VERSION NT_STATUS(0xc003005eL)
#define NT_STATUS_RPC_PIPE_CLOSED NT_STATUS(0xc003005fL)
#define NT_STATUS_RPC_PIPE_DISCIPLINE_ERROR NT_STATUS(0xc0030060L)
#define NT_STATUS_RPC_PIPE_EMPTY NT_STATUS(0xc0030061L)
#define NT_STATUS_PNP_BAD_MPS_TABLE NT_STATUS(0xc0040035L)
#define NT_STATUS_PNP_TRANSLATION_FAILED NT_STATUS(0xc0040036L)
#define NT_STATUS_PNP_IRQ_TRANSLATION_FAILED NT_STATUS(0xc0040037L)
#define NT_STATUS_PNP_INVALID_ID NT_STATUS(0xc0040038L)
#define NT_STATUS_IO_REISSUE_AS_CACHED NT_STATUS(0xc0040039L)
#define NT_STATUS_CTX_WINSTATION_NAME_INVALID NT_STATUS(0xc00a0001L)
#define NT_STATUS_CTX_INVALID_PD NT_STATUS(0xc00a0002L)
#define NT_STATUS_CTX_PD_NOT_FOUND NT_STATUS(0xc00a0003L)
#define NT_STATUS_CTX_CLOSE_PENDING NT_STATUS(0xc00a0006L)
#define NT_STATUS_CTX_NO_OUTBUF NT_STATUS(0xc00a0007L)
#define NT_STATUS_CTX_MODEM_INF_NOT_FOUND NT_STATUS(0xc00a0008L)
#define NT_STATUS_CTX_INVALID_MODEMNAME NT_STATUS(0xc00a0009L)
#define NT_STATUS_CTX_RESPONSE_ERROR NT_STATUS(0xc00a000aL)
#define NT_STATUS_CTX_MODEM_RESPONSE_TIMEOUT NT_STATUS(0xc00a000bL)
#define NT_STATUS_CTX_MODEM_RESPONSE_NO_CARRIER NT_STATUS(0xc00a000cL)
#define NT_STATUS_CTX_MODEM_RESPONSE_NO_DIALTONE NT_STATUS(0xc00a000dL)
#define NT_STATUS_CTX_MODEM_RESPONSE_BUSY NT_STATUS(0xc00a000eL)
#define NT_STATUS_CTX_MODEM_RESPONSE_VOICE NT_STATUS(0xc00a000fL)
#define NT_STATUS_CTX_TD_ERROR NT_STATUS(0xc00a0010L)
#define NT_STATUS_CTX_LICENSE_CLIENT_INVALID NT_STATUS(0xc00a0012L)
#define NT_STATUS_CTX_LICENSE_NOT_AVAILABLE NT_STATUS(0xc00a0013L)
#define NT_STATUS_CTX_LICENSE_EXPIRED NT_STATUS(0xc00a0014L)
#define NT_STATUS_CTX_WINSTATION_NOT_FOUND NT_STATUS(0xc00a0015L)
#define NT_STATUS_CTX_WINSTATION_NAME_COLLISION NT_STATUS(0xc00a0016L)
#define NT_STATUS_CTX_WINSTATION_BUSY NT_STATUS(0xc00a0017L)
#define NT_STATUS_CTX_BAD_VIDEO_MODE NT_STATUS(0xc00a0018L)
#define NT_STATUS_CTX_GRAPHICS_INVALID NT_STATUS(0xc00a0022L)
#define NT_STATUS_CTX_NOT_CONSOLE NT_STATUS(0xc00a0024L)
#define NT_STATUS_CTX_CLIENT_QUERY_TIMEOUT NT_STATUS(0xc00a0026L)
#define NT_STATUS_CTX_CONSOLE_DISCONNECT NT_STATUS(0xc00a0027L)
#define NT_STATUS_CTX_CONSOLE_CONNECT NT_STATUS(0xc00a0028L)
#define NT_STATUS_CTX_SHADOW_DENIED NT_STATUS(0xc00a002aL)
#define NT_STATUS_CTX_WINSTATION_ACCESS_DENIED NT_STATUS(0xc00a002bL)
#define NT_STATUS_CTX_INVALID_WD NT_STATUS(0xc00a002eL)
#define NT_STATUS_CTX_WD_NOT_FOUND NT_STATUS(0xc00a002fL)
#define NT_STATUS_CTX_SHADOW_INVALID NT_STATUS(0xc00a0030L)
#define NT_STATUS_CTX_SHADOW_DISABLED NT_STATUS(0xc00a0031L)
#define NT_STATUS_RDP_PROTOCOL_ERROR NT_STATUS(0xc00a0032L)
#define NT_STATUS_CTX_CLIENT_LICENSE_NOT_SET NT_STATUS(0xc00a0033L)
#define NT_STATUS_CTX_CLIENT_LICENSE_IN_USE NT_STATUS(0xc00a0034L)
#define NT_STATUS_CTX_SHADOW_ENDED_BY_MODE_CHANGE NT_STATUS(0xc00a0035L)
#define NT_STATUS_CTX_SHADOW_NOT_RUNNING NT_STATUS(0xc00a0036L)
#define NT_STATUS_CTX_LOGON_DISABLED NT_STATUS(0xc00a0037L)
#define NT_STATUS_CTX_SECURITY_LAYER_ERROR NT_STATUS(0xc00a0038L)
#define NT_STATUS_TS_INCOMPATIBLE_SESSIONS NT_STATUS(0xc00a0039L)
#define NT_STATUS_MUI_FILE_NOT_FOUND NT_STATUS(0xc00b0001L)
#define NT_STATUS_MUI_INVALID_FILE NT_STATUS(0xc00b0002L)
#define NT_STATUS_MUI_INVALID_RC_CONFIG NT_STATUS(0xc00b0003L)
#define NT_STATUS_MUI_INVALID_LOCALE_NAME NT_STATUS(0xc00b0004L)
#define NT_STATUS_MUI_INVALID_ULTIMATEFALLBACK_NAME NT_STATUS(0xc00b0005L)
#define NT_STATUS_MUI_FILE_NOT_LOADED NT_STATUS(0xc00b0006L)
#define NT_STATUS_RESOURCE_ENUM_USER_STOP NT_STATUS(0xc00b0007L)
#define NT_STATUS_CLUSTER_INVALID_NODE NT_STATUS(0xc0130001L)
#define NT_STATUS_CLUSTER_NODE_EXISTS NT_STATUS(0xc0130002L)
#define NT_STATUS_CLUSTER_JOIN_IN_PROGRESS NT_STATUS(0xc0130003L)
#define NT_STATUS_CLUSTER_NODE_NOT_FOUND NT_STATUS(0xc0130004L)
#define NT_STATUS_CLUSTER_LOCAL_NODE_NOT_FOUND NT_STATUS(0xc0130005L)
#define NT_STATUS_CLUSTER_NETWORK_EXISTS NT_STATUS(0xc0130006L)
#define NT_STATUS_CLUSTER_NETWORK_NOT_FOUND NT_STATUS(0xc0130007L)
#define NT_STATUS_CLUSTER_NETINTERFACE_EXISTS NT_STATUS(0xc0130008L)
#define NT_STATUS_CLUSTER_NETINTERFACE_NOT_FOUND NT_STATUS(0xc0130009L)
#define NT_STATUS_CLUSTER_INVALID_REQUEST NT_STATUS(0xc013000aL)
#define NT_STATUS_CLUSTER_INVALID_NETWORK_PROVIDER NT_STATUS(0xc013000bL)
#define NT_STATUS_CLUSTER_NODE_DOWN NT_STATUS(0xc013000cL)
#define NT_STATUS_CLUSTER_NODE_UNREACHABLE NT_STATUS(0xc013000dL)
#define NT_STATUS_CLUSTER_NODE_NOT_MEMBER NT_STATUS(0xc013000eL)
#define NT_STATUS_CLUSTER_JOIN_NOT_IN_PROGRESS NT_STATUS(0xc013000fL)
#define NT_STATUS_CLUSTER_INVALID_NETWORK NT_STATUS(0xc0130010L)
#define NT_STATUS_CLUSTER_NO_NET_ADAPTERS NT_STATUS(0xc0130011L)
#define NT_STATUS_CLUSTER_NODE_UP NT_STATUS(0xc0130012L)
#define NT_STATUS_CLUSTER_NODE_PAUSED NT_STATUS(0xc0130013L)
#define NT_STATUS_CLUSTER_NODE_NOT_PAUSED NT_STATUS(0xc0130014L)
#define NT_STATUS_CLUSTER_NO_SECURITY_CONTEXT NT_STATUS(0xc0130015L)
#define NT_STATUS_CLUSTER_NETWORK_NOT_INTERNAL NT_STATUS(0xc0130016L)
#define NT_STATUS_CLUSTER_POISONED NT_STATUS(0xc0130017L)
#define NT_STATUS_ACPI_INVALID_OPCODE NT_STATUS(0xc0140001L)
#define NT_STATUS_ACPI_STACK_OVERFLOW NT_STATUS(0xc0140002L)
#define NT_STATUS_ACPI_ASSERT_FAILED NT_STATUS(0xc0140003L)
#define NT_STATUS_ACPI_INVALID_INDEX NT_STATUS(0xc0140004L)
#define NT_STATUS_ACPI_INVALID_ARGUMENT NT_STATUS(0xc0140005L)
#define NT_STATUS_ACPI_FATAL NT_STATUS(0xc0140006L)
#define NT_STATUS_ACPI_INVALID_SUPERNAME NT_STATUS(0xc0140007L)
#define NT_STATUS_ACPI_INVALID_ARGTYPE NT_STATUS(0xc0140008L)
#define NT_STATUS_ACPI_INVALID_OBJTYPE NT_STATUS(0xc0140009L)
#define NT_STATUS_ACPI_INVALID_TARGETTYPE NT_STATUS(0xc014000aL)
#define NT_STATUS_ACPI_INCORRECT_ARGUMENT_COUNT NT_STATUS(0xc014000bL)
#define NT_STATUS_ACPI_ADDRESS_NOT_MAPPED NT_STATUS(0xc014000cL)
#define NT_STATUS_ACPI_INVALID_EVENTTYPE NT_STATUS(0xc014000dL)
#define NT_STATUS_ACPI_HANDLER_COLLISION NT_STATUS(0xc014000eL)
#define NT_STATUS_ACPI_INVALID_DATA NT_STATUS(0xc014000fL)
#define NT_STATUS_ACPI_INVALID_REGION NT_STATUS(0xc0140010L)
#define NT_STATUS_ACPI_INVALID_ACCESS_SIZE NT_STATUS(0xc0140011L)
#define NT_STATUS_ACPI_ACQUIRE_GLOBAL_LOCK NT_STATUS(0xc0140012L)
#define NT_STATUS_ACPI_ALREADY_INITIALIZED NT_STATUS(0xc0140013L)
#define NT_STATUS_ACPI_NOT_INITIALIZED NT_STATUS(0xc0140014L)
#define NT_STATUS_ACPI_INVALID_MUTEX_LEVEL NT_STATUS(0xc0140015L)
#define NT_STATUS_ACPI_MUTEX_NOT_OWNED NT_STATUS(0xc0140016L)
#define NT_STATUS_ACPI_MUTEX_NOT_OWNER NT_STATUS(0xc0140017L)
#define NT_STATUS_ACPI_RS_ACCESS NT_STATUS(0xc0140018L)
#define NT_STATUS_ACPI_INVALID_TABLE NT_STATUS(0xc0140019L)
#define NT_STATUS_ACPI_REG_HANDLER_FAILED NT_STATUS(0xc0140020L)
#define NT_STATUS_ACPI_POWER_REQUEST_FAILED NT_STATUS(0xc0140021L)
#define NT_STATUS_SXS_SECTION_NOT_FOUND NT_STATUS(0xc0150001L)
#define NT_STATUS_SXS_CANT_GEN_ACTCTX NT_STATUS(0xc0150002L)
#define NT_STATUS_SXS_INVALID_ACTCTXDATA_FORMAT NT_STATUS(0xc0150003L)
#define NT_STATUS_SXS_ASSEMBLY_NOT_FOUND NT_STATUS(0xc0150004L)
#define NT_STATUS_SXS_MANIFEST_FORMAT_ERROR NT_STATUS(0xc0150005L)
#define NT_STATUS_SXS_MANIFEST_PARSE_ERROR NT_STATUS(0xc0150006L)
#define NT_STATUS_SXS_ACTIVATION_CONTEXT_DISABLED NT_STATUS(0xc0150007L)
#define NT_STATUS_SXS_KEY_NOT_FOUND NT_STATUS(0xc0150008L)
#define NT_STATUS_SXS_VERSION_CONFLICT NT_STATUS(0xc0150009L)
#define NT_STATUS_SXS_WRONG_SECTION_TYPE NT_STATUS(0xc015000aL)
#define NT_STATUS_SXS_THREAD_QUERIES_DISABLED NT_STATUS(0xc015000bL)
#define NT_STATUS_SXS_ASSEMBLY_MISSING NT_STATUS(0xc015000cL)
#define NT_STATUS_SXS_PROCESS_DEFAULT_ALREADY_SET NT_STATUS(0xc015000eL)
#define NT_STATUS_SXS_EARLY_DEACTIVATION NT_STATUS(0xc015000fL)
#define NT_STATUS_SXS_INVALID_DEACTIVATION NT_STATUS(0xc0150010L)
#define NT_STATUS_SXS_MULTIPLE_DEACTIVATION NT_STATUS(0xc0150011L)
#define NT_STATUS_SXS_SYSTEM_DEFAULT_ACTIVATION_CONTEXT_EMPTY NT_STATUS(0xc0150012L)
#define NT_STATUS_SXS_PROCESS_TERMINATION_REQUESTED NT_STATUS(0xc0150013L)
#define NT_STATUS_SXS_CORRUPT_ACTIVATION_STACK NT_STATUS(0xc0150014L)
#define NT_STATUS_SXS_CORRUPTION NT_STATUS(0xc0150015L)
#define NT_STATUS_SXS_INVALID_IDENTITY_ATTRIBUTE_VALUE NT_STATUS(0xc0150016L)
#define NT_STATUS_SXS_INVALID_IDENTITY_ATTRIBUTE_NAME NT_STATUS(0xc0150017L)
#define NT_STATUS_SXS_IDENTITY_DUPLICATE_ATTRIBUTE NT_STATUS(0xc0150018L)
#define NT_STATUS_SXS_IDENTITY_PARSE_ERROR NT_STATUS(0xc0150019L)
#define NT_STATUS_SXS_COMPONENT_STORE_CORRUPT NT_STATUS(0xc015001aL)
#define NT_STATUS_SXS_FILE_HASH_MISMATCH NT_STATUS(0xc015001bL)
#define NT_STATUS_SXS_MANIFEST_IDENTITY_SAME_BUT_CONTENTS_DIFFERENT NT_STATUS(0xc015001cL)
#define NT_STATUS_SXS_IDENTITIES_DIFFERENT NT_STATUS(0xc015001dL)
#define NT_STATUS_SXS_ASSEMBLY_IS_NOT_A_DEPLOYMENT NT_STATUS(0xc015001eL)
#define NT_STATUS_SXS_FILE_NOT_PART_OF_ASSEMBLY NT_STATUS(0xc015001fL)
#define NT_STATUS_ADVANCED_INSTALLER_FAILED NT_STATUS(0xc0150020L)
#define NT_STATUS_XML_ENCODING_MISMATCH NT_STATUS(0xc0150021L)
#define NT_STATUS_SXS_MANIFEST_TOO_BIG NT_STATUS(0xc0150022L)
#define NT_STATUS_SXS_SETTING_NOT_REGISTERED NT_STATUS(0xc0150023L)
#define NT_STATUS_SXS_TRANSACTION_CLOSURE_INCOMPLETE NT_STATUS(0xc0150024L)
#define NT_STATUS_SMI_PRIMITIVE_INSTALLER_FAILED NT_STATUS(0xc0150025L)
#define NT_STATUS_GENERIC_COMMAND_FAILED NT_STATUS(0xc0150026L)
#define NT_STATUS_SXS_FILE_HASH_MISSING NT_STATUS(0xc0150027L)
#define NT_STATUS_TRANSACTIONAL_CONFLICT NT_STATUS(0xc0190001L)
#define NT_STATUS_INVALID_TRANSACTION NT_STATUS(0xc0190002L)
#define NT_STATUS_TRANSACTION_NOT_ACTIVE NT_STATUS(0xc0190003L)
#define NT_STATUS_TM_INITIALIZATION_FAILED NT_STATUS(0xc0190004L)
#define NT_STATUS_RM_NOT_ACTIVE NT_STATUS(0xc0190005L)
#define NT_STATUS_RM_METADATA_CORRUPT NT_STATUS(0xc0190006L)
#define NT_STATUS_TRANSACTION_NOT_JOINED NT_STATUS(0xc0190007L)
#define NT_STATUS_DIRECTORY_NOT_RM NT_STATUS(0xc0190008L)
#define NT_STATUS_TRANSACTIONS_UNSUPPORTED_REMOTE NT_STATUS(0xc019000aL)
#define NT_STATUS_LOG_RESIZE_INVALID_SIZE NT_STATUS(0xc019000bL)
#define NT_STATUS_REMOTE_FILE_VERSION_MISMATCH NT_STATUS(0xc019000cL)
#define NT_STATUS_CRM_PROTOCOL_ALREADY_EXISTS NT_STATUS(0xc019000fL)
#define NT_STATUS_TRANSACTION_PROPAGATION_FAILED NT_STATUS(0xc0190010L)
#define NT_STATUS_CRM_PROTOCOL_NOT_FOUND NT_STATUS(0xc0190011L)
#define NT_STATUS_TRANSACTION_SUPERIOR_EXISTS NT_STATUS(0xc0190012L)
#define NT_STATUS_TRANSACTION_REQUEST_NOT_VALID NT_STATUS(0xc0190013L)
#define NT_STATUS_TRANSACTION_NOT_REQUESTED NT_STATUS(0xc0190014L)
#define NT_STATUS_TRANSACTION_ALREADY_ABORTED NT_STATUS(0xc0190015L)
#define NT_STATUS_TRANSACTION_ALREADY_COMMITTED NT_STATUS(0xc0190016L)
#define NT_STATUS_TRANSACTION_INVALID_MARSHALL_BUFFER NT_STATUS(0xc0190017L)
#define NT_STATUS_CURRENT_TRANSACTION_NOT_VALID NT_STATUS(0xc0190018L)
#define NT_STATUS_LOG_GROWTH_FAILED NT_STATUS(0xc0190019L)
#define NT_STATUS_OBJECT_NO_LONGER_EXISTS NT_STATUS(0xc0190021L)
#define NT_STATUS_STREAM_MINIVERSION_NOT_FOUND NT_STATUS(0xc0190022L)
#define NT_STATUS_STREAM_MINIVERSION_NOT_VALID NT_STATUS(0xc0190023L)
#define NT_STATUS_MINIVERSION_INACCESSIBLE_FROM_SPECIFIED_TRANSACTION NT_STATUS(0xc0190024L)
#define NT_STATUS_CANT_OPEN_MINIVERSION_WITH_MODIFY_INTENT NT_STATUS(0xc0190025L)
#define NT_STATUS_CANT_CREATE_MORE_STREAM_MINIVERSIONS NT_STATUS(0xc0190026L)
#define NT_STATUS_HANDLE_NO_LONGER_VALID NT_STATUS(0xc0190028L)
#define NT_STATUS_LOG_CORRUPTION_DETECTED NT_STATUS(0xc0190030L)
#define NT_STATUS_RM_DISCONNECTED NT_STATUS(0xc0190032L)
#define NT_STATUS_ENLISTMENT_NOT_SUPERIOR NT_STATUS(0xc0190033L)
#define NT_STATUS_FILE_IDENTITY_NOT_PERSISTENT NT_STATUS(0xc0190036L)
#define NT_STATUS_CANT_BREAK_TRANSACTIONAL_DEPENDENCY NT_STATUS(0xc0190037L)
#define NT_STATUS_CANT_CROSS_RM_BOUNDARY NT_STATUS(0xc0190038L)
#define NT_STATUS_TXF_DIR_NOT_EMPTY NT_STATUS(0xc0190039L)
#define NT_STATUS_INDOUBT_TRANSACTIONS_EXIST NT_STATUS(0xc019003aL)
#define NT_STATUS_TM_VOLATILE NT_STATUS(0xc019003bL)
#define NT_STATUS_ROLLBACK_TIMER_EXPIRED NT_STATUS(0xc019003cL)
#define NT_STATUS_TXF_ATTRIBUTE_CORRUPT NT_STATUS(0xc019003dL)
#define NT_STATUS_EFS_NOT_ALLOWED_IN_TRANSACTION NT_STATUS(0xc019003eL)
#define NT_STATUS_TRANSACTIONAL_OPEN_NOT_ALLOWED NT_STATUS(0xc019003fL)
#define NT_STATUS_TRANSACTED_MAPPING_UNSUPPORTED_REMOTE NT_STATUS(0xc0190040L)
#define NT_STATUS_TRANSACTION_REQUIRED_PROMOTION NT_STATUS(0xc0190043L)
#define NT_STATUS_CANNOT_EXECUTE_FILE_IN_TRANSACTION NT_STATUS(0xc0190044L)
#define NT_STATUS_TRANSACTIONS_NOT_FROZEN NT_STATUS(0xc0190045L)
#define NT_STATUS_TRANSACTION_FREEZE_IN_PROGRESS NT_STATUS(0xc0190046L)
#define NT_STATUS_NOT_SNAPSHOT_VOLUME NT_STATUS(0xc0190047L)
#define NT_STATUS_NO_SAVEPOINT_WITH_OPEN_FILES NT_STATUS(0xc0190048L)
#define NT_STATUS_SPARSE_NOT_ALLOWED_IN_TRANSACTION NT_STATUS(0xc0190049L)
#define NT_STATUS_TM_IDENTITY_MISMATCH NT_STATUS(0xc019004aL)
#define NT_STATUS_FLOATED_SECTION NT_STATUS(0xc019004bL)
#define NT_STATUS_CANNOT_ACCEPT_TRANSACTED_WORK NT_STATUS(0xc019004cL)
#define NT_STATUS_CANNOT_ABORT_TRANSACTIONS NT_STATUS(0xc019004dL)
#define NT_STATUS_TRANSACTION_NOT_FOUND NT_STATUS(0xc019004eL)
#define NT_STATUS_RESOURCEMANAGER_NOT_FOUND NT_STATUS(0xc019004fL)
#define NT_STATUS_ENLISTMENT_NOT_FOUND NT_STATUS(0xc0190050L)
#define NT_STATUS_TRANSACTIONMANAGER_NOT_FOUND NT_STATUS(0xc0190051L)
#define NT_STATUS_TRANSACTIONMANAGER_NOT_ONLINE NT_STATUS(0xc0190052L)
#define NT_STATUS_TRANSACTIONMANAGER_RECOVERY_NAME_COLLISION NT_STATUS(0xc0190053L)
#define NT_STATUS_TRANSACTION_NOT_ROOT NT_STATUS(0xc0190054L)
#define NT_STATUS_TRANSACTION_OBJECT_EXPIRED NT_STATUS(0xc0190055L)
#define NT_STATUS_COMPRESSION_NOT_ALLOWED_IN_TRANSACTION NT_STATUS(0xc0190056L)
#define NT_STATUS_TRANSACTION_RESPONSE_NOT_ENLISTED NT_STATUS(0xc0190057L)
#define NT_STATUS_TRANSACTION_RECORD_TOO_LONG NT_STATUS(0xc0190058L)
#define NT_STATUS_NO_LINK_TRACKING_IN_TRANSACTION NT_STATUS(0xc0190059L)
#define NT_STATUS_OPERATION_NOT_SUPPORTED_IN_TRANSACTION NT_STATUS(0xc019005aL)
#define NT_STATUS_TRANSACTION_INTEGRITY_VIOLATED NT_STATUS(0xc019005bL)
#define NT_STATUS_EXPIRED_HANDLE NT_STATUS(0xc0190060L)
#define NT_STATUS_TRANSACTION_NOT_ENLISTED NT_STATUS(0xc0190061L)
#define NT_STATUS_LOG_SECTOR_INVALID NT_STATUS(0xc01a0001L)
#define NT_STATUS_LOG_SECTOR_PARITY_INVALID NT_STATUS(0xc01a0002L)
#define NT_STATUS_LOG_SECTOR_REMAPPED NT_STATUS(0xc01a0003L)
#define NT_STATUS_LOG_BLOCK_INCOMPLETE NT_STATUS(0xc01a0004L)
#define NT_STATUS_LOG_INVALID_RANGE NT_STATUS(0xc01a0005L)
#define NT_STATUS_LOG_BLOCKS_EXHAUSTED NT_STATUS(0xc01a0006L)
#define NT_STATUS_LOG_READ_CONTEXT_INVALID NT_STATUS(0xc01a0007L)
#define NT_STATUS_LOG_RESTART_INVALID NT_STATUS(0xc01a0008L)
#define NT_STATUS_LOG_BLOCK_VERSION NT_STATUS(0xc01a0009L)
#define NT_STATUS_LOG_BLOCK_INVALID NT_STATUS(0xc01a000aL)
#define NT_STATUS_LOG_READ_MODE_INVALID NT_STATUS(0xc01a000bL)
#define NT_STATUS_LOG_METADATA_CORRUPT NT_STATUS(0xc01a000dL)
#define NT_STATUS_LOG_METADATA_INVALID NT_STATUS(0xc01a000eL)
#define NT_STATUS_LOG_METADATA_INCONSISTENT NT_STATUS(0xc01a000fL)
#define NT_STATUS_LOG_RESERVATION_INVALID NT_STATUS(0xc01a0010L)
#define NT_STATUS_LOG_CANT_DELETE NT_STATUS(0xc01a0011L)
#define NT_STATUS_LOG_CONTAINER_LIMIT_EXCEEDED NT_STATUS(0xc01a0012L)
#define NT_STATUS_LOG_START_OF_LOG NT_STATUS(0xc01a0013L)
#define NT_STATUS_LOG_POLICY_ALREADY_INSTALLED NT_STATUS(0xc01a0014L)
#define NT_STATUS_LOG_POLICY_NOT_INSTALLED NT_STATUS(0xc01a0015L)
#define NT_STATUS_LOG_POLICY_INVALID NT_STATUS(0xc01a0016L)
#define NT_STATUS_LOG_POLICY_CONFLICT NT_STATUS(0xc01a0017L)
#define NT_STATUS_LOG_PINNED_ARCHIVE_TAIL NT_STATUS(0xc01a0018L)
#define NT_STATUS_LOG_RECORD_NONEXISTENT NT_STATUS(0xc01a0019L)
#define NT_STATUS_LOG_RECORDS_RESERVED_INVALID NT_STATUS(0xc01a001aL)
#define NT_STATUS_LOG_SPACE_RESERVED_INVALID NT_STATUS(0xc01a001bL)
#define NT_STATUS_LOG_TAIL_INVALID NT_STATUS(0xc01a001cL)
#define NT_STATUS_LOG_FULL NT_STATUS(0xc01a001dL)
#define NT_STATUS_LOG_MULTIPLEXED NT_STATUS(0xc01a001eL)
#define NT_STATUS_LOG_DEDICATED NT_STATUS(0xc01a001fL)
#define NT_STATUS_LOG_ARCHIVE_NOT_IN_PROGRESS NT_STATUS(0xc01a0020L)
#define NT_STATUS_LOG_ARCHIVE_IN_PROGRESS NT_STATUS(0xc01a0021L)
#define NT_STATUS_LOG_EPHEMERAL NT_STATUS(0xc01a0022L)
#define NT_STATUS_LOG_NOT_ENOUGH_CONTAINERS NT_STATUS(0xc01a0023L)
#define NT_STATUS_LOG_CLIENT_ALREADY_REGISTERED NT_STATUS(0xc01a0024L)
#define NT_STATUS_LOG_CLIENT_NOT_REGISTERED NT_STATUS(0xc01a0025L)
#define NT_STATUS_LOG_FULL_HANDLER_IN_PROGRESS NT_STATUS(0xc01a0026L)
#define NT_STATUS_LOG_CONTAINER_READ_FAILED NT_STATUS(0xc01a0027L)
#define NT_STATUS_LOG_CONTAINER_WRITE_FAILED NT_STATUS(0xc01a0028L)
#define NT_STATUS_LOG_CONTAINER_OPEN_FAILED NT_STATUS(0xc01a0029L)
#define NT_STATUS_LOG_CONTAINER_STATE_INVALID NT_STATUS(0xc01a002aL)
#define NT_STATUS_LOG_STATE_INVALID NT_STATUS(0xc01a002bL)
#define NT_STATUS_LOG_PINNED NT_STATUS(0xc01a002cL)
#define NT_STATUS_LOG_METADATA_FLUSH_FAILED NT_STATUS(0xc01a002dL)
#define NT_STATUS_LOG_INCONSISTENT_SECURITY NT_STATUS(0xc01a002eL)
#define NT_STATUS_LOG_APPENDED_FLUSH_FAILED NT_STATUS(0xc01a002fL)
#define NT_STATUS_LOG_PINNED_RESERVATION NT_STATUS(0xc01a0030L)
#define NT_STATUS_VIDEO_HUNG_DISPLAY_DRIVER_THREAD NT_STATUS(0xc01b00eaL)
#define NT_STATUS_FLT_NO_HANDLER_DEFINED NT_STATUS(0xc01c0001L)
#define NT_STATUS_FLT_CONTEXT_ALREADY_DEFINED NT_STATUS(0xc01c0002L)
#define NT_STATUS_FLT_INVALID_ASYNCHRONOUS_REQUEST NT_STATUS(0xc01c0003L)
#define NT_STATUS_FLT_DISALLOW_FAST_IO NT_STATUS(0xc01c0004L)
#define NT_STATUS_FLT_INVALID_NAME_REQUEST NT_STATUS(0xc01c0005L)
#define NT_STATUS_FLT_NOT_SAFE_TO_POST_OPERATION NT_STATUS(0xc01c0006L)
#define NT_STATUS_FLT_NOT_INITIALIZED NT_STATUS(0xc01c0007L)
#define NT_STATUS_FLT_FILTER_NOT_READY NT_STATUS(0xc01c0008L)
#define NT_STATUS_FLT_POST_OPERATION_CLEANUP NT_STATUS(0xc01c0009L)
#define NT_STATUS_FLT_INTERNAL_ERROR NT_STATUS(0xc01c000aL)
#define NT_STATUS_FLT_DELETING_OBJECT NT_STATUS(0xc01c000bL)
#define NT_STATUS_FLT_MUST_BE_NONPAGED_POOL NT_STATUS(0xc01c000cL)
#define NT_STATUS_FLT_DUPLICATE_ENTRY NT_STATUS(0xc01c000dL)
#define NT_STATUS_FLT_CBDQ_DISABLED NT_STATUS(0xc01c000eL)
#define NT_STATUS_FLT_DO_NOT_ATTACH NT_STATUS(0xc01c000fL)
#define NT_STATUS_FLT_DO_NOT_DETACH NT_STATUS(0xc01c0010L)
#define NT_STATUS_FLT_INSTANCE_ALTITUDE_COLLISION NT_STATUS(0xc01c0011L)
#define NT_STATUS_FLT_INSTANCE_NAME_COLLISION NT_STATUS(0xc01c0012L)
#define NT_STATUS_FLT_FILTER_NOT_FOUND NT_STATUS(0xc01c0013L)
#define NT_STATUS_FLT_VOLUME_NOT_FOUND NT_STATUS(0xc01c0014L)
#define NT_STATUS_FLT_INSTANCE_NOT_FOUND NT_STATUS(0xc01c0015L)
#define NT_STATUS_FLT_CONTEXT_ALLOCATION_NOT_FOUND NT_STATUS(0xc01c0016L)
#define NT_STATUS_FLT_INVALID_CONTEXT_REGISTRATION NT_STATUS(0xc01c0017L)
#define NT_STATUS_FLT_NAME_CACHE_MISS NT_STATUS(0xc01c0018L)
#define NT_STATUS_FLT_NO_DEVICE_OBJECT NT_STATUS(0xc01c0019L)
#define NT_STATUS_FLT_VOLUME_ALREADY_MOUNTED NT_STATUS(0xc01c001aL)
#define NT_STATUS_FLT_ALREADY_ENLISTED NT_STATUS(0xc01c001bL)
#define NT_STATUS_FLT_CONTEXT_ALREADY_LINKED NT_STATUS(0xc01c001cL)
#define NT_STATUS_FLT_NO_WAITER_FOR_REPLY NT_STATUS(0xc01c0020L)
#define NT_STATUS_MONITOR_NO_DESCRIPTOR NT_STATUS(0xc01d0001L)
#define NT_STATUS_MONITOR_UNKNOWN_DESCRIPTOR_FORMAT NT_STATUS(0xc01d0002L)
#define NT_STATUS_MONITOR_INVALID_DESCRIPTOR_CHECKSUM NT_STATUS(0xc01d0003L)
#define NT_STATUS_MONITOR_INVALID_STANDARD_TIMING_BLOCK NT_STATUS(0xc01d0004L)
#define NT_STATUS_MONITOR_WMI_DATABLOCK_REGISTRATION_FAILED NT_STATUS(0xc01d0005L)
#define NT_STATUS_MONITOR_INVALID_SERIAL_NUMBER_MONDSC_BLOCK NT_STATUS(0xc01d0006L)
#define NT_STATUS_MONITOR_INVALID_USER_FRIENDLY_MONDSC_BLOCK NT_STATUS(0xc01d0007L)
#define NT_STATUS_MONITOR_NO_MORE_DESCRIPTOR_DATA NT_STATUS(0xc01d0008L)
#define NT_STATUS_MONITOR_INVALID_DETAILED_TIMING_BLOCK NT_STATUS(0xc01d0009L)
#define NT_STATUS_MONITOR_INVALID_MANUFACTURE_DATE NT_STATUS(0xc01d000aL)
#define NT_STATUS_GRAPHICS_NOT_EXCLUSIVE_MODE_OWNER NT_STATUS(0xc01e0000L)
#define NT_STATUS_GRAPHICS_INSUFFICIENT_DMA_BUFFER NT_STATUS(0xc01e0001L)
#define NT_STATUS_GRAPHICS_INVALID_DISPLAY_ADAPTER NT_STATUS(0xc01e0002L)
#define NT_STATUS_GRAPHICS_ADAPTER_WAS_RESET NT_STATUS(0xc01e0003L)
#define NT_STATUS_GRAPHICS_INVALID_DRIVER_MODEL NT_STATUS(0xc01e0004L)
#define NT_STATUS_GRAPHICS_PRESENT_MODE_CHANGED NT_STATUS(0xc01e0005L)
#define NT_STATUS_GRAPHICS_PRESENT_OCCLUDED NT_STATUS(0xc01e0006L)
#define NT_STATUS_GRAPHICS_PRESENT_DENIED NT_STATUS(0xc01e0007L)
#define NT_STATUS_GRAPHICS_CANNOTCOLORCONVERT NT_STATUS(0xc01e0008L)
#define NT_STATUS_GRAPHICS_PRESENT_REDIRECTION_DISABLED NT_STATUS(0xc01e000bL)
#define NT_STATUS_GRAPHICS_PRESENT_UNOCCLUDED NT_STATUS(0xc01e000cL)
#define NT_STATUS_GRAPHICS_NO_VIDEO_MEMORY NT_STATUS(0xc01e0100L)
#define NT_STATUS_GRAPHICS_CANT_LOCK_MEMORY NT_STATUS(0xc01e0101L)
#define NT_STATUS_GRAPHICS_ALLOCATION_BUSY NT_STATUS(0xc01e0102L)
#define NT_STATUS_GRAPHICS_TOO_MANY_REFERENCES NT_STATUS(0xc01e0103L)
#define NT_STATUS_GRAPHICS_TRY_AGAIN_LATER NT_STATUS(0xc01e0104L)
#define NT_STATUS_GRAPHICS_TRY_AGAIN_NOW NT_STATUS(0xc01e0105L)
#define NT_STATUS_GRAPHICS_ALLOCATION_INVALID NT_STATUS(0xc01e0106L)
#define NT_STATUS_GRAPHICS_UNSWIZZLING_APERTURE_UNAVAILABLE NT_STATUS(0xc01e0107L)
#define NT_STATUS_GRAPHICS_UNSWIZZLING_APERTURE_UNSUPPORTED NT_STATUS(0xc01e0108L)
#define NT_STATUS_GRAPHICS_CANT_EVICT_PINNED_ALLOCATION NT_STATUS(0xc01e0109L)
#define NT_STATUS_GRAPHICS_INVALID_ALLOCATION_USAGE NT_STATUS(0xc01e0110L)
#define NT_STATUS_GRAPHICS_CANT_RENDER_LOCKED_ALLOCATION NT_STATUS(0xc01e0111L)
#define NT_STATUS_GRAPHICS_ALLOCATION_CLOSED NT_STATUS(0xc01e0112L)
#define NT_STATUS_GRAPHICS_INVALID_ALLOCATION_INSTANCE NT_STATUS(0xc01e0113L)
#define NT_STATUS_GRAPHICS_INVALID_ALLOCATION_HANDLE NT_STATUS(0xc01e0114L)
#define NT_STATUS_GRAPHICS_WRONG_ALLOCATION_DEVICE NT_STATUS(0xc01e0115L)
#define NT_STATUS_GRAPHICS_ALLOCATION_CONTENT_LOST NT_STATUS(0xc01e0116L)
#define NT_STATUS_GRAPHICS_GPU_EXCEPTION_ON_DEVICE NT_STATUS(0xc01e0200L)
#define NT_STATUS_GRAPHICS_INVALID_VIDPN_TOPOLOGY NT_STATUS(0xc01e0300L)
#define NT_STATUS_GRAPHICS_VIDPN_TOPOLOGY_NOT_SUPPORTED NT_STATUS(0xc01e0301L)
#define NT_STATUS_GRAPHICS_VIDPN_TOPOLOGY_CURRENTLY_NOT_SUPPORTED NT_STATUS(0xc01e0302L)
#define NT_STATUS_GRAPHICS_INVALID_VIDPN NT_STATUS(0xc01e0303L)
#define NT_STATUS_GRAPHICS_INVALID_VIDEO_PRESENT_SOURCE NT_STATUS(0xc01e0304L)
#define NT_STATUS_GRAPHICS_INVALID_VIDEO_PRESENT_TARGET NT_STATUS(0xc01e0305L)
#define NT_STATUS_GRAPHICS_VIDPN_MODALITY_NOT_SUPPORTED NT_STATUS(0xc01e0306L)
#define NT_STATUS_GRAPHICS_INVALID_VIDPN_SOURCEMODESET NT_STATUS(0xc01e0308L)
#define NT_STATUS_GRAPHICS_INVALID_VIDPN_TARGETMODESET NT_STATUS(0xc01e0309L)
#define NT_STATUS_GRAPHICS_INVALID_FREQUENCY NT_STATUS(0xc01e030aL)
#define NT_STATUS_GRAPHICS_INVALID_ACTIVE_REGION NT_STATUS(0xc01e030bL)
#define NT_STATUS_GRAPHICS_INVALID_TOTAL_REGION NT_STATUS(0xc01e030cL)
#define NT_STATUS_GRAPHICS_INVALID_VIDEO_PRESENT_SOURCE_MODE NT_STATUS(0xc01e0310L)
#define NT_STATUS_GRAPHICS_INVALID_VIDEO_PRESENT_TARGET_MODE NT_STATUS(0xc01e0311L)
#define NT_STATUS_GRAPHICS_PINNED_MODE_MUST_REMAIN_IN_SET NT_STATUS(0xc01e0312L)
#define NT_STATUS_GRAPHICS_PATH_ALREADY_IN_TOPOLOGY NT_STATUS(0xc01e0313L)
#define NT_STATUS_GRAPHICS_MODE_ALREADY_IN_MODESET NT_STATUS(0xc01e0314L)
#define NT_STATUS_GRAPHICS_INVALID_VIDEOPRESENTSOURCESET NT_STATUS(0xc01e0315L)
#define NT_STATUS_GRAPHICS_INVALID_VIDEOPRESENTTARGETSET NT_STATUS(0xc01e0316L)
#define NT_STATUS_GRAPHICS_SOURCE_ALREADY_IN_SET NT_STATUS(0xc01e0317L)
#define NT_STATUS_GRAPHICS_TARGET_ALREADY_IN_SET NT_STATUS(0xc01e0318L)
#define NT_STATUS_GRAPHICS_INVALID_VIDPN_PRESENT_PATH NT_STATUS(0xc01e0319L)
#define NT_STATUS_GRAPHICS_NO_RECOMMENDED_VIDPN_TOPOLOGY NT_STATUS(0xc01e031aL)
#define NT_STATUS_GRAPHICS_INVALID_MONITOR_FREQUENCYRANGESET NT_STATUS(0xc01e031bL)
#define NT_STATUS_GRAPHICS_INVALID_MONITOR_FREQUENCYRANGE NT_STATUS(0xc01e031cL)
#define NT_STATUS_GRAPHICS_FREQUENCYRANGE_NOT_IN_SET NT_STATUS(0xc01e031dL)
#define NT_STATUS_GRAPHICS_FREQUENCYRANGE_ALREADY_IN_SET NT_STATUS(0xc01e031fL)
#define NT_STATUS_GRAPHICS_STALE_MODESET NT_STATUS(0xc01e0320L)
#define NT_STATUS_GRAPHICS_INVALID_MONITOR_SOURCEMODESET NT_STATUS(0xc01e0321L)
#define NT_STATUS_GRAPHICS_INVALID_MONITOR_SOURCE_MODE NT_STATUS(0xc01e0322L)
#define NT_STATUS_GRAPHICS_NO_RECOMMENDED_FUNCTIONAL_VIDPN NT_STATUS(0xc01e0323L)
#define NT_STATUS_GRAPHICS_MODE_ID_MUST_BE_UNIQUE NT_STATUS(0xc01e0324L)
#define NT_STATUS_GRAPHICS_EMPTY_ADAPTER_MONITOR_MODE_SUPPORT_INTERSECTION NT_STATUS(0xc01e0325L)
#define NT_STATUS_GRAPHICS_VIDEO_PRESENT_TARGETS_LESS_THAN_SOURCES NT_STATUS(0xc01e0326L)
#define NT_STATUS_GRAPHICS_PATH_NOT_IN_TOPOLOGY NT_STATUS(0xc01e0327L)
#define NT_STATUS_GRAPHICS_ADAPTER_MUST_HAVE_AT_LEAST_ONE_SOURCE NT_STATUS(0xc01e0328L)
#define NT_STATUS_GRAPHICS_ADAPTER_MUST_HAVE_AT_LEAST_ONE_TARGET NT_STATUS(0xc01e0329L)
#define NT_STATUS_GRAPHICS_INVALID_MONITORDESCRIPTORSET NT_STATUS(0xc01e032aL)
#define NT_STATUS_GRAPHICS_INVALID_MONITORDESCRIPTOR NT_STATUS(0xc01e032bL)
#define NT_STATUS_GRAPHICS_MONITORDESCRIPTOR_NOT_IN_SET NT_STATUS(0xc01e032cL)
#define NT_STATUS_GRAPHICS_MONITORDESCRIPTOR_ALREADY_IN_SET NT_STATUS(0xc01e032dL)
#define NT_STATUS_GRAPHICS_MONITORDESCRIPTOR_ID_MUST_BE_UNIQUE NT_STATUS(0xc01e032eL)
#define NT_STATUS_GRAPHICS_INVALID_VIDPN_TARGET_SUBSET_TYPE NT_STATUS(0xc01e032fL)
#define NT_STATUS_GRAPHICS_RESOURCES_NOT_RELATED NT_STATUS(0xc01e0330L)
#define NT_STATUS_GRAPHICS_SOURCE_ID_MUST_BE_UNIQUE NT_STATUS(0xc01e0331L)
#define NT_STATUS_GRAPHICS_TARGET_ID_MUST_BE_UNIQUE NT_STATUS(0xc01e0332L)
#define NT_STATUS_GRAPHICS_NO_AVAILABLE_VIDPN_TARGET NT_STATUS(0xc01e0333L)
#define NT_STATUS_GRAPHICS_MONITOR_COULD_NOT_BE_ASSOCIATED_WITH_ADAPTER NT_STATUS(0xc01e0334L)
#define NT_STATUS_GRAPHICS_NO_VIDPNMGR NT_STATUS(0xc01e0335L)
#define NT_STATUS_GRAPHICS_NO_ACTIVE_VIDPN NT_STATUS(0xc01e0336L)
#define NT_STATUS_GRAPHICS_STALE_VIDPN_TOPOLOGY NT_STATUS(0xc01e0337L)
#define NT_STATUS_GRAPHICS_MONITOR_NOT_CONNECTED NT_STATUS(0xc01e0338L)
#define NT_STATUS_GRAPHICS_SOURCE_NOT_IN_TOPOLOGY NT_STATUS(0xc01e0339L)
#define NT_STATUS_GRAPHICS_INVALID_PRIMARYSURFACE_SIZE NT_STATUS(0xc01e033aL)
#define NT_STATUS_GRAPHICS_INVALID_VISIBLEREGION_SIZE NT_STATUS(0xc01e033bL)
#define NT_STATUS_GRAPHICS_INVALID_STRIDE NT_STATUS(0xc01e033cL)
#define NT_STATUS_GRAPHICS_INVALID_PIXELFORMAT NT_STATUS(0xc01e033dL)
#define NT_STATUS_GRAPHICS_INVALID_COLORBASIS NT_STATUS(0xc01e033eL)
#define NT_STATUS_GRAPHICS_INVALID_PIXELVALUEACCESSMODE NT_STATUS(0xc01e033fL)
#define NT_STATUS_GRAPHICS_TARGET_NOT_IN_TOPOLOGY NT_STATUS(0xc01e0340L)
#define NT_STATUS_GRAPHICS_NO_DISPLAY_MODE_MANAGEMENT_SUPPORT NT_STATUS(0xc01e0341L)
#define NT_STATUS_GRAPHICS_VIDPN_SOURCE_IN_USE NT_STATUS(0xc01e0342L)
#define NT_STATUS_GRAPHICS_CANT_ACCESS_ACTIVE_VIDPN NT_STATUS(0xc01e0343L)
#define NT_STATUS_GRAPHICS_INVALID_PATH_IMPORTANCE_ORDINAL NT_STATUS(0xc01e0344L)
#define NT_STATUS_GRAPHICS_INVALID_PATH_CONTENT_GEOMETRY_TRANSFORMATION NT_STATUS(0xc01e0345L)
#define NT_STATUS_GRAPHICS_PATH_CONTENT_GEOMETRY_TRANSFORMATION_NOT_SUPPORTED NT_STATUS(0xc01e0346L)
#define NT_STATUS_GRAPHICS_INVALID_GAMMA_RAMP NT_STATUS(0xc01e0347L)
#define NT_STATUS_GRAPHICS_GAMMA_RAMP_NOT_SUPPORTED NT_STATUS(0xc01e0348L)
#define NT_STATUS_GRAPHICS_MULTISAMPLING_NOT_SUPPORTED NT_STATUS(0xc01e0349L)
#define NT_STATUS_GRAPHICS_MODE_NOT_IN_MODESET NT_STATUS(0xc01e034aL)
#define NT_STATUS_GRAPHICS_INVALID_VIDPN_TOPOLOGY_RECOMMENDATION_REASON NT_STATUS(0xc01e034dL)
#define NT_STATUS_GRAPHICS_INVALID_PATH_CONTENT_TYPE NT_STATUS(0xc01e034eL)
#define NT_STATUS_GRAPHICS_INVALID_COPYPROTECTION_TYPE NT_STATUS(0xc01e034fL)
#define NT_STATUS_GRAPHICS_UNASSIGNED_MODESET_ALREADY_EXISTS NT_STATUS(0xc01e0350L)
#define NT_STATUS_GRAPHICS_INVALID_SCANLINE_ORDERING NT_STATUS(0xc01e0352L)
#define NT_STATUS_GRAPHICS_TOPOLOGY_CHANGES_NOT_ALLOWED NT_STATUS(0xc01e0353L)
#define NT_STATUS_GRAPHICS_NO_AVAILABLE_IMPORTANCE_ORDINALS NT_STATUS(0xc01e0354L)
#define NT_STATUS_GRAPHICS_INCOMPATIBLE_PRIVATE_FORMAT NT_STATUS(0xc01e0355L)
#define NT_STATUS_GRAPHICS_INVALID_MODE_PRUNING_ALGORITHM NT_STATUS(0xc01e0356L)
#define NT_STATUS_GRAPHICS_INVALID_MONITOR_CAPABILITY_ORIGIN NT_STATUS(0xc01e0357L)
#define NT_STATUS_GRAPHICS_INVALID_MONITOR_FREQUENCYRANGE_CONSTRAINT NT_STATUS(0xc01e0358L)
#define NT_STATUS_GRAPHICS_MAX_NUM_PATHS_REACHED NT_STATUS(0xc01e0359L)
#define NT_STATUS_GRAPHICS_CANCEL_VIDPN_TOPOLOGY_AUGMENTATION NT_STATUS(0xc01e035aL)
#define NT_STATUS_GRAPHICS_INVALID_CLIENT_TYPE NT_STATUS(0xc01e035bL)
#define NT_STATUS_GRAPHICS_CLIENTVIDPN_NOT_SET NT_STATUS(0xc01e035cL)
#define NT_STATUS_GRAPHICS_SPECIFIED_CHILD_ALREADY_CONNECTED NT_STATUS(0xc01e0400L)
#define NT_STATUS_GRAPHICS_CHILD_DESCRIPTOR_NOT_SUPPORTED NT_STATUS(0xc01e0401L)
#define NT_STATUS_GRAPHICS_NOT_A_LINKED_ADAPTER NT_STATUS(0xc01e0430L)
#define NT_STATUS_GRAPHICS_LEADLINK_NOT_ENUMERATED NT_STATUS(0xc01e0431L)
#define NT_STATUS_GRAPHICS_CHAINLINKS_NOT_ENUMERATED NT_STATUS(0xc01e0432L)
#define NT_STATUS_GRAPHICS_ADAPTER_CHAIN_NOT_READY NT_STATUS(0xc01e0433L)
#define NT_STATUS_GRAPHICS_CHAINLINKS_NOT_STARTED NT_STATUS(0xc01e0434L)
#define NT_STATUS_GRAPHICS_CHAINLINKS_NOT_POWERED_ON NT_STATUS(0xc01e0435L)
#define NT_STATUS_GRAPHICS_INCONSISTENT_DEVICE_LINK_STATE NT_STATUS(0xc01e0436L)
#define NT_STATUS_GRAPHICS_NOT_POST_DEVICE_DRIVER NT_STATUS(0xc01e0438L)
#define NT_STATUS_GRAPHICS_ADAPTER_ACCESS_NOT_EXCLUDED NT_STATUS(0xc01e043bL)
#define NT_STATUS_GRAPHICS_OPM_NOT_SUPPORTED NT_STATUS(0xc01e0500L)
#define NT_STATUS_GRAPHICS_COPP_NOT_SUPPORTED NT_STATUS(0xc01e0501L)
#define NT_STATUS_GRAPHICS_UAB_NOT_SUPPORTED NT_STATUS(0xc01e0502L)
#define NT_STATUS_GRAPHICS_OPM_INVALID_ENCRYPTED_PARAMETERS NT_STATUS(0xc01e0503L)
#define NT_STATUS_GRAPHICS_OPM_PARAMETER_ARRAY_TOO_SMALL NT_STATUS(0xc01e0504L)
#define NT_STATUS_GRAPHICS_OPM_NO_PROTECTED_OUTPUTS_EXIST NT_STATUS(0xc01e0505L)
#define NT_STATUS_GRAPHICS_PVP_NO_DISPLAY_DEVICE_CORRESPONDS_TO_NAME NT_STATUS(0xc01e0506L)
#define NT_STATUS_GRAPHICS_PVP_DISPLAY_DEVICE_NOT_ATTACHED_TO_DESKTOP NT_STATUS(0xc01e0507L)
#define NT_STATUS_GRAPHICS_PVP_MIRRORING_DEVICES_NOT_SUPPORTED NT_STATUS(0xc01e0508L)
#define NT_STATUS_GRAPHICS_OPM_INVALID_POINTER NT_STATUS(0xc01e050aL)
#define NT_STATUS_GRAPHICS_OPM_INTERNAL_ERROR NT_STATUS(0xc01e050bL)
#define NT_STATUS_GRAPHICS_OPM_INVALID_HANDLE NT_STATUS(0xc01e050cL)
#define NT_STATUS_GRAPHICS_PVP_NO_MONITORS_CORRESPOND_TO_DISPLAY_DEVICE NT_STATUS(0xc01e050dL)
#define NT_STATUS_GRAPHICS_PVP_INVALID_CERTIFICATE_LENGTH NT_STATUS(0xc01e050eL)
#define NT_STATUS_GRAPHICS_OPM_SPANNING_MODE_ENABLED NT_STATUS(0xc01e050fL)
#define NT_STATUS_GRAPHICS_OPM_THEATER_MODE_ENABLED NT_STATUS(0xc01e0510L)
#define NT_STATUS_GRAPHICS_PVP_HFS_FAILED NT_STATUS(0xc01e0511L)
#define NT_STATUS_GRAPHICS_OPM_INVALID_SRM NT_STATUS(0xc01e0512L)
#define NT_STATUS_GRAPHICS_OPM_OUTPUT_DOES_NOT_SUPPORT_HDCP NT_STATUS(0xc01e0513L)
#define NT_STATUS_GRAPHICS_OPM_OUTPUT_DOES_NOT_SUPPORT_ACP NT_STATUS(0xc01e0514L)
#define NT_STATUS_GRAPHICS_OPM_OUTPUT_DOES_NOT_SUPPORT_CGMSA NT_STATUS(0xc01e0515L)
#define NT_STATUS_GRAPHICS_OPM_HDCP_SRM_NEVER_SET NT_STATUS(0xc01e0516L)
#define NT_STATUS_GRAPHICS_OPM_RESOLUTION_TOO_HIGH NT_STATUS(0xc01e0517L)
#define NT_STATUS_GRAPHICS_OPM_ALL_HDCP_HARDWARE_ALREADY_IN_USE NT_STATUS(0xc01e0518L)
#define NT_STATUS_GRAPHICS_OPM_PROTECTED_OUTPUT_NO_LONGER_EXISTS NT_STATUS(0xc01e051aL)
#define NT_STATUS_GRAPHICS_OPM_SESSION_TYPE_CHANGE_IN_PROGRESS NT_STATUS(0xc01e051bL)
#define NT_STATUS_GRAPHICS_OPM_PROTECTED_OUTPUT_DOES_NOT_HAVE_COPP_SEMANTICS NT_STATUS(0xc01e051cL)
#define NT_STATUS_GRAPHICS_OPM_INVALID_INFORMATION_REQUEST NT_STATUS(0xc01e051dL)
#define NT_STATUS_GRAPHICS_OPM_DRIVER_INTERNAL_ERROR NT_STATUS(0xc01e051eL)
#define NT_STATUS_GRAPHICS_OPM_PROTECTED_OUTPUT_DOES_NOT_HAVE_OPM_SEMANTICS NT_STATUS(0xc01e051fL)
#define NT_STATUS_GRAPHICS_OPM_SIGNALING_NOT_SUPPORTED NT_STATUS(0xc01e0520L)
#define NT_STATUS_GRAPHICS_OPM_INVALID_CONFIGURATION_REQUEST NT_STATUS(0xc01e0521L)
#define NT_STATUS_GRAPHICS_I2C_NOT_SUPPORTED NT_STATUS(0xc01e0580L)
#define NT_STATUS_GRAPHICS_I2C_DEVICE_DOES_NOT_EXIST NT_STATUS(0xc01e0581L)
#define NT_STATUS_GRAPHICS_I2C_ERROR_TRANSMITTING_DATA NT_STATUS(0xc01e0582L)
#define NT_STATUS_GRAPHICS_I2C_ERROR_RECEIVING_DATA NT_STATUS(0xc01e0583L)
#define NT_STATUS_GRAPHICS_DDCCI_VCP_NOT_SUPPORTED NT_STATUS(0xc01e0584L)
#define NT_STATUS_GRAPHICS_DDCCI_INVALID_DATA NT_STATUS(0xc01e0585L)
#define NT_STATUS_GRAPHICS_DDCCI_MONITOR_RETURNED_INVALID_TIMING_STATUS_BYTE NT_STATUS(0xc01e0586L)
#define NT_STATUS_GRAPHICS_DDCCI_INVALID_CAPABILITIES_STRING NT_STATUS(0xc01e0587L)
#define NT_STATUS_GRAPHICS_MCA_INTERNAL_ERROR NT_STATUS(0xc01e0588L)
#define NT_STATUS_GRAPHICS_DDCCI_INVALID_MESSAGE_COMMAND NT_STATUS(0xc01e0589L)
#define NT_STATUS_GRAPHICS_DDCCI_INVALID_MESSAGE_LENGTH NT_STATUS(0xc01e058aL)
#define NT_STATUS_GRAPHICS_DDCCI_INVALID_MESSAGE_CHECKSUM NT_STATUS(0xc01e058bL)
#define NT_STATUS_GRAPHICS_INVALID_PHYSICAL_MONITOR_HANDLE NT_STATUS(0xc01e058cL)
#define NT_STATUS_GRAPHICS_MONITOR_NO_LONGER_EXISTS NT_STATUS(0xc01e058dL)
#define NT_STATUS_GRAPHICS_ONLY_CONSOLE_SESSION_SUPPORTED NT_STATUS(0xc01e05e0L)
#define NT_STATUS_GRAPHICS_NO_DISPLAY_DEVICE_CORRESPONDS_TO_NAME NT_STATUS(0xc01e05e1L)
#define NT_STATUS_GRAPHICS_DISPLAY_DEVICE_NOT_ATTACHED_TO_DESKTOP NT_STATUS(0xc01e05e2L)
#define NT_STATUS_GRAPHICS_MIRRORING_DEVICES_NOT_SUPPORTED NT_STATUS(0xc01e05e3L)
#define NT_STATUS_GRAPHICS_INVALID_POINTER NT_STATUS(0xc01e05e4L)
#define NT_STATUS_GRAPHICS_NO_MONITORS_CORRESPOND_TO_DISPLAY_DEVICE NT_STATUS(0xc01e05e5L)
#define NT_STATUS_GRAPHICS_PARAMETER_ARRAY_TOO_SMALL NT_STATUS(0xc01e05e6L)
#define NT_STATUS_GRAPHICS_INTERNAL_ERROR NT_STATUS(0xc01e05e7L)
#define NT_STATUS_GRAPHICS_SESSION_TYPE_CHANGE_IN_PROGRESS NT_STATUS(0xc01e05e8L)
#define NT_STATUS_FVE_LOCKED_VOLUME NT_STATUS(0xc0210000L)
#define NT_STATUS_FVE_NOT_ENCRYPTED NT_STATUS(0xc0210001L)
#define NT_STATUS_FVE_BAD_INFORMATION NT_STATUS(0xc0210002L)
#define NT_STATUS_FVE_TOO_SMALL NT_STATUS(0xc0210003L)
#define NT_STATUS_FVE_FAILED_WRONG_FS NT_STATUS(0xc0210004L)
#define NT_STATUS_FVE_FAILED_BAD_FS NT_STATUS(0xc0210005L)
#define NT_STATUS_FVE_FS_NOT_EXTENDED NT_STATUS(0xc0210006L)
#define NT_STATUS_FVE_FS_MOUNTED NT_STATUS(0xc0210007L)
#define NT_STATUS_FVE_NO_LICENSE NT_STATUS(0xc0210008L)
#define NT_STATUS_FVE_ACTION_NOT_ALLOWED NT_STATUS(0xc0210009L)
#define NT_STATUS_FVE_BAD_DATA NT_STATUS(0xc021000aL)
#define NT_STATUS_FVE_VOLUME_NOT_BOUND NT_STATUS(0xc021000bL)
#define NT_STATUS_FVE_NOT_DATA_VOLUME NT_STATUS(0xc021000cL)
#define NT_STATUS_FVE_CONV_READ_ERROR NT_STATUS(0xc021000dL)
#define NT_STATUS_FVE_CONV_WRITE_ERROR NT_STATUS(0xc021000eL)
#define NT_STATUS_FVE_OVERLAPPED_UPDATE NT_STATUS(0xc021000fL)
#define NT_STATUS_FVE_FAILED_SECTOR_SIZE NT_STATUS(0xc0210010L)
#define NT_STATUS_FVE_FAILED_AUTHENTICATION NT_STATUS(0xc0210011L)
#define NT_STATUS_FVE_NOT_OS_VOLUME NT_STATUS(0xc0210012L)
#define NT_STATUS_FVE_KEYFILE_NOT_FOUND NT_STATUS(0xc0210013L)
#define NT_STATUS_FVE_KEYFILE_INVALID NT_STATUS(0xc0210014L)
#define NT_STATUS_FVE_KEYFILE_NO_VMK NT_STATUS(0xc0210015L)
#define NT_STATUS_FVE_TPM_DISABLED NT_STATUS(0xc0210016L)
#define NT_STATUS_FVE_TPM_SRK_AUTH_NOT_ZERO NT_STATUS(0xc0210017L)
#define NT_STATUS_FVE_TPM_INVALID_PCR NT_STATUS(0xc0210018L)
#define NT_STATUS_FVE_TPM_NO_VMK NT_STATUS(0xc0210019L)
#define NT_STATUS_FVE_PIN_INVALID NT_STATUS(0xc021001aL)
#define NT_STATUS_FVE_AUTH_INVALID_APPLICATION NT_STATUS(0xc021001bL)
#define NT_STATUS_FVE_AUTH_INVALID_CONFIG NT_STATUS(0xc021001cL)
#define NT_STATUS_FVE_DEBUGGER_ENABLED NT_STATUS(0xc021001dL)
#define NT_STATUS_FVE_DRY_RUN_FAILED NT_STATUS(0xc021001eL)
#define NT_STATUS_FVE_BAD_METADATA_POINTER NT_STATUS(0xc021001fL)
#define NT_STATUS_FVE_OLD_METADATA_COPY NT_STATUS(0xc0210020L)
#define NT_STATUS_FVE_REBOOT_REQUIRED NT_STATUS(0xc0210021L)
#define NT_STATUS_FVE_RAW_ACCESS NT_STATUS(0xc0210022L)
#define NT_STATUS_FVE_RAW_BLOCKED NT_STATUS(0xc0210023L)
#define NT_STATUS_FVE_NO_FEATURE_LICENSE NT_STATUS(0xc0210026L)
#define NT_STATUS_FVE_POLICY_USER_DISABLE_RDV_NOT_ALLOWED NT_STATUS(0xc0210027L)
#define NT_STATUS_FVE_CONV_RECOVERY_FAILED NT_STATUS(0xc0210028L)
#define NT_STATUS_FVE_VIRTUALIZED_SPACE_TOO_BIG NT_STATUS(0xc0210029L)
#define NT_STATUS_FVE_VOLUME_TOO_SMALL NT_STATUS(0xc0210030L)
#define NT_STATUS_FWP_CALLOUT_NOT_FOUND NT_STATUS(0xc0220001L)
#define NT_STATUS_FWP_CONDITION_NOT_FOUND NT_STATUS(0xc0220002L)
#define NT_STATUS_FWP_FILTER_NOT_FOUND NT_STATUS(0xc0220003L)
#define NT_STATUS_FWP_LAYER_NOT_FOUND NT_STATUS(0xc0220004L)
#define NT_STATUS_FWP_PROVIDER_NOT_FOUND NT_STATUS(0xc0220005L)
#define NT_STATUS_FWP_PROVIDER_CONTEXT_NOT_FOUND NT_STATUS(0xc0220006L)
#define NT_STATUS_FWP_SUBLAYER_NOT_FOUND NT_STATUS(0xc0220007L)
#define NT_STATUS_FWP_NOT_FOUND NT_STATUS(0xc0220008L)
#define NT_STATUS_FWP_ALREADY_EXISTS NT_STATUS(0xc0220009L)
#define NT_STATUS_FWP_IN_USE NT_STATUS(0xc022000aL)
#define NT_STATUS_FWP_DYNAMIC_SESSION_IN_PROGRESS NT_STATUS(0xc022000bL)
#define NT_STATUS_FWP_WRONG_SESSION NT_STATUS(0xc022000cL)
#define NT_STATUS_FWP_NO_TXN_IN_PROGRESS NT_STATUS(0xc022000dL)
#define NT_STATUS_FWP_TXN_IN_PROGRESS NT_STATUS(0xc022000eL)
#define NT_STATUS_FWP_TXN_ABORTED NT_STATUS(0xc022000fL)
#define NT_STATUS_FWP_SESSION_ABORTED NT_STATUS(0xc0220010L)
#define NT_STATUS_FWP_INCOMPATIBLE_TXN NT_STATUS(0xc0220011L)
#define NT_STATUS_FWP_TIMEOUT NT_STATUS(0xc0220012L)
#define NT_STATUS_FWP_NET_EVENTS_DISABLED NT_STATUS(0xc0220013L)
#define NT_STATUS_FWP_INCOMPATIBLE_LAYER NT_STATUS(0xc0220014L)
#define NT_STATUS_FWP_KM_CLIENTS_ONLY NT_STATUS(0xc0220015L)
#define NT_STATUS_FWP_LIFETIME_MISMATCH NT_STATUS(0xc0220016L)
#define NT_STATUS_FWP_BUILTIN_OBJECT NT_STATUS(0xc0220017L)
#define NT_STATUS_FWP_TOO_MANY_BOOTTIME_FILTERS NT_STATUS(0xc0220018L)
#define NT_STATUS_FWP_TOO_MANY_CALLOUTS NT_STATUS(0xc0220018L)
#define NT_STATUS_FWP_NOTIFICATION_DROPPED NT_STATUS(0xc0220019L)
#define NT_STATUS_FWP_TRAFFIC_MISMATCH NT_STATUS(0xc022001aL)
#define NT_STATUS_FWP_INCOMPATIBLE_SA_STATE NT_STATUS(0xc022001bL)
#define NT_STATUS_FWP_NULL_POINTER NT_STATUS(0xc022001cL)
#define NT_STATUS_FWP_INVALID_ENUMERATOR NT_STATUS(0xc022001dL)
#define NT_STATUS_FWP_INVALID_FLAGS NT_STATUS(0xc022001eL)
#define NT_STATUS_FWP_INVALID_NET_MASK NT_STATUS(0xc022001fL)
#define NT_STATUS_FWP_INVALID_RANGE NT_STATUS(0xc0220020L)
#define NT_STATUS_FWP_INVALID_INTERVAL NT_STATUS(0xc0220021L)
#define NT_STATUS_FWP_ZERO_LENGTH_ARRAY NT_STATUS(0xc0220022L)
#define NT_STATUS_FWP_NULL_DISPLAY_NAME NT_STATUS(0xc0220023L)
#define NT_STATUS_FWP_INVALID_ACTION_TYPE NT_STATUS(0xc0220024L)
#define NT_STATUS_FWP_INVALID_WEIGHT NT_STATUS(0xc0220025L)
#define NT_STATUS_FWP_MATCH_TYPE_MISMATCH NT_STATUS(0xc0220026L)
#define NT_STATUS_FWP_TYPE_MISMATCH NT_STATUS(0xc0220027L)
#define NT_STATUS_FWP_OUT_OF_BOUNDS NT_STATUS(0xc0220028L)
#define NT_STATUS_FWP_RESERVED NT_STATUS(0xc0220029L)
#define NT_STATUS_FWP_DUPLICATE_CONDITION NT_STATUS(0xc022002aL)
#define NT_STATUS_FWP_DUPLICATE_KEYMOD NT_STATUS(0xc022002bL)
#define NT_STATUS_FWP_ACTION_INCOMPATIBLE_WITH_LAYER NT_STATUS(0xc022002cL)
#define NT_STATUS_FWP_ACTION_INCOMPATIBLE_WITH_SUBLAYER NT_STATUS(0xc022002dL)
#define NT_STATUS_FWP_CONTEXT_INCOMPATIBLE_WITH_LAYER NT_STATUS(0xc022002eL)
#define NT_STATUS_FWP_CONTEXT_INCOMPATIBLE_WITH_CALLOUT NT_STATUS(0xc022002fL)
#define NT_STATUS_FWP_INCOMPATIBLE_AUTH_METHOD NT_STATUS(0xc0220030L)
#define NT_STATUS_FWP_INCOMPATIBLE_DH_GROUP NT_STATUS(0xc0220031L)
#define NT_STATUS_FWP_EM_NOT_SUPPORTED NT_STATUS(0xc0220032L)
#define NT_STATUS_FWP_NEVER_MATCH NT_STATUS(0xc0220033L)
#define NT_STATUS_FWP_PROVIDER_CONTEXT_MISMATCH NT_STATUS(0xc0220034L)
#define NT_STATUS_FWP_INVALID_PARAMETER NT_STATUS(0xc0220035L)
#define NT_STATUS_FWP_TOO_MANY_SUBLAYERS NT_STATUS(0xc0220036L)
#define NT_STATUS_FWP_CALLOUT_NOTIFICATION_FAILED NT_STATUS(0xc0220037L)
#define NT_STATUS_FWP_INCOMPATIBLE_AUTH_CONFIG NT_STATUS(0xc0220038L)
#define NT_STATUS_FWP_INCOMPATIBLE_CIPHER_CONFIG NT_STATUS(0xc0220039L)
#define NT_STATUS_FWP_DUPLICATE_AUTH_METHOD NT_STATUS(0xc022003cL)
#define NT_STATUS_FWP_TCPIP_NOT_READY NT_STATUS(0xc0220100L)
#define NT_STATUS_FWP_INJECT_HANDLE_CLOSING NT_STATUS(0xc0220101L)
#define NT_STATUS_FWP_INJECT_HANDLE_STALE NT_STATUS(0xc0220102L)
#define NT_STATUS_FWP_CANNOT_PEND NT_STATUS(0xc0220103L)
#define NT_STATUS_NDIS_CLOSING NT_STATUS(0xc0230002L)
#define NT_STATUS_NDIS_BAD_VERSION NT_STATUS(0xc0230004L)
#define NT_STATUS_NDIS_BAD_CHARACTERISTICS NT_STATUS(0xc0230005L)
#define NT_STATUS_NDIS_ADAPTER_NOT_FOUND NT_STATUS(0xc0230006L)
#define NT_STATUS_NDIS_OPEN_FAILED NT_STATUS(0xc0230007L)
#define NT_STATUS_NDIS_DEVICE_FAILED NT_STATUS(0xc0230008L)
#define NT_STATUS_NDIS_MULTICAST_FULL NT_STATUS(0xc0230009L)
#define NT_STATUS_NDIS_MULTICAST_EXISTS NT_STATUS(0xc023000aL)
#define NT_STATUS_NDIS_MULTICAST_NOT_FOUND NT_STATUS(0xc023000bL)
#define NT_STATUS_NDIS_REQUEST_ABORTED NT_STATUS(0xc023000cL)
#define NT_STATUS_NDIS_RESET_IN_PROGRESS NT_STATUS(0xc023000dL)
#define NT_STATUS_NDIS_INVALID_PACKET NT_STATUS(0xc023000fL)
#define NT_STATUS_NDIS_INVALID_DEVICE_REQUEST NT_STATUS(0xc0230010L)
#define NT_STATUS_NDIS_ADAPTER_NOT_READY NT_STATUS(0xc0230011L)
#define NT_STATUS_NDIS_INVALID_LENGTH NT_STATUS(0xc0230014L)
#define NT_STATUS_NDIS_INVALID_DATA NT_STATUS(0xc0230015L)
#define NT_STATUS_NDIS_BUFFER_TOO_SHORT NT_STATUS(0xc0230016L)
#define NT_STATUS_NDIS_INVALID_OID NT_STATUS(0xc0230017L)
#define NT_STATUS_NDIS_ADAPTER_REMOVED NT_STATUS(0xc0230018L)
#define NT_STATUS_NDIS_UNSUPPORTED_MEDIA NT_STATUS(0xc0230019L)
#define NT_STATUS_NDIS_GROUP_ADDRESS_IN_USE NT_STATUS(0xc023001aL)
#define NT_STATUS_NDIS_FILE_NOT_FOUND NT_STATUS(0xc023001bL)
#define NT_STATUS_NDIS_ERROR_READING_FILE NT_STATUS(0xc023001cL)
#define NT_STATUS_NDIS_ALREADY_MAPPED NT_STATUS(0xc023001dL)
#define NT_STATUS_NDIS_RESOURCE_CONFLICT NT_STATUS(0xc023001eL)
#define NT_STATUS_NDIS_MEDIA_DISCONNECTED NT_STATUS(0xc023001fL)
#define NT_STATUS_NDIS_INVALID_ADDRESS NT_STATUS(0xc0230022L)
#define NT_STATUS_NDIS_PAUSED NT_STATUS(0xc023002aL)
#define NT_STATUS_NDIS_INTERFACE_NOT_FOUND NT_STATUS(0xc023002bL)
#define NT_STATUS_NDIS_UNSUPPORTED_REVISION NT_STATUS(0xc023002cL)
#define NT_STATUS_NDIS_INVALID_PORT NT_STATUS(0xc023002dL)
#define NT_STATUS_NDIS_INVALID_PORT_STATE NT_STATUS(0xc023002eL)
#define NT_STATUS_NDIS_LOW_POWER_STATE NT_STATUS(0xc023002fL)
#define NT_STATUS_NDIS_NOT_SUPPORTED NT_STATUS(0xc02300bbL)
#define NT_STATUS_NDIS_OFFLOAD_POLICY NT_STATUS(0xc023100fL)
#define NT_STATUS_NDIS_OFFLOAD_CONNECTION_REJECTED NT_STATUS(0xc0231012L)
#define NT_STATUS_NDIS_OFFLOAD_PATH_REJECTED NT_STATUS(0xc0231013L)
#define NT_STATUS_NDIS_DOT11_AUTO_CONFIG_ENABLED NT_STATUS(0xc0232000L)
#define NT_STATUS_NDIS_DOT11_MEDIA_IN_USE NT_STATUS(0xc0232001L)
#define NT_STATUS_NDIS_DOT11_POWER_STATE_INVALID NT_STATUS(0xc0232002L)
#define NT_STATUS_NDIS_PM_WOL_PATTERN_LIST_FULL NT_STATUS(0xc0232003L)
#define NT_STATUS_NDIS_PM_PROTOCOL_OFFLOAD_LIST_FULL NT_STATUS(0xc0232004L)
#define NT_STATUS_IPSEC_BAD_SPI NT_STATUS(0xc0360001L)
#define NT_STATUS_IPSEC_SA_LIFETIME_EXPIRED NT_STATUS(0xc0360002L)
#define NT_STATUS_IPSEC_WRONG_SA NT_STATUS(0xc0360003L)
#define NT_STATUS_IPSEC_REPLAY_CHECK_FAILED NT_STATUS(0xc0360004L)
#define NT_STATUS_IPSEC_INVALID_PACKET NT_STATUS(0xc0360005L)
#define NT_STATUS_IPSEC_INTEGRITY_CHECK_FAILED NT_STATUS(0xc0360006L)
#define NT_STATUS_IPSEC_CLEAR_TEXT_DROP NT_STATUS(0xc0360007L)
#define NT_STATUS_IPSEC_AUTH_FIREWALL_DROP NT_STATUS(0xc0360008L)
#define NT_STATUS_IPSEC_THROTTLE_DROP NT_STATUS(0xc0360009L)
#define NT_STATUS_IPSEC_DOSP_BLOCK NT_STATUS(0xc0368000L)
#define NT_STATUS_IPSEC_DOSP_RECEIVED_MULTICAST NT_STATUS(0xc0368001L)
#define NT_STATUS_IPSEC_DOSP_INVALID_PACKET NT_STATUS(0xc0368002L)
#define NT_STATUS_IPSEC_DOSP_STATE_LOOKUP_FAILED NT_STATUS(0xc0368003L)
#define NT_STATUS_IPSEC_DOSP_MAX_ENTRIES NT_STATUS(0xc0368004L)
#define NT_STATUS_IPSEC_DOSP_KEYMOD_NOT_ALLOWED NT_STATUS(0xc0368005L)
#define NT_STATUS_IPSEC_DOSP_MAX_PER_IP_RATELIMIT_QUEUES NT_STATUS(0xc0368006L)
#define NT_STATUS_VOLMGR_MIRROR_NOT_SUPPORTED NT_STATUS(0xc038005bL)
#define NT_STATUS_VOLMGR_RAID5_NOT_SUPPORTED NT_STATUS(0xc038005cL)
#define NT_STATUS_VIRTDISK_PROVIDER_NOT_FOUND NT_STATUS(0xc03a0014L)
#define NT_STATUS_VIRTDISK_NOT_VIRTUAL_DISK NT_STATUS(0xc03a0015L)
#define NT_STATUS_VHD_PARENT_VHD_ACCESS_DENIED NT_STATUS(0xc03a0016L)
#define NT_STATUS_VHD_CHILD_PARENT_SIZE_MISMATCH NT_STATUS(0xc03a0017L)
#define NT_STATUS_VHD_DIFFERENCING_CHAIN_CYCLE_DETECTED NT_STATUS(0xc03a0018L)
#define NT_STATUS_VHD_DIFFERENCING_CHAIN_ERROR_IN_PARENT NT_STATUS(0xc03a0019L)

#endif /* _NTSTATUS_GEN_H */
